// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

#include <sys/types.h>
#include <stdio.h>
#include <unistd.h>

#ifdef USE_LOCAL
#include "soundcard.h"
#else
#include <sys/soundcard.h>
#endif

#include "defines.h"
#include "structs.h"
#include "globals.h"

#ifdef USE_X
#include <stdlib.h>

#include "TrackShell.h"
#include "OptShell.h"
#include "TopShell.h"
#else
#include "CursesScr.h"
#endif

#include "Sequencer.h"

unsigned int
procInput (void)
{
  unsigned int seqInput;
  extern Sequencer *seq;
  extern char played[MAX_POSITION];
#ifdef USE_X
  extern TrackShell *trackShell;
  extern OptShell *optShell;
  extern TopShell *topShell;
#else
  extern CursesScr *cursScreen;
#endif

  if (seq->read ((char *)(&seqInput)) == 4)
    {
      if ((seqInput & 0xff) == SEQ_ECHO)
	{
	  seqInput >>= 8;
	  switch (seqInput & 0xff)
	    {
	    case ECHO_MESSAGE:
	      actualPos = (seqInput >> 16) & 0xff;
	      played[actualPos] = 2;   // played
#ifdef USE_X
	      topShell->setPosition(actualPos);
	      trackShell->updateTracker(tune[actualPos], 
					patternLen[tune[actualPos]],
					voiceTable, patternTable);
#else
	      cursScreen->setPos(actualPos, (seqInput >> 8) & 0xff);
#endif
	      break;
#ifdef USE_X
	    case ECHO_SPEED0:
	      if (optShell->speed0Checked() == FALSE)
		topShell->doNext(1);
	      break;
	    case ECHO_LOOP:
	      if (optShell->loopBreakChecked() == TRUE)
		topShell->doNext(1);
	      break;
	    case ECHO_PATTERN:
	      trackShell->setCurrent(seqInput >> 8);
	      break;
#endif
	    }
	}
      else
	seqInput = ECHO_NONE;
    }
  else
    seqInput = ECHO_NONE;

  return (seqInput);
}
