// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

#ifndef __EnvelopeH
#define __EnvelopeH

struct EnvelopeSegment
{
  int startX, startY;
  int endX, endY;

  double m, b;
};

class Envelope
{
public:
  Envelope();
  ~Envelope();
  void load(int, int, int, int, int, unsigned short, int, unsigned char *);
  int getY(int &, char, unsigned short * = 0) const;

private:
  struct EnvelopeSegment *envelope;
  int baseValue_;
  int numSegments;
  int sustainX;
  int loopOn;
  int sustainOn;
  int loopStartX;
  int loopEndX;
  unsigned short fadeRate;
};

inline
Envelope::Envelope() : envelope(0), numSegments(0), loopOn(0), sustainOn(0),
  fadeRate(0)
{
}

inline
Envelope::~Envelope()
{
  if (envelope != 0)
    delete [] envelope;
}

#endif
