
"Source/destination blending using C{glBlendFunc}."

import OpenGL.GL as gl

import glitch

class Blend(glitch.Node):
    def __init__(
            self, src=gl.GL_SRC_ALPHA, dst=gl.GL_ONE_MINUS_SRC_ALPHA, **kw):
        glitch.Node.__init__(self, **kw)
        self.src = src
        self.dst = dst

    def render(self, ctx):
        gl.glPushAttrib(gl.GL_COLOR_BUFFER_BIT | gl.GL_ENABLE_BIT)
        gl.glBlendFunc(self.src, self.dst)
        gl.glEnable(gl.GL_BLEND)
        glitch.Node.render(self, ctx)
        gl.glPopAttrib()

