
"Play a video file in a loop."

import gobject
import gst

from glitch.gst import VideoFileTexture

class VideoLoop(VideoFileTexture):
    "Play a video file in a loop."

    def __init__(self, *args, **kwargs):
        VideoFileTexture.__init__(self, *args, **kwargs)

        appsink = self.bin.get_by_name('appsink')
        pad = appsink.get_static_pad('sink')
        pad.add_event_probe(self._event)

    def _event(self, pad, event):
        if event.type == gst.EVENT_EOS:
            gobject.idle_add(self._reset)

        return True

    def _reset(self):
        self.bin.seek_simple(gst.FORMAT_TIME, gst.SEEK_FLAG_FLUSH, 0)
        return False

