%define name gl-117
%define version 0.8.8

Summary: An OpenGL and SDL based action flight simulator
Summary(de): Ein OpenGL- und SDL-basierter Flugsimulator
Summary(pl): Zrcznociowy symulator lotu uywajcy OpenGL i SDL
Name: %{name}
Version: %{version}
Release: 1
Copyright: GPL
Vendor: Thomas A. Drexl <tom.drexl@gmx.de>
Url: http://home.t-online.de/home/Primetime./
Packager: Dominik Seichter <domseichter@web.de>
Group: x11/games
Source: %{name}-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}

%description
GL-117 is an OpenGL and SDL-based action flight simulator written in
C++. It provides a random terrain generator, lighting effects, sounds,
and joystick support. Predefined levels of video quality and an amount
of viewing ranges let you perfectly adjust the game to the performance
of your system.

%description -l de
GL-117 ist ein in C++ entwickelter, OpenGL- und SDL-basierter
Action-Flugsimulator. Neben per Zufall erzeugten Landschaften besticht
das Spiel durch Lichteffekte, Sound und Joystickuntersttzung. Anhand
vordefinierter Qualittsstufen lsst sich die Grafik optimal an die
Leistung des eigenen Systems anpassen.

%description -l pl
GL-117 jest zrcznociowym symulatorem lotu napisanym w C++,
wykorzystujcym biblioteki OpenGL i SDL. Posiada obsug joysticka,
dwik, losowo generowany teren, efekty wietlne. Predefiniowane
poziomy jakoci obrazu oraz szeroki zakres ustawie widocznoci
pozwalaj idealnie dopasowa gr do wydajnoci systemu.

%prep
%setup
./configure

%build

# Setup for parallel builds
numprocs=`egrep -c ^cpu[0-9]+ /proc/stat || :`
if [ "$numprocs" = "0" ]; then
 numprocs=1
fi

make -j$numprocs

%install
make install-strip DESTDIR=$RPM_BUILD_ROOT

cd $RPM_BUILD_ROOT
find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' > $RPM_BUILD_DIR/file.list.gl-117
find . -type f | sed 's,^\.,\%attr(-\,root\,root) ,' >>  $RPM_BUILD_DIR/file.list.gl-117
find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >>  $RPM_BUILD_DIR/file.list.gl-117

%clean
rm -rf $RPM_BUILD_ROOT/*
rm -rf $RPM_BUILD_DIR/gl-117
rm -rf ../file.list.gl-117

%files -f ../file.list.gl-117



