#
# Unicode mappings for translating numerals into national variants.
#



LOCAL = _("LOCALMAPPING")


_MAPPINGS = {
    "LOCALMAPPING": {},


    #
    # Hindi numerals are frequently used in Arabic.
    #
    "HINDI": {0x0030: 0x0660,
              0x0031: 0x0661,
              0x0032: 0x0662,
              0x0033: 0x0663,
              0x0034: 0x0664,
              0x0035: 0x0665,
              0x0036: 0x0666,
              0x0037: 0x0667,
              0x0038: 0x0668,
              0x0039: 0x0669},



    #
    # Chinese numerals are sometimes used in Chinese and Japanese.
    #
    "CHINESE": {0x0030: 0x3007,
                0x0031: 0x4e00,
                0x0032: 0x4e8c,
                0x0033: 0x4e09,
                0x0034: 0x56db,
                0x0035: 0x4e94,
                0x0036: 0x516d,
                0x0037: 0x4e03,
                0x0038: 0x516b,
                0x0039: 0x4e5d}

    }


#
# Returns the translated number.
#
def map(number, mapping):

    mapping = _MAPPINGS.get(mapping)
    if (not mapping):
        return unicode(number)
    else:
        return unicode(number).translate(mapping)
