// ==========================================================
// Delphi wrapper for FreeImage 3
//
// Design and implementation by
// - Simon Beavis
// - Peter Bystrm
// - Anatoliy Pulyaevskiy (xvel84@rambler.ru)
//
// Contributors:
// - Lorenzo Monti (LM)  lomo74@gmail.com
//
// Revision history
// When        Who   What
// ----------- ----- -----------------------------------------------------------
// 2010-07-29  LM    Added Free Pascal / Lazarus 32 bit support
// 2010-11-12  LM    Added Delphi XE support
// 2011-03-04  JMB   Added 64 bit compiler support
// 2015-09-17  LM    Added Delphi XE7..XE8 support
// 2016-01-06  LM    Added Delphi 10 Seattle support
// 2016-06-03  LM    Added Delphi 10.1 Berlin support
//
// This file is part of FreeImage 3
//
// COVERED CODE IS PROVIDED UNDER THIS LICENSE ON AN "AS IS" BASIS, WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
// THAT THE COVERED CODE IS FREE OF DEFECTS, MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE
// OR NON-INFRINGING. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE COVERED
// CODE IS WITH YOU. SHOULD ANY COVERED CODE PROVE DEFECTIVE IN ANY RESPECT, YOU (NOT
// THE INITIAL DEVELOPER OR ANY OTHER CONTRIBUTOR) ASSUME THE COST OF ANY NECESSARY
// SERVICING, REPAIR OR CORRECTION. THIS DISCLAIMER OF WARRANTY CONSTITUTES AN ESSENTIAL
// PART OF THIS LICENSE. NO USE OF ANY COVERED CODE IS AUTHORIZED HEREUNDER EXCEPT UNDER
// THIS DISCLAIMER.
//
// Use at your own risk!
// ==========================================================

//some older Delphi version will define WIN32 but not MSWINDOWS
{$IFNDEF MSWINDOWS}
  {$IFDEF WIN32}
    {$DEFINE MSWINDOWS}
  {$ENDIF}
{$ENDIF}

//test for compiler
{$IFDEF FPC}
  //Free pascal
  {$IFNDEF CPU32}
    //{$ERROR "64 bit platforms not tested yet. Remove this line if you feel brave."}
  {$ENDIF}
  {$IFNDEF ENDIAN_LITTLE}
    {$ERROR "Big endian CPUs not tested yet. Remove this line if you feel brave."}
  {$ENDIF}
  {$DEFINE DELPHI1}
  {$DEFINE DELPHI2}
  {$DEFINE DELPHI3}
  {$DEFINE DELPHI4}
  {$DEFINE DELPHI5}
  {$DEFINE DELPHI6}
  {$DEFINE DELPHI7}
{$ELSE}
  //Delphi
  {$IFDEF VER80}
    {$DEFINE DELPHI1}
  {$ENDIF}

  {$IFDEF VER90}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
  {$ENDIF}

  {$IFDEF VER100}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
  {$ENDIF}

  {$IFDEF VER120}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
  {$ENDIF}

  {$IFDEF VER130}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
  {$ENDIF}

  {$IFDEF VER140}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
  {$ENDIF}

  {$IFDEF VER150}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
  {$ENDIF}

  {$IFDEF VER160}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
  {$ENDIF}

  {$IFDEF VER170}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
    {$DEFINE DELPHI2005}
  {$ENDIF}

  {$IFDEF VER180}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
    {$DEFINE DELPHI2005}
    {$DEFINE DELPHI2006}
  {$ENDIF}

  {$IFDEF VER185}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
    {$DEFINE DELPHI2005}
    {$DEFINE DELPHI2006}
    {$DEFINE DELPHI2007}
  {$ENDIF}

  {$IFDEF VER200}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
    {$DEFINE DELPHI2005}
    {$DEFINE DELPHI2006}
    {$DEFINE DELPHI2007}
    {$DEFINE DELPHI2009}
  {$ENDIF}

  {$IFDEF VER210}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
    {$DEFINE DELPHI2005}
    {$DEFINE DELPHI2006}
    {$DEFINE DELPHI2007}
    {$DEFINE DELPHI2009}
    {$DEFINE DELPHI2010}
  {$ENDIF}

  {$IFDEF VER220}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
    {$DEFINE DELPHI2005}
    {$DEFINE DELPHI2006}
    {$DEFINE DELPHI2007}
    {$DEFINE DELPHI2009}
    {$DEFINE DELPHI2010}
    {$DEFINE DELPHIXE}
  {$ENDIF}
  
  {$IFDEF VER230}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
    {$DEFINE DELPHI2005}
    {$DEFINE DELPHI2006}
    {$DEFINE DELPHI2007}
    {$DEFINE DELPHI2009}
    {$DEFINE DELPHI2010}
    {$DEFINE DELPHIXE}
    {$DEFINE DELPHIXE2}
  {$ENDIF}

  {$IFDEF VER240}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
    {$DEFINE DELPHI2005}
    {$DEFINE DELPHI2006}
    {$DEFINE DELPHI2007}
    {$DEFINE DELPHI2009}
    {$DEFINE DELPHI2010}
    {$DEFINE DELPHIXE}
    {$DEFINE DELPHIXE2}
    {$DEFINE DELPHIXE3}
  {$ENDIF}
  
  {$IFDEF VER250}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
    {$DEFINE DELPHI2005}
    {$DEFINE DELPHI2006}
    {$DEFINE DELPHI2007}
    {$DEFINE DELPHI2009}
    {$DEFINE DELPHI2010}
    {$DEFINE DELPHIXE}
    {$DEFINE DELPHIXE2}
    {$DEFINE DELPHIXE3}
    {$DEFINE DELPHIXE4}
  {$ENDIF}

  {$IFDEF VER260}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
    {$DEFINE DELPHI2005}
    {$DEFINE DELPHI2006}
    {$DEFINE DELPHI2007}
    {$DEFINE DELPHI2009}
    {$DEFINE DELPHI2010}
    {$DEFINE DELPHIXE}
    {$DEFINE DELPHIXE2}
    {$DEFINE DELPHIXE3}
    {$DEFINE DELPHIXE4}
    {$DEFINE DELPHIXE5}
  {$ENDIF}

  {$IFDEF VER270}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
    {$DEFINE DELPHI2005}
    {$DEFINE DELPHI2006}
    {$DEFINE DELPHI2007}
    {$DEFINE DELPHI2009}
    {$DEFINE DELPHI2010}
    {$DEFINE DELPHIXE}
    {$DEFINE DELPHIXE2}
    {$DEFINE DELPHIXE3}
    {$DEFINE DELPHIXE4}
    {$DEFINE DELPHIXE5}
    {$DEFINE DELPHIXE6}
  {$ENDIF}

  {$IFDEF VER280}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
    {$DEFINE DELPHI2005}
    {$DEFINE DELPHI2006}
    {$DEFINE DELPHI2007}
    {$DEFINE DELPHI2009}
    {$DEFINE DELPHI2010}
    {$DEFINE DELPHIXE}
    {$DEFINE DELPHIXE2}
    {$DEFINE DELPHIXE3}
    {$DEFINE DELPHIXE4}
    {$DEFINE DELPHIXE5}
    {$DEFINE DELPHIXE6}
    {$DEFINE DELPHIXE7}
  {$ENDIF}

  {$IFDEF VER290}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
    {$DEFINE DELPHI2005}
    {$DEFINE DELPHI2006}
    {$DEFINE DELPHI2007}
    {$DEFINE DELPHI2009}
    {$DEFINE DELPHI2010}
    {$DEFINE DELPHIXE}
    {$DEFINE DELPHIXE2}
    {$DEFINE DELPHIXE3}
    {$DEFINE DELPHIXE4}
    {$DEFINE DELPHIXE5}
    {$DEFINE DELPHIXE6}
    {$DEFINE DELPHIXE7}
    {$DEFINE DELPHIXE8}
  {$ENDIF}

  {$IFDEF VER300}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
    {$DEFINE DELPHI2005}
    {$DEFINE DELPHI2006}
    {$DEFINE DELPHI2007}
    {$DEFINE DELPHI2009}
    {$DEFINE DELPHI2010}
    {$DEFINE DELPHIXE}
    {$DEFINE DELPHIXE2}
    {$DEFINE DELPHIXE3}
    {$DEFINE DELPHIXE4}
    {$DEFINE DELPHIXE5}
    {$DEFINE DELPHIXE6}
    {$DEFINE DELPHIXE7}
    {$DEFINE DELPHIXE8}
    {$DEFINE DELPHISEATTLE}
  {$ENDIF}

  {$IFDEF VER310}
    {$DEFINE DELPHI1}
    {$DEFINE DELPHI2}
    {$DEFINE DELPHI3}
    {$DEFINE DELPHI4}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI7}
    {$DEFINE DELPHI8}
    {$DEFINE DELPHI2005}
    {$DEFINE DELPHI2006}
    {$DEFINE DELPHI2007}
    {$DEFINE DELPHI2009}
    {$DEFINE DELPHI2010}
    {$DEFINE DELPHIXE}
    {$DEFINE DELPHIXE2}
    {$DEFINE DELPHIXE3}
    {$DEFINE DELPHIXE4}
    {$DEFINE DELPHIXE5}
    {$DEFINE DELPHIXE6}
    {$DEFINE DELPHIXE7}
    {$DEFINE DELPHIXE8}
    {$DEFINE DELPHISEATTLE}
    {$DEFINE DELPHIBERLIN}
  {$ENDIF}
{$ENDIF}
