//
//  Emojione.m
//
//  Created by Alessandro Calzavara on 16/12/14.
//  Copyright (c) 2014 Spreaker, Inc.
//

#import "Emojione.h"

@implementation Emojione

+ (NSString *)shortnameToUnicode:(NSString *)string
{
    static NSDictionary * emojiMapping;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        emojiMapping = [self _loadShortNameToUnicode];
    });

    NSString * SHORTNAME_PATTERN = @":([-+\\w]+):";

    NSMutableString * unicodeString = [string mutableCopy];
    NSError * error = nil;
    NSRegularExpression * regex = [NSRegularExpression regularExpressionWithPattern:SHORTNAME_PATTERN
                                                                            options:0
                                                                              error:&error];

    NSAssert(!error, @"Unable to create regex: ", error);

    NSArray * matches = [regex matchesInString:unicodeString
                                       options:0
                                         range:NSMakeRange(0, [unicodeString length])];
    
    for (NSTextCheckingResult * result in [matches reverseObjectEnumerator]) {

        if ([result numberOfRanges] < 2) {
            continue;
        }
        
        // Range 0: full shortname
        // Range 1: shortname without :
        
        NSString * shortname = [string substringWithRange:[result rangeAtIndex:1]];
        NSString * emoji = [emojiMapping objectForKey:shortname];
        if (emoji) {
            [unicodeString replaceCharactersInRange:[result rangeAtIndex:0]
                                         withString:emoji];
        }
    }

    return unicodeString;
}

+ (NSDictionary *)_loadShortNameToUnicode
{
    // Mapping generated by script.

    return @{
        @"100" : @"\U0001f4af",
        @"1234" : @"\U0001f522",
        @"grinning" : @"\U0001f600",
        @"grimacing" : @"\U0001f62c",
        @"grin" : @"\U0001f601",
        @"joy" : @"\U0001f602",
        @"smiley" : @"\U0001f603",
        @"smile" : @"\U0001f604",
        @"sweat_smile" : @"\U0001f605",
        @"laughing" : @"\U0001f606",
        @"innocent" : @"\U0001f607",
        @"wink" : @"\U0001f609",
        @"blush" : @"\U0001f60a",
        @"slight_smile" : @"\U0001f642",
        @"upside_down" : @"\U0001f643",
        @"relaxed" : @"\U0000263a",
        @"yum" : @"\U0001f60b",
        @"relieved" : @"\U0001f60c",
        @"heart_eyes" : @"\U0001f60d",
        @"kissing_heart" : @"\U0001f618",
        @"kissing" : @"\U0001f617",
        @"kissing_smiling_eyes" : @"\U0001f619",
        @"kissing_closed_eyes" : @"\U0001f61a",
        @"stuck_out_tongue_winking_eye" : @"\U0001f61c",
        @"stuck_out_tongue_closed_eyes" : @"\U0001f61d",
        @"stuck_out_tongue" : @"\U0001f61b",
        @"money_mouth" : @"\U0001f911",
        @"nerd" : @"\U0001f913",
        @"sunglasses" : @"\U0001f60e",
        @"hugging" : @"\U0001f917",
        @"smirk" : @"\U0001f60f",
        @"no_mouth" : @"\U0001f636",
        @"neutral_face" : @"\U0001f610",
        @"expressionless" : @"\U0001f611",
        @"unamused" : @"\U0001f612",
        @"rolling_eyes" : @"\U0001f644",
        @"thinking" : @"\U0001f914",
        @"flushed" : @"\U0001f633",
        @"disappointed" : @"\U0001f61e",
        @"worried" : @"\U0001f61f",
        @"angry" : @"\U0001f620",
        @"rage" : @"\U0001f621",
        @"pensive" : @"\U0001f614",
        @"confused" : @"\U0001f615",
        @"slight_frown" : @"\U0001f641",
        @"frowning2" : @"\U00002639",
        @"persevere" : @"\U0001f623",
        @"confounded" : @"\U0001f616",
        @"tired_face" : @"\U0001f62b",
        @"weary" : @"\U0001f629",
        @"triumph" : @"\U0001f624",
        @"open_mouth" : @"\U0001f62e",
        @"scream" : @"\U0001f631",
        @"fearful" : @"\U0001f628",
        @"cold_sweat" : @"\U0001f630",
        @"hushed" : @"\U0001f62f",
        @"frowning" : @"\U0001f626",
        @"anguished" : @"\U0001f627",
        @"cry" : @"\U0001f622",
        @"disappointed_relieved" : @"\U0001f625",
        @"sleepy" : @"\U0001f62a",
        @"sweat" : @"\U0001f613",
        @"sob" : @"\U0001f62d",
        @"dizzy_face" : @"\U0001f635",
        @"astonished" : @"\U0001f632",
        @"zipper_mouth" : @"\U0001f910",
        @"mask" : @"\U0001f637",
        @"thermometer_face" : @"\U0001f912",
        @"head_bandage" : @"\U0001f915",
        @"sleeping" : @"\U0001f634",
        @"zzz" : @"\U0001f4a4",
        @"poop" : @"\U0001f4a9",
        @"smiling_imp" : @"\U0001f608",
        @"imp" : @"\U0001f47f",
        @"japanese_ogre" : @"\U0001f479",
        @"japanese_goblin" : @"\U0001f47a",
        @"skull" : @"\U0001f480",
        @"ghost" : @"\U0001f47b",
        @"alien" : @"\U0001f47d",
        @"robot" : @"\U0001f916",
        @"smiley_cat" : @"\U0001f63a",
        @"smile_cat" : @"\U0001f638",
        @"joy_cat" : @"\U0001f639",
        @"heart_eyes_cat" : @"\U0001f63b",
        @"smirk_cat" : @"\U0001f63c",
        @"kissing_cat" : @"\U0001f63d",
        @"scream_cat" : @"\U0001f640",
        @"crying_cat_face" : @"\U0001f63f",
        @"pouting_cat" : @"\U0001f63e",
        @"raised_hands" : @"\U0001f64c",
        @"clap" : @"\U0001f44f",
        @"wave" : @"\U0001f44b",
        @"thumbsup" : @"\U0001f44d",
        @"thumbsdown" : @"\U0001f44e",
        @"punch" : @"\U0001f44a",
        @"fist" : @"\U0000270a",
        @"v" : @"\U0000270c",
        @"ok_hand" : @"\U0001f44c",
        @"raised_hand" : @"\U0000270b",
        @"open_hands" : @"\U0001f450",
        @"muscle" : @"\U0001f4aa",
        @"pray" : @"\U0001f64f",
        @"point_up" : @"\U0000261d",
        @"point_up_2" : @"\U0001f446",
        @"point_down" : @"\U0001f447",
        @"point_left" : @"\U0001f448",
        @"point_right" : @"\U0001f449",
        @"middle_finger" : @"\U0001f595",
        @"hand_splayed" : @"\U0001f590",
        @"metal" : @"\U0001f918",
        @"vulcan" : @"\U0001f596",
        @"writing_hand" : @"\U0000270d",
        @"nail_care" : @"\U0001f485",
        @"lips" : @"\U0001f444",
        @"tongue" : @"\U0001f445",
        @"ear" : @"\U0001f442",
        @"nose" : @"\U0001f443",
        @"eye" : @"\U0001f441",
        @"eyes" : @"\U0001f440",
        @"bust_in_silhouette" : @"\U0001f464",
        @"busts_in_silhouette" : @"\U0001f465",
        @"speaking_head" : @"\U0001f5e3",
        @"baby" : @"\U0001f476",
        @"boy" : @"\U0001f466",
        @"girl" : @"\U0001f467",
        @"man" : @"\U0001f468",
        @"woman" : @"\U0001f469",
        @"person_with_blond_hair" : @"\U0001f471",
        @"older_man" : @"\U0001f474",
        @"older_woman" : @"\U0001f475",
        @"man_with_gua_pi_mao" : @"\U0001f472",
        @"man_with_turban" : @"\U0001f473",
        @"cop" : @"\U0001f46e",
        @"construction_worker" : @"\U0001f477",
        @"guardsman" : @"\U0001f482",
        @"spy" : @"\U0001f575",
        @"santa" : @"\U0001f385",
        @"angel" : @"\U0001f47c",
        @"princess" : @"\U0001f478",
        @"bride_with_veil" : @"\U0001f470",
        @"walking" : @"\U0001f6b6",
        @"runner" : @"\U0001f3c3",
        @"dancer" : @"\U0001f483",
        @"dancers" : @"\U0001f46f",
        @"couple" : @"\U0001f46b",
        @"two_men_holding_hands" : @"\U0001f46c",
        @"two_women_holding_hands" : @"\U0001f46d",
        @"bow" : @"\U0001f647",
        @"information_desk_person" : @"\U0001f481",
        @"no_good" : @"\U0001f645",
        @"ok_woman" : @"\U0001f646",
        @"raising_hand" : @"\U0001f64b",
        @"person_with_pouting_face" : @"\U0001f64e",
        @"person_frowning" : @"\U0001f64d",
        @"haircut" : @"\U0001f487",
        @"massage" : @"\U0001f486",
        @"couple_with_heart" : @"\U0001f491",
        @"couple_ww" : @"\U0001f469\U00002764\U0001f469",
        @"couple_mm" : @"\U0001f468\U00002764\U0001f468",
        @"couplekiss" : @"\U0001f48f",
        @"kiss_ww" : @"\U0001f469\U00002764\U0001f48b\U0001f469",
        @"kiss_mm" : @"\U0001f468\U00002764\U0001f48b\U0001f468",
        @"family" : @"\U0001f46a",
        @"family_mwg" : @"\U0001f468\U0001f469\U0001f467",
        @"family_mwgb" : @"\U0001f468\U0001f469\U0001f467\U0001f466",
        @"family_mwbb" : @"\U0001f468\U0001f469\U0001f466\U0001f466",
        @"family_mwgg" : @"\U0001f468\U0001f469\U0001f467\U0001f467",
        @"family_wwb" : @"\U0001f469\U0001f469\U0001f466",
        @"family_wwg" : @"\U0001f469\U0001f469\U0001f467",
        @"family_wwgb" : @"\U0001f469\U0001f469\U0001f467\U0001f466",
        @"family_wwbb" : @"\U0001f469\U0001f469\U0001f466\U0001f466",
        @"family_wwgg" : @"\U0001f469\U0001f469\U0001f467\U0001f467",
        @"family_mmb" : @"\U0001f468\U0001f468\U0001f466",
        @"family_mmg" : @"\U0001f468\U0001f468\U0001f467",
        @"family_mmgb" : @"\U0001f468\U0001f468\U0001f467\U0001f466",
        @"family_mmbb" : @"\U0001f468\U0001f468\U0001f466\U0001f466",
        @"family_mmgg" : @"\U0001f468\U0001f468\U0001f467\U0001f467",
        @"womans_clothes" : @"\U0001f45a",
        @"shirt" : @"\U0001f455",
        @"jeans" : @"\U0001f456",
        @"necktie" : @"\U0001f454",
        @"dress" : @"\U0001f457",
        @"bikini" : @"\U0001f459",
        @"kimono" : @"\U0001f458",
        @"lipstick" : @"\U0001f484",
        @"kiss" : @"\U0001f48b",
        @"footprints" : @"\U0001f463",
        @"high_heel" : @"\U0001f460",
        @"sandal" : @"\U0001f461",
        @"boot" : @"\U0001f462",
        @"mans_shoe" : @"\U0001f45e",
        @"athletic_shoe" : @"\U0001f45f",
        @"womans_hat" : @"\U0001f452",
        @"tophat" : @"\U0001f3a9",
        @"helmet_with_cross" : @"\U000026d1",
        @"mortar_board" : @"\U0001f393",
        @"crown" : @"\U0001f451",
        @"school_satchel" : @"\U0001f392",
        @"pouch" : @"\U0001f45d",
        @"purse" : @"\U0001f45b",
        @"handbag" : @"\U0001f45c",
        @"briefcase" : @"\U0001f4bc",
        @"eyeglasses" : @"\U0001f453",
        @"dark_sunglasses" : @"\U0001f576",
        @"ring" : @"\U0001f48d",
        @"closed_umbrella" : @"\U0001f302",
        @"dog" : @"\U0001f436",
        @"cat" : @"\U0001f431",
        @"mouse" : @"\U0001f42d",
        @"hamster" : @"\U0001f439",
        @"rabbit" : @"\U0001f430",
        @"bear" : @"\U0001f43b",
        @"panda_face" : @"\U0001f43c",
        @"koala" : @"\U0001f428",
        @"tiger" : @"\U0001f42f",
        @"lion_face" : @"\U0001f981",
        @"cow" : @"\U0001f42e",
        @"pig" : @"\U0001f437",
        @"pig_nose" : @"\U0001f43d",
        @"frog" : @"\U0001f438",
        @"octopus" : @"\U0001f419",
        @"monkey_face" : @"\U0001f435",
        @"see_no_evil" : @"\U0001f648",
        @"hear_no_evil" : @"\U0001f649",
        @"speak_no_evil" : @"\U0001f64a",
        @"monkey" : @"\U0001f412",
        @"chicken" : @"\U0001f414",
        @"penguin" : @"\U0001f427",
        @"bird" : @"\U0001f426",
        @"baby_chick" : @"\U0001f424",
        @"hatching_chick" : @"\U0001f423",
        @"hatched_chick" : @"\U0001f425",
        @"wolf" : @"\U0001f43a",
        @"boar" : @"\U0001f417",
        @"horse" : @"\U0001f434",
        @"unicorn" : @"\U0001f984",
        @"bee" : @"\U0001f41d",
        @"bug" : @"\U0001f41b",
        @"snail" : @"\U0001f40c",
        @"beetle" : @"\U0001f41e",
        @"ant" : @"\U0001f41c",
        @"spider" : @"\U0001f577",
        @"scorpion" : @"\U0001f982",
        @"crab" : @"\U0001f980",
        @"snake" : @"\U0001f40d",
        @"turtle" : @"\U0001f422",
        @"tropical_fish" : @"\U0001f420",
        @"fish" : @"\U0001f41f",
        @"blowfish" : @"\U0001f421",
        @"dolphin" : @"\U0001f42c",
        @"whale" : @"\U0001f433",
        @"whale2" : @"\U0001f40b",
        @"crocodile" : @"\U0001f40a",
        @"leopard" : @"\U0001f406",
        @"tiger2" : @"\U0001f405",
        @"water_buffalo" : @"\U0001f403",
        @"ox" : @"\U0001f402",
        @"cow2" : @"\U0001f404",
        @"dromedary_camel" : @"\U0001f42a",
        @"camel" : @"\U0001f42b",
        @"elephant" : @"\U0001f418",
        @"goat" : @"\U0001f410",
        @"ram" : @"\U0001f40f",
        @"sheep" : @"\U0001f411",
        @"racehorse" : @"\U0001f40e",
        @"pig2" : @"\U0001f416",
        @"rat" : @"\U0001f400",
        @"mouse2" : @"\U0001f401",
        @"rooster" : @"\U0001f413",
        @"turkey" : @"\U0001f983",
        @"dove" : @"\U0001f54a",
        @"dog2" : @"\U0001f415",
        @"poodle" : @"\U0001f429",
        @"cat2" : @"\U0001f408",
        @"rabbit2" : @"\U0001f407",
        @"chipmunk" : @"\U0001f43f",
        @"feet" : @"\U0001f43e",
        @"dragon" : @"\U0001f409",
        @"dragon_face" : @"\U0001f432",
        @"cactus" : @"\U0001f335",
        @"christmas_tree" : @"\U0001f384",
        @"evergreen_tree" : @"\U0001f332",
        @"deciduous_tree" : @"\U0001f333",
        @"palm_tree" : @"\U0001f334",
        @"seedling" : @"\U0001f331",
        @"herb" : @"\U0001f33f",
        @"shamrock" : @"\U00002618",
        @"four_leaf_clover" : @"\U0001f340",
        @"bamboo" : @"\U0001f38d",
        @"tanabata_tree" : @"\U0001f38b",
        @"leaves" : @"\U0001f343",
        @"fallen_leaf" : @"\U0001f342",
        @"maple_leaf" : @"\U0001f341",
        @"ear_of_rice" : @"\U0001f33e",
        @"hibiscus" : @"\U0001f33a",
        @"sunflower" : @"\U0001f33b",
        @"rose" : @"\U0001f339",
        @"tulip" : @"\U0001f337",
        @"blossom" : @"\U0001f33c",
        @"cherry_blossom" : @"\U0001f338",
        @"bouquet" : @"\U0001f490",
        @"mushroom" : @"\U0001f344",
        @"chestnut" : @"\U0001f330",
        @"jack_o_lantern" : @"\U0001f383",
        @"shell" : @"\U0001f41a",
        @"spider_web" : @"\U0001f578",
        @"earth_americas" : @"\U0001f30e",
        @"earth_africa" : @"\U0001f30d",
        @"earth_asia" : @"\U0001f30f",
        @"full_moon" : @"\U0001f315",
        @"waning_gibbous_moon" : @"\U0001f316",
        @"last_quarter_moon" : @"\U0001f317",
        @"waning_crescent_moon" : @"\U0001f318",
        @"new_moon" : @"\U0001f311",
        @"waxing_crescent_moon" : @"\U0001f312",
        @"first_quarter_moon" : @"\U0001f313",
        @"waxing_gibbous_moon" : @"\U0001f314",
        @"new_moon_with_face" : @"\U0001f31a",
        @"full_moon_with_face" : @"\U0001f31d",
        @"first_quarter_moon_with_face" : @"\U0001f31b",
        @"last_quarter_moon_with_face" : @"\U0001f31c",
        @"sun_with_face" : @"\U0001f31e",
        @"crescent_moon" : @"\U0001f319",
        @"star" : @"\U00002b50",
        @"star2" : @"\U0001f31f",
        @"dizzy" : @"\U0001f4ab",
        @"sparkles" : @"\U00002728",
        @"comet" : @"\U00002604",
        @"sunny" : @"\U00002600",
        @"white_sun_small_cloud" : @"\U0001f324",
        @"partly_sunny" : @"\U000026c5",
        @"white_sun_cloud" : @"\U0001f325",
        @"white_sun_rain_cloud" : @"\U0001f326",
        @"cloud" : @"\U00002601",
        @"cloud_rain" : @"\U0001f327",
        @"thunder_cloud_rain" : @"\U000026c8",
        @"cloud_lightning" : @"\U0001f329",
        @"zap" : @"\U000026a1",
        @"fire" : @"\U0001f525",
        @"boom" : @"\U0001f4a5",
        @"snowflake" : @"\U00002744",
        @"cloud_snow" : @"\U0001f328",
        @"snowman2" : @"\U00002603",
        @"snowman" : @"\U000026c4",
        @"wind_blowing_face" : @"\U0001f32c",
        @"dash" : @"\U0001f4a8",
        @"cloud_tornado" : @"\U0001f32a",
        @"fog" : @"\U0001f32b",
        @"umbrella2" : @"\U00002602",
        @"umbrella" : @"\U00002614",
        @"droplet" : @"\U0001f4a7",
        @"sweat_drops" : @"\U0001f4a6",
        @"ocean" : @"\U0001f30a",
        @"green_apple" : @"\U0001f34f",
        @"apple" : @"\U0001f34e",
        @"pear" : @"\U0001f350",
        @"tangerine" : @"\U0001f34a",
        @"lemon" : @"\U0001f34b",
        @"banana" : @"\U0001f34c",
        @"watermelon" : @"\U0001f349",
        @"grapes" : @"\U0001f347",
        @"strawberry" : @"\U0001f353",
        @"melon" : @"\U0001f348",
        @"cherries" : @"\U0001f352",
        @"peach" : @"\U0001f351",
        @"pineapple" : @"\U0001f34d",
        @"tomato" : @"\U0001f345",
        @"eggplant" : @"\U0001f346",
        @"hot_pepper" : @"\U0001f336",
        @"corn" : @"\U0001f33d",
        @"sweet_potato" : @"\U0001f360",
        @"honey_pot" : @"\U0001f36f",
        @"bread" : @"\U0001f35e",
        @"cheese" : @"\U0001f9c0",
        @"poultry_leg" : @"\U0001f357",
        @"meat_on_bone" : @"\U0001f356",
        @"fried_shrimp" : @"\U0001f364",
        @"cooking" : @"\U0001f373",
        @"hamburger" : @"\U0001f354",
        @"fries" : @"\U0001f35f",
        @"hotdog" : @"\U0001f32d",
        @"pizza" : @"\U0001f355",
        @"spaghetti" : @"\U0001f35d",
        @"taco" : @"\U0001f32e",
        @"burrito" : @"\U0001f32f",
        @"ramen" : @"\U0001f35c",
        @"stew" : @"\U0001f372",
        @"fish_cake" : @"\U0001f365",
        @"sushi" : @"\U0001f363",
        @"bento" : @"\U0001f371",
        @"curry" : @"\U0001f35b",
        @"rice_ball" : @"\U0001f359",
        @"rice" : @"\U0001f35a",
        @"rice_cracker" : @"\U0001f358",
        @"oden" : @"\U0001f362",
        @"dango" : @"\U0001f361",
        @"shaved_ice" : @"\U0001f367",
        @"ice_cream" : @"\U0001f368",
        @"icecream" : @"\U0001f366",
        @"cake" : @"\U0001f370",
        @"birthday" : @"\U0001f382",
        @"custard" : @"\U0001f36e",
        @"candy" : @"\U0001f36c",
        @"lollipop" : @"\U0001f36d",
        @"chocolate_bar" : @"\U0001f36b",
        @"popcorn" : @"\U0001f37f",
        @"doughnut" : @"\U0001f369",
        @"cookie" : @"\U0001f36a",
        @"beer" : @"\U0001f37a",
        @"beers" : @"\U0001f37b",
        @"wine_glass" : @"\U0001f377",
        @"cocktail" : @"\U0001f378",
        @"tropical_drink" : @"\U0001f379",
        @"champagne" : @"\U0001f37e",
        @"sake" : @"\U0001f376",
        @"tea" : @"\U0001f375",
        @"coffee" : @"\U00002615",
        @"baby_bottle" : @"\U0001f37c",
        @"fork_and_knife" : @"\U0001f374",
        @"fork_knife_plate" : @"\U0001f37d",
        @"soccer" : @"\U000026bd",
        @"basketball" : @"\U0001f3c0",
        @"football" : @"\U0001f3c8",
        @"baseball" : @"\U000026be",
        @"tennis" : @"\U0001f3be",
        @"volleyball" : @"\U0001f3d0",
        @"rugby_football" : @"\U0001f3c9",
        @"8ball" : @"\U0001f3b1",
        @"golf" : @"\U000026f3",
        @"golfer" : @"\U0001f3cc",
        @"ping_pong" : @"\U0001f3d3",
        @"badminton" : @"\U0001f3f8",
        @"hockey" : @"\U0001f3d2",
        @"field_hockey" : @"\U0001f3d1",
        @"cricket" : @"\U0001f3cf",
        @"ski" : @"\U0001f3bf",
        @"skier" : @"\U000026f7",
        @"snowboarder" : @"\U0001f3c2",
        @"ice_skate" : @"\U000026f8",
        @"bow_and_arrow" : @"\U0001f3f9",
        @"fishing_pole_and_fish" : @"\U0001f3a3",
        @"rowboat" : @"\U0001f6a3",
        @"swimmer" : @"\U0001f3ca",
        @"surfer" : @"\U0001f3c4",
        @"bath" : @"\U0001f6c0",
        @"basketball_player" : @"\U000026f9",
        @"lifter" : @"\U0001f3cb",
        @"bicyclist" : @"\U0001f6b4",
        @"mountain_bicyclist" : @"\U0001f6b5",
        @"horse_racing" : @"\U0001f3c7",
        @"levitate" : @"\U0001f574",
        @"trophy" : @"\U0001f3c6",
        @"running_shirt_with_sash" : @"\U0001f3bd",
        @"medal" : @"\U0001f3c5",
        @"military_medal" : @"\U0001f396",
        @"reminder_ribbon" : @"\U0001f397",
        @"rosette" : @"\U0001f3f5",
        @"ticket" : @"\U0001f3ab",
        @"tickets" : @"\U0001f39f",
        @"performing_arts" : @"\U0001f3ad",
        @"art" : @"\U0001f3a8",
        @"circus_tent" : @"\U0001f3aa",
        @"microphone" : @"\U0001f3a4",
        @"headphones" : @"\U0001f3a7",
        @"musical_score" : @"\U0001f3bc",
        @"musical_keyboard" : @"\U0001f3b9",
        @"saxophone" : @"\U0001f3b7",
        @"trumpet" : @"\U0001f3ba",
        @"guitar" : @"\U0001f3b8",
        @"violin" : @"\U0001f3bb",
        @"clapper" : @"\U0001f3ac",
        @"video_game" : @"\U0001f3ae",
        @"space_invader" : @"\U0001f47e",
        @"dart" : @"\U0001f3af",
        @"game_die" : @"\U0001f3b2",
        @"slot_machine" : @"\U0001f3b0",
        @"bowling" : @"\U0001f3b3",
        @"red_car" : @"\U0001f697",
        @"taxi" : @"\U0001f695",
        @"blue_car" : @"\U0001f699",
        @"bus" : @"\U0001f68c",
        @"trolleybus" : @"\U0001f68e",
        @"race_car" : @"\U0001f3ce",
        @"police_car" : @"\U0001f693",
        @"ambulance" : @"\U0001f691",
        @"fire_engine" : @"\U0001f692",
        @"minibus" : @"\U0001f690",
        @"truck" : @"\U0001f69a",
        @"articulated_lorry" : @"\U0001f69b",
        @"tractor" : @"\U0001f69c",
        @"motorcycle" : @"\U0001f3cd",
        @"bike" : @"\U0001f6b2",
        @"rotating_light" : @"\U0001f6a8",
        @"oncoming_police_car" : @"\U0001f694",
        @"oncoming_bus" : @"\U0001f68d",
        @"oncoming_automobile" : @"\U0001f698",
        @"oncoming_taxi" : @"\U0001f696",
        @"aerial_tramway" : @"\U0001f6a1",
        @"mountain_cableway" : @"\U0001f6a0",
        @"suspension_railway" : @"\U0001f69f",
        @"railway_car" : @"\U0001f683",
        @"train" : @"\U0001f68b",
        @"monorail" : @"\U0001f69d",
        @"bullettrain_side" : @"\U0001f684",
        @"bullettrain_front" : @"\U0001f685",
        @"light_rail" : @"\U0001f688",
        @"mountain_railway" : @"\U0001f69e",
        @"steam_locomotive" : @"\U0001f682",
        @"train2" : @"\U0001f686",
        @"metro" : @"\U0001f687",
        @"tram" : @"\U0001f68a",
        @"station" : @"\U0001f689",
        @"helicopter" : @"\U0001f681",
        @"airplane_small" : @"\U0001f6e9",
        @"airplane" : @"\U00002708",
        @"airplane_departure" : @"\U0001f6eb",
        @"airplane_arriving" : @"\U0001f6ec",
        @"sailboat" : @"\U000026f5",
        @"motorboat" : @"\U0001f6e5",
        @"speedboat" : @"\U0001f6a4",
        @"ferry" : @"\U000026f4",
        @"cruise_ship" : @"\U0001f6f3",
        @"rocket" : @"\U0001f680",
        @"satellite_orbital" : @"\U0001f6f0",
        @"seat" : @"\U0001f4ba",
        @"anchor" : @"\U00002693",
        @"construction" : @"\U0001f6a7",
        @"fuelpump" : @"\U000026fd",
        @"busstop" : @"\U0001f68f",
        @"vertical_traffic_light" : @"\U0001f6a6",
        @"traffic_light" : @"\U0001f6a5",
        @"checkered_flag" : @"\U0001f3c1",
        @"ship" : @"\U0001f6a2",
        @"ferris_wheel" : @"\U0001f3a1",
        @"roller_coaster" : @"\U0001f3a2",
        @"carousel_horse" : @"\U0001f3a0",
        @"construction_site" : @"\U0001f3d7",
        @"foggy" : @"\U0001f301",
        @"tokyo_tower" : @"\U0001f5fc",
        @"factory" : @"\U0001f3ed",
        @"fountain" : @"\U000026f2",
        @"rice_scene" : @"\U0001f391",
        @"mountain" : @"\U000026f0",
        @"mountain_snow" : @"\U0001f3d4",
        @"mount_fuji" : @"\U0001f5fb",
        @"volcano" : @"\U0001f30b",
        @"japan" : @"\U0001f5fe",
        @"camping" : @"\U0001f3d5",
        @"tent" : @"\U000026fa",
        @"park" : @"\U0001f3de",
        @"motorway" : @"\U0001f6e3",
        @"railway_track" : @"\U0001f6e4",
        @"sunrise" : @"\U0001f305",
        @"sunrise_over_mountains" : @"\U0001f304",
        @"desert" : @"\U0001f3dc",
        @"beach" : @"\U0001f3d6",
        @"island" : @"\U0001f3dd",
        @"city_sunset" : @"\U0001f307",
        @"city_dusk" : @"\U0001f306",
        @"cityscape" : @"\U0001f3d9",
        @"night_with_stars" : @"\U0001f303",
        @"bridge_at_night" : @"\U0001f309",
        @"milky_way" : @"\U0001f30c",
        @"stars" : @"\U0001f320",
        @"sparkler" : @"\U0001f387",
        @"fireworks" : @"\U0001f386",
        @"rainbow" : @"\U0001f308",
        @"homes" : @"\U0001f3d8",
        @"european_castle" : @"\U0001f3f0",
        @"japanese_castle" : @"\U0001f3ef",
        @"stadium" : @"\U0001f3df",
        @"statue_of_liberty" : @"\U0001f5fd",
        @"house" : @"\U0001f3e0",
        @"house_with_garden" : @"\U0001f3e1",
        @"house_abandoned" : @"\U0001f3da",
        @"office" : @"\U0001f3e2",
        @"department_store" : @"\U0001f3ec",
        @"post_office" : @"\U0001f3e3",
        @"european_post_office" : @"\U0001f3e4",
        @"hospital" : @"\U0001f3e5",
        @"bank" : @"\U0001f3e6",
        @"hotel" : @"\U0001f3e8",
        @"convenience_store" : @"\U0001f3ea",
        @"school" : @"\U0001f3eb",
        @"love_hotel" : @"\U0001f3e9",
        @"wedding" : @"\U0001f492",
        @"classical_building" : @"\U0001f3db",
        @"church" : @"\U000026ea",
        @"mosque" : @"\U0001f54c",
        @"synagogue" : @"\U0001f54d",
        @"kaaba" : @"\U0001f54b",
        @"shinto_shrine" : @"\U000026e9",
        @"watch" : @"\U0000231a",
        @"iphone" : @"\U0001f4f1",
        @"calling" : @"\U0001f4f2",
        @"computer" : @"\U0001f4bb",
        @"keyboard" : @"\U00002328",
        @"desktop" : @"\U0001f5a5",
        @"printer" : @"\U0001f5a8",
        @"mouse_three_button" : @"\U0001f5b1",
        @"trackball" : @"\U0001f5b2",
        @"joystick" : @"\U0001f579",
        @"compression" : @"\U0001f5dc",
        @"minidisc" : @"\U0001f4bd",
        @"floppy_disk" : @"\U0001f4be",
        @"cd" : @"\U0001f4bf",
        @"dvd" : @"\U0001f4c0",
        @"vhs" : @"\U0001f4fc",
        @"camera" : @"\U0001f4f7",
        @"camera_with_flash" : @"\U0001f4f8",
        @"video_camera" : @"\U0001f4f9",
        @"movie_camera" : @"\U0001f3a5",
        @"projector" : @"\U0001f4fd",
        @"film_frames" : @"\U0001f39e",
        @"telephone_receiver" : @"\U0001f4de",
        @"telephone" : @"\U0000260e",
        @"pager" : @"\U0001f4df",
        @"fax" : @"\U0001f4e0",
        @"tv" : @"\U0001f4fa",
        @"radio" : @"\U0001f4fb",
        @"microphone2" : @"\U0001f399",
        @"level_slider" : @"\U0001f39a",
        @"control_knobs" : @"\U0001f39b",
        @"stopwatch" : @"\U000023f1",
        @"timer" : @"\U000023f2",
        @"alarm_clock" : @"\U000023f0",
        @"clock" : @"\U0001f570",
        @"hourglass_flowing_sand" : @"\U000023f3",
        @"hourglass" : @"\U0000231b",
        @"satellite" : @"\U0001f4e1",
        @"battery" : @"\U0001f50b",
        @"electric_plug" : @"\U0001f50c",
        @"bulb" : @"\U0001f4a1",
        @"flashlight" : @"\U0001f526",
        @"candle" : @"\U0001f56f",
        @"wastebasket" : @"\U0001f5d1",
        @"oil" : @"\U0001f6e2",
        @"money_with_wings" : @"\U0001f4b8",
        @"dollar" : @"\U0001f4b5",
        @"yen" : @"\U0001f4b4",
        @"euro" : @"\U0001f4b6",
        @"pound" : @"\U0001f4b7",
        @"moneybag" : @"\U0001f4b0",
        @"credit_card" : @"\U0001f4b3",
        @"gem" : @"\U0001f48e",
        @"scales" : @"\U00002696",
        @"wrench" : @"\U0001f527",
        @"hammer" : @"\U0001f528",
        @"hammer_pick" : @"\U00002692",
        @"tools" : @"\U0001f6e0",
        @"pick" : @"\U000026cf",
        @"nut_and_bolt" : @"\U0001f529",
        @"gear" : @"\U00002699",
        @"chains" : @"\U000026d3",
        @"gun" : @"\U0001f52b",
        @"bomb" : @"\U0001f4a3",
        @"knife" : @"\U0001f52a",
        @"dagger" : @"\U0001f5e1",
        @"crossed_swords" : @"\U00002694",
        @"shield" : @"\U0001f6e1",
        @"smoking" : @"\U0001f6ac",
        @"skull_crossbones" : @"\U00002620",
        @"coffin" : @"\U000026b0",
        @"urn" : @"\U000026b1",
        @"amphora" : @"\U0001f3fa",
        @"crystal_ball" : @"\U0001f52e",
        @"prayer_beads" : @"\U0001f4ff",
        @"barber" : @"\U0001f488",
        @"alembic" : @"\U00002697",
        @"telescope" : @"\U0001f52d",
        @"microscope" : @"\U0001f52c",
        @"hole" : @"\U0001f573",
        @"pill" : @"\U0001f48a",
        @"syringe" : @"\U0001f489",
        @"thermometer" : @"\U0001f321",
        @"label" : @"\U0001f3f7",
        @"bookmark" : @"\U0001f516",
        @"toilet" : @"\U0001f6bd",
        @"shower" : @"\U0001f6bf",
        @"bathtub" : @"\U0001f6c1",
        @"key" : @"\U0001f511",
        @"key2" : @"\U0001f5dd",
        @"couch" : @"\U0001f6cb",
        @"sleeping_accommodation" : @"\U0001f6cc",
        @"bed" : @"\U0001f6cf",
        @"door" : @"\U0001f6aa",
        @"bellhop" : @"\U0001f6ce",
        @"frame_photo" : @"\U0001f5bc",
        @"map" : @"\U0001f5fa",
        @"beach_umbrella" : @"\U000026f1",
        @"moyai" : @"\U0001f5ff",
        @"shopping_bags" : @"\U0001f6cd",
        @"balloon" : @"\U0001f388",
        @"flags" : @"\U0001f38f",
        @"ribbon" : @"\U0001f380",
        @"gift" : @"\U0001f381",
        @"confetti_ball" : @"\U0001f38a",
        @"tada" : @"\U0001f389",
        @"dolls" : @"\U0001f38e",
        @"wind_chime" : @"\U0001f390",
        @"crossed_flags" : @"\U0001f38c",
        @"izakaya_lantern" : @"\U0001f3ee",
        @"envelope" : @"\U00002709",
        @"envelope_with_arrow" : @"\U0001f4e9",
        @"incoming_envelope" : @"\U0001f4e8",
        @"e-mail" : @"\U0001f4e7",
        @"love_letter" : @"\U0001f48c",
        @"postbox" : @"\U0001f4ee",
        @"mailbox_closed" : @"\U0001f4ea",
        @"mailbox" : @"\U0001f4eb",
        @"mailbox_with_mail" : @"\U0001f4ec",
        @"mailbox_with_no_mail" : @"\U0001f4ed",
        @"package" : @"\U0001f4e6",
        @"postal_horn" : @"\U0001f4ef",
        @"inbox_tray" : @"\U0001f4e5",
        @"outbox_tray" : @"\U0001f4e4",
        @"scroll" : @"\U0001f4dc",
        @"page_with_curl" : @"\U0001f4c3",
        @"bookmark_tabs" : @"\U0001f4d1",
        @"bar_chart" : @"\U0001f4ca",
        @"chart_with_upwards_trend" : @"\U0001f4c8",
        @"chart_with_downwards_trend" : @"\U0001f4c9",
        @"page_facing_up" : @"\U0001f4c4",
        @"date" : @"\U0001f4c5",
        @"calendar" : @"\U0001f4c6",
        @"calendar_spiral" : @"\U0001f5d3",
        @"card_index" : @"\U0001f4c7",
        @"card_box" : @"\U0001f5c3",
        @"ballot_box" : @"\U0001f5f3",
        @"file_cabinet" : @"\U0001f5c4",
        @"clipboard" : @"\U0001f4cb",
        @"notepad_spiral" : @"\U0001f5d2",
        @"file_folder" : @"\U0001f4c1",
        @"open_file_folder" : @"\U0001f4c2",
        @"dividers" : @"\U0001f5c2",
        @"newspaper2" : @"\U0001f5de",
        @"newspaper" : @"\U0001f4f0",
        @"notebook" : @"\U0001f4d3",
        @"closed_book" : @"\U0001f4d5",
        @"green_book" : @"\U0001f4d7",
        @"blue_book" : @"\U0001f4d8",
        @"orange_book" : @"\U0001f4d9",
        @"notebook_with_decorative_cover" : @"\U0001f4d4",
        @"ledger" : @"\U0001f4d2",
        @"books" : @"\U0001f4da",
        @"book" : @"\U0001f4d6",
        @"link" : @"\U0001f517",
        @"paperclip" : @"\U0001f4ce",
        @"paperclips" : @"\U0001f587",
        @"scissors" : @"\U00002702",
        @"triangular_ruler" : @"\U0001f4d0",
        @"straight_ruler" : @"\U0001f4cf",
        @"pushpin" : @"\U0001f4cc",
        @"round_pushpin" : @"\U0001f4cd",
        @"triangular_flag_on_post" : @"\U0001f6a9",
        @"flag_white" : @"\U0001f3f3",
        @"flag_black" : @"\U0001f3f4",
        @"closed_lock_with_key" : @"\U0001f510",
        @"lock" : @"\U0001f512",
        @"unlock" : @"\U0001f513",
        @"lock_with_ink_pen" : @"\U0001f50f",
        @"pen_ballpoint" : @"\U0001f58a",
        @"pen_fountain" : @"\U0001f58b",
        @"black_nib" : @"\U00002712",
        @"pencil" : @"\U0001f4dd",
        @"pencil2" : @"\U0000270f",
        @"crayon" : @"\U0001f58d",
        @"paintbrush" : @"\U0001f58c",
        @"mag" : @"\U0001f50d",
        @"mag_right" : @"\U0001f50e",
        @"heart" : @"\U00002764",
        @"yellow_heart" : @"\U0001f49b",
        @"green_heart" : @"\U0001f49a",
        @"blue_heart" : @"\U0001f499",
        @"purple_heart" : @"\U0001f49c",
        @"broken_heart" : @"\U0001f494",
        @"heart_exclamation" : @"\U00002763",
        @"two_hearts" : @"\U0001f495",
        @"revolving_hearts" : @"\U0001f49e",
        @"heartbeat" : @"\U0001f493",
        @"heartpulse" : @"\U0001f497",
        @"sparkling_heart" : @"\U0001f496",
        @"cupid" : @"\U0001f498",
        @"gift_heart" : @"\U0001f49d",
        @"heart_decoration" : @"\U0001f49f",
        @"peace" : @"\U0000262e",
        @"cross" : @"\U0000271d",
        @"star_and_crescent" : @"\U0000262a",
        @"om_symbol" : @"\U0001f549",
        @"wheel_of_dharma" : @"\U00002638",
        @"star_of_david" : @"\U00002721",
        @"six_pointed_star" : @"\U0001f52f",
        @"menorah" : @"\U0001f54e",
        @"yin_yang" : @"\U0000262f",
        @"orthodox_cross" : @"\U00002626",
        @"place_of_worship" : @"\U0001f6d0",
        @"ophiuchus" : @"\U000026ce",
        @"aries" : @"\U00002648",
        @"taurus" : @"\U00002649",
        @"gemini" : @"\U0000264a",
        @"cancer" : @"\U0000264b",
        @"leo" : @"\U0000264c",
        @"virgo" : @"\U0000264d",
        @"libra" : @"\U0000264e",
        @"scorpius" : @"\U0000264f",
        @"sagittarius" : @"\U00002650",
        @"capricorn" : @"\U00002651",
        @"aquarius" : @"\U00002652",
        @"pisces" : @"\U00002653",
        @"id" : @"\U0001f194",
        @"atom" : @"\U0000269b",
        @"u7a7a" : @"\U0001f233",
        @"u5272" : @"\U0001f239",
        @"radioactive" : @"\U00002622",
        @"biohazard" : @"\U00002623",
        @"mobile_phone_off" : @"\U0001f4f4",
        @"vibration_mode" : @"\U0001f4f3",
        @"u6709" : @"\U0001f236",
        @"u7121" : @"\U0001f21a",
        @"u7533" : @"\U0001f238",
        @"u55b6" : @"\U0001f23a",
        @"u6708" : @"\U0001f237",
        @"eight_pointed_black_star" : @"\U00002734",
        @"vs" : @"\U0001f19a",
        @"accept" : @"\U0001f251",
        @"white_flower" : @"\U0001f4ae",
        @"ideograph_advantage" : @"\U0001f250",
        @"secret" : @"\U00003299",
        @"congratulations" : @"\U00003297",
        @"u5408" : @"\U0001f234",
        @"u6e80" : @"\U0001f235",
        @"u7981" : @"\U0001f232",
        @"a" : @"\U0001f170",
        @"b" : @"\U0001f171",
        @"ab" : @"\U0001f18e",
        @"cl" : @"\U0001f191",
        @"o2" : @"\U0001f17e",
        @"sos" : @"\U0001f198",
        @"no_entry" : @"\U000026d4",
        @"name_badge" : @"\U0001f4db",
        @"no_entry_sign" : @"\U0001f6ab",
        @"x" : @"\U0000274c",
        @"o" : @"\U00002b55",
        @"anger" : @"\U0001f4a2",
        @"hotsprings" : @"\U00002668",
        @"no_pedestrians" : @"\U0001f6b7",
        @"do_not_litter" : @"\U0001f6af",
        @"no_bicycles" : @"\U0001f6b3",
        @"non-potable_water" : @"\U0001f6b1",
        @"underage" : @"\U0001f51e",
        @"no_mobile_phones" : @"\U0001f4f5",
        @"exclamation" : @"\U00002757",
        @"grey_exclamation" : @"\U00002755",
        @"question" : @"\U00002753",
        @"grey_question" : @"\U00002754",
        @"bangbang" : @"\U0000203c",
        @"interrobang" : @"\U00002049",
        @"low_brightness" : @"\U0001f505",
        @"high_brightness" : @"\U0001f506",
        @"trident" : @"\U0001f531",
        @"fleur-de-lis" : @"\U0000269c",
        @"part_alternation_mark" : @"\U0000303d",
        @"warning" : @"\U000026a0",
        @"children_crossing" : @"\U0001f6b8",
        @"beginner" : @"\U0001f530",
        @"recycle" : @"\U0000267b",
        @"u6307" : @"\U0001f22f",
        @"chart" : @"\U0001f4b9",
        @"sparkle" : @"\U00002747",
        @"eight_spoked_asterisk" : @"\U00002733",
        @"negative_squared_cross_mark" : @"\U0000274e",
        @"white_check_mark" : @"\U00002705",
        @"diamond_shape_with_a_dot_inside" : @"\U0001f4a0",
        @"cyclone" : @"\U0001f300",
        @"loop" : @"\U000027bf",
        @"globe_with_meridians" : @"\U0001f310",
        @"m" : @"\U000024c2",
        @"atm" : @"\U0001f3e7",
        @"sa" : @"\U0001f202",
        @"passport_control" : @"\U0001f6c2",
        @"customs" : @"\U0001f6c3",
        @"baggage_claim" : @"\U0001f6c4",
        @"left_luggage" : @"\U0001f6c5",
        @"wheelchair" : @"\U0000267f",
        @"no_smoking" : @"\U0001f6ad",
        @"wc" : @"\U0001f6be",
        @"parking" : @"\U0001f17f",
        @"potable_water" : @"\U0001f6b0",
        @"mens" : @"\U0001f6b9",
        @"womens" : @"\U0001f6ba",
        @"baby_symbol" : @"\U0001f6bc",
        @"restroom" : @"\U0001f6bb",
        @"put_litter_in_its_place" : @"\U0001f6ae",
        @"cinema" : @"\U0001f3a6",
        @"signal_strength" : @"\U0001f4f6",
        @"koko" : @"\U0001f201",
        @"ng" : @"\U0001f196",
        @"ok" : @"\U0001f197",
        @"up" : @"\U0001f199",
        @"cool" : @"\U0001f192",
        @"new" : @"\U0001f195",
        @"free" : @"\U0001f193",
        @"zero" : @"0\U000020e3",
        @"one" : @"1\U000020e3",
        @"two" : @"2\U000020e3",
        @"three" : @"3\U000020e3",
        @"four" : @"4\U000020e3",
        @"five" : @"5\U000020e3",
        @"six" : @"6\U000020e3",
        @"seven" : @"7\U000020e3",
        @"eight" : @"8\U000020e3",
        @"nine" : @"9\U000020e3",
        @"keycap_ten" : @"\U0001f51f",
        @"arrow_forward" : @"\U000025b6",
        @"pause_button" : @"\U000023f8",
        @"play_pause" : @"\U000023ef",
        @"stop_button" : @"\U000023f9",
        @"record_button" : @"\U000023fa",
        @"track_next" : @"\U000023ed",
        @"track_previous" : @"\U000023ee",
        @"fast_forward" : @"\U000023e9",
        @"rewind" : @"\U000023ea",
        @"twisted_rightwards_arrows" : @"\U0001f500",
        @"repeat" : @"\U0001f501",
        @"repeat_one" : @"\U0001f502",
        @"arrow_backward" : @"\U000025c0",
        @"arrow_up_small" : @"\U0001f53c",
        @"arrow_down_small" : @"\U0001f53d",
        @"arrow_double_up" : @"\U000023eb",
        @"arrow_double_down" : @"\U000023ec",
        @"arrow_right" : @"\U000027a1",
        @"arrow_left" : @"\U00002b05",
        @"arrow_up" : @"\U00002b06",
        @"arrow_down" : @"\U00002b07",
        @"arrow_upper_right" : @"\U00002197",
        @"arrow_lower_right" : @"\U00002198",
        @"arrow_lower_left" : @"\U00002199",
        @"arrow_upper_left" : @"\U00002196",
        @"arrow_up_down" : @"\U00002195",
        @"left_right_arrow" : @"\U00002194",
        @"arrows_counterclockwise" : @"\U0001f504",
        @"arrow_right_hook" : @"\U000021aa",
        @"leftwards_arrow_with_hook" : @"\U000021a9",
        @"arrow_heading_up" : @"\U00002934",
        @"arrow_heading_down" : @"\U00002935",
        @"hash" : @"#\U000020e3",
        @"asterisk" : @"\U0000002a\U000020e3",
        @"information_source" : @"\U00002139",
        @"abc" : @"\U0001f524",
        @"abcd" : @"\U0001f521",
        @"capital_abcd" : @"\U0001f520",
        @"symbols" : @"\U0001f523",
        @"musical_note" : @"\U0001f3b5",
        @"notes" : @"\U0001f3b6",
        @"wavy_dash" : @"\U00003030",
        @"curly_loop" : @"\U000027b0",
        @"heavy_check_mark" : @"\U00002714",
        @"arrows_clockwise" : @"\U0001f503",
        @"heavy_plus_sign" : @"\U00002795",
        @"heavy_minus_sign" : @"\U00002796",
        @"heavy_division_sign" : @"\U00002797",
        @"heavy_multiplication_x" : @"\U00002716",
        @"heavy_dollar_sign" : @"\U0001f4b2",
        @"currency_exchange" : @"\U0001f4b1",
        @"copyright" : @"\U000000a9",
        @"registered" : @"\U000000ae",
        @"tm" : @"\U00002122",
        @"end" : @"\U0001f51a",
        @"back" : @"\U0001f519",
        @"on" : @"\U0001f51b",
        @"top" : @"\U0001f51d",
        @"soon" : @"\U0001f51c",
        @"ballot_box_with_check" : @"\U00002611",
        @"radio_button" : @"\U0001f518",
        @"white_circle" : @"\U000026aa",
        @"black_circle" : @"\U000026ab",
        @"red_circle" : @"\U0001f534",
        @"large_blue_circle" : @"\U0001f535",
        @"small_orange_diamond" : @"\U0001f538",
        @"small_blue_diamond" : @"\U0001f539",
        @"large_orange_diamond" : @"\U0001f536",
        @"large_blue_diamond" : @"\U0001f537",
        @"small_red_triangle" : @"\U0001f53a",
        @"black_small_square" : @"\U000025aa",
        @"white_small_square" : @"\U000025ab",
        @"black_large_square" : @"\U00002b1b",
        @"white_large_square" : @"\U00002b1c",
        @"small_red_triangle_down" : @"\U0001f53b",
        @"black_medium_square" : @"\U000025fc",
        @"white_medium_square" : @"\U000025fb",
        @"black_medium_small_square" : @"\U000025fe",
        @"white_medium_small_square" : @"\U000025fd",
        @"black_square_button" : @"\U0001f532",
        @"white_square_button" : @"\U0001f533",
        @"speaker" : @"\U0001f508",
        @"sound" : @"\U0001f509",
        @"loud_sound" : @"\U0001f50a",
        @"mute" : @"\U0001f507",
        @"mega" : @"\U0001f4e3",
        @"loudspeaker" : @"\U0001f4e2",
        @"bell" : @"\U0001f514",
        @"no_bell" : @"\U0001f515",
        @"black_joker" : @"\U0001f0cf",
        @"mahjong" : @"\U0001f004",
        @"spades" : @"\U00002660",
        @"clubs" : @"\U00002663",
        @"hearts" : @"\U00002665",
        @"diamonds" : @"\U00002666",
        @"flower_playing_cards" : @"\U0001f3b4",
        @"thought_balloon" : @"\U0001f4ad",
        @"anger_right" : @"\U0001f5ef",
        @"speech_balloon" : @"\U0001f4ac",
        @"clock1" : @"\U0001f550",
        @"clock2" : @"\U0001f551",
        @"clock3" : @"\U0001f552",
        @"clock4" : @"\U0001f553",
        @"clock5" : @"\U0001f554",
        @"clock6" : @"\U0001f555",
        @"clock7" : @"\U0001f556",
        @"clock8" : @"\U0001f557",
        @"clock9" : @"\U0001f558",
        @"clock10" : @"\U0001f559",
        @"clock11" : @"\U0001f55a",
        @"clock12" : @"\U0001f55b",
        @"clock130" : @"\U0001f55c",
        @"clock230" : @"\U0001f55d",
        @"clock330" : @"\U0001f55e",
        @"clock430" : @"\U0001f55f",
        @"clock530" : @"\U0001f560",
        @"clock630" : @"\U0001f561",
        @"clock730" : @"\U0001f562",
        @"clock830" : @"\U0001f563",
        @"clock930" : @"\U0001f564",
        @"clock1030" : @"\U0001f565",
        @"clock1130" : @"\U0001f566",
        @"clock1230" : @"\U0001f567",
        @"eye_in_speech_bubble" : @"\U0001f441\U0001f5e8",
        @"flag_ac" : @"\U0001f1e6\U0001f1e8",
        @"flag_af" : @"\U0001f1e6\U0001f1eb",
        @"flag_al" : @"\U0001f1e6\U0001f1f1",
        @"flag_dz" : @"\U0001f1e9\U0001f1ff",
        @"flag_ad" : @"\U0001f1e6\U0001f1e9",
        @"flag_ao" : @"\U0001f1e6\U0001f1f4",
        @"flag_ai" : @"\U0001f1e6\U0001f1ee",
        @"flag_ag" : @"\U0001f1e6\U0001f1ec",
        @"flag_ar" : @"\U0001f1e6\U0001f1f7",
        @"flag_am" : @"\U0001f1e6\U0001f1f2",
        @"flag_aw" : @"\U0001f1e6\U0001f1fc",
        @"flag_au" : @"\U0001f1e6\U0001f1fa",
        @"flag_at" : @"\U0001f1e6\U0001f1f9",
        @"flag_az" : @"\U0001f1e6\U0001f1ff",
        @"flag_bs" : @"\U0001f1e7\U0001f1f8",
        @"flag_bh" : @"\U0001f1e7\U0001f1ed",
        @"flag_bd" : @"\U0001f1e7\U0001f1e9",
        @"flag_bb" : @"\U0001f1e7\U0001f1e7",
        @"flag_by" : @"\U0001f1e7\U0001f1fe",
        @"flag_be" : @"\U0001f1e7\U0001f1ea",
        @"flag_bz" : @"\U0001f1e7\U0001f1ff",
        @"flag_bj" : @"\U0001f1e7\U0001f1ef",
        @"flag_bm" : @"\U0001f1e7\U0001f1f2",
        @"flag_bt" : @"\U0001f1e7\U0001f1f9",
        @"flag_bo" : @"\U0001f1e7\U0001f1f4",
        @"flag_ba" : @"\U0001f1e7\U0001f1e6",
        @"flag_bw" : @"\U0001f1e7\U0001f1fc",
        @"flag_br" : @"\U0001f1e7\U0001f1f7",
        @"flag_bn" : @"\U0001f1e7\U0001f1f3",
        @"flag_bg" : @"\U0001f1e7\U0001f1ec",
        @"flag_bf" : @"\U0001f1e7\U0001f1eb",
        @"flag_bi" : @"\U0001f1e7\U0001f1ee",
        @"flag_cv" : @"\U0001f1e8\U0001f1fb",
        @"flag_kh" : @"\U0001f1f0\U0001f1ed",
        @"flag_cm" : @"\U0001f1e8\U0001f1f2",
        @"flag_ca" : @"\U0001f1e8\U0001f1e6",
        @"flag_ky" : @"\U0001f1f0\U0001f1fe",
        @"flag_cf" : @"\U0001f1e8\U0001f1eb",
        @"flag_td" : @"\U0001f1f9\U0001f1e9",
        @"flag_cl" : @"\U0001f1e8\U0001f1f1",
        @"flag_cn" : @"\U0001f1e8\U0001f1f3",
        @"flag_co" : @"\U0001f1e8\U0001f1f4",
        @"flag_km" : @"\U0001f1f0\U0001f1f2",
        @"flag_cg" : @"\U0001f1e8\U0001f1ec",
        @"flag_cd" : @"\U0001f1e8\U0001f1e9",
        @"flag_cr" : @"\U0001f1e8\U0001f1f7",
        @"flag_hr" : @"\U0001f1ed\U0001f1f7",
        @"flag_cu" : @"\U0001f1e8\U0001f1fa",
        @"flag_cy" : @"\U0001f1e8\U0001f1fe",
        @"flag_cz" : @"\U0001f1e8\U0001f1ff",
        @"flag_dk" : @"\U0001f1e9\U0001f1f0",
        @"flag_dj" : @"\U0001f1e9\U0001f1ef",
        @"flag_dm" : @"\U0001f1e9\U0001f1f2",
        @"flag_do" : @"\U0001f1e9\U0001f1f4",
        @"flag_ec" : @"\U0001f1ea\U0001f1e8",
        @"flag_eg" : @"\U0001f1ea\U0001f1ec",
        @"flag_sv" : @"\U0001f1f8\U0001f1fb",
        @"flag_gq" : @"\U0001f1ec\U0001f1f6",
        @"flag_er" : @"\U0001f1ea\U0001f1f7",
        @"flag_ee" : @"\U0001f1ea\U0001f1ea",
        @"flag_et" : @"\U0001f1ea\U0001f1f9",
        @"flag_fk" : @"\U0001f1eb\U0001f1f0",
        @"flag_fo" : @"\U0001f1eb\U0001f1f4",
        @"flag_fj" : @"\U0001f1eb\U0001f1ef",
        @"flag_fi" : @"\U0001f1eb\U0001f1ee",
        @"flag_fr" : @"\U0001f1eb\U0001f1f7",
        @"flag_pf" : @"\U0001f1f5\U0001f1eb",
        @"flag_ga" : @"\U0001f1ec\U0001f1e6",
        @"flag_gm" : @"\U0001f1ec\U0001f1f2",
        @"flag_ge" : @"\U0001f1ec\U0001f1ea",
        @"flag_de" : @"\U0001f1e9\U0001f1ea",
        @"flag_gh" : @"\U0001f1ec\U0001f1ed",
        @"flag_gi" : @"\U0001f1ec\U0001f1ee",
        @"flag_gr" : @"\U0001f1ec\U0001f1f7",
        @"flag_gl" : @"\U0001f1ec\U0001f1f1",
        @"flag_gd" : @"\U0001f1ec\U0001f1e9",
        @"flag_gu" : @"\U0001f1ec\U0001f1fa",
        @"flag_gt" : @"\U0001f1ec\U0001f1f9",
        @"flag_gn" : @"\U0001f1ec\U0001f1f3",
        @"flag_gw" : @"\U0001f1ec\U0001f1fc",
        @"flag_gy" : @"\U0001f1ec\U0001f1fe",
        @"flag_ht" : @"\U0001f1ed\U0001f1f9",
        @"flag_hn" : @"\U0001f1ed\U0001f1f3",
        @"flag_hk" : @"\U0001f1ed\U0001f1f0",
        @"flag_hu" : @"\U0001f1ed\U0001f1fa",
        @"flag_is" : @"\U0001f1ee\U0001f1f8",
        @"flag_in" : @"\U0001f1ee\U0001f1f3",
        @"flag_id" : @"\U0001f1ee\U0001f1e9",
        @"flag_ir" : @"\U0001f1ee\U0001f1f7",
        @"flag_iq" : @"\U0001f1ee\U0001f1f6",
        @"flag_ie" : @"\U0001f1ee\U0001f1ea",
        @"flag_il" : @"\U0001f1ee\U0001f1f1",
        @"flag_it" : @"\U0001f1ee\U0001f1f9",
        @"flag_ci" : @"\U0001f1e8\U0001f1ee",
        @"flag_jm" : @"\U0001f1ef\U0001f1f2",
        @"flag_jp" : @"\U0001f1ef\U0001f1f5",
        @"flag_je" : @"\U0001f1ef\U0001f1ea",
        @"flag_jo" : @"\U0001f1ef\U0001f1f4",
        @"flag_kz" : @"\U0001f1f0\U0001f1ff",
        @"flag_ke" : @"\U0001f1f0\U0001f1ea",
        @"flag_ki" : @"\U0001f1f0\U0001f1ee",
        @"flag_xk" : @"\U0001f1fd\U0001f1f0",
        @"flag_kw" : @"\U0001f1f0\U0001f1fc",
        @"flag_kg" : @"\U0001f1f0\U0001f1ec",
        @"flag_la" : @"\U0001f1f1\U0001f1e6",
        @"flag_lv" : @"\U0001f1f1\U0001f1fb",
        @"flag_lb" : @"\U0001f1f1\U0001f1e7",
        @"flag_ls" : @"\U0001f1f1\U0001f1f8",
        @"flag_lr" : @"\U0001f1f1\U0001f1f7",
        @"flag_ly" : @"\U0001f1f1\U0001f1fe",
        @"flag_li" : @"\U0001f1f1\U0001f1ee",
        @"flag_lt" : @"\U0001f1f1\U0001f1f9",
        @"flag_lu" : @"\U0001f1f1\U0001f1fa",
        @"flag_mo" : @"\U0001f1f2\U0001f1f4",
        @"flag_mk" : @"\U0001f1f2\U0001f1f0",
        @"flag_mg" : @"\U0001f1f2\U0001f1ec",
        @"flag_mw" : @"\U0001f1f2\U0001f1fc",
        @"flag_my" : @"\U0001f1f2\U0001f1fe",
        @"flag_mv" : @"\U0001f1f2\U0001f1fb",
        @"flag_ml" : @"\U0001f1f2\U0001f1f1",
        @"flag_mt" : @"\U0001f1f2\U0001f1f9",
        @"flag_mh" : @"\U0001f1f2\U0001f1ed",
        @"flag_mr" : @"\U0001f1f2\U0001f1f7",
        @"flag_mu" : @"\U0001f1f2\U0001f1fa",
        @"flag_mx" : @"\U0001f1f2\U0001f1fd",
        @"flag_fm" : @"\U0001f1eb\U0001f1f2",
        @"flag_md" : @"\U0001f1f2\U0001f1e9",
        @"flag_mc" : @"\U0001f1f2\U0001f1e8",
        @"flag_mn" : @"\U0001f1f2\U0001f1f3",
        @"flag_me" : @"\U0001f1f2\U0001f1ea",
        @"flag_ms" : @"\U0001f1f2\U0001f1f8",
        @"flag_ma" : @"\U0001f1f2\U0001f1e6",
        @"flag_mz" : @"\U0001f1f2\U0001f1ff",
        @"flag_mm" : @"\U0001f1f2\U0001f1f2",
        @"flag_na" : @"\U0001f1f3\U0001f1e6",
        @"flag_nr" : @"\U0001f1f3\U0001f1f7",
        @"flag_np" : @"\U0001f1f3\U0001f1f5",
        @"flag_nl" : @"\U0001f1f3\U0001f1f1",
        @"flag_nc" : @"\U0001f1f3\U0001f1e8",
        @"flag_nz" : @"\U0001f1f3\U0001f1ff",
        @"flag_ni" : @"\U0001f1f3\U0001f1ee",
        @"flag_ne" : @"\U0001f1f3\U0001f1ea",
        @"flag_ng" : @"\U0001f1f3\U0001f1ec",
        @"flag_nu" : @"\U0001f1f3\U0001f1fa",
        @"flag_kp" : @"\U0001f1f0\U0001f1f5",
        @"flag_no" : @"\U0001f1f3\U0001f1f4",
        @"flag_om" : @"\U0001f1f4\U0001f1f2",
        @"flag_pk" : @"\U0001f1f5\U0001f1f0",
        @"flag_pw" : @"\U0001f1f5\U0001f1fc",
        @"flag_ps" : @"\U0001f1f5\U0001f1f8",
        @"flag_pa" : @"\U0001f1f5\U0001f1e6",
        @"flag_pg" : @"\U0001f1f5\U0001f1ec",
        @"flag_py" : @"\U0001f1f5\U0001f1fe",
        @"flag_pe" : @"\U0001f1f5\U0001f1ea",
        @"flag_ph" : @"\U0001f1f5\U0001f1ed",
        @"flag_pl" : @"\U0001f1f5\U0001f1f1",
        @"flag_pt" : @"\U0001f1f5\U0001f1f9",
        @"flag_pr" : @"\U0001f1f5\U0001f1f7",
        @"flag_qa" : @"\U0001f1f6\U0001f1e6",
        @"flag_ro" : @"\U0001f1f7\U0001f1f4",
        @"flag_ru" : @"\U0001f1f7\U0001f1fa",
        @"flag_rw" : @"\U0001f1f7\U0001f1fc",
        @"flag_sh" : @"\U0001f1f8\U0001f1ed",
        @"flag_kn" : @"\U0001f1f0\U0001f1f3",
        @"flag_lc" : @"\U0001f1f1\U0001f1e8",
        @"flag_vc" : @"\U0001f1fb\U0001f1e8",
        @"flag_ws" : @"\U0001f1fc\U0001f1f8",
        @"flag_sm" : @"\U0001f1f8\U0001f1f2",
        @"flag_st" : @"\U0001f1f8\U0001f1f9",
        @"flag_sa" : @"\U0001f1f8\U0001f1e6",
        @"flag_sn" : @"\U0001f1f8\U0001f1f3",
        @"flag_rs" : @"\U0001f1f7\U0001f1f8",
        @"flag_sc" : @"\U0001f1f8\U0001f1e8",
        @"flag_sl" : @"\U0001f1f8\U0001f1f1",
        @"flag_sg" : @"\U0001f1f8\U0001f1ec",
        @"flag_sk" : @"\U0001f1f8\U0001f1f0",
        @"flag_si" : @"\U0001f1f8\U0001f1ee",
        @"flag_sb" : @"\U0001f1f8\U0001f1e7",
        @"flag_so" : @"\U0001f1f8\U0001f1f4",
        @"flag_za" : @"\U0001f1ff\U0001f1e6",
        @"flag_kr" : @"\U0001f1f0\U0001f1f7",
        @"flag_es" : @"\U0001f1ea\U0001f1f8",
        @"flag_lk" : @"\U0001f1f1\U0001f1f0",
        @"flag_sd" : @"\U0001f1f8\U0001f1e9",
        @"flag_sr" : @"\U0001f1f8\U0001f1f7",
        @"flag_sz" : @"\U0001f1f8\U0001f1ff",
        @"flag_se" : @"\U0001f1f8\U0001f1ea",
        @"flag_ch" : @"\U0001f1e8\U0001f1ed",
        @"flag_sy" : @"\U0001f1f8\U0001f1fe",
        @"flag_tw" : @"\U0001f1f9\U0001f1fc",
        @"flag_tj" : @"\U0001f1f9\U0001f1ef",
        @"flag_tz" : @"\U0001f1f9\U0001f1ff",
        @"flag_th" : @"\U0001f1f9\U0001f1ed",
        @"flag_tl" : @"\U0001f1f9\U0001f1f1",
        @"flag_tg" : @"\U0001f1f9\U0001f1ec",
        @"flag_to" : @"\U0001f1f9\U0001f1f4",
        @"flag_tt" : @"\U0001f1f9\U0001f1f9",
        @"flag_tn" : @"\U0001f1f9\U0001f1f3",
        @"flag_tr" : @"\U0001f1f9\U0001f1f7",
        @"flag_tm" : @"\U0001f1f9\U0001f1f2",
        @"flag_tv" : @"\U0001f1f9\U0001f1fb",
        @"flag_ug" : @"\U0001f1fa\U0001f1ec",
        @"flag_ua" : @"\U0001f1fa\U0001f1e6",
        @"flag_ae" : @"\U0001f1e6\U0001f1ea",
        @"flag_gb" : @"\U0001f1ec\U0001f1e7",
        @"flag_us" : @"\U0001f1fa\U0001f1f8",
        @"flag_vi" : @"\U0001f1fb\U0001f1ee",
        @"flag_uy" : @"\U0001f1fa\U0001f1fe",
        @"flag_uz" : @"\U0001f1fa\U0001f1ff",
        @"flag_vu" : @"\U0001f1fb\U0001f1fa",
        @"flag_va" : @"\U0001f1fb\U0001f1e6",
        @"flag_ve" : @"\U0001f1fb\U0001f1ea",
        @"flag_vn" : @"\U0001f1fb\U0001f1f3",
        @"flag_wf" : @"\U0001f1fc\U0001f1eb",
        @"flag_eh" : @"\U0001f1ea\U0001f1ed",
        @"flag_ye" : @"\U0001f1fe\U0001f1ea",
        @"flag_zm" : @"\U0001f1ff\U0001f1f2",
        @"flag_zw" : @"\U0001f1ff\U0001f1fc",
        @"flag_re" : @"\U0001f1f7\U0001f1ea",
        @"flag_ax" : @"\U0001f1e6\U0001f1fd",
        @"flag_ta" : @"\U0001f1f9\U0001f1e6",
        @"flag_io" : @"\U0001f1ee\U0001f1f4",
        @"flag_bq" : @"\U0001f1e7\U0001f1f6",
        @"flag_cx" : @"\U0001f1e8\U0001f1fd",
        @"flag_cc" : @"\U0001f1e8\U0001f1e8",
        @"flag_gg" : @"\U0001f1ec\U0001f1ec",
        @"flag_im" : @"\U0001f1ee\U0001f1f2",
        @"flag_yt" : @"\U0001f1fe\U0001f1f9",
        @"flag_nf" : @"\U0001f1f3\U0001f1eb",
        @"flag_pn" : @"\U0001f1f5\U0001f1f3",
        @"flag_bl" : @"\U0001f1e7\U0001f1f1",
        @"flag_pm" : @"\U0001f1f5\U0001f1f2",
        @"flag_gs" : @"\U0001f1ec\U0001f1f8",
        @"flag_tk" : @"\U0001f1f9\U0001f1f0",
        @"flag_bv" : @"\U0001f1e7\U0001f1fb",
        @"flag_hm" : @"\U0001f1ed\U0001f1f2",
        @"flag_sj" : @"\U0001f1f8\U0001f1ef",
        @"flag_um" : @"\U0001f1fa\U0001f1f2",
        @"flag_ic" : @"\U0001f1ee\U0001f1e8",
        @"flag_ea" : @"\U0001f1ea\U0001f1e6",
        @"flag_cp" : @"\U0001f1e8\U0001f1f5",
        @"flag_dg" : @"\U0001f1e9\U0001f1ec",
        @"flag_as" : @"\U0001f1e6\U0001f1f8",
        @"flag_aq" : @"\U0001f1e6\U0001f1f6",
        @"flag_vg" : @"\U0001f1fb\U0001f1ec",
        @"flag_ck" : @"\U0001f1e8\U0001f1f0",
        @"flag_cw" : @"\U0001f1e8\U0001f1fc",
        @"flag_eu" : @"\U0001f1ea\U0001f1fa",
        @"flag_gf" : @"\U0001f1ec\U0001f1eb",
        @"flag_tf" : @"\U0001f1f9\U0001f1eb",
        @"flag_gp" : @"\U0001f1ec\U0001f1f5",
        @"flag_mq" : @"\U0001f1f2\U0001f1f6",
        @"flag_mp" : @"\U0001f1f2\U0001f1f5",
        @"flag_sx" : @"\U0001f1f8\U0001f1fd",
        @"flag_ss" : @"\U0001f1f8\U0001f1f8",
        @"flag_tc" : @"\U0001f1f9\U0001f1e8",
        @"flag_mf" : @"\U0001f1f2\U0001f1eb",
        @"raised_hands_tone1" : @"\U0001f64c\U0001f3fb",
        @"raised_hands_tone2" : @"\U0001f64c\U0001f3fc",
        @"raised_hands_tone3" : @"\U0001f64c\U0001f3fd",
        @"raised_hands_tone4" : @"\U0001f64c\U0001f3fe",
        @"raised_hands_tone5" : @"\U0001f64c\U0001f3ff",
        @"clap_tone1" : @"\U0001f44f\U0001f3fb",
        @"clap_tone2" : @"\U0001f44f\U0001f3fc",
        @"clap_tone3" : @"\U0001f44f\U0001f3fd",
        @"clap_tone4" : @"\U0001f44f\U0001f3fe",
        @"clap_tone5" : @"\U0001f44f\U0001f3ff",
        @"wave_tone1" : @"\U0001f44b\U0001f3fb",
        @"wave_tone2" : @"\U0001f44b\U0001f3fc",
        @"wave_tone3" : @"\U0001f44b\U0001f3fd",
        @"wave_tone4" : @"\U0001f44b\U0001f3fe",
        @"wave_tone5" : @"\U0001f44b\U0001f3ff",
        @"thumbsup_tone1" : @"\U0001f44d\U0001f3fb",
        @"thumbsup_tone2" : @"\U0001f44d\U0001f3fc",
        @"thumbsup_tone3" : @"\U0001f44d\U0001f3fd",
        @"thumbsup_tone4" : @"\U0001f44d\U0001f3fe",
        @"thumbsup_tone5" : @"\U0001f44d\U0001f3ff",
        @"thumbsdown_tone1" : @"\U0001f44e\U0001f3fb",
        @"thumbsdown_tone2" : @"\U0001f44e\U0001f3fc",
        @"thumbsdown_tone3" : @"\U0001f44e\U0001f3fd",
        @"thumbsdown_tone4" : @"\U0001f44e\U0001f3fe",
        @"thumbsdown_tone5" : @"\U0001f44e\U0001f3ff",
        @"punch_tone1" : @"\U0001f44a\U0001f3fb",
        @"punch_tone2" : @"\U0001f44a\U0001f3fc",
        @"punch_tone3" : @"\U0001f44a\U0001f3fd",
        @"punch_tone4" : @"\U0001f44a\U0001f3fe",
        @"punch_tone5" : @"\U0001f44a\U0001f3ff",
        @"fist_tone1" : @"\U0000270a\U0001f3fb",
        @"fist_tone2" : @"\U0000270a\U0001f3fc",
        @"fist_tone3" : @"\U0000270a\U0001f3fd",
        @"fist_tone4" : @"\U0000270a\U0001f3fe",
        @"fist_tone5" : @"\U0000270a\U0001f3ff",
        @"v_tone1" : @"\U0000270c\U0001f3fb",
        @"v_tone2" : @"\U0000270c\U0001f3fc",
        @"v_tone3" : @"\U0000270c\U0001f3fd",
        @"v_tone4" : @"\U0000270c\U0001f3fe",
        @"v_tone5" : @"\U0000270c\U0001f3ff",
        @"ok_hand_tone1" : @"\U0001f44c\U0001f3fb",
        @"ok_hand_tone2" : @"\U0001f44c\U0001f3fc",
        @"ok_hand_tone3" : @"\U0001f44c\U0001f3fd",
        @"ok_hand_tone4" : @"\U0001f44c\U0001f3fe",
        @"ok_hand_tone5" : @"\U0001f44c\U0001f3ff",
        @"raised_hand_tone1" : @"\U0000270b\U0001f3fb",
        @"raised_hand_tone2" : @"\U0000270b\U0001f3fc",
        @"raised_hand_tone3" : @"\U0000270b\U0001f3fd",
        @"raised_hand_tone4" : @"\U0000270b\U0001f3fe",
        @"raised_hand_tone5" : @"\U0000270b\U0001f3ff",
        @"open_hands_tone1" : @"\U0001f450\U0001f3fb",
        @"open_hands_tone2" : @"\U0001f450\U0001f3fc",
        @"open_hands_tone3" : @"\U0001f450\U0001f3fd",
        @"open_hands_tone4" : @"\U0001f450\U0001f3fe",
        @"open_hands_tone5" : @"\U0001f450\U0001f3ff",
        @"muscle_tone1" : @"\U0001f4aa\U0001f3fb",
        @"muscle_tone2" : @"\U0001f4aa\U0001f3fc",
        @"muscle_tone3" : @"\U0001f4aa\U0001f3fd",
        @"muscle_tone4" : @"\U0001f4aa\U0001f3fe",
        @"muscle_tone5" : @"\U0001f4aa\U0001f3ff",
        @"pray_tone1" : @"\U0001f64f\U0001f3fb",
        @"pray_tone2" : @"\U0001f64f\U0001f3fc",
        @"pray_tone3" : @"\U0001f64f\U0001f3fd",
        @"pray_tone4" : @"\U0001f64f\U0001f3fe",
        @"pray_tone5" : @"\U0001f64f\U0001f3ff",
        @"point_up_tone1" : @"\U0000261d\U0001f3fb",
        @"point_up_tone2" : @"\U0000261d\U0001f3fc",
        @"point_up_tone3" : @"\U0000261d\U0001f3fd",
        @"point_up_tone4" : @"\U0000261d\U0001f3fe",
        @"point_up_tone5" : @"\U0000261d\U0001f3ff",
        @"point_up_2_tone1" : @"\U0001f446\U0001f3fb",
        @"point_up_2_tone2" : @"\U0001f446\U0001f3fc",
        @"point_up_2_tone3" : @"\U0001f446\U0001f3fd",
        @"point_up_2_tone4" : @"\U0001f446\U0001f3fe",
        @"point_up_2_tone5" : @"\U0001f446\U0001f3ff",
        @"point_down_tone1" : @"\U0001f447\U0001f3fb",
        @"point_down_tone2" : @"\U0001f447\U0001f3fc",
        @"point_down_tone3" : @"\U0001f447\U0001f3fd",
        @"point_down_tone4" : @"\U0001f447\U0001f3fe",
        @"point_down_tone5" : @"\U0001f447\U0001f3ff",
        @"point_left_tone1" : @"\U0001f448\U0001f3fb",
        @"point_left_tone2" : @"\U0001f448\U0001f3fc",
        @"point_left_tone3" : @"\U0001f448\U0001f3fd",
        @"point_left_tone4" : @"\U0001f448\U0001f3fe",
        @"point_left_tone5" : @"\U0001f448\U0001f3ff",
        @"point_right_tone1" : @"\U0001f449\U0001f3fb",
        @"point_right_tone2" : @"\U0001f449\U0001f3fc",
        @"point_right_tone3" : @"\U0001f449\U0001f3fd",
        @"point_right_tone4" : @"\U0001f449\U0001f3fe",
        @"point_right_tone5" : @"\U0001f449\U0001f3ff",
        @"middle_finger_tone1" : @"\U0001f595\U0001f3fb",
        @"middle_finger_tone2" : @"\U0001f595\U0001f3fc",
        @"middle_finger_tone3" : @"\U0001f595\U0001f3fd",
        @"middle_finger_tone4" : @"\U0001f595\U0001f3fe",
        @"middle_finger_tone5" : @"\U0001f595\U0001f3ff",
        @"hand_splayed_tone1" : @"\U0001f590\U0001f3fb",
        @"hand_splayed_tone2" : @"\U0001f590\U0001f3fc",
        @"hand_splayed_tone3" : @"\U0001f590\U0001f3fd",
        @"hand_splayed_tone4" : @"\U0001f590\U0001f3fe",
        @"hand_splayed_tone5" : @"\U0001f590\U0001f3ff",
        @"metal_tone1" : @"\U0001f918\U0001f3fb",
        @"metal_tone2" : @"\U0001f918\U0001f3fc",
        @"metal_tone3" : @"\U0001f918\U0001f3fd",
        @"metal_tone4" : @"\U0001f918\U0001f3fe",
        @"metal_tone5" : @"\U0001f918\U0001f3ff",
        @"vulcan_tone1" : @"\U0001f596\U0001f3fb",
        @"vulcan_tone2" : @"\U0001f596\U0001f3fc",
        @"vulcan_tone3" : @"\U0001f596\U0001f3fd",
        @"vulcan_tone4" : @"\U0001f596\U0001f3fe",
        @"vulcan_tone5" : @"\U0001f596\U0001f3ff",
        @"writing_hand_tone1" : @"\U0000270d\U0001f3fb",
        @"writing_hand_tone2" : @"\U0000270d\U0001f3fc",
        @"writing_hand_tone3" : @"\U0000270d\U0001f3fd",
        @"writing_hand_tone4" : @"\U0000270d\U0001f3fe",
        @"writing_hand_tone5" : @"\U0000270d\U0001f3ff",
        @"nail_care_tone1" : @"\U0001f485\U0001f3fb",
        @"nail_care_tone2" : @"\U0001f485\U0001f3fc",
        @"nail_care_tone3" : @"\U0001f485\U0001f3fd",
        @"nail_care_tone4" : @"\U0001f485\U0001f3fe",
        @"nail_care_tone5" : @"\U0001f485\U0001f3ff",
        @"ear_tone1" : @"\U0001f442\U0001f3fb",
        @"ear_tone2" : @"\U0001f442\U0001f3fc",
        @"ear_tone3" : @"\U0001f442\U0001f3fd",
        @"ear_tone4" : @"\U0001f442\U0001f3fe",
        @"ear_tone5" : @"\U0001f442\U0001f3ff",
        @"nose_tone1" : @"\U0001f443\U0001f3fb",
        @"nose_tone2" : @"\U0001f443\U0001f3fc",
        @"nose_tone3" : @"\U0001f443\U0001f3fd",
        @"nose_tone4" : @"\U0001f443\U0001f3fe",
        @"nose_tone5" : @"\U0001f443\U0001f3ff",
        @"baby_tone1" : @"\U0001f476\U0001f3fb",
        @"baby_tone2" : @"\U0001f476\U0001f3fc",
        @"baby_tone3" : @"\U0001f476\U0001f3fd",
        @"baby_tone4" : @"\U0001f476\U0001f3fe",
        @"baby_tone5" : @"\U0001f476\U0001f3ff",
        @"boy_tone1" : @"\U0001f466\U0001f3fb",
        @"boy_tone2" : @"\U0001f466\U0001f3fc",
        @"boy_tone3" : @"\U0001f466\U0001f3fd",
        @"boy_tone4" : @"\U0001f466\U0001f3fe",
        @"boy_tone5" : @"\U0001f466\U0001f3ff",
        @"girl_tone1" : @"\U0001f467\U0001f3fb",
        @"girl_tone2" : @"\U0001f467\U0001f3fc",
        @"girl_tone3" : @"\U0001f467\U0001f3fd",
        @"girl_tone4" : @"\U0001f467\U0001f3fe",
        @"girl_tone5" : @"\U0001f467\U0001f3ff",
        @"man_tone1" : @"\U0001f468\U0001f3fb",
        @"man_tone2" : @"\U0001f468\U0001f3fc",
        @"man_tone3" : @"\U0001f468\U0001f3fd",
        @"man_tone4" : @"\U0001f468\U0001f3fe",
        @"man_tone5" : @"\U0001f468\U0001f3ff",
        @"woman_tone1" : @"\U0001f469\U0001f3fb",
        @"woman_tone2" : @"\U0001f469\U0001f3fc",
        @"woman_tone3" : @"\U0001f469\U0001f3fd",
        @"woman_tone4" : @"\U0001f469\U0001f3fe",
        @"woman_tone5" : @"\U0001f469\U0001f3ff",
        @"person_with_blond_hair_tone1" : @"\U0001f471\U0001f3fb",
        @"person_with_blond_hair_tone2" : @"\U0001f471\U0001f3fc",
        @"person_with_blond_hair_tone3" : @"\U0001f471\U0001f3fd",
        @"person_with_blond_hair_tone4" : @"\U0001f471\U0001f3fe",
        @"person_with_blond_hair_tone5" : @"\U0001f471\U0001f3ff",
        @"older_man_tone1" : @"\U0001f474\U0001f3fb",
        @"older_man_tone2" : @"\U0001f474\U0001f3fc",
        @"older_man_tone3" : @"\U0001f474\U0001f3fd",
        @"older_man_tone4" : @"\U0001f474\U0001f3fe",
        @"older_man_tone5" : @"\U0001f474\U0001f3ff",
        @"older_woman_tone1" : @"\U0001f475\U0001f3fb",
        @"older_woman_tone2" : @"\U0001f475\U0001f3fc",
        @"older_woman_tone3" : @"\U0001f475\U0001f3fd",
        @"older_woman_tone4" : @"\U0001f475\U0001f3fe",
        @"older_woman_tone5" : @"\U0001f475\U0001f3ff",
        @"man_with_gua_pi_mao_tone1" : @"\U0001f472\U0001f3fb",
        @"man_with_gua_pi_mao_tone2" : @"\U0001f472\U0001f3fc",
        @"man_with_gua_pi_mao_tone3" : @"\U0001f472\U0001f3fd",
        @"man_with_gua_pi_mao_tone4" : @"\U0001f472\U0001f3fe",
        @"man_with_gua_pi_mao_tone5" : @"\U0001f472\U0001f3ff",
        @"man_with_turban_tone1" : @"\U0001f473\U0001f3fb",
        @"man_with_turban_tone2" : @"\U0001f473\U0001f3fc",
        @"man_with_turban_tone3" : @"\U0001f473\U0001f3fd",
        @"man_with_turban_tone4" : @"\U0001f473\U0001f3fe",
        @"man_with_turban_tone5" : @"\U0001f473\U0001f3ff",
        @"cop_tone1" : @"\U0001f46e\U0001f3fb",
        @"cop_tone2" : @"\U0001f46e\U0001f3fc",
        @"cop_tone3" : @"\U0001f46e\U0001f3fd",
        @"cop_tone4" : @"\U0001f46e\U0001f3fe",
        @"cop_tone5" : @"\U0001f46e\U0001f3ff",
        @"construction_worker_tone1" : @"\U0001f477\U0001f3fb",
        @"construction_worker_tone2" : @"\U0001f477\U0001f3fc",
        @"construction_worker_tone3" : @"\U0001f477\U0001f3fd",
        @"construction_worker_tone4" : @"\U0001f477\U0001f3fe",
        @"construction_worker_tone5" : @"\U0001f477\U0001f3ff",
        @"guardsman_tone1" : @"\U0001f482\U0001f3fb",
        @"guardsman_tone2" : @"\U0001f482\U0001f3fc",
        @"guardsman_tone3" : @"\U0001f482\U0001f3fd",
        @"guardsman_tone4" : @"\U0001f482\U0001f3fe",
        @"guardsman_tone5" : @"\U0001f482\U0001f3ff",
        @"santa_tone1" : @"\U0001f385\U0001f3fb",
        @"santa_tone2" : @"\U0001f385\U0001f3fc",
        @"santa_tone3" : @"\U0001f385\U0001f3fd",
        @"santa_tone4" : @"\U0001f385\U0001f3fe",
        @"santa_tone5" : @"\U0001f385\U0001f3ff",
        @"angel_tone1" : @"\U0001f47c\U0001f3fb",
        @"angel_tone2" : @"\U0001f47c\U0001f3fc",
        @"angel_tone3" : @"\U0001f47c\U0001f3fd",
        @"angel_tone4" : @"\U0001f47c\U0001f3fe",
        @"angel_tone5" : @"\U0001f47c\U0001f3ff",
        @"princess_tone1" : @"\U0001f478\U0001f3fb",
        @"princess_tone2" : @"\U0001f478\U0001f3fc",
        @"princess_tone3" : @"\U0001f478\U0001f3fd",
        @"princess_tone4" : @"\U0001f478\U0001f3fe",
        @"princess_tone5" : @"\U0001f478\U0001f3ff",
        @"bride_with_veil_tone1" : @"\U0001f470\U0001f3fb",
        @"bride_with_veil_tone2" : @"\U0001f470\U0001f3fc",
        @"bride_with_veil_tone3" : @"\U0001f470\U0001f3fd",
        @"bride_with_veil_tone4" : @"\U0001f470\U0001f3fe",
        @"bride_with_veil_tone5" : @"\U0001f470\U0001f3ff",
        @"walking_tone1" : @"\U0001f6b6\U0001f3fb",
        @"walking_tone2" : @"\U0001f6b6\U0001f3fc",
        @"walking_tone3" : @"\U0001f6b6\U0001f3fd",
        @"walking_tone4" : @"\U0001f6b6\U0001f3fe",
        @"walking_tone5" : @"\U0001f6b6\U0001f3ff",
        @"runner_tone1" : @"\U0001f3c3\U0001f3fb",
        @"runner_tone2" : @"\U0001f3c3\U0001f3fc",
        @"runner_tone3" : @"\U0001f3c3\U0001f3fd",
        @"runner_tone4" : @"\U0001f3c3\U0001f3fe",
        @"runner_tone5" : @"\U0001f3c3\U0001f3ff",
        @"dancer_tone1" : @"\U0001f483\U0001f3fb",
        @"dancer_tone2" : @"\U0001f483\U0001f3fc",
        @"dancer_tone3" : @"\U0001f483\U0001f3fd",
        @"dancer_tone4" : @"\U0001f483\U0001f3fe",
        @"dancer_tone5" : @"\U0001f483\U0001f3ff",
        @"bow_tone1" : @"\U0001f647\U0001f3fb",
        @"bow_tone2" : @"\U0001f647\U0001f3fc",
        @"bow_tone3" : @"\U0001f647\U0001f3fd",
        @"bow_tone4" : @"\U0001f647\U0001f3fe",
        @"bow_tone5" : @"\U0001f647\U0001f3ff",
        @"information_desk_person_tone1" : @"\U0001f481\U0001f3fb",
        @"information_desk_person_tone2" : @"\U0001f481\U0001f3fc",
        @"information_desk_person_tone3" : @"\U0001f481\U0001f3fd",
        @"information_desk_person_tone4" : @"\U0001f481\U0001f3fe",
        @"information_desk_person_tone5" : @"\U0001f481\U0001f3ff",
        @"no_good_tone1" : @"\U0001f645\U0001f3fb",
        @"no_good_tone2" : @"\U0001f645\U0001f3fc",
        @"no_good_tone3" : @"\U0001f645\U0001f3fd",
        @"no_good_tone4" : @"\U0001f645\U0001f3fe",
        @"no_good_tone5" : @"\U0001f645\U0001f3ff",
        @"ok_woman_tone1" : @"\U0001f646\U0001f3fb",
        @"ok_woman_tone2" : @"\U0001f646\U0001f3fc",
        @"ok_woman_tone3" : @"\U0001f646\U0001f3fd",
        @"ok_woman_tone4" : @"\U0001f646\U0001f3fe",
        @"ok_woman_tone5" : @"\U0001f646\U0001f3ff",
        @"raising_hand_tone1" : @"\U0001f64b\U0001f3fb",
        @"raising_hand_tone2" : @"\U0001f64b\U0001f3fc",
        @"raising_hand_tone3" : @"\U0001f64b\U0001f3fd",
        @"raising_hand_tone4" : @"\U0001f64b\U0001f3fe",
        @"raising_hand_tone5" : @"\U0001f64b\U0001f3ff",
        @"person_with_pouting_face_tone1" : @"\U0001f64e\U0001f3fb",
        @"person_with_pouting_face_tone2" : @"\U0001f64e\U0001f3fc",
        @"person_with_pouting_face_tone3" : @"\U0001f64e\U0001f3fd",
        @"person_with_pouting_face_tone4" : @"\U0001f64e\U0001f3fe",
        @"person_with_pouting_face_tone5" : @"\U0001f64e\U0001f3ff",
        @"person_frowning_tone1" : @"\U0001f64d\U0001f3fb",
        @"person_frowning_tone2" : @"\U0001f64d\U0001f3fc",
        @"person_frowning_tone3" : @"\U0001f64d\U0001f3fd",
        @"person_frowning_tone4" : @"\U0001f64d\U0001f3fe",
        @"person_frowning_tone5" : @"\U0001f64d\U0001f3ff",
        @"haircut_tone1" : @"\U0001f487\U0001f3fb",
        @"haircut_tone2" : @"\U0001f487\U0001f3fc",
        @"haircut_tone3" : @"\U0001f487\U0001f3fd",
        @"haircut_tone4" : @"\U0001f487\U0001f3fe",
        @"haircut_tone5" : @"\U0001f487\U0001f3ff",
        @"massage_tone1" : @"\U0001f486\U0001f3fb",
        @"massage_tone2" : @"\U0001f486\U0001f3fc",
        @"massage_tone3" : @"\U0001f486\U0001f3fd",
        @"massage_tone4" : @"\U0001f486\U0001f3fe",
        @"massage_tone5" : @"\U0001f486\U0001f3ff",
        @"rowboat_tone1" : @"\U0001f6a3\U0001f3fb",
        @"rowboat_tone2" : @"\U0001f6a3\U0001f3fc",
        @"rowboat_tone3" : @"\U0001f6a3\U0001f3fd",
        @"rowboat_tone4" : @"\U0001f6a3\U0001f3fe",
        @"rowboat_tone5" : @"\U0001f6a3\U0001f3ff",
        @"swimmer_tone1" : @"\U0001f3ca\U0001f3fb",
        @"swimmer_tone2" : @"\U0001f3ca\U0001f3fc",
        @"swimmer_tone3" : @"\U0001f3ca\U0001f3fd",
        @"swimmer_tone4" : @"\U0001f3ca\U0001f3fe",
        @"swimmer_tone5" : @"\U0001f3ca\U0001f3ff",
        @"surfer_tone1" : @"\U0001f3c4\U0001f3fb",
        @"surfer_tone2" : @"\U0001f3c4\U0001f3fc",
        @"surfer_tone3" : @"\U0001f3c4\U0001f3fd",
        @"surfer_tone4" : @"\U0001f3c4\U0001f3fe",
        @"surfer_tone5" : @"\U0001f3c4\U0001f3ff",
        @"bath_tone1" : @"\U0001f6c0\U0001f3fb",
        @"bath_tone2" : @"\U0001f6c0\U0001f3fc",
        @"bath_tone3" : @"\U0001f6c0\U0001f3fd",
        @"bath_tone4" : @"\U0001f6c0\U0001f3fe",
        @"bath_tone5" : @"\U0001f6c0\U0001f3ff",
        @"basketball_player_tone1" : @"\U000026f9\U0001f3fb",
        @"basketball_player_tone2" : @"\U000026f9\U0001f3fc",
        @"basketball_player_tone3" : @"\U000026f9\U0001f3fd",
        @"basketball_player_tone4" : @"\U000026f9\U0001f3fe",
        @"basketball_player_tone5" : @"\U000026f9\U0001f3ff",
        @"lifter_tone1" : @"\U0001f3cb\U0001f3fb",
        @"lifter_tone2" : @"\U0001f3cb\U0001f3fc",
        @"lifter_tone3" : @"\U0001f3cb\U0001f3fd",
        @"lifter_tone4" : @"\U0001f3cb\U0001f3fe",
        @"lifter_tone5" : @"\U0001f3cb\U0001f3ff",
        @"bicyclist_tone1" : @"\U0001f6b4\U0001f3fb",
        @"bicyclist_tone2" : @"\U0001f6b4\U0001f3fc",
        @"bicyclist_tone3" : @"\U0001f6b4\U0001f3fd",
        @"bicyclist_tone4" : @"\U0001f6b4\U0001f3fe",
        @"bicyclist_tone5" : @"\U0001f6b4\U0001f3ff",
        @"mountain_bicyclist_tone1" : @"\U0001f6b5\U0001f3fb",
        @"mountain_bicyclist_tone2" : @"\U0001f6b5\U0001f3fc",
        @"mountain_bicyclist_tone3" : @"\U0001f6b5\U0001f3fd",
        @"mountain_bicyclist_tone4" : @"\U0001f6b5\U0001f3fe",
        @"mountain_bicyclist_tone5" : @"\U0001f6b5\U0001f3ff",
        @"horse_racing_tone1" : @"\U0001f3c7\U0001f3fb",
        @"horse_racing_tone2" : @"\U0001f3c7\U0001f3fc",
        @"horse_racing_tone3" : @"\U0001f3c7\U0001f3fd",
        @"horse_racing_tone4" : @"\U0001f3c7\U0001f3fe",
        @"horse_racing_tone5" : @"\U0001f3c7\U0001f3ff",
        @"spy_tone1" : @"\U0001f575\U0001f3fb",
        @"spy_tone2" : @"\U0001f575\U0001f3fc",
        @"spy_tone3" : @"\U0001f575\U0001f3fd",
        @"spy_tone4" : @"\U0001f575\U0001f3fe",
        @"spy_tone5" : @"\U0001f575\U0001f3ff",
        @"tone1" : @"\U0001f3fb",
        @"tone2" : @"\U0001f3fc",
        @"tone3" : @"\U0001f3fd",
        @"tone4" : @"\U0001f3fe",
        @"tone5" : @"\U0001f3ff",
        @"prince_tone1" : @"\U0001f934\U0001f3fb",
        @"prince_tone2" : @"\U0001f934\U0001f3fc",
        @"prince_tone3" : @"\U0001f934\U0001f3fd",
        @"prince_tone4" : @"\U0001f934\U0001f3fe",
        @"prince_tone5" : @"\U0001f934\U0001f3ff",
        @"mrs_claus_tone1" : @"\U0001f936\U0001f3fb",
        @"mrs_claus_tone2" : @"\U0001f936\U0001f3fc",
        @"mrs_claus_tone3" : @"\U0001f936\U0001f3fd",
        @"mrs_claus_tone4" : @"\U0001f936\U0001f3fe",
        @"mrs_claus_tone5" : @"\U0001f936\U0001f3ff",
        @"man_in_tuxedo_tone1" : @"\U0001f935\U0001f3fb",
        @"man_in_tuxedo_tone2" : @"\U0001f935\U0001f3fc",
        @"man_in_tuxedo_tone3" : @"\U0001f935\U0001f3fd",
        @"man_in_tuxedo_tone4" : @"\U0001f935\U0001f3fe",
        @"man_in_tuxedo_tone5" : @"\U0001f935\U0001f3ff",
        @"shrug_tone1" : @"\U0001f937\U0001f3fb",
        @"shrug_tone2" : @"\U0001f937\U0001f3fc",
        @"shrug_tone3" : @"\U0001f937\U0001f3fd",
        @"shrug_tone4" : @"\U0001f937\U0001f3fe",
        @"shrug_tone5" : @"\U0001f937\U0001f3ff",
        @"face_palm_tone1" : @"\U0001f926\U0001f3fb",
        @"face_palm_tone2" : @"\U0001f926\U0001f3fc",
        @"face_palm_tone3" : @"\U0001f926\U0001f3fd",
        @"face_palm_tone4" : @"\U0001f926\U0001f3fe",
        @"face_palm_tone5" : @"\U0001f926\U0001f3ff",
        @"pregnant_woman_tone1" : @"\U0001f930\U0001f3fb",
        @"pregnant_woman_tone2" : @"\U0001f930\U0001f3fc",
        @"pregnant_woman_tone3" : @"\U0001f930\U0001f3fd",
        @"pregnant_woman_tone4" : @"\U0001f930\U0001f3fe",
        @"pregnant_woman_tone5" : @"\U0001f930\U0001f3ff",
        @"man_dancing_tone1" : @"\U0001f57a\U0001f3fb",
        @"man_dancing_tone2" : @"\U0001f57a\U0001f3fc",
        @"man_dancing_tone3" : @"\U0001f57a\U0001f3fd",
        @"man_dancing_tone4" : @"\U0001f57a\U0001f3fe",
        @"man_dancing_tone5" : @"\U0001f57a\U0001f3ff",
        @"selfie_tone1" : @"\U0001f933\U0001f3fb",
        @"selfie_tone2" : @"\U0001f933\U0001f3fc",
        @"selfie_tone3" : @"\U0001f933\U0001f3fd",
        @"selfie_tone4" : @"\U0001f933\U0001f3fe",
        @"selfie_tone5" : @"\U0001f933\U0001f3ff",
        @"fingers_crossed_tone1" : @"\U0001f91e\U0001f3fb",
        @"fingers_crossed_tone2" : @"\U0001f91e\U0001f3fc",
        @"fingers_crossed_tone3" : @"\U0001f91e\U0001f3fd",
        @"fingers_crossed_tone4" : @"\U0001f91e\U0001f3fe",
        @"fingers_crossed_tone5" : @"\U0001f91e\U0001f3ff",
        @"call_me_tone1" : @"\U0001f919\U0001f3fb",
        @"call_me_tone2" : @"\U0001f919\U0001f3fc",
        @"call_me_tone3" : @"\U0001f919\U0001f3fd",
        @"call_me_tone4" : @"\U0001f919\U0001f3fe",
        @"call_me_tone5" : @"\U0001f919\U0001f3ff",
        @"left_facing_fist_tone1" : @"\U0001f91b\U0001f3fb",
        @"left_facing_fist_tone2" : @"\U0001f91b\U0001f3fc",
        @"left_facing_fist_tone3" : @"\U0001f91b\U0001f3fd",
        @"left_facing_fist_tone4" : @"\U0001f91b\U0001f3fe",
        @"left_facing_fist_tone5" : @"\U0001f91b\U0001f3ff",
        @"right_facing_fist_tone1" : @"\U0001f91c\U0001f3fb",
        @"right_facing_fist_tone2" : @"\U0001f91c\U0001f3fc",
        @"right_facing_fist_tone3" : @"\U0001f91c\U0001f3fd",
        @"right_facing_fist_tone4" : @"\U0001f91c\U0001f3fe",
        @"right_facing_fist_tone5" : @"\U0001f91c\U0001f3ff",
        @"raised_back_of_hand_tone1" : @"\U0001f91a\U0001f3fb",
        @"raised_back_of_hand_tone2" : @"\U0001f91a\U0001f3fc",
        @"raised_back_of_hand_tone3" : @"\U0001f91a\U0001f3fd",
        @"raised_back_of_hand_tone4" : @"\U0001f91a\U0001f3fe",
        @"raised_back_of_hand_tone5" : @"\U0001f91a\U0001f3ff",
        @"handshake_tone1" : @"\U0001f91d\U0001f3fb",
        @"handshake_tone2" : @"\U0001f91d\U0001f3fc",
        @"handshake_tone3" : @"\U0001f91d\U0001f3fd",
        @"handshake_tone4" : @"\U0001f91d\U0001f3fe",
        @"handshake_tone5" : @"\U0001f91d\U0001f3ff",
        @"cartwheel_tone1" : @"\U0001f938\U0001f3fb",
        @"cartwheel_tone2" : @"\U0001f938\U0001f3fc",
        @"cartwheel_tone3" : @"\U0001f938\U0001f3fd",
        @"cartwheel_tone4" : @"\U0001f938\U0001f3fe",
        @"cartwheel_tone5" : @"\U0001f938\U0001f3ff",
        @"wrestlers_tone1" : @"\U0001f93c\U0001f3fb",
        @"wrestlers_tone2" : @"\U0001f93c\U0001f3fc",
        @"wrestlers_tone3" : @"\U0001f93c\U0001f3fd",
        @"wrestlers_tone4" : @"\U0001f93c\U0001f3fe",
        @"wrestlers_tone5" : @"\U0001f93c\U0001f3ff",
        @"water_polo_tone1" : @"\U0001f93d\U0001f3fb",
        @"water_polo_tone2" : @"\U0001f93d\U0001f3fc",
        @"water_polo_tone3" : @"\U0001f93d\U0001f3fd",
        @"water_polo_tone4" : @"\U0001f93d\U0001f3fe",
        @"water_polo_tone5" : @"\U0001f93d\U0001f3ff",
        @"handball_tone1" : @"\U0001f93e\U0001f3fb",
        @"handball_tone2" : @"\U0001f93e\U0001f3fc",
        @"handball_tone3" : @"\U0001f93e\U0001f3fd",
        @"handball_tone4" : @"\U0001f93e\U0001f3fe",
        @"handball_tone5" : @"\U0001f93e\U0001f3ff",
        @"juggling_tone1" : @"\U0001f939\U0001f3fb",
        @"juggling_tone2" : @"\U0001f939\U0001f3fc",
        @"juggling_tone3" : @"\U0001f939\U0001f3fd",
        @"juggling_tone4" : @"\U0001f939\U0001f3fe",
        @"juggling_tone5" : @"\U0001f939\U0001f3ff",
        @"speech_left" : @"\U0001f5e8",
        @"eject" : @"\U000023cf",
        @"gay_pride_flag" : @"\U0001f3f3\U0001f308",
        @"cowboy" : @"\U0001f920",
        @"clown" : @"\U0001f921",
        @"nauseated_face" : @"\U0001f922",
        @"rofl" : @"\U0001f923",
        @"drooling_face" : @"\U0001f924",
        @"lying_face" : @"\U0001f925",
        @"sneezing_face" : @"\U0001f927",
        @"prince" : @"\U0001f934",
        @"man_in_tuxedo" : @"\U0001f935",
        @"mrs_claus" : @"\U0001f936",
        @"face_palm" : @"\U0001f926",
        @"shrug" : @"\U0001f937",
        @"pregnant_woman" : @"\U0001f930",
        @"selfie" : @"\U0001f933",
        @"man_dancing" : @"\U0001f57a",
        @"call_me" : @"\U0001f919",
        @"raised_back_of_hand" : @"\U0001f91a",
        @"left_facing_fist" : @"\U0001f91b",
        @"right_facing_fist" : @"\U0001f91c",
        @"handshake" : @"\U0001f91d",
        @"fingers_crossed" : @"\U0001f91e",
        @"black_heart" : @"\U0001f5a4",
        @"eagle" : @"\U0001f985",
        @"duck" : @"\U0001f986",
        @"bat" : @"\U0001f987",
        @"shark" : @"\U0001f988",
        @"owl" : @"\U0001f989",
        @"fox" : @"\U0001f98a",
        @"butterfly" : @"\U0001f98b",
        @"deer" : @"\U0001f98c",
        @"gorilla" : @"\U0001f98d",
        @"lizard" : @"\U0001f98e",
        @"rhino" : @"\U0001f98f",
        @"wilted_rose" : @"\U0001f940",
        @"croissant" : @"\U0001f950",
        @"avocado" : @"\U0001f951",
        @"cucumber" : @"\U0001f952",
        @"bacon" : @"\U0001f953",
        @"potato" : @"\U0001f954",
        @"carrot" : @"\U0001f955",
        @"french_bread" : @"\U0001f956",
        @"salad" : @"\U0001f957",
        @"shallow_pan_of_food" : @"\U0001f958",
        @"stuffed_flatbread" : @"\U0001f959",
        @"champagne_glass" : @"\U0001f942",
        @"tumbler_glass" : @"\U0001f943",
        @"spoon" : @"\U0001f944",
        @"octagonal_sign" : @"\U0001f6d1",
        @"shopping_cart" : @"\U0001f6d2",
        @"scooter" : @"\U0001f6f4",
        @"motor_scooter" : @"\U0001f6f5",
        @"canoe" : @"\U0001f6f6",
        @"cartwheel" : @"\U0001f938",
        @"juggling" : @"\U0001f939",
        @"wrestlers" : @"\U0001f93c",
        @"boxing_glove" : @"\U0001f94a",
        @"martial_arts_uniform" : @"\U0001f94b",
        @"water_polo" : @"\U0001f93d",
        @"handball" : @"\U0001f93e",
        @"goal" : @"\U0001f945",
        @"fencer" : @"\U0001f93a",
        @"first_place" : @"\U0001f947",
        @"second_place" : @"\U0001f948",
        @"third_place" : @"\U0001f949",
        @"drum" : @"\U0001f941",
        @"shrimp" : @"\U0001f990",
        @"squid" : @"\U0001f991",
        @"egg" : @"\U0001f95a",
        @"milk" : @"\U0001f95b",
        @"peanuts" : @"\U0001f95c",
        @"kiwi" : @"\U0001f95d",
        @"pancakes" : @"\U0001f95e",
        @"regional_indicator_z" : @"\U0001f1ff",
        @"regional_indicator_y" : @"\U0001f1fe",
        @"regional_indicator_x" : @"\U0001f1fd",
        @"regional_indicator_w" : @"\U0001f1fc",
        @"regional_indicator_v" : @"\U0001f1fb",
        @"regional_indicator_u" : @"\U0001f1fa",
        @"regional_indicator_t" : @"\U0001f1f9",
        @"regional_indicator_s" : @"\U0001f1f8",
        @"regional_indicator_r" : @"\U0001f1f7",
        @"regional_indicator_q" : @"\U0001f1f6",
        @"regional_indicator_p" : @"\U0001f1f5",
        @"regional_indicator_o" : @"\U0001f1f4",
        @"regional_indicator_n" : @"\U0001f1f3",
        @"regional_indicator_m" : @"\U0001f1f2",
        @"regional_indicator_l" : @"\U0001f1f1",
        @"regional_indicator_k" : @"\U0001f1f0",
        @"regional_indicator_j" : @"\U0001f1ef",
        @"regional_indicator_i" : @"\U0001f1ee",
        @"regional_indicator_h" : @"\U0001f1ed",
        @"regional_indicator_g" : @"\U0001f1ec",
        @"regional_indicator_f" : @"\U0001f1eb",
        @"regional_indicator_e" : @"\U0001f1ea",
        @"regional_indicator_d" : @"\U0001f1e9",
        @"regional_indicator_c" : @"\U0001f1e8",
        @"regional_indicator_b" : @"\U0001f1e7",
        @"regional_indicator_a" : @"\U0001f1e6",
            };
}

@end
