/*
    Copyright (C) 2009 William Hart
    Copyright (C) 2011 Sebastian Pancratz

    This file is part of FLINT.

    FLINT is free software: you can redistribute it and/or modify it under
    the terms of the GNU Lesser General Public License (LGPL) as published
    by the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.  See <https://www.gnu.org/licenses/>.
*/

#include <limits.h>

#include "long_extras.h"

slong z_randint(flint_rand_t state, ulong limit)
{
    slong z;

    if ((limit == UWORD(0)) || (limit > WORD_MAX))
        limit = WORD_MAX;

    z = n_randlimb(state) % limit;
    if (n_randint(state, 2))
        z = -z;

    return z;
}
