if test -d "$__fish_datadir/man/man1/"
	complete -c help -x -a '(__fish_print_commands)' --description 'Help for this command'
end

# Help topics
# This was semi-automated with `grep 'class="anchor"' -A1 /usr/share/doc/fish/index.html
# It's not fully automated since that requires parsing html with regex,
# and since this is by definition in sync - we ship the html, and we ship these completions.
complete -c help -x -a autosuggestions --description 'Autosuggestions'
complete -c help -x -a builtin-overview --description 'Builtin commands'
complete -c help -x -a cartesian-product --description 'Cartesian Products'
complete -c help -x -a color --description 'Setting syntax highlighting colors'
complete -c help -x -a combine --description 'Combining different expansions'
complete -c help -x -a completion --description 'How tab-completion works'
complete -c help -x -a completion-func --description 'Useful functions for writing completions'
complete -c help -x -a completion-own --description 'Writing your own completions'
complete -c help -x -a completion-path --description 'Where to put completions'
complete -c help -x -a debugging --description 'Debugging fish scripts'
complete -c help -x -a docs --description 'Help'
complete -c help -x -a editor --description 'Command line editor'
complete -c help -x -a emacs-mode --description 'Emacs mode commands'
complete -c help -x -a escapes --description 'Escaping characters'
complete -c help -x -a event --description 'Event handlers'
complete -c help -x -a expand --description 'Parameter expansion (Globbing)'
complete -c help -x -a expand-brace --description 'Brace expansion {a,b,c}'
complete -c help -x -a expand-command-substitution --description 'Command substitution'
complete -c help -x -a expand-command-substitution --description 'Command substitution (SUBCOMMAND)'
complete -c help -x -a expand-home --description 'Home directory expansion ~USER'
complete -c help -x -a expand-index-range --description 'Index range expansion'
complete -c help -x -a expand-process --description 'Process expansion %JOB'
complete -c help -x -a expand-variable --description 'Variable expansion $VARNAME'
complete -c help -x -a expand-wildcard --description 'Wildcard expansion *.*'
# Note: This is hard-coded in help.fish - it's not an anchor in the html.
complete -c help -x -a globbing --description 'Parameter expansion (Globbing)'
complete -c help -x -a greeting --description 'Configurable greeting'
complete -c help -x -a history --description 'Help on how to reuse previously entered commands'
complete -c help -x -a history-search --description 'Searchable history'
complete -c help -x -a identifiers --description 'Shell variable and function names'
complete -c help -x -a initialization --description 'Initialization files'
complete -c help -x -a introduction --description 'Introduction'
complete -c help -x -a issues --description 'Common issues with fish'
complete -c help -x -a job-control --description 'Running multiple programs'
complete -c help -x -a killring --description 'Copy and paste (Kill Ring)'
complete -c help -x -a more-help --description 'Further help and development'
complete -c help -x -a multiline --description 'Multiline editing'
complete -c help -x -a other --description 'Other features'
complete -c help -x -a piping --description 'Piping'
complete -c help -x -a prompt --description 'Programmable prompt'
complete -c help -x -a quotes --description 'Quotes'
complete -c help -x -a redirects --description 'Input/Output (IO) redirection'
complete -c help -x -a shared-binds --description 'Shared bindings'
complete -c help -x -a syntax --description 'Introduction to the fish syntax'
complete -c help -x -a syntax-background --description 'Background jobs'
complete -c help -x -a syntax-conditional --description 'Conditional execution of code and flow control'
complete -c help -x -a syntax-function --description 'Functions'
complete -c help -x -a syntax-function-autoloading --description 'Autoloading functions'
complete -c help -x -a syntax-function-wrappers --description 'Defining aliases'
complete -c help -x -a syntax-job-control --description 'Job control'
complete -c help -x -a syntax-words --description 'Some common words'
complete -c help -x -a title --description 'Programmable title'
complete -c help -x -a variables --description 'Shell variables'
complete -c help -x -a variables-arrays --description 'Arrays'
complete -c help -x -a variables-color --description 'Variables for changing highlighting colors'
complete -c help -x -a variables-export --description 'Exporting variables'
complete -c help -x -a variables-functions --description 'Variable scope for functions'
complete -c help -x -a variables-locale --description 'Locale variables'
complete -c help -x -a variables-scope --description 'Variable scope'
complete -c help -x -a variables-special --description 'Special variables'
complete -c help -x -a variables-status --description 'The status variable'
complete -c help -x -a variables-universal --description 'More on universal variables'
complete -c help -x -a vi-mode --description 'Vi mode commands'
complete -c help -x -a vi-mode-command --description 'Command mode'
complete -c help -x -a vi-mode-insert --description 'Insert mode'
complete -c help -x -a vi-mode-visual --description 'Visual mode'

# Tutorial
complete -c help -x -a tutorial --description 'Tutorial'
complete -c help -x -a tut_autoload --description 'Autoloading Functions'
complete -c help -x -a tut_autosuggestions --description 'Autosuggestions'
complete -c help -x -a tut_combiners --description 'Combiners (And, Or, Not)'
complete -c help -x -a tut_command_substitutions --description 'Command Substitutions'
complete -c help -x -a tut_conditionals --description 'Conditionals (If, Else, Switch)'
complete -c help -x -a tut_exit_status --description 'Exit Status'
complete -c help -x -a tut_exports --description 'Exports (Shell Variables)'
complete -c help -x -a tut_functions --description 'Functions'
complete -c help -x -a tut_getting_help --description 'Getting Help'
complete -c help -x -a tut_learning_Fish --description 'Learning fish'
complete -c help -x -a tut_lists --description 'Lists'
complete -c help -x -a tut_loops --description 'Loops'
complete -c help -x -a tut_more --description 'Ready for more?'
complete -c help -x -a tut_path --description '$PATH'
complete -c help -x -a tut_pipes_and_redirections --description 'Pipes and Redirections'
complete -c help -x -a tut_prompt --description 'Prompt'
complete -c help -x -a tut_running_commands --description 'Running Commands'
complete -c help -x -a tut_semicolon --description 'Separating Commands (Semicolon)'
complete -c help -x -a tut_startup --description "Startup (Where's .bashrc?)"
complete -c help -x -a tut_syntax_highlighting --description 'Syntax Highlighting'
complete -c help -x -a tut_tab_completions --description 'Tab Completions'
complete -c help -x -a tut_universal --description 'Universal Variables'
complete -c help -x -a tut_variables --description 'Variables'
complete -c help -x -a tut_why_fish --description 'Why fish?'
complete -c help -x -a tut_wildcards --description 'Wildcards'
