/* $Id: comm.h,v 1.7 2003/05/13 19:37:42 sjoerd Exp $ */
#ifndef FFRENZY_COMM_H
#define FFRENZY_COMM_H

#include "network.h"
#include "list.h"

#define COMM_STATE_VERSION     0x1
#define COMM_STATE_PLAYREQ     0x2
#define COMM_STATE_CCONNREQ    0x3
#define COMM_STATE_WCONNREQ    0x4
#define COMM_STATE_SCONNREQ    0x5
#define COMM_STATE_PLAYINFO    0x6
#define COMM_STATE_LINFO       0x7

typedef struct {
  int state;
  Network_connection *con;
  char *hostname;
  uint32_t port;
  List *remotes;
} Comm_server_client;


typedef struct {
  char **players;
  int registered_players;
  int nrplayers;
  List *conns;
  List *clients;
  List *listeners;
} Comm_server;

typedef struct {
  uint32_t num;
  char *name;
}  Comm_client_player;

typedef struct {
  List *listeners;
  Network_listener *listener;
  List *connections;
  Network_connection *server;
  List *players;
  char *level;
  int levellen;
} Comm_client;

typedef struct {
  uint32_t *events;
  List *connections;
  List *synced_connections;
} Comm_game;

Comm_server_client *new_comm_server_client(Network_connection *con);
void del_comm_server_client(Comm_server_client *client);

Comm_server *new_comm_server(int port,int nrplayers);
void del_comm_server(Comm_server *serv);
void comm_server_add_client(Comm_server *serv, Comm_server_client *client);
void comm_server_del_client(Comm_server *serv, Comm_server_client *client);

int comm_server_register_player(Comm_server *serv, char *name);
int comm_server_wait_for_others(Comm_server *serv);
int comm_server_send_connections(Comm_server *serv);
int comm_server_send_player_info(Comm_server *serv);
int comm_server_send_level(Comm_server *serv,char *level);
char *comm_server_get_name(Comm_server *serv,int player);
Comm_game *comm_server_finalize(Comm_server *serv);

Comm_client *new_comm_client(char *host,int port);
void del_comm_client(Comm_client *client);
int comm_client_register_player(Comm_client *client, char *name);
int comm_client_register_done(Comm_client *client);
int comm_client_wait_for_connections(Comm_client *client,char *host,int port);
int comm_client_get_player_info(Comm_client *client);
int comm_client_get_nrplayers(Comm_client *client);
char *comm_client_get_name(Comm_client *client,int player);
int comm_client_get_level(Comm_client *client);
char *comm_client_get_levelstr(Comm_client *client);
Comm_game *comm_client_finalize(Comm_client *serv);

/** \ingroup comm
 * create a simple comm game without network connections 
 */
Comm_game * new_comm_game(int nrplayers);
void del_comm_game(Comm_game *g);

void comm_game_send_event(Comm_game *g,int player,uint32_t event);
uint32_t comm_game_get_event(Comm_game *g,int player);
int comm_game_update(Comm_game *g);

#endif /* FFRENZY_COMM_H */
