	INTEGER FUNCTION TM_GET_VARNUM( vname, dset )

*
*
*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration's (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE. 
*
*
* given a variable name supposed to be in the indicated data set return the
* TMAP variable ID

* programmer - steve hankin
* NOAA/PMEL, Seattle, WA - Tropical Modeling and Analysis Program
* written for VAX computer under VMS operating system
*
* revision 0.0 - 3/92
* V500 4/99 *kob*: increase upcase_var from 24 to 64 chars - to match passed in vname
* V552 5/03 *acm*: increase size of upcase_var from 64 to 128 chars
* calling argument declarations

	INTEGER		dset
	CHARACTER*(*)	vname

* include files
	include 'tmap_dims.parm'
#include "tmap_dset.parm"
#include "gt_lib.parm"
	include 'xdset_info.cmn_text'
	external xdset_info_data

* local variable declarations:
      INTEGER STR_UPCASE, TM_LENSTR1, istat, slen, ivar
      CHARACTER upcase_var*128

* convert to upper case
      istat = STR_UPCASE( upcase_var, vname )     ! 4/91
      slen  = TM_LENSTR1( vname )

* locate the variable code among the variables in this data set
      DO 100 ivar = 1,maxvars

          IF ( ds_var_setnum(ivar) .NE. dset ) GOTO 100

          IF ( ds_var_code(ivar)(:slen) .EQ. upcase_var(:slen) ) THEN
            TM_GET_VARNUM = ivar
            RETURN
          ENDIF

 100  CONTINUE

* not found
      TM_GET_VARNUM = unspecified_int4
      RETURN
      END
