/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import net.jcip.annotations.Immutable;
import thredds.inventory.DateExtractor;
import thredds.inventory.MFile;
import thredds.inventory.MFileFilter;

@Immutable
public class MCollection {
    private final String name;
    private final String dirName;
    private final boolean wantSubdirs;
    private final MFileFilter ff;
    private final DateExtractor dateExtractor;
    private final Object auxInfo;

    public MCollection(String name, String dirName, boolean wantSubdirs, MFileFilter ff, DateExtractor dateExtractor, Object auxInfo) {
        this.name = name;
        this.dirName = dirName;
        this.wantSubdirs = wantSubdirs;
        this.ff = ff;
        this.dateExtractor = dateExtractor;
        this.auxInfo = auxInfo;
    }

    public MCollection subdir(MFile child) {
        return new MCollection(this.name + "/" + child.getName(), this.dirName + "/" + child.getName(), this.wantSubdirs, this.ff, this.dateExtractor, child.getAuxInfo());
    }

    public String getName() {
        return this.name;
    }

    public String getDirectoryName() {
        return this.dirName;
    }

    public boolean wantSubdirs() {
        return this.wantSubdirs;
    }

    public MFileFilter getFileFilter() {
        return this.ff;
    }

    public DateExtractor getDateExtractor() {
        return this.dateExtractor;
    }

    public boolean accept(MFile file) {
        return this.ff == null || this.ff.accept(file);
    }

    public String toString() {
        return "MCollection{name='" + this.name + '\'' + ", dirName='" + this.dirName + '\'' + ", wantSubdirs=" + this.wantSubdirs + ", ff=" + this.ff + ", dateExtractor=" + this.dateExtractor + '}';
    }

    public Object getAuxInfo() {
        return this.auxInfo;
    }
}

