/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.zip.DeflaterOutputStream;
import opendap.dap.BaseType;
import opendap.dap.BaseTypeFactory;
import opendap.dap.ClientIO;
import opendap.dap.DAP2Exception;
import opendap.dap.DDS;
import opendap.dap.DataReadException;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;

public class DataDDS
extends DDS {
    private ServerVersion ver;

    public DataDDS(ServerVersion ver) {
        this.ver = ver;
    }

    public DataDDS(ServerVersion ver, BaseTypeFactory btf) {
        super(btf);
        this.ver = ver;
    }

    public final ServerVersion getServerVersion() {
        return this.ver;
    }

    public void readData(InputStream is, StatusUI statusUI) throws IOException, EOFException, DAP2Exception {
        BufferedInputStream bufferedIS = new BufferedInputStream(is);
        DataInputStream dataIS = new DataInputStream(bufferedIS);
        Enumeration e = this.getVariables();
        while (e.hasMoreElements()) {
            if (statusUI != null && statusUI.userCancelled()) {
                throw new DataReadException("User cancelled");
            }
            ClientIO bt = (ClientIO)e.nextElement();
            bt.deserialize(dataIS, this.ver, statusUI);
        }
        if (statusUI != null) {
            statusUI.finished();
        }
    }

    public void printVal(PrintWriter pw) {
        Enumeration e = this.getVariables();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            bt.printVal(pw, "", true);
            pw.flush();
        }
        pw.println();
    }

    public final void printVal(OutputStream os) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.printVal(pw);
        pw.flush();
    }

    public final void externalize(OutputStream os, boolean compress, boolean headers) throws IOException {
        if (headers) {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
            pw.println("HTTP/1.0 200 OK");
            pw.println("XDAP: 3.2");
            pw.println("XDODS-Server: DODS/3.2");
            pw.println("Content-type: application/octet-stream");
            pw.println("Content-Description: dods-data");
            if (compress) {
                pw.println("Content-Encoding: deflate");
            }
            pw.println();
            pw.flush();
        }
        BufferedOutputStream bufferedOS = compress ? new BufferedOutputStream(new DeflaterOutputStream(os)) : new BufferedOutputStream(os);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(bufferedOS));
        this.print(pw);
        pw.flush();
        ((OutputStream)bufferedOS).write("\nData:\n".getBytes());
        ((OutputStream)bufferedOS).flush();
        DataOutputStream dataOS = new DataOutputStream(bufferedOS);
        Enumeration e = this.getVariables();
        while (e.hasMoreElements()) {
            ClientIO bt = (ClientIO)e.nextElement();
            bt.externalize(dataOS);
        }
        dataOS.close();
    }
}

