/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

class RETokenChar
extends REToken {
    private char[] ch = new char[1];
    private boolean insens;

    RETokenChar(int f_subIndex, char c, boolean ins) {
        super(f_subIndex);
        this.insens = ins;
        this.ch[0] = this.insens ? Character.toLowerCase(c) : c;
    }

    int getMinimumLength() {
        return this.ch.length;
    }

    int[] match(CharIndexed input, int index, int eflags, REMatch mymatch) {
        int z = this.ch.length;
        for (int i = 0; i < z; ++i) {
            char c = input.charAt(index + i);
            if ((this.insens ? Character.toLowerCase(c) : c) == this.ch[i]) continue;
            return null;
        }
        return this.next(input, index + z, eflags, mymatch);
    }

    boolean chain(REToken next) {
        if (next instanceof RETokenChar) {
            RETokenChar cnext = (RETokenChar)next;
            int newsize = this.ch.length + cnext.ch.length;
            char[] chTemp = new char[newsize];
            System.arraycopy(this.ch, 0, chTemp, 0, this.ch.length);
            System.arraycopy(cnext.ch, 0, chTemp, this.ch.length, cnext.ch.length);
            this.ch = chTemp;
            return false;
        }
        return super.chain(next);
    }

    void dump(StringBuffer os) {
        os.append(this.ch);
    }
}

