/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;

public class REMatch {
    private String m_match;
    int offset;
    int anchor;
    int[] start;
    int[] end;
    int[] count;

    REMatch(int f_subs, int f_index) {
        this.start = new int[f_subs + 1];
        this.end = new int[f_subs + 1];
        this.count = new int[f_subs + 1];
        this.anchor = f_index;
        this.clear(f_index);
    }

    void finish(CharIndexed text) {
        int i;
        this.start[0] = 0;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < this.end[0]; ++i) {
            sb.append(text.charAt(i));
        }
        this.m_match = sb.toString();
        for (i = 0; i < this.start.length; ++i) {
            if (this.start[i] != -1) continue;
            this.end[i] = -1;
        }
    }

    void reset(int f_subIndex) {
        for (int i = f_subIndex; i < this.start.length; ++i) {
            this.end[i] = -1;
            this.start[i] = -1;
            this.count[i] = 0;
        }
    }

    void clear(int f_index) {
        this.offset = f_index;
        for (int i = 0; i < this.start.length; ++i) {
            this.end[i] = -1;
            this.start[i] = -1;
            this.count[i] = 0;
        }
    }

    public String toString() {
        return this.m_match;
    }

    public int getStartIndex() {
        return this.offset + this.start[0];
    }

    public int getEndIndex() {
        return this.offset + this.end[0];
    }

    public String toString(int sub) {
        if (sub >= this.start.length || this.start[sub] == -1) {
            return "";
        }
        return this.m_match.substring(this.start[sub], this.end[sub]);
    }

    public int getSubStartIndex(int sub) {
        if (sub >= this.start.length) {
            return -1;
        }
        int x = this.start[sub];
        return x == -1 ? x : this.offset + x;
    }

    public int getSubEndIndex(int sub) {
        if (sub >= this.start.length) {
            return -1;
        }
        int x = this.end[sub];
        return x == -1 ? x : this.offset + x;
    }

    public String substituteInto(String input) {
        int pos;
        StringBuffer output = new StringBuffer();
        for (pos = 0; pos < input.length() - 1; ++pos) {
            if (input.charAt(pos) == '$' && Character.isDigit(input.charAt(pos + 1))) {
                int val;
                if ((val = Character.digit(input.charAt(++pos), 10)) >= this.start.length) continue;
                output.append(this.toString(val));
                continue;
            }
            output.append(input.charAt(pos));
        }
        if (pos < input.length()) {
            output.append(input.charAt(pos));
        }
        return output.toString();
    }
}

