/*
 * $Id: floppy.h,v 1.1 2012-07-03 07:36:46 vrsieh Exp $ 
 *
 * Copyright (C) 2004-2012 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/* ==================== RUNTIME_RM ==================== */
#ifdef RUNTIME_RM

extern void
floppy_tick(void);

extern uint8_t
floppy_read_chs(
	uint8_t drive,
	uint8_t num,
	uint8_t cylinder,
	uint8_t head,
	uint8_t sector,
	uint16_t buffer_seg,
	uint16_t buffer_off
);
extern uint8_t
floppy_write_chs(
	uint8_t drive,
	uint8_t num,
	uint8_t cylinder,
	uint8_t head,
	uint8_t sector,
	uint16_t buffer_seg,
	uint16_t buffer_off
);
extern uint8_t
floppy_verify_chs(
	uint8_t drive,
	uint8_t num,
	uint8_t cylinder,
	uint8_t head,
	uint8_t sector,
	uint16_t buffer_seg,
	uint16_t buffer_off
);
extern uint8_t
floppy_check_changeline(
	uint8_t drive
);

#endif /* RUNTIME_RM */
/* ==================== REAL-MODE INIT ==================== */
#ifdef INIT_RM

extern const char *
get_identify_floppy(uint16_t drive);

extern void
floppy_init(void);

#endif /* INIT_RM */
