#!/bin/sh

set -e

WORK=/export/home.local/potyra/work
EXP=$WORK/FAUmachine/src/experiments/test-fi-smart-step2

LIST=tests.list.$(hostname | sed -e s'/faui//')

if [ -e "$LIST" ]; then
	echo "Single experiment"
	exit 0
fi

cd $EXP
for i in $LIST.*; do
	INSTANCE=$(echo $i | cut -d. -f4-)
	mkdir run-$INSTANCE
	cp $i \
		simulation.setup \
		fi.vhdl.in \
		Makefile \
		generate.in \
		run-tests.sh \
		gen_vhdl_faults.sh \
		test_bench.vhdl \
		pc-4.vhdl \
		\
		run-$INSTANCE
	cd run-$INSTANCE
	cp $LIST.$INSTANCE $LIST
	echo "Created $LIST from $LIST.$INSTANCE"
	sed -e "s/image /image ..\\//" simulation.setup > simulation.setup.new
	sed -e "s/test-fi/..\\/test-fi/" \
		-e "s/install-Debian/..\\/install-Debian/" \
		Makefile >> Makefile.new
	mv simulation.setup.new simulation.setup
	mv Makefile.new Makefile
	cd ..
done
