-- $Id$

-- test resolution functions
-- actually this test doesn't document a parser bug, but rather a 
-- bug with evaluating resolution functions (which results from a 
-- not strictly lrm conforming design decision).

-- Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.

package t is
	type iv is array(integer range <>) of integer;
	function resolve_integer_vl(v : iv) return integer;
	subtype integer_vl is resolve_integer_vl integer;
end package t;

package body t is
	function resolve_integer_vl(v : iv) return integer is
	begin
		return v'length;
	end;
end;

use t.integer_vl;
entity d is
	port (
		o : out integer_vl;
		i1 : in integer;
		i2 : in integer
	);
end entity d;

architecture d_impl of d is
begin
	update_output : process(i1, i2)
	begin
		o <= i1 + i2 after 10 ms;
	end process;
end;

entity test_bench is
end entity test_bench;

use t.integer_vl;
architecture test_bench_impl of test_bench is
	signal r : integer_vl;
	signal i1 : integer;
	signal i2 : integer;
	signal i3 : integer;
	signal i4 : integer;
begin
	d1 : d port map(o => r, i1 => i1, i2 => i2);
	d2 : d port map(o => r, i1 => i3, i2 => i4);

	p : process
	begin
		i1 <= 1;
		i2 <= 2;
		i3 <= 3;
		i4 <= 4;

		wait for 12 ms;
		-- lrm 2003: there are 2 drivers for the final resolution
		-- hence the result must be 2.
		-- fauhdlc doesn't adhere to this. There every
		-- driver gets connected to the final signal (recursively).
		-- hence fauhdli's result will be 4.
		assert r = 2 report "r must be 2" severity failure;

		assert false report "simulation finished" severity note;
		wait;
	end process;
end;
