# Copyright (c) 2011-2020, Manfred Moitzi
# License: MIT License
import sys
from pathlib import Path
import ezdxf


def main(filename):
    doc = ezdxf.readfile(filename)
    msp = doc.modelspace()
    hatches = msp.query("HATCH[solid_fill==0]")
    filename.with_suffix(".py")
    dump_pattern(filename.with_suffix(".py"), hatches)


def dump_pattern(filename, hatches):
    with open(filename, "wt") as f:
        f.write(FILE_HEADER)
        for hatch in hatches:
            f.write(get_pattern_definition_string(hatch))
        f.write(FILE_TAIL)


FILE_HEADER = """# DXF pattern definition file
# Do not edit this file, because this file was generated by 'dump_hatch_pattern.py'
# 'dump_hatch_pattern.py' is part of the Python package 'ezdxf'

Pattern = {
"""

FILE_TAIL = "}\n"


def get_pattern_definition_string(hatch):
    name = hatch.dxf.pattern_name
    with hatch.edit_pattern() as p:
        pattern = str(p)
    return "'{}': {},\n".format(name, pattern)


if __name__ == "__main__":
    main(Path(sys.argv[1]))
