/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

class GraphFactory {
    private String title = "";
    private XYSeriesCollection dataset = new XYSeriesCollection();

    public GraphFactory(String string) {
        if (string != null) {
            this.title = string;
        }
    }

    public void addDataSet(String string, double[][] dArray) {
        if (string == null) {
            string = "Default";
        }
        XYSeries xYSeries = new XYSeries((Comparable)((Object)string));
        for (int i = 0; i < dArray.length; ++i) {
            xYSeries.add(dArray[i][0], dArray[i][1]);
        }
        this.dataset.addSeries(xYSeries);
    }

    public JPanel getGraph() {
        JFreeChart jFreeChart = this.createChart();
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        return chartPanel;
    }

    private JFreeChart createChart() {
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(this.title, "Wavelength", "Amplitude", this.dataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        xYLineAndShapeRenderer.setSeriesLinesVisible(0, false);
        xYLineAndShapeRenderer.setSeriesShapesVisible(1, false);
        xYPlot.setRenderer(xYLineAndShapeRenderer);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }
}

