/* Ergo, version 3.3, a program for linear scaling electronic structure
 * calculations.
 * Copyright (C) 2013 Elias Rudberg, Emanuel H. Rubensson, and Pawel Salek.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Primary academic reference:
 * Kohn−Sham Density Functional Theory Electronic Structure Calculations 
 * with Linearly Scaling Computational Time and Memory Usage,
 * Elias Rudberg, Emanuel H. Rubensson, and Pawel Salek,
 * J. Chem. Theory Comput. 7, 340 (2011),
 * <http://dx.doi.org/10.1021/ct100611z>
 * 
 * For further information about Ergo, see <http://www.ergoscf.org>.
 */
#ifndef INTEGRAL_INFO_CHUNK_HEADER
#define INTEGRAL_INFO_CHUNK_HEADER

#ifdef USE_CHUNKS_AND_TASKS

#include "basisinfo.h"
#include "chunks_and_tasks.h"

class IntegralInfoChunk : public cht::Chunk {
 public:  
  // Things required for a Chunk object
  void writeToBuffer ( char * dataBuffer, 
		       size_t const bufferSize ) const;
  size_t getSize() const;
  void assignFromBuffer ( char const * dataBuffer, 
			  size_t const bufferSize);
  size_t memoryUsage() const;
  void getChildChunks(std::list<cht::ChunkID> & childChunkIDs) const;
  // Other stuff
  IntegralInfoChunk() : ii(false) { }
  IntegralInfoChunk(const IntegralInfo & ii_) : ii(ii_) { }
  IntegralInfo ii;
  CHT_CHUNK_TYPE_DECLARATION;
};

#endif

#endif
