/*
 * dsyslog - a dumb syslog (e.g. syslog for people who have a clue)
 * Copyright (c) 2008 William Pitcock <nenolod@sacredspiral.co.uk>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice is present in all copies.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "dsyslog.h"

static void
filter_regexp_destructor(dsyslog_filter_t *filter)
{
	_ENTER;

	g_regex_unref(filter->opaque);

	_LEAVE;
}

static gboolean
filter_regexp_handler(dsyslog_event_t *event, dsyslog_filter_t *filter)
{
	gchar *old;
	GError *error = NULL;

	_ENTER;

	if (!filter->opaque) {
		filter->opaque = g_regex_new(filter->message, G_REGEX_CASELESS, 0, &error);
		if (error) {
			filter->opaque = NULL;
			_ERROR("filter->opaque failed to compile: %s", error->message);
			g_clear_error(&error);

			_LEAVE TRUE;	/* TODO: should we bail gracefully or abort() in this condition? */
		}
		filter->destructor = filter_regexp_destructor;
	}

	old = event->message;
	event->message = g_regex_replace(filter->opaque, event->message, -1, 0, filter->replace, 0, &error);

	if (error) {
		_ERROR("error=%s [msg dropped]", error->message);
		g_clear_error(&error);
		_LEAVE FALSE;
	}

	g_free(old);

	_LEAVE TRUE;
}

void
_modinit(void)
{
	_ENTER;

	dsyslog_filter_type_register("regexp", filter_regexp_handler);

	_LEAVE;
}

void
_modfini(void)
{
	_ENTER;

	dsyslog_filter_type_unregister("regexp");

	_LEAVE;
}
