// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.


//---------------------------------------------------------------------------

//
// This file is automatically generated.  Please do not edit it directly.
//
// File name: marshal_generated.cpp
//---------------------------------------------------------------------------

#include "precomp.hpp"

template <class TResourceType>
inline
HRESULT
UnmarshalResourceArray(
    __inout_pcount_in_bcount(1, cbRawArray) BYTE const *&pbRawArray,
    __inout_ecount(1) UINT32 &cbRawArray,
    UINT32 cbReqArray,
    MIL_RESOURCE_TYPE resType,
    PERFMETERTAG mt,
    __out_ecount(1) UINT32 &cResources,
    __out_pcount_out_out_ecount_full(1,cResources) TResourceType ** &rgpResources,
    __in_ecount(1) CMilSlaveHandleTable *pHandleTable,
    bool fAllowNullHandles = true
    )
{
    //
    // Ensure that the specified type inherits from CMilSlaveResource. The
    // following line doesn't generate any code in debug or retail but it
    // emits a compile-time error if TResourceType doesn't inherit from
    // CMilSlaveResource.
    //
    static_cast<CMilSlaveResource *>(static_cast<TResourceType *>(NULL));

    CMilSlaveResource **rgpResourcesTemp;

    HRESULT hr = UnmarshalResourceArray(
        pbRawArray,
        cbRawArray,
        cbReqArray,
        resType,
        mt,
        cResources,
        rgpResourcesTemp,
        pHandleTable,
        fAllowNullHandles
        );

    rgpResources = reinterpret_cast<TResourceType **>(rgpResourcesTemp);

    return hr;
}

HRESULT
UnmarshalResourceArray(
    __inout_pcount_in_bcount(1, cbRawArray) BYTE const *&pbRawArray,
    __inout_ecount(1) UINT32 &cbRawArray,
    UINT32 cbReqArray,
    MIL_RESOURCE_TYPE resType,
    PERFMETERTAG mt,
    __out_ecount(1) UINT32 &cResources,
    __out_pcount_out_out_ecount_full(1,cResources) CMilSlaveResource ** &rgpResources,
    __in_ecount(1) CMilSlaveHandleTable *pHandleTable,
    bool fAllowNullHandles = true
    )
{
    HRESULT hr = S_OK;

    //
    // Initialize out parameters
    //

    cResources = 0;
    rgpResources = NULL;

    //
    // Make sure there is enough buffer and that the manifested resource
    // table size is divisible by the handle size.
    //

    if (cbReqArray > cbRawArray
        || cbReqArray % sizeof(HMIL_RESOURCE) != 0)
    {
        IFC(WGXERR_UCE_MALFORMEDPACKET);
    }

    //
    // Compute resource count from expected array byte size
    //

    cResources = cbReqArray / sizeof(HMIL_RESOURCE);

    if (cResources > 0)
    {
        UINT const uCount = cResources;

        //
        // Allocate pointer buffer. We'll use this buffer to translate resource
        // handles to pointers to resources.
        //

        IFC(HrMalloc(
            mt,
            sizeof(*rgpResources),
            cResources,
            (void **)&rgpResources
            ));


        //
        // Copy data that contains only handles; collection resource
        //

        HMIL_RESOURCE const *phResourceHandles = reinterpret_cast<HMIL_RESOURCE const *>(pbRawArray);
        CMilSlaveResource **ppResourcePointers = rgpResources;
        for (UINT i = 0; i < uCount; i++)
        {
            HMIL_RESOURCE hResource = *phResourceHandles++;
            CMilSlaveResource *pResource = NULL;

            //
            // If the handle is non-NULL we need to validate it
            // against the handle table. Otherwise, we check whether
            // this resource allows NULL pointers (based on fAllowNullHandles)
            // and, if so, the pointer is implicitly NULL
            //

            if (hResource)
            {
                pResource = pHandleTable->GetResource(hResource, resType);
                IFCNULL(pResource);
            }
            else if (!fAllowNullHandles)
            {
                IFCNULL(hResource);
            }

            *ppResourcePointers++ = pResource;
        }


        //
        // Update data pointer and size for any remaining data.
        //
        // Note that at the moment of writing this coment, the following operations
        // are guaranteed to succeed. This follows from the fact that the batch size
        // (and, hence, the maximum size of the resource array) is a 32-bit value.
        //
        // Adding these checks as a security-in-depth practice.
        //

        UINT_PTR cbUnmarshaled;
        UINT_PTR cbRawArrayFixed;

        IFC(UIntPtrSub(reinterpret_cast<UINT_PTR>(phResourceHandles), reinterpret_cast<UINT_PTR>(pbRawArray), &cbUnmarshaled));
        IFC(UIntPtrSub(static_cast<UINT_PTR>(cbRawArray), cbUnmarshaled, &cbRawArrayFixed));
        IFC(UIntPtrToUInt(cbRawArrayFixed, &cbRawArray));

        pbRawArray = reinterpret_cast<BYTE const *>(phResourceHandles);
    }

Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to unmarshal the array -- perform the clean up here
        // or otherwise we're risking problems during while unregistering.
        //

        if (rgpResources != NULL)
        {
            WPFFree(ProcessHeap, rgpResources);
            rgpResources = NULL;
        }

        cResources = 0;
    }

    RRETURN(hr);
}

HRESULT CMilAxisAngleRotation3DDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_AXISANGLEROTATION3D* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_axis = pCmd->axis;
    if (pCmd->hAxisAnimations != NULL)
    {
        m_data.m_pAxisAnimation =
            static_cast<CMilSlaveVector3D*>(pHandleTable->GetResource(
                pCmd->hAxisAnimations,
                TYPE_VECTOR3DRESOURCE
                ));

        if (m_data.m_pAxisAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pAxisAnimation = NULL;
    }

    m_data.m_angle = pCmd->angle;
    if (pCmd->hAngleAnimations != NULL)
    {
        m_data.m_pAngleAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hAngleAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pAngleAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pAngleAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilAxisAngleRotation3DDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pAxisAnimation));
    IFC(RegisterNotifier(m_data.m_pAngleAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilAxisAngleRotation3DDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pAxisAnimation);
    UnRegisterNotifier(m_data.m_pAngleAnimation);
}


HRESULT CMilAxisAngleRotation3DDuce::SynchronizeAnimatedFields()
{
    HRESULT hr = S_OK;

    if (m_data.m_pAxisAnimation)
    {
        IFC(m_data.m_pAxisAnimation->GetValue(&m_data.m_axis));
    }
    if (m_data.m_pAngleAnimation)
    {
        IFC(m_data.m_pAngleAnimation->GetValue(&m_data.m_angle));
    }

Cleanup:
    RRETURN(hr);
}

HRESULT CMilQuaternionRotation3DDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_QUATERNIONROTATION3D* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_quaternion = pCmd->quaternion;
    if (pCmd->hQuaternionAnimations != NULL)
    {
        m_data.m_pQuaternionAnimation =
            static_cast<CMilSlaveQuaternion*>(pHandleTable->GetResource(
                pCmd->hQuaternionAnimations,
                TYPE_QUATERNIONRESOURCE
                ));

        if (m_data.m_pQuaternionAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pQuaternionAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilQuaternionRotation3DDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pQuaternionAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilQuaternionRotation3DDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pQuaternionAnimation);
}


HRESULT CMilQuaternionRotation3DDuce::SynchronizeAnimatedFields()
{
    HRESULT hr = S_OK;

    if (m_data.m_pQuaternionAnimation)
    {
        IFC(m_data.m_pQuaternionAnimation->GetValue(&m_data.m_quaternion));
    }

Cleanup:
    RRETURN(hr);
}

HRESULT CMilPerspectiveCameraDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_PERSPECTIVECAMERA* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->htransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransform3DDuce*>(pHandleTable->GetResource(
                pCmd->htransform,
                TYPE_TRANSFORM3D
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }

    m_data.m_nearPlaneDistance = pCmd->nearPlaneDistance;
    if (pCmd->hNearPlaneDistanceAnimations != NULL)
    {
        m_data.m_pNearPlaneDistanceAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hNearPlaneDistanceAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pNearPlaneDistanceAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pNearPlaneDistanceAnimation = NULL;
    }

    m_data.m_farPlaneDistance = pCmd->farPlaneDistance;
    if (pCmd->hFarPlaneDistanceAnimations != NULL)
    {
        m_data.m_pFarPlaneDistanceAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hFarPlaneDistanceAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pFarPlaneDistanceAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pFarPlaneDistanceAnimation = NULL;
    }

    m_data.m_position = pCmd->position;
    if (pCmd->hPositionAnimations != NULL)
    {
        m_data.m_pPositionAnimation =
            static_cast<CMilSlavePoint3D*>(pHandleTable->GetResource(
                pCmd->hPositionAnimations,
                TYPE_POINT3DRESOURCE
                ));

        if (m_data.m_pPositionAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pPositionAnimation = NULL;
    }

    m_data.m_lookDirection = pCmd->lookDirection;
    if (pCmd->hLookDirectionAnimations != NULL)
    {
        m_data.m_pLookDirectionAnimation =
            static_cast<CMilSlaveVector3D*>(pHandleTable->GetResource(
                pCmd->hLookDirectionAnimations,
                TYPE_VECTOR3DRESOURCE
                ));

        if (m_data.m_pLookDirectionAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pLookDirectionAnimation = NULL;
    }

    m_data.m_upDirection = pCmd->upDirection;
    if (pCmd->hUpDirectionAnimations != NULL)
    {
        m_data.m_pUpDirectionAnimation =
            static_cast<CMilSlaveVector3D*>(pHandleTable->GetResource(
                pCmd->hUpDirectionAnimations,
                TYPE_VECTOR3DRESOURCE
                ));

        if (m_data.m_pUpDirectionAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pUpDirectionAnimation = NULL;
    }

    m_data.m_fieldOfView = pCmd->fieldOfView;
    if (pCmd->hFieldOfViewAnimations != NULL)
    {
        m_data.m_pFieldOfViewAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hFieldOfViewAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pFieldOfViewAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pFieldOfViewAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilPerspectiveCameraDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pNearPlaneDistanceAnimation));
    IFC(RegisterNotifier(m_data.m_pFarPlaneDistanceAnimation));
    IFC(RegisterNotifier(m_data.m_pPositionAnimation));
    IFC(RegisterNotifier(m_data.m_pLookDirectionAnimation));
    IFC(RegisterNotifier(m_data.m_pUpDirectionAnimation));
    IFC(RegisterNotifier(m_data.m_pFieldOfViewAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilPerspectiveCameraDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pNearPlaneDistanceAnimation);
    UnRegisterNotifier(m_data.m_pFarPlaneDistanceAnimation);
    UnRegisterNotifier(m_data.m_pPositionAnimation);
    UnRegisterNotifier(m_data.m_pLookDirectionAnimation);
    UnRegisterNotifier(m_data.m_pUpDirectionAnimation);
    UnRegisterNotifier(m_data.m_pFieldOfViewAnimation);
}


HRESULT CMilPerspectiveCameraDuce::SynchronizeAnimatedFields()
{
    HRESULT hr = S_OK;

    if (m_data.m_pNearPlaneDistanceAnimation)
    {
        IFC(m_data.m_pNearPlaneDistanceAnimation->GetValue(&m_data.m_nearPlaneDistance));
    }
    if (m_data.m_pFarPlaneDistanceAnimation)
    {
        IFC(m_data.m_pFarPlaneDistanceAnimation->GetValue(&m_data.m_farPlaneDistance));
    }
    if (m_data.m_pPositionAnimation)
    {
        IFC(m_data.m_pPositionAnimation->GetValue(&m_data.m_position));
    }
    if (m_data.m_pLookDirectionAnimation)
    {
        IFC(m_data.m_pLookDirectionAnimation->GetValue(&m_data.m_lookDirection));
    }
    if (m_data.m_pUpDirectionAnimation)
    {
        IFC(m_data.m_pUpDirectionAnimation->GetValue(&m_data.m_upDirection));
    }
    if (m_data.m_pFieldOfViewAnimation)
    {
        IFC(m_data.m_pFieldOfViewAnimation->GetValue(&m_data.m_fieldOfView));
    }

Cleanup:
    RRETURN(hr);
}

HRESULT CMilOrthographicCameraDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_ORTHOGRAPHICCAMERA* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->htransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransform3DDuce*>(pHandleTable->GetResource(
                pCmd->htransform,
                TYPE_TRANSFORM3D
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }

    m_data.m_nearPlaneDistance = pCmd->nearPlaneDistance;
    if (pCmd->hNearPlaneDistanceAnimations != NULL)
    {
        m_data.m_pNearPlaneDistanceAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hNearPlaneDistanceAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pNearPlaneDistanceAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pNearPlaneDistanceAnimation = NULL;
    }

    m_data.m_farPlaneDistance = pCmd->farPlaneDistance;
    if (pCmd->hFarPlaneDistanceAnimations != NULL)
    {
        m_data.m_pFarPlaneDistanceAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hFarPlaneDistanceAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pFarPlaneDistanceAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pFarPlaneDistanceAnimation = NULL;
    }

    m_data.m_position = pCmd->position;
    if (pCmd->hPositionAnimations != NULL)
    {
        m_data.m_pPositionAnimation =
            static_cast<CMilSlavePoint3D*>(pHandleTable->GetResource(
                pCmd->hPositionAnimations,
                TYPE_POINT3DRESOURCE
                ));

        if (m_data.m_pPositionAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pPositionAnimation = NULL;
    }

    m_data.m_lookDirection = pCmd->lookDirection;
    if (pCmd->hLookDirectionAnimations != NULL)
    {
        m_data.m_pLookDirectionAnimation =
            static_cast<CMilSlaveVector3D*>(pHandleTable->GetResource(
                pCmd->hLookDirectionAnimations,
                TYPE_VECTOR3DRESOURCE
                ));

        if (m_data.m_pLookDirectionAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pLookDirectionAnimation = NULL;
    }

    m_data.m_upDirection = pCmd->upDirection;
    if (pCmd->hUpDirectionAnimations != NULL)
    {
        m_data.m_pUpDirectionAnimation =
            static_cast<CMilSlaveVector3D*>(pHandleTable->GetResource(
                pCmd->hUpDirectionAnimations,
                TYPE_VECTOR3DRESOURCE
                ));

        if (m_data.m_pUpDirectionAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pUpDirectionAnimation = NULL;
    }

    m_data.m_width = pCmd->width;
    if (pCmd->hWidthAnimations != NULL)
    {
        m_data.m_pWidthAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hWidthAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pWidthAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pWidthAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilOrthographicCameraDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pNearPlaneDistanceAnimation));
    IFC(RegisterNotifier(m_data.m_pFarPlaneDistanceAnimation));
    IFC(RegisterNotifier(m_data.m_pPositionAnimation));
    IFC(RegisterNotifier(m_data.m_pLookDirectionAnimation));
    IFC(RegisterNotifier(m_data.m_pUpDirectionAnimation));
    IFC(RegisterNotifier(m_data.m_pWidthAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilOrthographicCameraDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pNearPlaneDistanceAnimation);
    UnRegisterNotifier(m_data.m_pFarPlaneDistanceAnimation);
    UnRegisterNotifier(m_data.m_pPositionAnimation);
    UnRegisterNotifier(m_data.m_pLookDirectionAnimation);
    UnRegisterNotifier(m_data.m_pUpDirectionAnimation);
    UnRegisterNotifier(m_data.m_pWidthAnimation);
}


HRESULT CMilOrthographicCameraDuce::SynchronizeAnimatedFields()
{
    HRESULT hr = S_OK;

    if (m_data.m_pNearPlaneDistanceAnimation)
    {
        IFC(m_data.m_pNearPlaneDistanceAnimation->GetValue(&m_data.m_nearPlaneDistance));
    }
    if (m_data.m_pFarPlaneDistanceAnimation)
    {
        IFC(m_data.m_pFarPlaneDistanceAnimation->GetValue(&m_data.m_farPlaneDistance));
    }
    if (m_data.m_pPositionAnimation)
    {
        IFC(m_data.m_pPositionAnimation->GetValue(&m_data.m_position));
    }
    if (m_data.m_pLookDirectionAnimation)
    {
        IFC(m_data.m_pLookDirectionAnimation->GetValue(&m_data.m_lookDirection));
    }
    if (m_data.m_pUpDirectionAnimation)
    {
        IFC(m_data.m_pUpDirectionAnimation->GetValue(&m_data.m_upDirection));
    }
    if (m_data.m_pWidthAnimation)
    {
        IFC(m_data.m_pWidthAnimation->GetValue(&m_data.m_width));
    }

Cleanup:
    RRETURN(hr);
}

HRESULT CMilMatrixCameraDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_MATRIXCAMERA* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->htransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransform3DDuce*>(pHandleTable->GetResource(
                pCmd->htransform,
                TYPE_TRANSFORM3D
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }

    m_data.m_viewMatrix = pCmd->viewMatrix;
    m_data.m_projectionMatrix = pCmd->projectionMatrix;

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilMatrixCameraDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilMatrixCameraDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
}

HRESULT CMilModel3DGroupDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_MODEL3DGROUP* pCmd,
    __in_bcount(cbPayload) LPCVOID pPayload,
    UINT cbPayload
    )
{
    HRESULT hr = S_OK;

    const BYTE* pbDataSection =
        reinterpret_cast<const BYTE*>(pPayload);




    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->htransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransform3DDuce*>(pHandleTable->GetResource(
                pCmd->htransform,
                TYPE_TRANSFORM3D
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }

    // Read the Children
    // This is for data with handles only; collection field
    // need to do the pointer to handle conversion here.
    IFC(UnmarshalResourceArray(
        IN OUT pbDataSection,
        IN OUT cbPayload,
        pCmd->ChildrenSize,
        TYPE_MODEL3D,
        Mt(CMilModel3DGroupDuce),
        OUT m_data.m_cChildren,
        OUT m_data.m_rgpChildren,
        pHandleTable,
        false
        ));

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilModel3DGroupDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNNotifiers(m_data.m_rgpChildren, m_data.m_cChildren));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilModel3DGroupDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);

    if (m_data.m_rgpChildren)
    {
        UnRegisterNNotifiers(m_data.m_rgpChildren, m_data.m_cChildren);
        WPFFree(ProcessHeap, m_data.m_rgpChildren);
        m_data.m_rgpChildren = NULL;
    }
    m_data.m_cChildren = 0;
}

HRESULT CMilAmbientLightDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_AMBIENTLIGHT* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->htransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransform3DDuce*>(pHandleTable->GetResource(
                pCmd->htransform,
                TYPE_TRANSFORM3D
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }

    m_data.m_color = pCmd->color;
    if (pCmd->hColorAnimations != NULL)
    {
        m_data.m_pColorAnimation =
            static_cast<CMilSlaveColor*>(pHandleTable->GetResource(
                pCmd->hColorAnimations,
                TYPE_COLORRESOURCE
                ));

        if (m_data.m_pColorAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pColorAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilAmbientLightDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pColorAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilAmbientLightDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pColorAnimation);
}


HRESULT CMilAmbientLightDuce::SynchronizeAnimatedFields()
{
    HRESULT hr = S_OK;

    if (m_data.m_pColorAnimation)
    {
        IFC(m_data.m_pColorAnimation->GetValue(&m_data.m_color));
    }

Cleanup:
    RRETURN(hr);
}

HRESULT CMilDirectionalLightDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_DIRECTIONALLIGHT* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->htransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransform3DDuce*>(pHandleTable->GetResource(
                pCmd->htransform,
                TYPE_TRANSFORM3D
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }

    m_data.m_color = pCmd->color;
    if (pCmd->hColorAnimations != NULL)
    {
        m_data.m_pColorAnimation =
            static_cast<CMilSlaveColor*>(pHandleTable->GetResource(
                pCmd->hColorAnimations,
                TYPE_COLORRESOURCE
                ));

        if (m_data.m_pColorAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pColorAnimation = NULL;
    }

    m_data.m_direction = pCmd->direction;
    if (pCmd->hDirectionAnimations != NULL)
    {
        m_data.m_pDirectionAnimation =
            static_cast<CMilSlaveVector3D*>(pHandleTable->GetResource(
                pCmd->hDirectionAnimations,
                TYPE_VECTOR3DRESOURCE
                ));

        if (m_data.m_pDirectionAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pDirectionAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilDirectionalLightDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pColorAnimation));
    IFC(RegisterNotifier(m_data.m_pDirectionAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilDirectionalLightDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pColorAnimation);
    UnRegisterNotifier(m_data.m_pDirectionAnimation);
}


HRESULT CMilDirectionalLightDuce::SynchronizeAnimatedFields()
{
    HRESULT hr = S_OK;

    if (m_data.m_pColorAnimation)
    {
        IFC(m_data.m_pColorAnimation->GetValue(&m_data.m_color));
    }
    if (m_data.m_pDirectionAnimation)
    {
        IFC(m_data.m_pDirectionAnimation->GetValue(&m_data.m_direction));
    }

Cleanup:
    RRETURN(hr);
}

HRESULT CMilPointLightDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_POINTLIGHT* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->htransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransform3DDuce*>(pHandleTable->GetResource(
                pCmd->htransform,
                TYPE_TRANSFORM3D
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }

    m_data.m_color = pCmd->color;
    if (pCmd->hColorAnimations != NULL)
    {
        m_data.m_pColorAnimation =
            static_cast<CMilSlaveColor*>(pHandleTable->GetResource(
                pCmd->hColorAnimations,
                TYPE_COLORRESOURCE
                ));

        if (m_data.m_pColorAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pColorAnimation = NULL;
    }

    m_data.m_position = pCmd->position;
    if (pCmd->hPositionAnimations != NULL)
    {
        m_data.m_pPositionAnimation =
            static_cast<CMilSlavePoint3D*>(pHandleTable->GetResource(
                pCmd->hPositionAnimations,
                TYPE_POINT3DRESOURCE
                ));

        if (m_data.m_pPositionAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pPositionAnimation = NULL;
    }

    m_data.m_range = pCmd->range;
    if (pCmd->hRangeAnimations != NULL)
    {
        m_data.m_pRangeAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hRangeAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pRangeAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRangeAnimation = NULL;
    }

    m_data.m_constantAttenuation = pCmd->constantAttenuation;
    if (pCmd->hConstantAttenuationAnimations != NULL)
    {
        m_data.m_pConstantAttenuationAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hConstantAttenuationAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pConstantAttenuationAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pConstantAttenuationAnimation = NULL;
    }

    m_data.m_linearAttenuation = pCmd->linearAttenuation;
    if (pCmd->hLinearAttenuationAnimations != NULL)
    {
        m_data.m_pLinearAttenuationAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hLinearAttenuationAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pLinearAttenuationAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pLinearAttenuationAnimation = NULL;
    }

    m_data.m_quadraticAttenuation = pCmd->quadraticAttenuation;
    if (pCmd->hQuadraticAttenuationAnimations != NULL)
    {
        m_data.m_pQuadraticAttenuationAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hQuadraticAttenuationAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pQuadraticAttenuationAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pQuadraticAttenuationAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilPointLightDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pColorAnimation));
    IFC(RegisterNotifier(m_data.m_pPositionAnimation));
    IFC(RegisterNotifier(m_data.m_pRangeAnimation));
    IFC(RegisterNotifier(m_data.m_pConstantAttenuationAnimation));
    IFC(RegisterNotifier(m_data.m_pLinearAttenuationAnimation));
    IFC(RegisterNotifier(m_data.m_pQuadraticAttenuationAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilPointLightDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pColorAnimation);
    UnRegisterNotifier(m_data.m_pPositionAnimation);
    UnRegisterNotifier(m_data.m_pRangeAnimation);
    UnRegisterNotifier(m_data.m_pConstantAttenuationAnimation);
    UnRegisterNotifier(m_data.m_pLinearAttenuationAnimation);
    UnRegisterNotifier(m_data.m_pQuadraticAttenuationAnimation);
}


HRESULT CMilPointLightDuce::SynchronizeAnimatedFields()
{
    HRESULT hr = S_OK;

    if (m_data.m_pColorAnimation)
    {
        IFC(m_data.m_pColorAnimation->GetValue(&m_data.m_color));
    }
    if (m_data.m_pPositionAnimation)
    {
        IFC(m_data.m_pPositionAnimation->GetValue(&m_data.m_position));
    }
    if (m_data.m_pRangeAnimation)
    {
        IFC(m_data.m_pRangeAnimation->GetValue(&m_data.m_range));
    }
    if (m_data.m_pConstantAttenuationAnimation)
    {
        IFC(m_data.m_pConstantAttenuationAnimation->GetValue(&m_data.m_constantAttenuation));
    }
    if (m_data.m_pLinearAttenuationAnimation)
    {
        IFC(m_data.m_pLinearAttenuationAnimation->GetValue(&m_data.m_linearAttenuation));
    }
    if (m_data.m_pQuadraticAttenuationAnimation)
    {
        IFC(m_data.m_pQuadraticAttenuationAnimation->GetValue(&m_data.m_quadraticAttenuation));
    }

Cleanup:
    RRETURN(hr);
}

HRESULT CMilSpotLightDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_SPOTLIGHT* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->htransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransform3DDuce*>(pHandleTable->GetResource(
                pCmd->htransform,
                TYPE_TRANSFORM3D
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }

    m_data.m_color = pCmd->color;
    if (pCmd->hColorAnimations != NULL)
    {
        m_data.m_pColorAnimation =
            static_cast<CMilSlaveColor*>(pHandleTable->GetResource(
                pCmd->hColorAnimations,
                TYPE_COLORRESOURCE
                ));

        if (m_data.m_pColorAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pColorAnimation = NULL;
    }

    m_data.m_position = pCmd->position;
    if (pCmd->hPositionAnimations != NULL)
    {
        m_data.m_pPositionAnimation =
            static_cast<CMilSlavePoint3D*>(pHandleTable->GetResource(
                pCmd->hPositionAnimations,
                TYPE_POINT3DRESOURCE
                ));

        if (m_data.m_pPositionAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pPositionAnimation = NULL;
    }

    m_data.m_range = pCmd->range;
    if (pCmd->hRangeAnimations != NULL)
    {
        m_data.m_pRangeAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hRangeAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pRangeAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRangeAnimation = NULL;
    }

    m_data.m_constantAttenuation = pCmd->constantAttenuation;
    if (pCmd->hConstantAttenuationAnimations != NULL)
    {
        m_data.m_pConstantAttenuationAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hConstantAttenuationAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pConstantAttenuationAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pConstantAttenuationAnimation = NULL;
    }

    m_data.m_linearAttenuation = pCmd->linearAttenuation;
    if (pCmd->hLinearAttenuationAnimations != NULL)
    {
        m_data.m_pLinearAttenuationAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hLinearAttenuationAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pLinearAttenuationAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pLinearAttenuationAnimation = NULL;
    }

    m_data.m_quadraticAttenuation = pCmd->quadraticAttenuation;
    if (pCmd->hQuadraticAttenuationAnimations != NULL)
    {
        m_data.m_pQuadraticAttenuationAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hQuadraticAttenuationAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pQuadraticAttenuationAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pQuadraticAttenuationAnimation = NULL;
    }

    m_data.m_direction = pCmd->direction;
    if (pCmd->hDirectionAnimations != NULL)
    {
        m_data.m_pDirectionAnimation =
            static_cast<CMilSlaveVector3D*>(pHandleTable->GetResource(
                pCmd->hDirectionAnimations,
                TYPE_VECTOR3DRESOURCE
                ));

        if (m_data.m_pDirectionAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pDirectionAnimation = NULL;
    }

    m_data.m_outerConeAngle = pCmd->outerConeAngle;
    if (pCmd->hOuterConeAngleAnimations != NULL)
    {
        m_data.m_pOuterConeAngleAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hOuterConeAngleAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pOuterConeAngleAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOuterConeAngleAnimation = NULL;
    }

    m_data.m_innerConeAngle = pCmd->innerConeAngle;
    if (pCmd->hInnerConeAngleAnimations != NULL)
    {
        m_data.m_pInnerConeAngleAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hInnerConeAngleAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pInnerConeAngleAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pInnerConeAngleAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilSpotLightDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pColorAnimation));
    IFC(RegisterNotifier(m_data.m_pPositionAnimation));
    IFC(RegisterNotifier(m_data.m_pRangeAnimation));
    IFC(RegisterNotifier(m_data.m_pConstantAttenuationAnimation));
    IFC(RegisterNotifier(m_data.m_pLinearAttenuationAnimation));
    IFC(RegisterNotifier(m_data.m_pQuadraticAttenuationAnimation));
    IFC(RegisterNotifier(m_data.m_pDirectionAnimation));
    IFC(RegisterNotifier(m_data.m_pOuterConeAngleAnimation));
    IFC(RegisterNotifier(m_data.m_pInnerConeAngleAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilSpotLightDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pColorAnimation);
    UnRegisterNotifier(m_data.m_pPositionAnimation);
    UnRegisterNotifier(m_data.m_pRangeAnimation);
    UnRegisterNotifier(m_data.m_pConstantAttenuationAnimation);
    UnRegisterNotifier(m_data.m_pLinearAttenuationAnimation);
    UnRegisterNotifier(m_data.m_pQuadraticAttenuationAnimation);
    UnRegisterNotifier(m_data.m_pDirectionAnimation);
    UnRegisterNotifier(m_data.m_pOuterConeAngleAnimation);
    UnRegisterNotifier(m_data.m_pInnerConeAngleAnimation);
}


HRESULT CMilSpotLightDuce::SynchronizeAnimatedFields()
{
    HRESULT hr = S_OK;

    if (m_data.m_pColorAnimation)
    {
        IFC(m_data.m_pColorAnimation->GetValue(&m_data.m_color));
    }
    if (m_data.m_pPositionAnimation)
    {
        IFC(m_data.m_pPositionAnimation->GetValue(&m_data.m_position));
    }
    if (m_data.m_pRangeAnimation)
    {
        IFC(m_data.m_pRangeAnimation->GetValue(&m_data.m_range));
    }
    if (m_data.m_pConstantAttenuationAnimation)
    {
        IFC(m_data.m_pConstantAttenuationAnimation->GetValue(&m_data.m_constantAttenuation));
    }
    if (m_data.m_pLinearAttenuationAnimation)
    {
        IFC(m_data.m_pLinearAttenuationAnimation->GetValue(&m_data.m_linearAttenuation));
    }
    if (m_data.m_pQuadraticAttenuationAnimation)
    {
        IFC(m_data.m_pQuadraticAttenuationAnimation->GetValue(&m_data.m_quadraticAttenuation));
    }
    if (m_data.m_pDirectionAnimation)
    {
        IFC(m_data.m_pDirectionAnimation->GetValue(&m_data.m_direction));
    }
    if (m_data.m_pOuterConeAngleAnimation)
    {
        IFC(m_data.m_pOuterConeAngleAnimation->GetValue(&m_data.m_outerConeAngle));
    }
    if (m_data.m_pInnerConeAngleAnimation)
    {
        IFC(m_data.m_pInnerConeAngleAnimation->GetValue(&m_data.m_innerConeAngle));
    }

Cleanup:
    RRETURN(hr);
}

HRESULT CMilGeometryModel3DDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_GEOMETRYMODEL3D* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->htransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransform3DDuce*>(pHandleTable->GetResource(
                pCmd->htransform,
                TYPE_TRANSFORM3D
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }


    if (pCmd->hgeometry != NULL)
    {
        m_data.m_pGeometry =
            static_cast<CMilGeometry3DDuce*>(pHandleTable->GetResource(
                pCmd->hgeometry,
                TYPE_GEOMETRY3D
                ));

        if (m_data.m_pGeometry == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pGeometry = NULL;
    }


    if (pCmd->hmaterial != NULL)
    {
        m_data.m_pMaterial =
            static_cast<CMilMaterialDuce*>(pHandleTable->GetResource(
                pCmd->hmaterial,
                TYPE_MATERIAL
                ));

        if (m_data.m_pMaterial == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pMaterial = NULL;
    }


    if (pCmd->hbackMaterial != NULL)
    {
        m_data.m_pBackMaterial =
            static_cast<CMilMaterialDuce*>(pHandleTable->GetResource(
                pCmd->hbackMaterial,
                TYPE_MATERIAL
                ));

        if (m_data.m_pBackMaterial == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pBackMaterial = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilGeometryModel3DDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pGeometry));
    IFC(RegisterNotifier(m_data.m_pMaterial));
    IFC(RegisterNotifier(m_data.m_pBackMaterial));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilGeometryModel3DDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pGeometry);
    UnRegisterNotifier(m_data.m_pMaterial);
    UnRegisterNotifier(m_data.m_pBackMaterial);
}

HRESULT CMilMeshGeometry3DDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_MESHGEOMETRY3D* pCmd,
    __in_bcount(cbPayload) LPCVOID pPayload,
    UINT cbPayload
    )
{
    HRESULT hr = S_OK;

    const BYTE* pbDataSection =
        reinterpret_cast<const BYTE*>(pPayload);

    ClearRealization();


    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    // Read the Positions
    m_data.m_cbPositionsSize = pCmd->PositionsSize;
    if (m_data.m_cbPositionsSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbPositionsSize > cbPayload
            || m_data.m_cbPositionsSize % sizeof(MilPoint3F) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilMeshGeometry3DDuce),
            m_data.m_cbPositionsSize,
            reinterpret_cast<void**>(&m_data.m_pPositionsData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pPositionsData, pbDataSection, m_data.m_cbPositionsSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbPositionsSize;
        pbDataSection += m_data.m_cbPositionsSize;
    }
    // Read the Normals
    m_data.m_cbNormalsSize = pCmd->NormalsSize;
    if (m_data.m_cbNormalsSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbNormalsSize > cbPayload
            || m_data.m_cbNormalsSize % sizeof(MilPoint3F) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilMeshGeometry3DDuce),
            m_data.m_cbNormalsSize,
            reinterpret_cast<void**>(&m_data.m_pNormalsData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pNormalsData, pbDataSection, m_data.m_cbNormalsSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbNormalsSize;
        pbDataSection += m_data.m_cbNormalsSize;
    }
    // Read the TextureCoordinates
    m_data.m_cbTextureCoordinatesSize = pCmd->TextureCoordinatesSize;
    if (m_data.m_cbTextureCoordinatesSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbTextureCoordinatesSize > cbPayload
            || m_data.m_cbTextureCoordinatesSize % sizeof(MilPoint2D) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilMeshGeometry3DDuce),
            m_data.m_cbTextureCoordinatesSize,
            reinterpret_cast<void**>(&m_data.m_pTextureCoordinatesData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pTextureCoordinatesData, pbDataSection, m_data.m_cbTextureCoordinatesSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbTextureCoordinatesSize;
        pbDataSection += m_data.m_cbTextureCoordinatesSize;
    }
    // Read the TriangleIndices
    m_data.m_cbTriangleIndicesSize = pCmd->TriangleIndicesSize;
    if (m_data.m_cbTriangleIndicesSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbTriangleIndicesSize > cbPayload
            || m_data.m_cbTriangleIndicesSize % sizeof(INT) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilMeshGeometry3DDuce),
            m_data.m_cbTriangleIndicesSize,
            reinterpret_cast<void**>(&m_data.m_pTriangleIndicesData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pTriangleIndicesData, pbDataSection, m_data.m_cbTriangleIndicesSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbTriangleIndicesSize;
        pbDataSection += m_data.m_cbTriangleIndicesSize;
    }

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilMeshGeometry3DDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;






    RRETURN(hr);
}

/*override*/ void CMilMeshGeometry3DDuce::UnRegisterNotifiers()
{

    if (m_data.m_pPositionsData)
    {

        WPFFree(ProcessHeap, m_data.m_pPositionsData);
        m_data.m_pPositionsData = NULL;
    }
    m_data.m_cbPositionsSize = 0;

    if (m_data.m_pNormalsData)
    {

        WPFFree(ProcessHeap, m_data.m_pNormalsData);
        m_data.m_pNormalsData = NULL;
    }
    m_data.m_cbNormalsSize = 0;

    if (m_data.m_pTextureCoordinatesData)
    {

        WPFFree(ProcessHeap, m_data.m_pTextureCoordinatesData);
        m_data.m_pTextureCoordinatesData = NULL;
    }
    m_data.m_cbTextureCoordinatesSize = 0;

    if (m_data.m_pTriangleIndicesData)
    {

        WPFFree(ProcessHeap, m_data.m_pTriangleIndicesData);
        m_data.m_pTriangleIndicesData = NULL;
    }
    m_data.m_cbTriangleIndicesSize = 0;
}

HRESULT CMilMaterialGroupDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_MATERIALGROUP* pCmd,
    __in_bcount(cbPayload) LPCVOID pPayload,
    UINT cbPayload
    )
{
    HRESULT hr = S_OK;

    const BYTE* pbDataSection =
        reinterpret_cast<const BYTE*>(pPayload);




    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    // Read the Children
    // This is for data with handles only; collection field
    // need to do the pointer to handle conversion here.
    IFC(UnmarshalResourceArray(
        IN OUT pbDataSection,
        IN OUT cbPayload,
        pCmd->ChildrenSize,
        TYPE_MATERIAL,
        Mt(CMilMaterialGroupDuce),
        OUT m_data.m_cChildren,
        OUT m_data.m_rgpChildren,
        pHandleTable,
        false
        ));

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilMaterialGroupDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNNotifiers(m_data.m_rgpChildren, m_data.m_cChildren));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilMaterialGroupDuce::UnRegisterNotifiers()
{

    if (m_data.m_rgpChildren)
    {
        UnRegisterNNotifiers(m_data.m_rgpChildren, m_data.m_cChildren);
        WPFFree(ProcessHeap, m_data.m_rgpChildren);
        m_data.m_rgpChildren = NULL;
    }
    m_data.m_cChildren = 0;
}

/*override*/ CMilSlaveResource* CMilMaterialGroupDuce::GetResource()
{
    return this;
}

HRESULT CMilDiffuseMaterialDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_DIFFUSEMATERIAL* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_color = pCmd->color;
    m_data.m_ambientColor = pCmd->ambientColor;

    if (pCmd->hbrush != NULL)
    {
        m_data.m_pBrush =
            static_cast<CMilBrushDuce*>(pHandleTable->GetResource(
                pCmd->hbrush,
                TYPE_BRUSH
                ));

        if (m_data.m_pBrush == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pBrush = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilDiffuseMaterialDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pBrush));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilDiffuseMaterialDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pBrush);
}

HRESULT CMilSpecularMaterialDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_SPECULARMATERIAL* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_color = pCmd->color;

    if (pCmd->hbrush != NULL)
    {
        m_data.m_pBrush =
            static_cast<CMilBrushDuce*>(pHandleTable->GetResource(
                pCmd->hbrush,
                TYPE_BRUSH
                ));

        if (m_data.m_pBrush == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pBrush = NULL;
    }

    m_data.m_specularPower = pCmd->specularPower;

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilSpecularMaterialDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pBrush));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilSpecularMaterialDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pBrush);
}

HRESULT CMilEmissiveMaterialDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_EMISSIVEMATERIAL* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_color = pCmd->color;

    if (pCmd->hbrush != NULL)
    {
        m_data.m_pBrush =
            static_cast<CMilBrushDuce*>(pHandleTable->GetResource(
                pCmd->hbrush,
                TYPE_BRUSH
                ));

        if (m_data.m_pBrush == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pBrush = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilEmissiveMaterialDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pBrush));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilEmissiveMaterialDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pBrush);
}

HRESULT CMilTransform3DGroupDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_TRANSFORM3DGROUP* pCmd,
    __in_bcount(cbPayload) LPCVOID pPayload,
    UINT cbPayload
    )
{
    HRESULT hr = S_OK;

    const BYTE* pbDataSection =
        reinterpret_cast<const BYTE*>(pPayload);




    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    // Read the Children
    // This is for data with handles only; collection field
    // need to do the pointer to handle conversion here.
    IFC(UnmarshalResourceArray(
        IN OUT pbDataSection,
        IN OUT cbPayload,
        pCmd->ChildrenSize,
        TYPE_TRANSFORM3D,
        Mt(CMilTransform3DGroupDuce),
        OUT m_data.m_cChildren,
        OUT m_data.m_rgpChildren,
        pHandleTable,
        false
        ));

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilTransform3DGroupDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNNotifiers(m_data.m_rgpChildren, m_data.m_cChildren));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilTransform3DGroupDuce::UnRegisterNotifiers()
{

    if (m_data.m_rgpChildren)
    {
        UnRegisterNNotifiers(m_data.m_rgpChildren, m_data.m_cChildren);
        WPFFree(ProcessHeap, m_data.m_rgpChildren);
        m_data.m_rgpChildren = NULL;
    }
    m_data.m_cChildren = 0;
}

/*override*/ CMilSlaveResource* CMilTransform3DGroupDuce::GetResource()
{
    return this;
}

HRESULT CMilTranslateTransform3DDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_TRANSLATETRANSFORM3D* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_offsetX = pCmd->offsetX;
    if (pCmd->hOffsetXAnimations != NULL)
    {
        m_data.m_pOffsetXAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hOffsetXAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pOffsetXAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOffsetXAnimation = NULL;
    }

    m_data.m_offsetY = pCmd->offsetY;
    if (pCmd->hOffsetYAnimations != NULL)
    {
        m_data.m_pOffsetYAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hOffsetYAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pOffsetYAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOffsetYAnimation = NULL;
    }

    m_data.m_offsetZ = pCmd->offsetZ;
    if (pCmd->hOffsetZAnimations != NULL)
    {
        m_data.m_pOffsetZAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hOffsetZAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pOffsetZAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOffsetZAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilTranslateTransform3DDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pOffsetXAnimation));
    IFC(RegisterNotifier(m_data.m_pOffsetYAnimation));
    IFC(RegisterNotifier(m_data.m_pOffsetZAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilTranslateTransform3DDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pOffsetXAnimation);
    UnRegisterNotifier(m_data.m_pOffsetYAnimation);
    UnRegisterNotifier(m_data.m_pOffsetZAnimation);
}


HRESULT CMilTranslateTransform3DDuce::SynchronizeAnimatedFields()
{
    HRESULT hr = S_OK;

    if (m_data.m_pOffsetXAnimation)
    {
        IFC(m_data.m_pOffsetXAnimation->GetValue(&m_data.m_offsetX));
    }
    if (m_data.m_pOffsetYAnimation)
    {
        IFC(m_data.m_pOffsetYAnimation->GetValue(&m_data.m_offsetY));
    }
    if (m_data.m_pOffsetZAnimation)
    {
        IFC(m_data.m_pOffsetZAnimation->GetValue(&m_data.m_offsetZ));
    }

Cleanup:
    RRETURN(hr);
}

HRESULT CMilScaleTransform3DDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_SCALETRANSFORM3D* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_scaleX = pCmd->scaleX;
    if (pCmd->hScaleXAnimations != NULL)
    {
        m_data.m_pScaleXAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hScaleXAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pScaleXAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pScaleXAnimation = NULL;
    }

    m_data.m_scaleY = pCmd->scaleY;
    if (pCmd->hScaleYAnimations != NULL)
    {
        m_data.m_pScaleYAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hScaleYAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pScaleYAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pScaleYAnimation = NULL;
    }

    m_data.m_scaleZ = pCmd->scaleZ;
    if (pCmd->hScaleZAnimations != NULL)
    {
        m_data.m_pScaleZAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hScaleZAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pScaleZAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pScaleZAnimation = NULL;
    }

    m_data.m_centerX = pCmd->centerX;
    if (pCmd->hCenterXAnimations != NULL)
    {
        m_data.m_pCenterXAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hCenterXAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pCenterXAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pCenterXAnimation = NULL;
    }

    m_data.m_centerY = pCmd->centerY;
    if (pCmd->hCenterYAnimations != NULL)
    {
        m_data.m_pCenterYAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hCenterYAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pCenterYAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pCenterYAnimation = NULL;
    }

    m_data.m_centerZ = pCmd->centerZ;
    if (pCmd->hCenterZAnimations != NULL)
    {
        m_data.m_pCenterZAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hCenterZAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pCenterZAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pCenterZAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilScaleTransform3DDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pScaleXAnimation));
    IFC(RegisterNotifier(m_data.m_pScaleYAnimation));
    IFC(RegisterNotifier(m_data.m_pScaleZAnimation));
    IFC(RegisterNotifier(m_data.m_pCenterXAnimation));
    IFC(RegisterNotifier(m_data.m_pCenterYAnimation));
    IFC(RegisterNotifier(m_data.m_pCenterZAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilScaleTransform3DDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pScaleXAnimation);
    UnRegisterNotifier(m_data.m_pScaleYAnimation);
    UnRegisterNotifier(m_data.m_pScaleZAnimation);
    UnRegisterNotifier(m_data.m_pCenterXAnimation);
    UnRegisterNotifier(m_data.m_pCenterYAnimation);
    UnRegisterNotifier(m_data.m_pCenterZAnimation);
}


HRESULT CMilScaleTransform3DDuce::SynchronizeAnimatedFields()
{
    HRESULT hr = S_OK;

    if (m_data.m_pScaleXAnimation)
    {
        IFC(m_data.m_pScaleXAnimation->GetValue(&m_data.m_scaleX));
    }
    if (m_data.m_pScaleYAnimation)
    {
        IFC(m_data.m_pScaleYAnimation->GetValue(&m_data.m_scaleY));
    }
    if (m_data.m_pScaleZAnimation)
    {
        IFC(m_data.m_pScaleZAnimation->GetValue(&m_data.m_scaleZ));
    }
    if (m_data.m_pCenterXAnimation)
    {
        IFC(m_data.m_pCenterXAnimation->GetValue(&m_data.m_centerX));
    }
    if (m_data.m_pCenterYAnimation)
    {
        IFC(m_data.m_pCenterYAnimation->GetValue(&m_data.m_centerY));
    }
    if (m_data.m_pCenterZAnimation)
    {
        IFC(m_data.m_pCenterZAnimation->GetValue(&m_data.m_centerZ));
    }

Cleanup:
    RRETURN(hr);
}

HRESULT CMilRotateTransform3DDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_ROTATETRANSFORM3D* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_centerX = pCmd->centerX;
    if (pCmd->hCenterXAnimations != NULL)
    {
        m_data.m_pCenterXAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hCenterXAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pCenterXAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pCenterXAnimation = NULL;
    }

    m_data.m_centerY = pCmd->centerY;
    if (pCmd->hCenterYAnimations != NULL)
    {
        m_data.m_pCenterYAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hCenterYAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pCenterYAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pCenterYAnimation = NULL;
    }

    m_data.m_centerZ = pCmd->centerZ;
    if (pCmd->hCenterZAnimations != NULL)
    {
        m_data.m_pCenterZAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hCenterZAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pCenterZAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pCenterZAnimation = NULL;
    }


    if (pCmd->hrotation != NULL)
    {
        m_data.m_pRotation =
            static_cast<CMilRotation3DDuce*>(pHandleTable->GetResource(
                pCmd->hrotation,
                TYPE_ROTATION3D
                ));

        if (m_data.m_pRotation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRotation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilRotateTransform3DDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pRotation));
    IFC(RegisterNotifier(m_data.m_pCenterXAnimation));
    IFC(RegisterNotifier(m_data.m_pCenterYAnimation));
    IFC(RegisterNotifier(m_data.m_pCenterZAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilRotateTransform3DDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pRotation);
    UnRegisterNotifier(m_data.m_pCenterXAnimation);
    UnRegisterNotifier(m_data.m_pCenterYAnimation);
    UnRegisterNotifier(m_data.m_pCenterZAnimation);
}


HRESULT CMilRotateTransform3DDuce::SynchronizeAnimatedFields()
{
    HRESULT hr = S_OK;

    if (m_data.m_pCenterXAnimation)
    {
        IFC(m_data.m_pCenterXAnimation->GetValue(&m_data.m_centerX));
    }
    if (m_data.m_pCenterYAnimation)
    {
        IFC(m_data.m_pCenterYAnimation->GetValue(&m_data.m_centerY));
    }
    if (m_data.m_pCenterZAnimation)
    {
        IFC(m_data.m_pCenterZAnimation->GetValue(&m_data.m_centerZ));
    }

Cleanup:
    RRETURN(hr);
}

HRESULT CMilMatrixTransform3DDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_MATRIXTRANSFORM3D* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_matrix = pCmd->matrix;

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilMatrixTransform3DDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;



    RRETURN(hr);
}

/*override*/ void CMilMatrixTransform3DDuce::UnRegisterNotifiers()
{

}

HRESULT CMilPixelShaderDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_PIXELSHADER* pCmd,
    __in_bcount(cbPayload) LPCVOID pPayload,
    UINT cbPayload
    )
{
    HRESULT hr = S_OK;

    const BYTE* pbDataSection =
        reinterpret_cast<const BYTE*>(pPayload);




    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_ShaderRenderMode = pCmd->ShaderRenderMode;
    m_data.m_CompileSoftwareShader = pCmd->CompileSoftwareShader;
    // Read the PixelShaderBytecode
    m_data.m_cbPixelShaderBytecodeSize = pCmd->PixelShaderBytecodeSize;
    if (m_data.m_cbPixelShaderBytecodeSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbPixelShaderBytecodeSize > cbPayload
            || m_data.m_cbPixelShaderBytecodeSize % sizeof(INT) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilPixelShaderDuce),
            m_data.m_cbPixelShaderBytecodeSize,
            reinterpret_cast<void**>(&m_data.m_pPixelShaderBytecodeData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pPixelShaderBytecodeData, pbDataSection, m_data.m_cbPixelShaderBytecodeSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbPixelShaderBytecodeSize;
        pbDataSection += m_data.m_cbPixelShaderBytecodeSize;
    }

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilPixelShaderDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;



    RRETURN(hr);
}

/*override*/ void CMilPixelShaderDuce::UnRegisterNotifiers()
{

    if (m_data.m_pPixelShaderBytecodeData)
    {

        WPFFree(ProcessHeap, m_data.m_pPixelShaderBytecodeData);
        m_data.m_pPixelShaderBytecodeData = NULL;
    }
    m_data.m_cbPixelShaderBytecodeSize = 0;
}

HRESULT CMilImplicitInputBrushDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_IMPLICITINPUTBRUSH* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_Opacity = pCmd->Opacity;
    if (pCmd->hOpacityAnimations != NULL)
    {
        m_data.m_pOpacityAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hOpacityAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pOpacityAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOpacityAnimation = NULL;
    }


    if (pCmd->hTransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }


    if (pCmd->hRelativeTransform != NULL)
    {
        m_data.m_pRelativeTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hRelativeTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pRelativeTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRelativeTransform = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilImplicitInputBrushDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pRelativeTransform));
    IFC(RegisterNotifier(m_data.m_pOpacityAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilImplicitInputBrushDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pRelativeTransform);
    UnRegisterNotifier(m_data.m_pOpacityAnimation);
}

HRESULT CMilBlurEffectDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_BLUREFFECT* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_Radius = pCmd->Radius;
    if (pCmd->hRadiusAnimations != NULL)
    {
        m_data.m_pRadiusAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hRadiusAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pRadiusAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRadiusAnimation = NULL;
    }

    m_data.m_KernelType = pCmd->KernelType;
    m_data.m_RenderingBias = pCmd->RenderingBias;

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilBlurEffectDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pRadiusAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilBlurEffectDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pRadiusAnimation);
}

HRESULT CMilDropShadowEffectDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_DROPSHADOWEFFECT* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_ShadowDepth = pCmd->ShadowDepth;
    if (pCmd->hShadowDepthAnimations != NULL)
    {
        m_data.m_pShadowDepthAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hShadowDepthAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pShadowDepthAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pShadowDepthAnimation = NULL;
    }

    m_data.m_Color = pCmd->Color;
    if (pCmd->hColorAnimations != NULL)
    {
        m_data.m_pColorAnimation =
            static_cast<CMilSlaveColor*>(pHandleTable->GetResource(
                pCmd->hColorAnimations,
                TYPE_COLORRESOURCE
                ));

        if (m_data.m_pColorAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pColorAnimation = NULL;
    }

    m_data.m_Direction = pCmd->Direction;
    if (pCmd->hDirectionAnimations != NULL)
    {
        m_data.m_pDirectionAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hDirectionAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pDirectionAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pDirectionAnimation = NULL;
    }

    m_data.m_Opacity = pCmd->Opacity;
    if (pCmd->hOpacityAnimations != NULL)
    {
        m_data.m_pOpacityAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hOpacityAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pOpacityAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOpacityAnimation = NULL;
    }

    m_data.m_BlurRadius = pCmd->BlurRadius;
    if (pCmd->hBlurRadiusAnimations != NULL)
    {
        m_data.m_pBlurRadiusAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hBlurRadiusAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pBlurRadiusAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pBlurRadiusAnimation = NULL;
    }

    m_data.m_RenderingBias = pCmd->RenderingBias;

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilDropShadowEffectDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pShadowDepthAnimation));
    IFC(RegisterNotifier(m_data.m_pColorAnimation));
    IFC(RegisterNotifier(m_data.m_pDirectionAnimation));
    IFC(RegisterNotifier(m_data.m_pOpacityAnimation));
    IFC(RegisterNotifier(m_data.m_pBlurRadiusAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilDropShadowEffectDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pShadowDepthAnimation);
    UnRegisterNotifier(m_data.m_pColorAnimation);
    UnRegisterNotifier(m_data.m_pDirectionAnimation);
    UnRegisterNotifier(m_data.m_pOpacityAnimation);
    UnRegisterNotifier(m_data.m_pBlurRadiusAnimation);
}

HRESULT CMilShaderEffectDuce::GeneratedProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_SHADEREFFECT* pCmd,
    __in_bcount(cbPayload) LPCVOID pPayload,
    UINT cbPayload
    )
{
    HRESULT hr = S_OK;

    const BYTE* pbDataSection =
        reinterpret_cast<const BYTE*>(pPayload);




    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->hPixelShader != NULL)
    {
        m_data.m_pPixelShader =
            static_cast<CMilPixelShaderDuce*>(pHandleTable->GetResource(
                pCmd->hPixelShader,
                TYPE_PIXELSHADER
                ));

        if (m_data.m_pPixelShader == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pPixelShader = NULL;
    }

    m_data.m_DdxUvDdyUvRegisterIndex = pCmd->DdxUvDdyUvRegisterIndex;
    m_data.m_TopPadding = pCmd->TopPadding;
    m_data.m_BottomPadding = pCmd->BottomPadding;
    m_data.m_LeftPadding = pCmd->LeftPadding;
    m_data.m_RightPadding = pCmd->RightPadding;
    // Read the ShaderConstantFloatRegisters
    m_data.m_cbShaderConstantFloatRegistersSize = pCmd->ShaderConstantFloatRegistersSize;
    if (m_data.m_cbShaderConstantFloatRegistersSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbShaderConstantFloatRegistersSize > cbPayload
            || m_data.m_cbShaderConstantFloatRegistersSize % sizeof(SHORT) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilShaderEffectDuce),
            m_data.m_cbShaderConstantFloatRegistersSize,
            reinterpret_cast<void**>(&m_data.m_pShaderConstantFloatRegistersData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pShaderConstantFloatRegistersData, pbDataSection, m_data.m_cbShaderConstantFloatRegistersSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbShaderConstantFloatRegistersSize;
        pbDataSection += m_data.m_cbShaderConstantFloatRegistersSize;
    }
    // Read the DependencyPropertyFloatValues
    m_data.m_cbDependencyPropertyFloatValuesSize = pCmd->DependencyPropertyFloatValuesSize;
    if (m_data.m_cbDependencyPropertyFloatValuesSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbDependencyPropertyFloatValuesSize > cbPayload
            || m_data.m_cbDependencyPropertyFloatValuesSize % sizeof(FLOAT) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilShaderEffectDuce),
            m_data.m_cbDependencyPropertyFloatValuesSize,
            reinterpret_cast<void**>(&m_data.m_pDependencyPropertyFloatValuesData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pDependencyPropertyFloatValuesData, pbDataSection, m_data.m_cbDependencyPropertyFloatValuesSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbDependencyPropertyFloatValuesSize;
        pbDataSection += m_data.m_cbDependencyPropertyFloatValuesSize;
    }
    // Read the ShaderConstantIntRegisters
    m_data.m_cbShaderConstantIntRegistersSize = pCmd->ShaderConstantIntRegistersSize;
    if (m_data.m_cbShaderConstantIntRegistersSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbShaderConstantIntRegistersSize > cbPayload
            || m_data.m_cbShaderConstantIntRegistersSize % sizeof(SHORT) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilShaderEffectDuce),
            m_data.m_cbShaderConstantIntRegistersSize,
            reinterpret_cast<void**>(&m_data.m_pShaderConstantIntRegistersData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pShaderConstantIntRegistersData, pbDataSection, m_data.m_cbShaderConstantIntRegistersSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbShaderConstantIntRegistersSize;
        pbDataSection += m_data.m_cbShaderConstantIntRegistersSize;
    }
    // Read the DependencyPropertyIntValues
    m_data.m_cbDependencyPropertyIntValuesSize = pCmd->DependencyPropertyIntValuesSize;
    if (m_data.m_cbDependencyPropertyIntValuesSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbDependencyPropertyIntValuesSize > cbPayload
            || m_data.m_cbDependencyPropertyIntValuesSize % sizeof(INT) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilShaderEffectDuce),
            m_data.m_cbDependencyPropertyIntValuesSize,
            reinterpret_cast<void**>(&m_data.m_pDependencyPropertyIntValuesData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pDependencyPropertyIntValuesData, pbDataSection, m_data.m_cbDependencyPropertyIntValuesSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbDependencyPropertyIntValuesSize;
        pbDataSection += m_data.m_cbDependencyPropertyIntValuesSize;
    }
    // Read the ShaderConstantBoolRegisters
    m_data.m_cbShaderConstantBoolRegistersSize = pCmd->ShaderConstantBoolRegistersSize;
    if (m_data.m_cbShaderConstantBoolRegistersSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbShaderConstantBoolRegistersSize > cbPayload
            || m_data.m_cbShaderConstantBoolRegistersSize % sizeof(SHORT) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilShaderEffectDuce),
            m_data.m_cbShaderConstantBoolRegistersSize,
            reinterpret_cast<void**>(&m_data.m_pShaderConstantBoolRegistersData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pShaderConstantBoolRegistersData, pbDataSection, m_data.m_cbShaderConstantBoolRegistersSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbShaderConstantBoolRegistersSize;
        pbDataSection += m_data.m_cbShaderConstantBoolRegistersSize;
    }
    // Read the DependencyPropertyBoolValues
    m_data.m_cbDependencyPropertyBoolValuesSize = pCmd->DependencyPropertyBoolValuesSize;
    if (m_data.m_cbDependencyPropertyBoolValuesSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbDependencyPropertyBoolValuesSize > cbPayload
            || m_data.m_cbDependencyPropertyBoolValuesSize % sizeof(BOOL) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilShaderEffectDuce),
            m_data.m_cbDependencyPropertyBoolValuesSize,
            reinterpret_cast<void**>(&m_data.m_pDependencyPropertyBoolValuesData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pDependencyPropertyBoolValuesData, pbDataSection, m_data.m_cbDependencyPropertyBoolValuesSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbDependencyPropertyBoolValuesSize;
        pbDataSection += m_data.m_cbDependencyPropertyBoolValuesSize;
    }
    // Read the ShaderSamplerRegistrationInfo
    m_data.m_cbShaderSamplerRegistrationInfoSize = pCmd->ShaderSamplerRegistrationInfoSize;
    if (m_data.m_cbShaderSamplerRegistrationInfoSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbShaderSamplerRegistrationInfoSize > cbPayload
            || m_data.m_cbShaderSamplerRegistrationInfoSize % sizeof(INT) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilShaderEffectDuce),
            m_data.m_cbShaderSamplerRegistrationInfoSize,
            reinterpret_cast<void**>(&m_data.m_pShaderSamplerRegistrationInfoData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pShaderSamplerRegistrationInfoData, pbDataSection, m_data.m_cbShaderSamplerRegistrationInfoSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbShaderSamplerRegistrationInfoSize;
        pbDataSection += m_data.m_cbShaderSamplerRegistrationInfoSize;
    }
    // Read the DependencyPropertySamplerValues
    m_data.m_cbDependencyPropertySamplerValuesSize = pCmd->DependencyPropertySamplerValuesSize;
    if (m_data.m_cbDependencyPropertySamplerValuesSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbDependencyPropertySamplerValuesSize > cbPayload
            || m_data.m_cbDependencyPropertySamplerValuesSize % sizeof(INT) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilShaderEffectDuce),
            m_data.m_cbDependencyPropertySamplerValuesSize,
            reinterpret_cast<void**>(&m_data.m_pDependencyPropertySamplerValuesData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pDependencyPropertySamplerValuesData, pbDataSection, m_data.m_cbDependencyPropertySamplerValuesSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbDependencyPropertySamplerValuesSize;
        pbDataSection += m_data.m_cbDependencyPropertySamplerValuesSize;
    }

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilShaderEffectDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pPixelShader));









Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilShaderEffectDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pPixelShader);

    if (m_data.m_pShaderConstantFloatRegistersData)
    {

        WPFFree(ProcessHeap, m_data.m_pShaderConstantFloatRegistersData);
        m_data.m_pShaderConstantFloatRegistersData = NULL;
    }
    m_data.m_cbShaderConstantFloatRegistersSize = 0;

    if (m_data.m_pDependencyPropertyFloatValuesData)
    {

        WPFFree(ProcessHeap, m_data.m_pDependencyPropertyFloatValuesData);
        m_data.m_pDependencyPropertyFloatValuesData = NULL;
    }
    m_data.m_cbDependencyPropertyFloatValuesSize = 0;

    if (m_data.m_pShaderConstantIntRegistersData)
    {

        WPFFree(ProcessHeap, m_data.m_pShaderConstantIntRegistersData);
        m_data.m_pShaderConstantIntRegistersData = NULL;
    }
    m_data.m_cbShaderConstantIntRegistersSize = 0;

    if (m_data.m_pDependencyPropertyIntValuesData)
    {

        WPFFree(ProcessHeap, m_data.m_pDependencyPropertyIntValuesData);
        m_data.m_pDependencyPropertyIntValuesData = NULL;
    }
    m_data.m_cbDependencyPropertyIntValuesSize = 0;

    if (m_data.m_pShaderConstantBoolRegistersData)
    {

        WPFFree(ProcessHeap, m_data.m_pShaderConstantBoolRegistersData);
        m_data.m_pShaderConstantBoolRegistersData = NULL;
    }
    m_data.m_cbShaderConstantBoolRegistersSize = 0;

    if (m_data.m_pDependencyPropertyBoolValuesData)
    {

        WPFFree(ProcessHeap, m_data.m_pDependencyPropertyBoolValuesData);
        m_data.m_pDependencyPropertyBoolValuesData = NULL;
    }
    m_data.m_cbDependencyPropertyBoolValuesSize = 0;

    if (m_data.m_pShaderSamplerRegistrationInfoData)
    {

        WPFFree(ProcessHeap, m_data.m_pShaderSamplerRegistrationInfoData);
        m_data.m_pShaderSamplerRegistrationInfoData = NULL;
    }
    m_data.m_cbShaderSamplerRegistrationInfoSize = 0;

    if (m_data.m_pDependencyPropertySamplerValuesData)
    {

        WPFFree(ProcessHeap, m_data.m_pDependencyPropertySamplerValuesData);
        m_data.m_pDependencyPropertySamplerValuesData = NULL;
    }
    m_data.m_cbDependencyPropertySamplerValuesSize = 0;
}

HRESULT CMilDrawingImageDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_DRAWINGIMAGE* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->hDrawing != NULL)
    {
        m_data.m_pDrawing =
            static_cast<CMilDrawingDuce*>(pHandleTable->GetResource(
                pCmd->hDrawing,
                TYPE_DRAWING
                ));

        if (m_data.m_pDrawing == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pDrawing = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilDrawingImageDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pDrawing));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilDrawingImageDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pDrawing);
}

HRESULT CMilTransformGroupDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_TRANSFORMGROUP* pCmd,
    __in_bcount(cbPayload) LPCVOID pPayload,
    UINT cbPayload
    )
{
    HRESULT hr = S_OK;

    const BYTE* pbDataSection =
        reinterpret_cast<const BYTE*>(pPayload);




    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    // Read the Children
    // This is for data with handles only; collection field
    // need to do the pointer to handle conversion here.
    IFC(UnmarshalResourceArray(
        IN OUT pbDataSection,
        IN OUT cbPayload,
        pCmd->ChildrenSize,
        TYPE_TRANSFORM,
        Mt(CMilTransformGroupDuce),
        OUT m_data.m_cChildren,
        OUT m_data.m_rgpChildren,
        pHandleTable,
        false
        ));

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilTransformGroupDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNNotifiers(m_data.m_rgpChildren, m_data.m_cChildren));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilTransformGroupDuce::UnRegisterNotifiers()
{

    if (m_data.m_rgpChildren)
    {
        UnRegisterNNotifiers(m_data.m_rgpChildren, m_data.m_cChildren);
        WPFFree(ProcessHeap, m_data.m_rgpChildren);
        m_data.m_rgpChildren = NULL;
    }
    m_data.m_cChildren = 0;
}

/*override*/ CMilSlaveResource* CMilTransformGroupDuce::GetResource()
{
    return this;
}

HRESULT CMilTranslateTransformDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_TRANSLATETRANSFORM* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_X = pCmd->X;
    if (pCmd->hXAnimations != NULL)
    {
        m_data.m_pXAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hXAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pXAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pXAnimation = NULL;
    }

    m_data.m_Y = pCmd->Y;
    if (pCmd->hYAnimations != NULL)
    {
        m_data.m_pYAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hYAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pYAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pYAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilTranslateTransformDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pXAnimation));
    IFC(RegisterNotifier(m_data.m_pYAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilTranslateTransformDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pXAnimation);
    UnRegisterNotifier(m_data.m_pYAnimation);
}


HRESULT CMilTranslateTransformDuce::SynchronizeAnimatedFields()
{
    HRESULT hr = S_OK;

    if (m_data.m_pXAnimation)
    {
        IFC(m_data.m_pXAnimation->GetValue(&m_data.m_X));
    }
    if (m_data.m_pYAnimation)
    {
        IFC(m_data.m_pYAnimation->GetValue(&m_data.m_Y));
    }

Cleanup:
    RRETURN(hr);
}

HRESULT CMilScaleTransformDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_SCALETRANSFORM* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_ScaleX = pCmd->ScaleX;
    if (pCmd->hScaleXAnimations != NULL)
    {
        m_data.m_pScaleXAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hScaleXAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pScaleXAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pScaleXAnimation = NULL;
    }

    m_data.m_ScaleY = pCmd->ScaleY;
    if (pCmd->hScaleYAnimations != NULL)
    {
        m_data.m_pScaleYAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hScaleYAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pScaleYAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pScaleYAnimation = NULL;
    }

    m_data.m_CenterX = pCmd->CenterX;
    if (pCmd->hCenterXAnimations != NULL)
    {
        m_data.m_pCenterXAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hCenterXAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pCenterXAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pCenterXAnimation = NULL;
    }

    m_data.m_CenterY = pCmd->CenterY;
    if (pCmd->hCenterYAnimations != NULL)
    {
        m_data.m_pCenterYAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hCenterYAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pCenterYAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pCenterYAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilScaleTransformDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pScaleXAnimation));
    IFC(RegisterNotifier(m_data.m_pScaleYAnimation));
    IFC(RegisterNotifier(m_data.m_pCenterXAnimation));
    IFC(RegisterNotifier(m_data.m_pCenterYAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilScaleTransformDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pScaleXAnimation);
    UnRegisterNotifier(m_data.m_pScaleYAnimation);
    UnRegisterNotifier(m_data.m_pCenterXAnimation);
    UnRegisterNotifier(m_data.m_pCenterYAnimation);
}


HRESULT CMilScaleTransformDuce::SynchronizeAnimatedFields()
{
    HRESULT hr = S_OK;

    if (m_data.m_pScaleXAnimation)
    {
        IFC(m_data.m_pScaleXAnimation->GetValue(&m_data.m_ScaleX));
    }
    if (m_data.m_pScaleYAnimation)
    {
        IFC(m_data.m_pScaleYAnimation->GetValue(&m_data.m_ScaleY));
    }
    if (m_data.m_pCenterXAnimation)
    {
        IFC(m_data.m_pCenterXAnimation->GetValue(&m_data.m_CenterX));
    }
    if (m_data.m_pCenterYAnimation)
    {
        IFC(m_data.m_pCenterYAnimation->GetValue(&m_data.m_CenterY));
    }

Cleanup:
    RRETURN(hr);
}

HRESULT CMilSkewTransformDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_SKEWTRANSFORM* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_AngleX = pCmd->AngleX;
    if (pCmd->hAngleXAnimations != NULL)
    {
        m_data.m_pAngleXAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hAngleXAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pAngleXAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pAngleXAnimation = NULL;
    }

    m_data.m_AngleY = pCmd->AngleY;
    if (pCmd->hAngleYAnimations != NULL)
    {
        m_data.m_pAngleYAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hAngleYAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pAngleYAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pAngleYAnimation = NULL;
    }

    m_data.m_CenterX = pCmd->CenterX;
    if (pCmd->hCenterXAnimations != NULL)
    {
        m_data.m_pCenterXAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hCenterXAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pCenterXAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pCenterXAnimation = NULL;
    }

    m_data.m_CenterY = pCmd->CenterY;
    if (pCmd->hCenterYAnimations != NULL)
    {
        m_data.m_pCenterYAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hCenterYAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pCenterYAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pCenterYAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilSkewTransformDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pAngleXAnimation));
    IFC(RegisterNotifier(m_data.m_pAngleYAnimation));
    IFC(RegisterNotifier(m_data.m_pCenterXAnimation));
    IFC(RegisterNotifier(m_data.m_pCenterYAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilSkewTransformDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pAngleXAnimation);
    UnRegisterNotifier(m_data.m_pAngleYAnimation);
    UnRegisterNotifier(m_data.m_pCenterXAnimation);
    UnRegisterNotifier(m_data.m_pCenterYAnimation);
}


HRESULT CMilSkewTransformDuce::SynchronizeAnimatedFields()
{
    HRESULT hr = S_OK;

    if (m_data.m_pAngleXAnimation)
    {
        IFC(m_data.m_pAngleXAnimation->GetValue(&m_data.m_AngleX));
    }
    if (m_data.m_pAngleYAnimation)
    {
        IFC(m_data.m_pAngleYAnimation->GetValue(&m_data.m_AngleY));
    }
    if (m_data.m_pCenterXAnimation)
    {
        IFC(m_data.m_pCenterXAnimation->GetValue(&m_data.m_CenterX));
    }
    if (m_data.m_pCenterYAnimation)
    {
        IFC(m_data.m_pCenterYAnimation->GetValue(&m_data.m_CenterY));
    }

Cleanup:
    RRETURN(hr);
}

HRESULT CMilRotateTransformDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_ROTATETRANSFORM* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_Angle = pCmd->Angle;
    if (pCmd->hAngleAnimations != NULL)
    {
        m_data.m_pAngleAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hAngleAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pAngleAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pAngleAnimation = NULL;
    }

    m_data.m_CenterX = pCmd->CenterX;
    if (pCmd->hCenterXAnimations != NULL)
    {
        m_data.m_pCenterXAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hCenterXAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pCenterXAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pCenterXAnimation = NULL;
    }

    m_data.m_CenterY = pCmd->CenterY;
    if (pCmd->hCenterYAnimations != NULL)
    {
        m_data.m_pCenterYAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hCenterYAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pCenterYAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pCenterYAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilRotateTransformDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pAngleAnimation));
    IFC(RegisterNotifier(m_data.m_pCenterXAnimation));
    IFC(RegisterNotifier(m_data.m_pCenterYAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilRotateTransformDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pAngleAnimation);
    UnRegisterNotifier(m_data.m_pCenterXAnimation);
    UnRegisterNotifier(m_data.m_pCenterYAnimation);
}


HRESULT CMilRotateTransformDuce::SynchronizeAnimatedFields()
{
    HRESULT hr = S_OK;

    if (m_data.m_pAngleAnimation)
    {
        IFC(m_data.m_pAngleAnimation->GetValue(&m_data.m_Angle));
    }
    if (m_data.m_pCenterXAnimation)
    {
        IFC(m_data.m_pCenterXAnimation->GetValue(&m_data.m_CenterX));
    }
    if (m_data.m_pCenterYAnimation)
    {
        IFC(m_data.m_pCenterYAnimation->GetValue(&m_data.m_CenterY));
    }

Cleanup:
    RRETURN(hr);
}

HRESULT CMilMatrixTransformDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_MATRIXTRANSFORM* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_Matrix = pCmd->Matrix;
    if (pCmd->hMatrixAnimations != NULL)
    {
        m_data.m_pMatrixAnimation =
            static_cast<CMilSlaveMatrix*>(pHandleTable->GetResource(
                pCmd->hMatrixAnimations,
                TYPE_MATRIXRESOURCE
                ));

        if (m_data.m_pMatrixAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pMatrixAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilMatrixTransformDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pMatrixAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilMatrixTransformDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pMatrixAnimation);
}

HRESULT CMilLineGeometryDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_LINEGEOMETRY* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->hTransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }

    m_data.m_StartPoint = pCmd->StartPoint;
    if (pCmd->hStartPointAnimations != NULL)
    {
        m_data.m_pStartPointAnimation =
            static_cast<CMilSlavePoint*>(pHandleTable->GetResource(
                pCmd->hStartPointAnimations,
                TYPE_POINTRESOURCE
                ));

        if (m_data.m_pStartPointAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pStartPointAnimation = NULL;
    }

    m_data.m_EndPoint = pCmd->EndPoint;
    if (pCmd->hEndPointAnimations != NULL)
    {
        m_data.m_pEndPointAnimation =
            static_cast<CMilSlavePoint*>(pHandleTable->GetResource(
                pCmd->hEndPointAnimations,
                TYPE_POINTRESOURCE
                ));

        if (m_data.m_pEndPointAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pEndPointAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilLineGeometryDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pStartPointAnimation));
    IFC(RegisterNotifier(m_data.m_pEndPointAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilLineGeometryDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pStartPointAnimation);
    UnRegisterNotifier(m_data.m_pEndPointAnimation);
}

HRESULT CMilRectangleGeometryDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_RECTANGLEGEOMETRY* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->hTransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }

    m_data.m_RadiusX = pCmd->RadiusX;
    if (pCmd->hRadiusXAnimations != NULL)
    {
        m_data.m_pRadiusXAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hRadiusXAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pRadiusXAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRadiusXAnimation = NULL;
    }

    m_data.m_RadiusY = pCmd->RadiusY;
    if (pCmd->hRadiusYAnimations != NULL)
    {
        m_data.m_pRadiusYAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hRadiusYAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pRadiusYAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRadiusYAnimation = NULL;
    }

    m_data.m_Rect = pCmd->Rect;
    if (pCmd->hRectAnimations != NULL)
    {
        m_data.m_pRectAnimation =
            static_cast<CMilSlaveRect*>(pHandleTable->GetResource(
                pCmd->hRectAnimations,
                TYPE_RECTRESOURCE
                ));

        if (m_data.m_pRectAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRectAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilRectangleGeometryDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pRadiusXAnimation));
    IFC(RegisterNotifier(m_data.m_pRadiusYAnimation));
    IFC(RegisterNotifier(m_data.m_pRectAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilRectangleGeometryDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pRadiusXAnimation);
    UnRegisterNotifier(m_data.m_pRadiusYAnimation);
    UnRegisterNotifier(m_data.m_pRectAnimation);
}

HRESULT CMilEllipseGeometryDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_ELLIPSEGEOMETRY* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->hTransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }

    m_data.m_RadiusX = pCmd->RadiusX;
    if (pCmd->hRadiusXAnimations != NULL)
    {
        m_data.m_pRadiusXAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hRadiusXAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pRadiusXAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRadiusXAnimation = NULL;
    }

    m_data.m_RadiusY = pCmd->RadiusY;
    if (pCmd->hRadiusYAnimations != NULL)
    {
        m_data.m_pRadiusYAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hRadiusYAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pRadiusYAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRadiusYAnimation = NULL;
    }

    m_data.m_Center = pCmd->Center;
    if (pCmd->hCenterAnimations != NULL)
    {
        m_data.m_pCenterAnimation =
            static_cast<CMilSlavePoint*>(pHandleTable->GetResource(
                pCmd->hCenterAnimations,
                TYPE_POINTRESOURCE
                ));

        if (m_data.m_pCenterAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pCenterAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilEllipseGeometryDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pRadiusXAnimation));
    IFC(RegisterNotifier(m_data.m_pRadiusYAnimation));
    IFC(RegisterNotifier(m_data.m_pCenterAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilEllipseGeometryDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pRadiusXAnimation);
    UnRegisterNotifier(m_data.m_pRadiusYAnimation);
    UnRegisterNotifier(m_data.m_pCenterAnimation);
}

HRESULT CMilGeometryGroupDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_GEOMETRYGROUP* pCmd,
    __in_bcount(cbPayload) LPCVOID pPayload,
    UINT cbPayload
    )
{
    HRESULT hr = S_OK;

    const BYTE* pbDataSection =
        reinterpret_cast<const BYTE*>(pPayload);




    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->hTransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }

    m_data.m_FillRule = pCmd->FillRule;
    // Read the Children
    // This is for data with handles only; collection field
    // need to do the pointer to handle conversion here.
    IFC(UnmarshalResourceArray(
        IN OUT pbDataSection,
        IN OUT cbPayload,
        pCmd->ChildrenSize,
        TYPE_GEOMETRY,
        Mt(CMilGeometryGroupDuce),
        OUT m_data.m_cChildren,
        OUT m_data.m_rgpChildren,
        pHandleTable,
        false
        ));

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilGeometryGroupDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNNotifiers(m_data.m_rgpChildren, m_data.m_cChildren));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilGeometryGroupDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);

    if (m_data.m_rgpChildren)
    {
        UnRegisterNNotifiers(m_data.m_rgpChildren, m_data.m_cChildren);
        WPFFree(ProcessHeap, m_data.m_rgpChildren);
        m_data.m_rgpChildren = NULL;
    }
    m_data.m_cChildren = 0;
}

/*override*/ CMilSlaveResource* CMilGeometryGroupDuce::GetResource()
{
    return this;
}

HRESULT CMilCombinedGeometryDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_COMBINEDGEOMETRY* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->hTransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }

    m_data.m_GeometryCombineMode = pCmd->GeometryCombineMode;

    if (pCmd->hGeometry1 != NULL)
    {
        m_data.m_pGeometry1 =
            static_cast<CMilGeometryDuce*>(pHandleTable->GetResource(
                pCmd->hGeometry1,
                TYPE_GEOMETRY
                ));

        if (m_data.m_pGeometry1 == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pGeometry1 = NULL;
    }


    if (pCmd->hGeometry2 != NULL)
    {
        m_data.m_pGeometry2 =
            static_cast<CMilGeometryDuce*>(pHandleTable->GetResource(
                pCmd->hGeometry2,
                TYPE_GEOMETRY
                ));

        if (m_data.m_pGeometry2 == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pGeometry2 = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilCombinedGeometryDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pGeometry1));
    IFC(RegisterNotifier(m_data.m_pGeometry2));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilCombinedGeometryDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pGeometry1);
    UnRegisterNotifier(m_data.m_pGeometry2);
}

/*override*/ CMilSlaveResource* CMilCombinedGeometryDuce::GetResource()
{
    return this;
}

HRESULT CMilPathGeometryDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_PATHGEOMETRY* pCmd,
    __in_bcount(cbPayload) LPCVOID pPayload,
    UINT cbPayload
    )
{
    HRESULT hr = S_OK;

    const BYTE* pbDataSection =
        reinterpret_cast<const BYTE*>(pPayload);




    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->hTransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }

    m_data.m_FillRule = pCmd->FillRule;
    // Read the Figures
    m_data.m_cbFiguresSize = pCmd->FiguresSize;
    if (m_data.m_cbFiguresSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Since the PathGeometry packets are
        // really complicated and difficult to perform automatically, more
        // detailed checks are performed at a later stage.
        //

        if (m_data.m_cbFiguresSize > cbPayload)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilPathGeometryDuce),
            m_data.m_cbFiguresSize,
            reinterpret_cast<void**>(&m_data.m_pFiguresData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pFiguresData, pbDataSection, m_data.m_cbFiguresSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbFiguresSize;
        pbDataSection += m_data.m_cbFiguresSize;
    }

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));

    IFC(ProcessUpdateCore());

Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilPathGeometryDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));


Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilPathGeometryDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);

    if (m_data.m_pFiguresData)
    {

        WPFFree(ProcessHeap, m_data.m_pFiguresData);
        m_data.m_pFiguresData = NULL;
    }
    m_data.m_cbFiguresSize = 0;
}

HRESULT CMilSolidColorBrushDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_SOLIDCOLORBRUSH* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_Opacity = pCmd->Opacity;
    if (pCmd->hOpacityAnimations != NULL)
    {
        m_data.m_pOpacityAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hOpacityAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pOpacityAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOpacityAnimation = NULL;
    }


    if (pCmd->hTransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }


    if (pCmd->hRelativeTransform != NULL)
    {
        m_data.m_pRelativeTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hRelativeTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pRelativeTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRelativeTransform = NULL;
    }

    m_data.m_Color = pCmd->Color;
    if (pCmd->hColorAnimations != NULL)
    {
        m_data.m_pColorAnimation =
            static_cast<CMilSlaveColor*>(pHandleTable->GetResource(
                pCmd->hColorAnimations,
                TYPE_COLORRESOURCE
                ));

        if (m_data.m_pColorAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pColorAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilSolidColorBrushDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pRelativeTransform));
    IFC(RegisterNotifier(m_data.m_pOpacityAnimation));
    IFC(RegisterNotifier(m_data.m_pColorAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilSolidColorBrushDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pRelativeTransform);
    UnRegisterNotifier(m_data.m_pOpacityAnimation);
    UnRegisterNotifier(m_data.m_pColorAnimation);
}

HRESULT CMilLinearGradientBrushDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_LINEARGRADIENTBRUSH* pCmd,
    __in_bcount(cbPayload) LPCVOID pPayload,
    UINT cbPayload
    )
{
    HRESULT hr = S_OK;

    const BYTE* pbDataSection =
        reinterpret_cast<const BYTE*>(pPayload);




    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_Opacity = pCmd->Opacity;
    if (pCmd->hOpacityAnimations != NULL)
    {
        m_data.m_pOpacityAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hOpacityAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pOpacityAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOpacityAnimation = NULL;
    }


    if (pCmd->hTransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }


    if (pCmd->hRelativeTransform != NULL)
    {
        m_data.m_pRelativeTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hRelativeTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pRelativeTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRelativeTransform = NULL;
    }

    m_data.m_ColorInterpolationMode = pCmd->ColorInterpolationMode;
    m_data.m_MappingMode = pCmd->MappingMode;
    m_data.m_SpreadMethod = pCmd->SpreadMethod;
    m_data.m_StartPoint = pCmd->StartPoint;
    if (pCmd->hStartPointAnimations != NULL)
    {
        m_data.m_pStartPointAnimation =
            static_cast<CMilSlavePoint*>(pHandleTable->GetResource(
                pCmd->hStartPointAnimations,
                TYPE_POINTRESOURCE
                ));

        if (m_data.m_pStartPointAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pStartPointAnimation = NULL;
    }

    m_data.m_EndPoint = pCmd->EndPoint;
    if (pCmd->hEndPointAnimations != NULL)
    {
        m_data.m_pEndPointAnimation =
            static_cast<CMilSlavePoint*>(pHandleTable->GetResource(
                pCmd->hEndPointAnimations,
                TYPE_POINTRESOURCE
                ));

        if (m_data.m_pEndPointAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pEndPointAnimation = NULL;
    }

    // Read the GradientStops
    m_data.m_cbGradientStopsSize = pCmd->GradientStopsSize;
    if (m_data.m_cbGradientStopsSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbGradientStopsSize > cbPayload
            || m_data.m_cbGradientStopsSize % sizeof(MilGradientStop) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilLinearGradientBrushDuce),
            m_data.m_cbGradientStopsSize,
            reinterpret_cast<void**>(&m_data.m_pGradientStopsData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pGradientStopsData, pbDataSection, m_data.m_cbGradientStopsSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbGradientStopsSize;
        pbDataSection += m_data.m_cbGradientStopsSize;
    }

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilLinearGradientBrushDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pRelativeTransform));

    IFC(RegisterNotifier(m_data.m_pOpacityAnimation));
    IFC(RegisterNotifier(m_data.m_pStartPointAnimation));
    IFC(RegisterNotifier(m_data.m_pEndPointAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilLinearGradientBrushDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pRelativeTransform);

    if (m_data.m_pGradientStopsData)
    {

        WPFFree(ProcessHeap, m_data.m_pGradientStopsData);
        m_data.m_pGradientStopsData = NULL;
    }
    m_data.m_cbGradientStopsSize = 0;
    UnRegisterNotifier(m_data.m_pOpacityAnimation);
    UnRegisterNotifier(m_data.m_pStartPointAnimation);
    UnRegisterNotifier(m_data.m_pEndPointAnimation);
}

HRESULT CMilRadialGradientBrushDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_RADIALGRADIENTBRUSH* pCmd,
    __in_bcount(cbPayload) LPCVOID pPayload,
    UINT cbPayload
    )
{
    HRESULT hr = S_OK;

    const BYTE* pbDataSection =
        reinterpret_cast<const BYTE*>(pPayload);




    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_Opacity = pCmd->Opacity;
    if (pCmd->hOpacityAnimations != NULL)
    {
        m_data.m_pOpacityAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hOpacityAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pOpacityAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOpacityAnimation = NULL;
    }


    if (pCmd->hTransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }


    if (pCmd->hRelativeTransform != NULL)
    {
        m_data.m_pRelativeTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hRelativeTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pRelativeTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRelativeTransform = NULL;
    }

    m_data.m_ColorInterpolationMode = pCmd->ColorInterpolationMode;
    m_data.m_MappingMode = pCmd->MappingMode;
    m_data.m_SpreadMethod = pCmd->SpreadMethod;
    m_data.m_Center = pCmd->Center;
    if (pCmd->hCenterAnimations != NULL)
    {
        m_data.m_pCenterAnimation =
            static_cast<CMilSlavePoint*>(pHandleTable->GetResource(
                pCmd->hCenterAnimations,
                TYPE_POINTRESOURCE
                ));

        if (m_data.m_pCenterAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pCenterAnimation = NULL;
    }

    m_data.m_RadiusX = pCmd->RadiusX;
    if (pCmd->hRadiusXAnimations != NULL)
    {
        m_data.m_pRadiusXAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hRadiusXAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pRadiusXAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRadiusXAnimation = NULL;
    }

    m_data.m_RadiusY = pCmd->RadiusY;
    if (pCmd->hRadiusYAnimations != NULL)
    {
        m_data.m_pRadiusYAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hRadiusYAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pRadiusYAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRadiusYAnimation = NULL;
    }

    m_data.m_GradientOrigin = pCmd->GradientOrigin;
    if (pCmd->hGradientOriginAnimations != NULL)
    {
        m_data.m_pGradientOriginAnimation =
            static_cast<CMilSlavePoint*>(pHandleTable->GetResource(
                pCmd->hGradientOriginAnimations,
                TYPE_POINTRESOURCE
                ));

        if (m_data.m_pGradientOriginAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pGradientOriginAnimation = NULL;
    }

    // Read the GradientStops
    m_data.m_cbGradientStopsSize = pCmd->GradientStopsSize;
    if (m_data.m_cbGradientStopsSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbGradientStopsSize > cbPayload
            || m_data.m_cbGradientStopsSize % sizeof(MilGradientStop) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilRadialGradientBrushDuce),
            m_data.m_cbGradientStopsSize,
            reinterpret_cast<void**>(&m_data.m_pGradientStopsData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pGradientStopsData, pbDataSection, m_data.m_cbGradientStopsSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbGradientStopsSize;
        pbDataSection += m_data.m_cbGradientStopsSize;
    }

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilRadialGradientBrushDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pRelativeTransform));

    IFC(RegisterNotifier(m_data.m_pOpacityAnimation));
    IFC(RegisterNotifier(m_data.m_pCenterAnimation));
    IFC(RegisterNotifier(m_data.m_pRadiusXAnimation));
    IFC(RegisterNotifier(m_data.m_pRadiusYAnimation));
    IFC(RegisterNotifier(m_data.m_pGradientOriginAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilRadialGradientBrushDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pRelativeTransform);

    if (m_data.m_pGradientStopsData)
    {

        WPFFree(ProcessHeap, m_data.m_pGradientStopsData);
        m_data.m_pGradientStopsData = NULL;
    }
    m_data.m_cbGradientStopsSize = 0;
    UnRegisterNotifier(m_data.m_pOpacityAnimation);
    UnRegisterNotifier(m_data.m_pCenterAnimation);
    UnRegisterNotifier(m_data.m_pRadiusXAnimation);
    UnRegisterNotifier(m_data.m_pRadiusYAnimation);
    UnRegisterNotifier(m_data.m_pGradientOriginAnimation);
}

HRESULT CMilImageBrushDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_IMAGEBRUSH* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_Opacity = pCmd->Opacity;
    if (pCmd->hOpacityAnimations != NULL)
    {
        m_data.m_pOpacityAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hOpacityAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pOpacityAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOpacityAnimation = NULL;
    }


    if (pCmd->hTransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }


    if (pCmd->hRelativeTransform != NULL)
    {
        m_data.m_pRelativeTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hRelativeTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pRelativeTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRelativeTransform = NULL;
    }

    m_data.m_ViewportUnits = pCmd->ViewportUnits;
    m_data.m_ViewboxUnits = pCmd->ViewboxUnits;
    m_data.m_Viewport = pCmd->Viewport;
    if (pCmd->hViewportAnimations != NULL)
    {
        m_data.m_pViewportAnimation =
            static_cast<CMilSlaveRect*>(pHandleTable->GetResource(
                pCmd->hViewportAnimations,
                TYPE_RECTRESOURCE
                ));

        if (m_data.m_pViewportAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pViewportAnimation = NULL;
    }

    m_data.m_Viewbox = pCmd->Viewbox;
    if (pCmd->hViewboxAnimations != NULL)
    {
        m_data.m_pViewboxAnimation =
            static_cast<CMilSlaveRect*>(pHandleTable->GetResource(
                pCmd->hViewboxAnimations,
                TYPE_RECTRESOURCE
                ));

        if (m_data.m_pViewboxAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pViewboxAnimation = NULL;
    }

    m_data.m_Stretch = pCmd->Stretch;
    m_data.m_TileMode = pCmd->TileMode;
    m_data.m_AlignmentX = pCmd->AlignmentX;
    m_data.m_AlignmentY = pCmd->AlignmentY;
    m_data.m_CachingHint = pCmd->CachingHint;
    m_data.m_CacheInvalidationThresholdMinimum = pCmd->CacheInvalidationThresholdMinimum;
    m_data.m_CacheInvalidationThresholdMaximum = pCmd->CacheInvalidationThresholdMaximum;

    if (pCmd->hImageSource != NULL)
    {
        m_data.m_pImageSource =
            static_cast<CMilImageSource*>(pHandleTable->GetResource(
                pCmd->hImageSource,
                TYPE_IMAGESOURCE
                ));

        if (m_data.m_pImageSource == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pImageSource = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilImageBrushDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pRelativeTransform));
    IFC(RegisterNotifier(m_data.m_pImageSource));
    IFC(RegisterNotifier(m_data.m_pOpacityAnimation));
    IFC(RegisterNotifier(m_data.m_pViewportAnimation));
    IFC(RegisterNotifier(m_data.m_pViewboxAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilImageBrushDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pRelativeTransform);
    UnRegisterNotifier(m_data.m_pImageSource);
    UnRegisterNotifier(m_data.m_pOpacityAnimation);
    UnRegisterNotifier(m_data.m_pViewportAnimation);
    UnRegisterNotifier(m_data.m_pViewboxAnimation);
}

HRESULT CMilDrawingBrushDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_DRAWINGBRUSH* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_Opacity = pCmd->Opacity;
    if (pCmd->hOpacityAnimations != NULL)
    {
        m_data.m_pOpacityAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hOpacityAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pOpacityAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOpacityAnimation = NULL;
    }


    if (pCmd->hTransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }


    if (pCmd->hRelativeTransform != NULL)
    {
        m_data.m_pRelativeTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hRelativeTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pRelativeTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRelativeTransform = NULL;
    }

    m_data.m_ViewportUnits = pCmd->ViewportUnits;
    m_data.m_ViewboxUnits = pCmd->ViewboxUnits;
    m_data.m_Viewport = pCmd->Viewport;
    if (pCmd->hViewportAnimations != NULL)
    {
        m_data.m_pViewportAnimation =
            static_cast<CMilSlaveRect*>(pHandleTable->GetResource(
                pCmd->hViewportAnimations,
                TYPE_RECTRESOURCE
                ));

        if (m_data.m_pViewportAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pViewportAnimation = NULL;
    }

    m_data.m_Viewbox = pCmd->Viewbox;
    if (pCmd->hViewboxAnimations != NULL)
    {
        m_data.m_pViewboxAnimation =
            static_cast<CMilSlaveRect*>(pHandleTable->GetResource(
                pCmd->hViewboxAnimations,
                TYPE_RECTRESOURCE
                ));

        if (m_data.m_pViewboxAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pViewboxAnimation = NULL;
    }

    m_data.m_Stretch = pCmd->Stretch;
    m_data.m_TileMode = pCmd->TileMode;
    m_data.m_AlignmentX = pCmd->AlignmentX;
    m_data.m_AlignmentY = pCmd->AlignmentY;
    m_data.m_CachingHint = pCmd->CachingHint;
    m_data.m_CacheInvalidationThresholdMinimum = pCmd->CacheInvalidationThresholdMinimum;
    m_data.m_CacheInvalidationThresholdMaximum = pCmd->CacheInvalidationThresholdMaximum;

    if (pCmd->hDrawing != NULL)
    {
        m_data.m_pDrawing =
            static_cast<CMilDrawingDuce*>(pHandleTable->GetResource(
                pCmd->hDrawing,
                TYPE_DRAWING
                ));

        if (m_data.m_pDrawing == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pDrawing = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilDrawingBrushDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pRelativeTransform));
    IFC(RegisterNotifier(m_data.m_pDrawing));
    IFC(RegisterNotifier(m_data.m_pOpacityAnimation));
    IFC(RegisterNotifier(m_data.m_pViewportAnimation));
    IFC(RegisterNotifier(m_data.m_pViewboxAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilDrawingBrushDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pRelativeTransform);
    UnRegisterNotifier(m_data.m_pDrawing);
    UnRegisterNotifier(m_data.m_pOpacityAnimation);
    UnRegisterNotifier(m_data.m_pViewportAnimation);
    UnRegisterNotifier(m_data.m_pViewboxAnimation);
}

HRESULT CMilVisualBrushDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_VISUALBRUSH* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_Opacity = pCmd->Opacity;
    if (pCmd->hOpacityAnimations != NULL)
    {
        m_data.m_pOpacityAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hOpacityAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pOpacityAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOpacityAnimation = NULL;
    }


    if (pCmd->hTransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }


    if (pCmd->hRelativeTransform != NULL)
    {
        m_data.m_pRelativeTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hRelativeTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pRelativeTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRelativeTransform = NULL;
    }

    m_data.m_ViewportUnits = pCmd->ViewportUnits;
    m_data.m_ViewboxUnits = pCmd->ViewboxUnits;
    m_data.m_Viewport = pCmd->Viewport;
    if (pCmd->hViewportAnimations != NULL)
    {
        m_data.m_pViewportAnimation =
            static_cast<CMilSlaveRect*>(pHandleTable->GetResource(
                pCmd->hViewportAnimations,
                TYPE_RECTRESOURCE
                ));

        if (m_data.m_pViewportAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pViewportAnimation = NULL;
    }

    m_data.m_Viewbox = pCmd->Viewbox;
    if (pCmd->hViewboxAnimations != NULL)
    {
        m_data.m_pViewboxAnimation =
            static_cast<CMilSlaveRect*>(pHandleTable->GetResource(
                pCmd->hViewboxAnimations,
                TYPE_RECTRESOURCE
                ));

        if (m_data.m_pViewboxAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pViewboxAnimation = NULL;
    }

    m_data.m_Stretch = pCmd->Stretch;
    m_data.m_TileMode = pCmd->TileMode;
    m_data.m_AlignmentX = pCmd->AlignmentX;
    m_data.m_AlignmentY = pCmd->AlignmentY;
    m_data.m_CachingHint = pCmd->CachingHint;
    m_data.m_CacheInvalidationThresholdMinimum = pCmd->CacheInvalidationThresholdMinimum;
    m_data.m_CacheInvalidationThresholdMaximum = pCmd->CacheInvalidationThresholdMaximum;

    if (pCmd->hVisual != NULL)
    {
        m_data.m_pVisual =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->hVisual,
                TYPE_VISUAL
                ));

        if (m_data.m_pVisual == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pVisual = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilVisualBrushDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pRelativeTransform));
    IFC(RegisterNotifier(m_data.m_pVisual));
    IFC(RegisterNotifier(m_data.m_pOpacityAnimation));
    IFC(RegisterNotifier(m_data.m_pViewportAnimation));
    IFC(RegisterNotifier(m_data.m_pViewboxAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilVisualBrushDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pRelativeTransform);
    UnRegisterNotifier(m_data.m_pVisual);
    UnRegisterNotifier(m_data.m_pOpacityAnimation);
    UnRegisterNotifier(m_data.m_pViewportAnimation);
    UnRegisterNotifier(m_data.m_pViewboxAnimation);
}

/*override*/ CMilSlaveResource* CMilVisualBrushDuce::GetResource()
{
    return this;
}

HRESULT CMilBitmapCacheBrushDuce::GeneratedProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_BITMAPCACHEBRUSH* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_Opacity = pCmd->Opacity;
    if (pCmd->hOpacityAnimations != NULL)
    {
        m_data.m_pOpacityAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hOpacityAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pOpacityAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOpacityAnimation = NULL;
    }


    if (pCmd->hTransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }


    if (pCmd->hRelativeTransform != NULL)
    {
        m_data.m_pRelativeTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hRelativeTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pRelativeTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRelativeTransform = NULL;
    }


    if (pCmd->hBitmapCache != NULL)
    {
        m_data.m_pBitmapCache =
            static_cast<CMilBitmapCacheDuce*>(pHandleTable->GetResource(
                pCmd->hBitmapCache,
                TYPE_BITMAPCACHE
                ));

        if (m_data.m_pBitmapCache == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pBitmapCache = NULL;
    }


    if (pCmd->hInternalTarget != NULL)
    {
        m_data.m_pInternalTarget =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->hInternalTarget,
                TYPE_VISUAL
                ));

        if (m_data.m_pInternalTarget == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pInternalTarget = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilBitmapCacheBrushDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pRelativeTransform));
    IFC(RegisterNotifier(m_data.m_pBitmapCache));
    IFC(RegisterNotifier(m_data.m_pInternalTarget));
    IFC(RegisterNotifier(m_data.m_pOpacityAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilBitmapCacheBrushDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pRelativeTransform);
    UnRegisterNotifier(m_data.m_pBitmapCache);
    UnRegisterNotifier(m_data.m_pInternalTarget);
    UnRegisterNotifier(m_data.m_pOpacityAnimation);
}

/*override*/ CMilSlaveResource* CMilBitmapCacheBrushDuce::GetResource()
{
    return this;
}

HRESULT CMilDashStyleDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_DASHSTYLE* pCmd,
    __in_bcount(cbPayload) LPCVOID pPayload,
    UINT cbPayload
    )
{
    HRESULT hr = S_OK;

    const BYTE* pbDataSection =
        reinterpret_cast<const BYTE*>(pPayload);




    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_Offset = pCmd->Offset;
    if (pCmd->hOffsetAnimations != NULL)
    {
        m_data.m_pOffsetAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hOffsetAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pOffsetAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOffsetAnimation = NULL;
    }

    // Read the Dashes
    m_data.m_cbDashesSize = pCmd->DashesSize;
    if (m_data.m_cbDashesSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbDashesSize > cbPayload
            || m_data.m_cbDashesSize % sizeof(DOUBLE) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilDashStyleDuce),
            m_data.m_cbDashesSize,
            reinterpret_cast<void**>(&m_data.m_pDashesData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pDashesData, pbDataSection, m_data.m_cbDashesSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbDashesSize;
        pbDataSection += m_data.m_cbDashesSize;
    }

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilDashStyleDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;


    IFC(RegisterNotifier(m_data.m_pOffsetAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilDashStyleDuce::UnRegisterNotifiers()
{

    if (m_data.m_pDashesData)
    {

        WPFFree(ProcessHeap, m_data.m_pDashesData);
        m_data.m_pDashesData = NULL;
    }
    m_data.m_cbDashesSize = 0;
    UnRegisterNotifier(m_data.m_pOffsetAnimation);
}

HRESULT CMilPenDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_PEN* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->hBrush != NULL)
    {
        m_data.m_pBrush =
            static_cast<CMilBrushDuce*>(pHandleTable->GetResource(
                pCmd->hBrush,
                TYPE_BRUSH
                ));

        if (m_data.m_pBrush == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pBrush = NULL;
    }

    m_data.m_Thickness = pCmd->Thickness;
    if (pCmd->hThicknessAnimations != NULL)
    {
        m_data.m_pThicknessAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hThicknessAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pThicknessAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pThicknessAnimation = NULL;
    }

    m_data.m_StartLineCap = pCmd->StartLineCap;
    m_data.m_EndLineCap = pCmd->EndLineCap;
    m_data.m_DashCap = pCmd->DashCap;
    m_data.m_LineJoin = pCmd->LineJoin;
    m_data.m_MiterLimit = pCmd->MiterLimit;

    if (pCmd->hDashStyle != NULL)
    {
        m_data.m_pDashStyle =
            static_cast<CMilDashStyleDuce*>(pHandleTable->GetResource(
                pCmd->hDashStyle,
                TYPE_DASHSTYLE
                ));

        if (m_data.m_pDashStyle == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pDashStyle = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilPenDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pBrush));
    IFC(RegisterNotifier(m_data.m_pDashStyle));
    IFC(RegisterNotifier(m_data.m_pThicknessAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilPenDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pBrush);
    UnRegisterNotifier(m_data.m_pDashStyle);
    UnRegisterNotifier(m_data.m_pThicknessAnimation);
}

HRESULT CMilGeometryDrawingDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_GEOMETRYDRAWING* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->hBrush != NULL)
    {
        m_data.m_pBrush =
            static_cast<CMilBrushDuce*>(pHandleTable->GetResource(
                pCmd->hBrush,
                TYPE_BRUSH
                ));

        if (m_data.m_pBrush == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pBrush = NULL;
    }


    if (pCmd->hPen != NULL)
    {
        m_data.m_pPen =
            static_cast<CMilPenDuce*>(pHandleTable->GetResource(
                pCmd->hPen,
                TYPE_PEN
                ));

        if (m_data.m_pPen == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pPen = NULL;
    }


    if (pCmd->hGeometry != NULL)
    {
        m_data.m_pGeometry =
            static_cast<CMilGeometryDuce*>(pHandleTable->GetResource(
                pCmd->hGeometry,
                TYPE_GEOMETRY
                ));

        if (m_data.m_pGeometry == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pGeometry = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilGeometryDrawingDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pBrush));
    IFC(RegisterNotifier(m_data.m_pPen));
    IFC(RegisterNotifier(m_data.m_pGeometry));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilGeometryDrawingDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pBrush);
    UnRegisterNotifier(m_data.m_pPen);
    UnRegisterNotifier(m_data.m_pGeometry);
}

HRESULT CMilGlyphRunDrawingDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_GLYPHRUNDRAWING* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->hGlyphRun != NULL)
    {
        m_data.m_pGlyphRun =
            static_cast<CGlyphRunResource*>(pHandleTable->GetResource(
                pCmd->hGlyphRun,
                TYPE_GLYPHRUN
                ));

        if (m_data.m_pGlyphRun == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pGlyphRun = NULL;
    }


    if (pCmd->hForegroundBrush != NULL)
    {
        m_data.m_pForegroundBrush =
            static_cast<CMilBrushDuce*>(pHandleTable->GetResource(
                pCmd->hForegroundBrush,
                TYPE_BRUSH
                ));

        if (m_data.m_pForegroundBrush == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pForegroundBrush = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilGlyphRunDrawingDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pGlyphRun));
    IFC(RegisterNotifier(m_data.m_pForegroundBrush));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilGlyphRunDrawingDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pGlyphRun);
    UnRegisterNotifier(m_data.m_pForegroundBrush);
}

HRESULT CMilImageDrawingDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_IMAGEDRAWING* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->hImageSource != NULL)
    {
        m_data.m_pImageSource =
            static_cast<CMilImageSource*>(pHandleTable->GetResource(
                pCmd->hImageSource,
                TYPE_IMAGESOURCE
                ));

        if (m_data.m_pImageSource == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pImageSource = NULL;
    }

    m_data.m_Rect = pCmd->Rect;
    if (pCmd->hRectAnimations != NULL)
    {
        m_data.m_pRectAnimation =
            static_cast<CMilSlaveRect*>(pHandleTable->GetResource(
                pCmd->hRectAnimations,
                TYPE_RECTRESOURCE
                ));

        if (m_data.m_pRectAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRectAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilImageDrawingDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pImageSource));
    IFC(RegisterNotifier(m_data.m_pRectAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilImageDrawingDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pImageSource);
    UnRegisterNotifier(m_data.m_pRectAnimation);
}

HRESULT CMilVideoDrawingDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_VIDEODRAWING* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->hPlayer != NULL)
    {
        m_data.m_pPlayer =
            static_cast<CMilSlaveVideo*>(pHandleTable->GetResource(
                pCmd->hPlayer,
                TYPE_MEDIAPLAYER
                ));

        if (m_data.m_pPlayer == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pPlayer = NULL;
    }

    m_data.m_Rect = pCmd->Rect;
    if (pCmd->hRectAnimations != NULL)
    {
        m_data.m_pRectAnimation =
            static_cast<CMilSlaveRect*>(pHandleTable->GetResource(
                pCmd->hRectAnimations,
                TYPE_RECTRESOURCE
                ));

        if (m_data.m_pRectAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRectAnimation = NULL;
    }


    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilVideoDrawingDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pPlayer));
    IFC(RegisterNotifier(m_data.m_pRectAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilVideoDrawingDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pPlayer);
    UnRegisterNotifier(m_data.m_pRectAnimation);
}

HRESULT CMilDrawingGroupDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_DRAWINGGROUP* pCmd,
    __in_bcount(cbPayload) LPCVOID pPayload,
    UINT cbPayload
    )
{
    HRESULT hr = S_OK;

    const BYTE* pbDataSection =
        reinterpret_cast<const BYTE*>(pPayload);




    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();

    if (pCmd->hClipGeometry != NULL)
    {
        m_data.m_pClipGeometry =
            static_cast<CMilGeometryDuce*>(pHandleTable->GetResource(
                pCmd->hClipGeometry,
                TYPE_GEOMETRY
                ));

        if (m_data.m_pClipGeometry == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pClipGeometry = NULL;
    }

    m_data.m_Opacity = pCmd->Opacity;
    if (pCmd->hOpacityAnimations != NULL)
    {
        m_data.m_pOpacityAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hOpacityAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pOpacityAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOpacityAnimation = NULL;
    }


    if (pCmd->hOpacityMask != NULL)
    {
        m_data.m_pOpacityMask =
            static_cast<CMilBrushDuce*>(pHandleTable->GetResource(
                pCmd->hOpacityMask,
                TYPE_BRUSH
                ));

        if (m_data.m_pOpacityMask == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pOpacityMask = NULL;
    }


    if (pCmd->hTransform != NULL)
    {
        m_data.m_pTransform =
            static_cast<CMilTransformDuce*>(pHandleTable->GetResource(
                pCmd->hTransform,
                TYPE_TRANSFORM
                ));

        if (m_data.m_pTransform == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pTransform = NULL;
    }


    if (pCmd->hGuidelineSet != NULL)
    {
        m_data.m_pGuidelineSet =
            static_cast<CMilGuidelineSetDuce*>(pHandleTable->GetResource(
                pCmd->hGuidelineSet,
                TYPE_GUIDELINESET
                ));

        if (m_data.m_pGuidelineSet == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pGuidelineSet = NULL;
    }

    m_data.m_EdgeMode = pCmd->EdgeMode;
    m_data.m_bitmapScalingMode = pCmd->bitmapScalingMode;
    m_data.m_ClearTypeHint = pCmd->ClearTypeHint;
    // Read the Children
    // This is for data with handles only; collection field
    // need to do the pointer to handle conversion here.
    IFC(UnmarshalResourceArray(
        IN OUT pbDataSection,
        IN OUT cbPayload,
        pCmd->ChildrenSize,
        TYPE_DRAWING,
        Mt(CMilDrawingGroupDuce),
        OUT m_data.m_cChildren,
        OUT m_data.m_rgpChildren,
        pHandleTable,
        false
        ));

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilDrawingGroupDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNNotifiers(m_data.m_rgpChildren, m_data.m_cChildren));
    IFC(RegisterNotifier(m_data.m_pClipGeometry));
    IFC(RegisterNotifier(m_data.m_pOpacityMask));
    IFC(RegisterNotifier(m_data.m_pTransform));
    IFC(RegisterNotifier(m_data.m_pGuidelineSet));
    IFC(RegisterNotifier(m_data.m_pOpacityAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilDrawingGroupDuce::UnRegisterNotifiers()
{

    if (m_data.m_rgpChildren)
    {
        UnRegisterNNotifiers(m_data.m_rgpChildren, m_data.m_cChildren);
        WPFFree(ProcessHeap, m_data.m_rgpChildren);
        m_data.m_rgpChildren = NULL;
    }
    m_data.m_cChildren = 0;
    UnRegisterNotifier(m_data.m_pClipGeometry);
    UnRegisterNotifier(m_data.m_pOpacityMask);
    UnRegisterNotifier(m_data.m_pTransform);
    UnRegisterNotifier(m_data.m_pGuidelineSet);
    UnRegisterNotifier(m_data.m_pOpacityAnimation);
}

/*override*/ CMilSlaveResource* CMilDrawingGroupDuce::GetResource()
{
    return this;
}

HRESULT CMilGuidelineSetDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_GUIDELINESET* pCmd,
    __in_bcount(cbPayload) LPCVOID pPayload,
    UINT cbPayload
    )
{
    HRESULT hr = S_OK;

    const BYTE* pbDataSection =
        reinterpret_cast<const BYTE*>(pPayload);




    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_IsDynamic = pCmd->IsDynamic;
    // Read the GuidelinesX
    m_data.m_cbGuidelinesXSize = pCmd->GuidelinesXSize;
    if (m_data.m_cbGuidelinesXSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbGuidelinesXSize > cbPayload
            || m_data.m_cbGuidelinesXSize % sizeof(DOUBLE) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilGuidelineSetDuce),
            m_data.m_cbGuidelinesXSize,
            reinterpret_cast<void**>(&m_data.m_pGuidelinesXData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pGuidelinesXData, pbDataSection, m_data.m_cbGuidelinesXSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbGuidelinesXSize;
        pbDataSection += m_data.m_cbGuidelinesXSize;
    }
    // Read the GuidelinesY
    m_data.m_cbGuidelinesYSize = pCmd->GuidelinesYSize;
    if (m_data.m_cbGuidelinesYSize > 0)
    {
        //
        // Check if the manifested size of the payload matches what we have
        // received from the transport. Also, the manifested size should be
        // a multiply of the size of the contained type.
        //

        if (m_data.m_cbGuidelinesYSize > cbPayload
            || m_data.m_cbGuidelinesYSize % sizeof(DOUBLE) != 0)
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }

        // Allocate memory for copy of data
        IFC(HrAlloc(
            Mt(CMilGuidelineSetDuce),
            m_data.m_cbGuidelinesYSize,
            reinterpret_cast<void**>(&m_data.m_pGuidelinesYData)
            ));

        // Copy data
        RtlCopyMemory(m_data.m_pGuidelinesYData, pbDataSection, m_data.m_cbGuidelinesYSize);

        // Advance data pointer and reduce data size
        cbPayload -= m_data.m_cbGuidelinesYSize;
        pbDataSection += m_data.m_cbGuidelinesYSize;
    }

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilGuidelineSetDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;




    RRETURN(hr);
}

/*override*/ void CMilGuidelineSetDuce::UnRegisterNotifiers()
{

    if (m_data.m_pGuidelinesXData)
    {

        WPFFree(ProcessHeap, m_data.m_pGuidelinesXData);
        m_data.m_pGuidelinesXData = NULL;
    }
    m_data.m_cbGuidelinesXSize = 0;

    if (m_data.m_pGuidelinesYData)
    {

        WPFFree(ProcessHeap, m_data.m_pGuidelinesYData);
        m_data.m_pGuidelinesYData = NULL;
    }
    m_data.m_cbGuidelinesYSize = 0;
}

HRESULT CMilBitmapCacheDuce::ProcessUpdate(
    __in_ecount(1) CMilSlaveHandleTable* pHandleTable,
    __in_ecount(1) const MILCMD_BITMAPCACHE* pCmd
    )
{
    HRESULT hr = S_OK;






    // Remove any pre-existing registered resources.
    UnRegisterNotifiers();
    m_data.m_RenderAtScale = pCmd->RenderAtScale;
    if (pCmd->hRenderAtScaleAnimations != NULL)
    {
        m_data.m_pRenderAtScaleAnimation =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->hRenderAtScaleAnimations,
                TYPE_DOUBLERESOURCE
                ));

        if (m_data.m_pRenderAtScaleAnimation == NULL)
        {
            RIP("Invalid handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
    }
    else
    {
        m_data.m_pRenderAtScaleAnimation = NULL;
    }

    m_data.m_SnapsToDevicePixels = pCmd->SnapsToDevicePixels;
    m_data.m_EnableClearType = pCmd->EnableClearType;

    // Register the new resources.
    IFC(RegisterNotifiers(pHandleTable));



Cleanup:
    if (FAILED(hr))
    {
        //
        // We have failed to process the update command. Performing unregistration
        // now guarantees that we leave the resource in a predictable state.
        //

        UnRegisterNotifiers();
    }

    NotifyOnChanged(this);

    RRETURN(hr);
}

HRESULT CMilBitmapCacheDuce::RegisterNotifiers(__in_ecount(1) CMilSlaveHandleTable *pHandleTable)
{
    HRESULT hr = S_OK;

    IFC(RegisterNotifier(m_data.m_pRenderAtScaleAnimation));

Cleanup:

    RRETURN(hr);
}

/*override*/ void CMilBitmapCacheDuce::UnRegisterNotifiers()
{
    UnRegisterNotifier(m_data.m_pRenderAtScaleAnimation);
}
