﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

#nullable disable

using System;
using Microsoft.CodeAnalysis;
using Microsoft.VisualStudio.OLE.Interop;

namespace Microsoft.VisualStudio.LanguageServices.Implementation;

internal abstract partial class AbstractOleCommandTarget
{
    public int QueryStatus(ref Guid pguidCmdGroup, uint commandCount, OLECMD[] prgCmds, IntPtr commandText)
    {
        Contract.ThrowIfFalse(commandCount == 1);
        Contract.ThrowIfFalse(prgCmds.Length == 1);

        // TODO: We'll need to extend the command handler interfaces at some point when we have commands that
        // require enabling/disabling at some point.  For now, we just enable the few that we care about.
        if (pguidCmdGroup == VSConstants.VsStd14)
        {
            return QueryVisualStudio2014Status(ref pguidCmdGroup, commandCount, prgCmds, commandText);
        }
        else
        {
            return NextCommandTarget.QueryStatus(ref pguidCmdGroup, commandCount, prgCmds, commandText);
        }
    }

    private int QueryVisualStudio2014Status(ref Guid pguidCmdGroup, uint commandCount, OLECMD[] prgCmds, IntPtr commandText)
    {
        switch ((VSConstants.VSStd14CmdID)prgCmds[0].cmdID)
        {
            case VSConstants.VSStd14CmdID.SmartBreakLine:
                prgCmds[0].cmdf = (uint)(OLECMDF.OLECMDF_ENABLED | OLECMDF.OLECMDF_SUPPORTED | OLECMDF.OLECMDF_INVISIBLE);
                return VSConstants.S_OK;

            default:
                return NextCommandTarget.QueryStatus(ref pguidCmdGroup, commandCount, prgCmds, commandText);
        }
    }
}
