/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.adl.datamodels.Element;
import org.adl.util.debug.DebugIndicator;

public class DataModelValidator
implements Serializable {
    private static transient Hashtable vocabulary;

    public DataModelValidator() {
        vocabulary = new Hashtable();
        vocabulary.put("Mode", this.buildModeList());
        vocabulary.put("Status", this.buildStatusList());
        vocabulary.put("Exit", this.buildExitList());
        vocabulary.put("Credit", this.buildCreditList());
        vocabulary.put("Entry", this.buildEntryList());
        vocabulary.put("TimeLimitAction", this.buildTimeLimitActionList());
        vocabulary.put("Interaction", this.buildInteractionList());
        vocabulary.put("Result", this.buildResultList());
    }

    private String[] buildModeList() {
        int numItems = 3;
        String[] list = new String[numItems];
        list[0] = "normal";
        list[1] = "review";
        list[2] = "browse";
        return list;
    }

    private String[] buildStatusList() {
        int numItems = 6;
        String[] list = new String[numItems];
        list[0] = "passed";
        list[1] = "completed";
        list[2] = "failed";
        list[3] = "incomplete";
        list[4] = "browsed";
        list[5] = "not attempted";
        return list;
    }

    private String[] buildExitList() {
        int numItems = 4;
        String[] list = new String[numItems];
        list[0] = "";
        list[1] = "time-out";
        list[2] = "suspend";
        list[3] = "logout";
        return list;
    }

    private String[] buildCreditList() {
        int numItems = 2;
        String[] list = new String[numItems];
        list[0] = "credit";
        list[1] = "no-credit";
        return list;
    }

    private String[] buildEntryList() {
        int numItems = 3;
        String[] list = new String[numItems];
        list[0] = "";
        list[1] = "ab-initio";
        list[2] = "resume";
        return list;
    }

    private String[] buildTimeLimitActionList() {
        int numItems = 5;
        String[] list = new String[numItems];
        list[0] = "";
        list[1] = "exit,message";
        list[2] = "exit,no message";
        list[3] = "continue,message";
        list[4] = "continue,no message";
        return list;
    }

    private String[] buildInteractionList() {
        int numItems = 8;
        String[] list = new String[numItems];
        list[0] = "true-false";
        list[1] = "choice";
        list[2] = "fill-in";
        list[3] = "matching";
        list[4] = "performance";
        list[5] = "likert";
        list[6] = "sequencing";
        list[7] = "numeric";
        return list;
    }

    private String[] buildResultList() {
        int numItems = 4;
        String[] list = new String[numItems];
        list[0] = "correct";
        list[1] = "wrong";
        list[2] = "unanticipated";
        list[3] = "neutral";
        return list;
    }

    public boolean checkBlank(Element elementToBeChecked, String value) {
        boolean result = false;
        if (value.length() == 0) {
            result = true;
        }
        return result;
    }

    public boolean checkBoolean(Element elementToBeChecked, String value) {
        boolean flag = false;
        if (value.equals("true") || value.equals("false")) {
            flag = true;
        }
        return flag;
    }

    public boolean checkFeedback(Element elementToBeChecked, String value) {
        return true;
    }

    public boolean checkString255(Element elementToBeChecked, String value) {
        boolean flag = false;
        if (value.length() <= 255) {
            flag = true;
        }
        return flag;
    }

    public boolean checkString4096(Element elementToBeChecked, String value) {
        boolean flag = false;
        if (value.length() <= 4096) {
            flag = true;
        }
        return flag;
    }

    public boolean checkScoreDecimal(Element elementToBeChecked, String value) {
        boolean result;
        block7: {
            result = false;
            Double zero = new Double(0.0);
            Double oneHundred = new Double(100.0);
            if (!this.checkBlank(elementToBeChecked, value)) {
                try {
                    Double tmpDouble = new Double(value);
                    if (tmpDouble.compareTo(zero) >= 0 && tmpDouble.compareTo(oneHundred) <= 0) {
                        result = true;
                    } else if (DebugIndicator.ON) {
                        System.out.println(value + " is not a normalized score");
                        System.out.println("0 <= " + value + " >= 100");
                    }
                    break block7;
                }
                catch (NumberFormatException nfe) {
                    if (DebugIndicator.ON) {
                        System.out.println(value + " is not a valid CMIDecimal Type");
                    }
                    break block7;
                }
            }
            result = true;
        }
        return result;
    }

    public boolean checkDecimal(Element elementToBeChecked, String value) {
        boolean result = false;
        if (!this.checkBlank(elementToBeChecked, value)) {
            try {
                Double tmpDouble = new Double(value);
                result = true;
            }
            catch (NumberFormatException nfe) {
                if (DebugIndicator.ON) {
                    System.out.println(value + " is not a valid CMIDecimal Type ");
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    public boolean checkVocabulary(Element elementToBeChecked, String value) {
        boolean flag = false;
        String vocabType = elementToBeChecked.getVocabularyType();
        String[] theList = (String[])vocabulary.get(vocabType);
        for (int i = 0; i < theList.length; ++i) {
            String tmpString = theList[i];
            if (!tmpString.equals(value)) continue;
            flag = true;
            break;
        }
        if (vocabType.equals("Result") && !flag) {
            flag = this.checkDecimal(elementToBeChecked, value);
        }
        if (!flag && DebugIndicator.ON) {
            System.out.println("[" + value + "] is not a valid vocabulary member ");
            System.out.println("for the " + vocabType + " Vocabulary Type");
        }
        return flag;
    }

    public boolean checkIdentifier(Element elementToBeChecked, String value) {
        boolean flag = false;
        if (value.length() <= 255 && value.indexOf(32) == -1 && !this.checkBlank(elementToBeChecked, value)) {
            flag = true;
        }
        return flag;
    }

    public boolean checkInteger(Element elementToBeChecked, String value) {
        boolean flag;
        block3: {
            flag = false;
            try {
                Integer tmpInt = new Integer(value);
                int theValue = tmpInt;
                if (theValue >= 0 && theValue <= 65536) {
                    flag = true;
                }
            }
            catch (NumberFormatException nfe) {
                if (!DebugIndicator.ON) break block3;
                System.out.println(value + "  has invalid format for an Integer");
            }
        }
        return flag;
    }

    public boolean checkSInteger(Element elementToBeChecked, String value) {
        boolean flag;
        block3: {
            flag = false;
            try {
                Integer tmpInt = new Integer(value);
                int theValue = tmpInt;
                if (theValue >= Short.MIN_VALUE && theValue <= 32768) {
                    flag = true;
                }
            }
            catch (NumberFormatException nfe) {
                if (!DebugIndicator.ON) break block3;
                System.out.println(value + " has invalid format for a Signed Integer");
            }
        }
        return flag;
    }

    public boolean checkTime(Element elementToBeChecked, String value) {
        boolean flag = false;
        StringTokenizer stk = new StringTokenizer(value, ":", false);
        if (stk.countTokens() == 3) {
            String hour = stk.nextToken();
            String minute = stk.nextToken();
            String sec = stk.nextToken();
            if (hour.length() == 2 && minute.length() == 2 && sec.length() <= 5) {
                try {
                    Integer hourAsInt = new Integer(hour);
                    Integer minAsInt = new Integer(minute);
                    if (hourAsInt >= 0 && hourAsInt <= 24 && minAsInt >= 0 && minAsInt <= 60) {
                        flag = true;
                        StringTokenizer secTokenizer = new StringTokenizer(sec, ".", false);
                        int numTok = secTokenizer.countTokens();
                        String secondsPart = secTokenizer.nextToken();
                        if (DebugIndicator.ON) {
                            System.out.println("secondsPart: " + secondsPart);
                        }
                        if (secondsPart.length() == 2) {
                            Double secAsDouble = new Double(secondsPart);
                            flag = true;
                            if (DebugIndicator.ON) {
                                System.out.println("seconds part had 2 chars and a valid decimal");
                            }
                        } else {
                            flag = false;
                            if (DebugIndicator.ON) {
                                System.out.println("Seconds Part did not have 2 chars");
                            }
                        }
                    }
                }
                catch (NumberFormatException nfe) {
                    if (DebugIndicator.ON) {
                        System.out.println("Value could not be converted to a time");
                    }
                    flag = false;
                }
            }
        }
        if (!flag && DebugIndicator.ON) {
            System.out.println("Value being used for setting: " + value + " is not in Valid Time Format (HH:MM:SS.SS)");
        }
        return flag;
    }

    public boolean checkTimespan(Element elementToBeChecked, String value) {
        boolean flag;
        block15: {
            flag = false;
            if (!this.checkBlank(elementToBeChecked, value)) {
                StringTokenizer stk = new StringTokenizer(value, ":", false);
                if (stk.countTokens() == 3) {
                    String hour = stk.nextToken();
                    String minute = stk.nextToken();
                    String sec = stk.nextToken();
                    if (hour.length() >= 2 && hour.length() <= 4 && minute.length() == 2 && sec.length() <= 5) {
                        try {
                            Integer hourAsInt = new Integer(hour);
                            Integer minAsInt = new Integer(minute);
                            if (hourAsInt >= 0 && hourAsInt <= 9999 && minAsInt >= 0 && minAsInt <= 99) {
                                flag = true;
                            }
                            StringTokenizer secTokenizer = new StringTokenizer(sec, ".", false);
                            int numTok = secTokenizer.countTokens();
                            String secondsPart = secTokenizer.nextToken();
                            if (DebugIndicator.ON) {
                                System.out.println("secondsPart: " + secondsPart);
                            }
                            if (secondsPart.length() == 2) {
                                Double secAsDouble = new Double(secondsPart);
                                flag = true;
                                if (DebugIndicator.ON) {
                                    System.out.println("seconds part had 2 chars and a valid decimal");
                                }
                            } else {
                                flag = false;
                                if (DebugIndicator.ON) {
                                    System.out.println("Seconds Part did not have 2 chars");
                                }
                            }
                            if (numTok != 2 || !flag) break block15;
                            String decimalPart = secTokenizer.nextToken();
                            if (decimalPart.length() <= 2) {
                                Double decAsDouble = new Double(decimalPart);
                                flag = true;
                                break block15;
                            }
                            flag = true;
                        }
                        catch (NumberFormatException nfe) {
                            if (DebugIndicator.ON) {
                                System.out.println("Value could not be converted to a time");
                            }
                            flag = false;
                        }
                    }
                }
            } else {
                flag = true;
            }
        }
        if (!flag && DebugIndicator.ON) {
            System.out.println("Value being used for setting: " + value + " is not in Valid Time Format (HHHH:MM:SS.SS)");
        }
        return flag;
    }
}

