/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/name_separators.cpp 
 *
 * @brief [LEVEL: beta] Implementation of @ref
 * diagnostics::unittest::name_adheres_convention, @ref
 * diagnostics::unittest::path_adheres_convention, and @ref
 * diagnostics::unittest::mask_adheres_convention
 *
 * $Id: name_separators.cpp,v 1.5 2005/06/23 09:54:24 esdentem Exp $
 * 
 * @author Christian Schallhart
 */

#include <diagnostics/unittest/name_separators.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

bool name_adheres_convention(::std::string const & name)
{
    if(::std::string::npos!=name.find(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR[0]))
	return false;
    if(::std::string::npos!=name.find(DIAGNOSTICS_UNITTEST_TEST_DATA_NAME_SEPARATOR))
	return false;
    if(::std::string::npos!=name.find(DIAGNOSTICS_UNITTEST_TEST_CASE_ASTERISK[0]))
	return false;
    return true;
}


bool path_adheres_convention(::std::string const & path)
{
    // must begin with a '/' (DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR)
    if(path.find(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR[0])!=0) 
	return false;
    
    // is not allowed to conatain '//' (DIAGNOSTICS_UNITTEST_TEST_DATA_NAME_SEPARATOR)
    if(path.find(DIAGNOSTICS_UNITTEST_TEST_DATA_NAME_SEPARATOR)!= ::std::string::npos)
	return false;

    // is not allowed to conatain '*' (DIAGNOSTICS_UNITTEST_TEST_CASE_ASTERISK)
    if(path.find(DIAGNOSTICS_UNITTEST_TEST_CASE_ASTERISK[0])!= ::std::string::npos)
	return false;

    // is not allowed to end with '/' (DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR)
    if(path.rfind(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR[0])==path.size()-1)
	return false;

    // is not allowed to contain a CASE_SEPERATOR directly followed by another one.
    // at the moment, that's the same as the previous check -- but who knows.... the future.
    //if(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR !=
    // DIAGNOSTICS_UNITTEST_TEST_DATA_NAME_SEPARATOR)
    //    if(path.find(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR 
    //		     DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR)!= ::std::string::npos)
    //return false;

    return true;
}

bool mask_adheres_convention(::std::string const & mask)
{
    // must begin with a '/' (DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR)
    if(mask.find(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR[0])!=0) 
	return false;
    
    // is not allowed to conatain '//' (DIAGNOSTICS_UNITTEST_TEST_DATA_NAME_SEPARATOR)
    if(mask.find(DIAGNOSTICS_UNITTEST_TEST_DATA_NAME_SEPARATOR)!= ::std::string::npos)
	return false;

    ::std::string::size_type const size(mask.size()-1);

    // is not allowed to end with '/' (DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR)
    if(mask.rfind(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR[0])==size)
	return false;

    ::std::string::size_type pos(mask.find(DIAGNOSTICS_UNITTEST_TEST_CASE_ASTERISK[0]));
    for(;pos!= ::std::string::npos ; pos=mask.find(DIAGNOSTICS_UNITTEST_TEST_CASE_ASTERISK[0],pos+1)){
	// it can't be the first string, the
	// DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR must come
	// first
	if(mask[pos-1]!=DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR[0])
	    return false;
	if(pos<size){
	    if(mask[pos+1]!=DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR[0])
		return false;
	}
    }
    

    //// is not allowed to contain a CASE_SEPERATOR directly followed by another one.
    //// at the moment, that's the same as the previous check -- but who knows.... the future.
    //if(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR !=
    //   DIAGNOSTICS_UNITTEST_TEST_DATA_NAME_SEPARATOR)
    //	if(mask.find(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR 
    //		     DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR)!= ::std::string::npos)
    //     return false;
    //

    return true;
}


UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

// vim:ts=4:sw=4
