/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/logger/intending_file_logger.hpp
 *
 * @brief [LEVEL: beta] The @ref diagnostics::Intending_File_Logger class
 *
 * $Id: intending_file_logger.hpp,v 1.4 2005/06/23 09:54:21 esdentem Exp $
 *
 * @test diagnostics/logger/intending_file_logger.t.cpp
 *
 * @author Christian Schallhart
 */
#ifndef DIAGNOSTICS__LOGGER__INTENDING_FILE_LOGGER_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__LOGGER__INTENDING_FILE_LOGGER_HPP__INCLUDE_GUARD

// used as base class
#include <diagnostics/logger/intending_stream_logger.hpp>

// used in the interface by reference
#include <string>

// used in the implementation by value
#include <fstream>

DIAGNOSTICS_NAMESPACE_BEGIN;

/**
 * @class Intending_File_Logger diagnostics/logger/intending_file_logger.hpp
 *
 * @brief logs each @ref Record into a file. The log is intended and
 * stripped (this is a functionality of @ref Stream_Logger).
 *
 * @nosubgrouping
 */
class Intending_File_Logger :
    public Intending_Stream_Logger
{
	////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Types
     * @{
     */
private:
	typedef Intending_File_Logger Self;
	// @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Creation
     * @{
     */
public:
    /** 
     * @brief noop 
     *
     * @throw never
     */
    virtual ~Intending_File_Logger();
    
    /**
     * @brief constructs a logger which opens @a file_name and APPENDS
     * its records into it.
     *
     * @throw Logging_Config_Exception if the file cannot be opened successfully.
     */
    Intending_File_Logger(::std::string const & file_Name);

    /**
     * @brief constructs a logger which opens @a file_name with mode
     * @a mode and writes its records into it.
     *
     * @throw Logging_Config_Exception if the file cannot be opened successfully.
     */
    Intending_File_Logger(::std::string const & file_Name, ::std::ofstream::openmode const mode);

private:
	/**
	 * @brief not available 
	 */
	Self & operator=(Self const & other);
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Overriding of the Implementation of @ref Stream_Logger (@ref Logger Interface)
     * @{
     */
public:
    /**
     * @brief closes the file.
     *
     * @throw never
     */
    virtual void close();
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Encapsulated State
     * @{
     */
private:
    ::std::ofstream m_file_stream;
    // @}
};


DIAGNOSTICS_NAMESPACE_END;

#endif

// vim:ts=4:sw=4
