/*
 * DO NOT EDIT THIS FILE. Generated by checkmk.
 * Edit the original source file "test_clean_lower.template" instead.
 * Run `make internals` from the base of the project to regenerate this file.
 */

#include <check.h>

#line 1 "test_clean_lower.template"
/**
 * This file is part of the Detox package.
 *
 * Copyright (c) Doug Harple <detox.dharple@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

#include <string.h>

// need defines first
#include "config.h"

#include "clean_string.h"

#include "unit_struct.h"

#define DATA_COUNT 4
static struct test_filename data[DATA_COUNT] = {

    // legacy tests

    { .filename = "lower",      .expected = "lower" },
    { .filename = "L0W3R",      .expected = "l0w3r" },
    { .filename = "UPPER",      .expected = "upper" },
    { .filename = "UPPer_2",    .expected = "upper_2" },

};

START_TEST(test_clean_lower)
{
#line 32
    char *output;
    int i;

    for (i = 0; i < DATA_COUNT; i++) {
        output = clean_lower(data[i].filename);
        ck_assert_str_eq(output, data[i].expected);
    }

}
END_TEST

START_TEST(test_clean_lower_null)
{
#line 41
    char *output;

    // confirm NULL works
    output = clean_lower(NULL);
    ck_assert(output == NULL);
}
END_TEST

int main(void)
{
    Suite *s1 = suite_create("Core");
    TCase *tc1_1 = tcase_create("Core");
    SRunner *sr = srunner_create(s1);
    int nf;

    suite_add_tcase(s1, tc1_1);
    tcase_add_test(tc1_1, test_clean_lower);
    tcase_add_test(tc1_1, test_clean_lower_null);

    srunner_run_all(sr, CK_ENV);
    nf = srunner_ntests_failed(sr);
    srunner_free(sr);

    return nf == 0 ? 0 : 1;
}
