;;; skk-tutcdef.el --- SKK TUT-code default definition -*- coding: iso-2022-jp -*-

;; Copyright (C) 1999, 2000 GUNJI Takao <gunji@sils.shoin.ac.jp>

;; Author: GUNJI Takao <gunji@sils.shoin.ac.jp>
;; Maintainer: SKK Development Team <skk@ring.gr.jp>
;; Keywords: japanese, mule, input method

;; This file is part of Daredevil SKK.

;; Daredevil SKK is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; (at your option) any later version.

;; Daredevil SKK is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with Daredevil SKK, see the file COPYING.  If not, write to
;; the Free Software Foundation Inc., 51 Franklin Street, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;;; Commentary:

;;; Code:

(eval-when-compile
  (require 'skk)
  (require 'skk-tutcode))

(define-key skk-j-mode-map "\C-l" 'skk-latin-mode)
(setq skk-try-completion-char ?\016)	; \C-n
;;(setq skk-latin-mode-string " sTUT")
;;(setq skk-hiragana-mode-string " $B#s$?$C$H(B")
;;(setq skk-katakana-mode-string " $B#s%?%C%H(B")
;;(setq skk-jisx0208-latin-mode-string " $B#s#T#U#T(B")
;;(setq skk-abbrev-mode-string " s$B$?(B")
(setq skk-start-henkan-char ?\^@)

(setq skk-rom-kana-base-rule-list
 '(("$" nil skk-tutcode-display-code)
   ("'" nil skk-abbrev-mode)
   ("@" nil skk-today)
   ("L" nil skk-jisx0208-latin-mode)
   ("Q" nil skk-set-henkan-point-subr)
   ("X" nil skk-purge-from-jisyo)
   ("\\" nil skk-tutcode-mode-off)
   ("\t" nil skk-toggle-kana)
   ("^" nil skk-input-by-code-or-menu)
   ("\C-@" nil skk-start-henkan)))

;; (if (and (featurep 'xemacs) (= emacs-major-version 20))
;;     (progn
;;       (setq skk-rom-kana-base-rule-list
;;	    (delete '("\t" nil skk-toggle-kana) skk-rom-kana-base-rule-list))
;;       (define-key skk-j-mode-map "\t" 'skk-toggle-kana)))

;; The first few entries are necessary to disable special treatments of
(setq skk-rom-kana-rule-list
      '(
	("rk" nil ("$B%"(B" . "$B$"(B")) ("rlk" nil ("$B%!(B" . "$B$!(B")) ("ek" nil ("$B%+(B" . "$B$+(B"))
	("elk" nil ("$B%,(B" . "$B$,(B")) ("sk" nil ("$B%5(B" . "$B$5(B")) ("slk" nil ("$B%6(B" . "$B$6(B"))
	("dk" nil ("$B%?(B" . "$B$?(B")) ("dlk" nil ("$B%@(B" . "$B$@(B")) ("fk" nil ("$B%J(B" . "$B$J(B"))
	("tk" nil ("$B%O(B" . "$B$O(B")) ("tlk" nil ("$B%P(B" . "$B$P(B")) ("tltk" nil ("$B%Q(B" . "$B$Q(B"))
	("wk" nil ("$B%^(B" . "$B$^(B")) ("qk" nil ("$B%d(B" . "$B$d(B")) ("qlk" nil ("$B%c(B" . "$B$c(B"))
	("gk" nil ("$B%i(B" . "$B$i(B")) ("ak" nil ("$B%o(B" . "$B$o(B")) ("alk" nil ("$B%n(B" . "$B$n(B"))
	("ri" nil ("$B%$(B" . "$B$$(B")) ("rli" nil ("$B%#(B" . "$B$#(B")) ("ei" nil ("$B%-(B" . "$B$-(B"))
	("eli" nil ("$B%.(B" . "$B$.(B")) ("si" nil ("$B%7(B" . "$B$7(B")) ("sli" nil ("$B%8(B" . "$B$8(B"))
	("di" nil ("$B%A(B" . "$B$A(B")) ("dli" nil ("$B%B(B" . "$B$B(B")) ("fi" nil ("$B%K(B" . "$B$K(B"))
	("ti" nil ("$B%R(B" . "$B$R(B")) ("tli" nil ("$B%S(B" . "$B$S(B")) ("tlti" nil ("$B%T(B" . "$B$T(B"))
	("wi" nil ("$B%_(B" . "$B$_(B")) ("gi" nil ("$B%j(B" . "$B$j(B")) ("ai" nil ("$B%p(B" . "$B$p(B"))
	("ru" nil ("$B%&(B" . "$B$&(B")) ("rlu" nil ("$B%%(B" . "$B$%(B")) ("eu" nil ("$B%/(B" . "$B$/(B"))
	("elu" nil ("$B%0(B" . "$B$0(B")) ("su" nil ("$B%9(B" . "$B$9(B")) ("slu" nil ("$B%:(B" . "$B$:(B"))
	("du" nil ("$B%D(B" . "$B$D(B")) ("dlu" nil ("$B%C(B" . "$B$C(B")) ("dldu" nil ("$B%E(B" . "$B$E(B"))
	("fu" nil ("$B%L(B" . "$B$L(B")) ("tu" nil ("$B%U(B" . "$B$U(B")) ("tlu" nil ("$B%V(B" . "$B$V(B"))
	("tltu" nil ("$B%W(B" . "$B$W(B")) ("wu" nil ("$B%`(B" . "$B$`(B")) ("qu" nil ("$B%f(B" . "$B$f(B"))
	("qlu" nil ("$B%e(B" . "$B$e(B")) ("gu" nil ("$B%k(B" . "$B$k(B"))
	("rh" nil ("$B%((B" . "$B$((B")) ("rlh" nil ("$B%'(B" . "$B$'(B")) ("eh" nil ("$B%1(B" . "$B$1(B"))
	("elh" nil ("$B%2(B" . "$B$2(B")) ("sh" nil ("$B%;(B" . "$B$;(B")) ("slh" nil ("$B%<(B" . "$B$<(B"))
	("dh" nil ("$B%F(B" . "$B$F(B")) ("dlh" nil ("$B%G(B" . "$B$G(B")) ("fh" nil ("$B%M(B" . "$B$M(B"))
	("th" nil ("$B%X(B" . "$B$X(B")) ("tlh" nil ("$B%Y(B" . "$B$Y(B")) ("tlth" nil ("$B%Z(B" . "$B$Z(B"))
	("wh" nil ("$B%a(B" . "$B$a(B")) ("gh" nil ("$B%l(B" . "$B$l(B")) ("ah" nil ("$B%q(B" . "$B$q(B"))
	("rj" nil ("$B%*(B" . "$B$*(B")) ("rlj" nil ("$B%)(B" . "$B$)(B")) ("ej" nil ("$B%3(B" . "$B$3(B"))
	("elj" nil ("$B%4(B" . "$B$4(B")) ("sj" nil ("$B%=(B" . "$B$=(B")) ("slj" nil ("$B%>(B" . "$B$>(B"))
	("dj" nil ("$B%H(B" . "$B$H(B")) ("dlj" nil ("$B%I(B" . "$B$I(B")) ("fj" nil ("$B%N(B" . "$B$N(B"))
	("tj" nil ("$B%[(B" . "$B$[(B")) ("tlj" nil ("$B%\(B" . "$B$\(B")) ("tltj" nil ("$B%](B" . "$B$](B"))
	("wj" nil ("$B%b(B" . "$B$b(B")) ("qj" nil ("$B%h(B" . "$B$h(B")) ("qlj" nil ("$B%g(B" . "$B$g(B"))
	("gj" nil ("$B%m(B" . "$B$m(B")) ("aj" nil ("$B%r(B" . "$B$r(B")) ("fl" nil ("$B%s(B" . "$B$s(B"))
	("rlru" nil "$B%t(B") ("eleh" nil "$B%v(B") ("elek" nil "$B%u(B")
	("f " nil skk-current-kuten) ("d " nil skk-current-touten)
	("/ " nil "$B!?(B")
	("q " nil "$B!H(B") ("w " nil "$B")(B") ("e " nil "$B!<(B")
	("r " nil "$B!J(B") ("u " nil "$B!K(B") ("i " nil "$B!D(B")
	("o " nil "$B!&(B") ("p " nil "$B!I(B") ("a " nil "$B!F(B")
	("s " nil "$B!y(B") ("j " nil "$B!9(B") ("k " nil "$B"((B")
	("l " nil "$B!@(B") ("; " nil "$B!G(B") ("z " nil "$B!:(B")
	("x " nil "$B!x(B") ("c " nil "$B!;(B") ("v " nil "$B!Z(B")
	("m " nil "$B![(B") (", " nil "$B!T(B") (". " nil "$B!U(B")
	("t " nil "$B!V(B") ("y " nil "$B!W(B") ("g " nil "$B!X(B")
	("h " nil "$B!Y(B") ("b " nil "$B"+(B") ("n " nil "$B"*(B")
	("zz" nil "$B;((B") ("xz" nil "$B?d(B") ("cz" nil "$BEO(B")
	("vz" nil "$B8z(B") ("bz" nil "$B1'(B") ("nz" nil "$B?6(B")
	("mz" nil "$B9[(B") (",z" nil "$BI_(B") ("az" nil "$B@1(B")
	("sz" nil "$B5v(B") ("dz" nil "$B39(B") ("fz" nil "$BNk(B")
	("gz" nil "$BDk(B") ("hz" nil "$B@:(B") ("jz" nil "$BM'(B")
	("kz" nil "$B<}(B") ("qz" nil "$BJV(B") ("wz" nil "$B6%(B")
	("ez" nil "$BJl(B") ("rz" nil "$BG.(B") ("tz" nil "$BB`(B")
	("yz" nil "$B4k(B") ("uz" nil "$BI~(B") ("iz" nil "$B9](B")
	(".z" nil "$BM;(B") ("/z" nil "$B1:(B") ("lz" nil "$B;{(B")
	(";z" nil "$BMz(B") ("oz" nil "$BDd(B") ("pz" nil "$B=#(B")
	("zx" nil "$B4)(B") ("xx" nil "$BFA(B") ("cx" nil "$BEP(B")
	("vx" nil "$BNd(B") ("bx" nil "$B6A(B") ("nx" nil "$BDE(B")
	("mx" nil "$BDM(B") (",x" nil "$BHx(B") ("ax" nil "$BB2(B")
	("sx" nil "$B=>(B") ("dx" nil "$BF2(B") ("fx" nil "$BJ<(B")
	("gx" nil "$B4F(B") ("hx" nil "$BIM(B") ("jx" nil "$B8M(B")
	("kx" nil "$BNA(B") ("qx" nil "$B:W(B") ("wx" nil "$BK,(B")
	("ex" nil "$B=t(B") ("rx" nil "$B=$(B") ("tx" nil "$BHG(B")
	("yx" nil "$B0K(B") ("ux" nil "$B=5(B") ("ix" nil "$B3,(B")
	(".x" nil "$BC](B") ("/x" nil "$B@t(B") ("lx" nil "$B2P(B")
	(";x" nil "$B:d(B") ("ox" nil "$BO+(B") ("px" nil "$BHD(B")
	("zc" nil "$B<r(B") ("xc" nil "$B8f(B") ("cc" nil "$B<i(B")
	("vc" nil "$BDx(B") ("bc" nil "$B;K(B") ("nc" nil "$BAp(B")
	("mc" nil "$B>r(B") (",c" nil "$B1I(B") ("ac" nil "$BDB(B")
	("sc" nil "$B@2(B") ("dc" nil "$BFH(B") ("fc" nil "$B4Q(B")
	("gc" nil "$BJQ(B") ("hc" nil "$BFn(B") ("jc" nil "$BC+(B")
	("kc" nil "$BF;(B") ("qc" nil "$BF^(B") ("wc" nil "$BCm(B")
	("ec" nil "$BLH(B") ("rc" nil "$BCc(B") ("tc" nil "$B:r(B")
	("yc" nil "$B2J(B") ("uc" nil "$B20(B") ("ic" nil "$B1G(B")
	(".c" nil "$B8K(B") ("/c" nil "$BGH(B") ("lc" nil "$B6&(B")
	(";c" nil "$B9>(B") ("oc" nil "$B:e(B") ("pc" nil "$B>:(B")
	("nv" nil "$B<G(B") ("mv" nil "$B9,(B") (",v" nil "$B6L(B")
	("hv" nil "$B2#(B") ("jv" nil "$BBf(B") ("kv" nil "$B66(B")
	("yv" nil "$B1{(B") ("uv" nil "$BCS(B") ("iv" nil "$B@)(B")
	(".v" nil "$BMK(B") ("/v" nil "$B4D(B") ("lv" nil "$BIp(B")
	(";v" nil "$BJu(B") ("ov" nil "$B>Z(B") ("pv" nil "$B@u(B")
	("nb" nil "$B4d(B") ("mb" nil "$B>k(B") (",b" nil "$B1J(B")
	("hb" nil "$B73(B") ("jb" nil "$BEZ(B") ("kb" nil "$B?@(B")
	("yb" nil "$B><(B") ("ub" nil "$B5\(B") ("ib" nil "$B?&(B")
	(".b" nil "$B=)(B") ("/b" nil "$BN&(B") ("lb" nil "$BB$(B")
	(";b" nil "$B7](B") ("ob" nil "$BM:(B") ("pb" nil "$B=U(B")
	("ng" nil "$B<!(B") ("mg" nil "$BBp(B") (",g" nil "$BB<(B")
	("hg" nil "$B1_(B") ("jg" nil "$B;M(B") ("kg" nil "$B==(B")
	("yg" nil "$BFb(B") ("ug" nil "$B@i(B") ("ig" nil "$BJ,(B")
	(".g" nil "$B8E(B") ("/g" nil "$BB^(B") ("lg" nil "$BLL(B")
	(";g" nil "$B65(B") ("og" nil "$BN)(B") ("pg" nil "$B30(B")
	("zn" nil "$BIi(B") ("xn" nil "$BG'(B") ("cn" nil "$B0&(B")
	("vn" nil "$BCe(B") ("bn" nil "$B>C(B") ("an" nil "$B=u(B")
	("sn" nil "$B@-(B") ("dn" nil "$BOC(B") ("fn" nil "$B8l(B")
	("gn" nil "$BE@(B") ("qn" nil "$BI,(B") ("wn" nil "$B41(B")
	("en" nil "$B<#(B") ("rn" nil "$B@h(B") ("tn" nil "$B=i(B")
	("zm" nil "$B<:(B") ("xm" nil "$BA[(B") ("cm" nil "$BN.(B")
	("vm" nil "$B8!(B") ("bm" nil "$B:F(B") ("am" nil "$B<L(B")
	("sm" nil "$BJg(B") ("dm" nil "$B:n(B") ("fm" nil "$B8r(B")
	("gm" nil "$B=E(B") ("qm" nil "$B9V(B") ("wm" nil "$BI\(B")
	("em" nil "$BCL(B") ("rm" nil "$B6((B") ("tm" nil "$BH?(B")
	("z," nil "$B5/(B") ("x," nil "$BL?(B") ("c," nil "$B@b(B")
	("v," nil "$BIX(B") ("b," nil "$B8@(B") ("n," nil "$B=p(B")
	("m," nil "$B32(B") (",," nil "$B8D(B") ("a," nil "$B8"(B")
	("s," nil "$BA*(B") ("d," nil "$BGd(B") ("f," nil "$BE9(B")
	("g," nil "$BCK(B") ("h," nil "$B4^(B") ("j," nil "$BJ9(B")
	("k," nil "$B7o(B") ("q," nil "$B;H(B") ("w," nil "$B??(B")
	("e," nil "$B3+(B") ("r," nil "$B7h(B") ("t," nil "$BH~(B")
	("y," nil "$BBb(B") ("u," nil "$BHt(B") ("i," nil "$B9R(B")
	(".," nil "$B4,(B") ("/," nil "$B1+(B") ("l," nil "$B;U(B")
	(";," nil "$BDc(B") ("o," nil "$B4s(B") ("p," nil "$BK~(B")
	("za" nil "$BAU(B") ("xa" nil "$B<((B") ("ca" nil "$B;y(B")
	("va" nil "$B;V(B") ("ba" nil "$BL$(B") ("na" nil "$B8&(B")
	("ma" nil "$BMU(B") (",a" nil "$BAR(B") ("aa" nil "$B?<(B")
	("sa" nil "$B4I(B") ("da" nil "$B6P(B") ("fa" nil "$BA}(B")
	("ga" nil "$B=,(B") ("ha" nil "$BF#(B") ("ja" nil "$BIU(B")
	("ka" nil "$B7P(B") ("qa" nil "$BG0(B") ("wa" nil "$B1&(B")
	("ea" nil "$B;D(B") ("ra" nil "$B@V(B") ("ta" nil "$B7A(B")
	("ya" nil "$B6x(B") ("ua" nil "$B0f(B") ("ia" nil "$BEg(B")
	(".a" nil "$BI)(B") ("/a" nil "$BMa(B") ("la" nil "$B@5(B")
	(";a" nil "$B>^(B") ("oa" nil "$B;N(B") ("pa" nil "$BDZ(B")
	("zs" nil "$B0e(B") ("xs" nil "$BC1(B") ("cs" nil "$BB_(B")
	("vs" nil "$BDI(B") ("bs" nil "$B5s(B") ("ns" nil "$B4](B")
	("ms" nil "$BB4(B") (",s" nil "$BD+(B") ("as" nil "$BKh(B")
	("ss" nil "$BJ!(B") ("ds" nil "$BB>(B") ("fs" nil "$BJF(B")
	("gs" nil "$BMx(B") ("hs" nil "$BBe(B") ("js" nil "$B7n(B")
	("ks" nil "$BED(B") ("qs" nil "$B@G(B") ("ws" nil "$B<A(B")
	("es" nil "$BCD(B") ("rs" nil "$B;2(B") ("ts" nil "$B4p(B")
	("ys" nil "$B5!(B") ("us" nil "$BLn(B") ("is" nil "$BA0(B")
	(".s" nil "$BG@(B") ("/s" nil "$B2/(B") ("ls" nil "$B8e(B")
	(";s" nil "$B>&(B") ("os" nil "$BI4(B") ("ps" nil "$B@\(B")
	("zd" nil "$BI>(B") ("xd" nil "$BDm(B") ("cd" nil "$B2~(B")
	("vd" nil "$BLr(B") ("bd" nil "$B2V(B") ("nd" nil "$B5^(B")
	("md" nil "$B3$(B") (",d" nil "$B;T(B") ("ad" nil "$BLs(B")
	("sd" nil "$BM-(B") ("dd" nil "$BA4(B") ("fd" nil "$B<+(B")
	("gd" nil "$B=;(B") ("hd" nil "$BEl(B") ("jd" nil "$BFs(B")
	("kd" nil "$BF|(B") ("qd" nil "$B9u(B") ("wd" nil "$B;q(B")
	("ed" nil "$B?t(B") ("rd" nil "$BIJ(B") ("td" nil "$B:B(B")
	("yd" nil "$B3X(B") ("ud" nil "$BK\(B") ("id" nil "$BBg(B")
	(".d" nil "$B;Y(B") ("/d" nil "$B?9(B") ("ld" nil "$B;~(B")
	(";d" nil "$BIT(B") ("od" nil "$BO;(B") ("pd" nil "$B3t(B")
	("zf" nil "$BF$(B") ("xf" nil "$B6q(B") ("cf" nil "$BKI(B")
	("vf" nil "$BAG(B") ("bf" nil "$B2p(B") ("nf" nil "$B8w(B")
	("mf" nil "$BO:(B") (",f" nil "$BJ8(B") ("af" nil "$BD>(B")
	("sf" nil "$BAw(B") ("df" nil "$BJ](B") ("ff" nil "$B@$(B")
	("gf" nil "$B8=(B") ("hf" nil "$B?7(B") ("jf" nil "$BG/(B")
	("kf" nil "$B0l(B") ("qf" nil "$B7Y(B") ("wf" nil "$BBw(B")
	("ef" nil "$B8x(B") ("rf" nil "$B:Y(B") ("tf" nil "$BHq(B")
	("yf" nil "$B9)(B") ("uf" nil "$B;v(B") ("if" nil "$BCf(B")
	(".f" nil "$BBt(B") ("/f" nil "$BGO(B") ("lf" nil "$BF1(B")
	(";f" nil "$BJb(B") ("of" nil "$B6e(B") ("pf" nil "$B8a(B")
	("zh" nil "$BH=(B") ("xh" nil "$BEj(B") ("ch" nil "$B@o(B")
	("vh" nil "$BAH(B") ("bh" nil "$BB?(B") ("qh" nil "$B<g(B")
	("zj" nil "$B:v(B") ("xj" nil "$BHw(B") ("cj" nil "$BEv(B")
	("vj" nil "$BMh(B") ("bj" nil "$B6/(B") ("nj" nil "$BNI(B")
	("mj" nil "$BMM(B") (",j" nil "$B>J(B") ("hj" nil "$BNO(B")
	("jj" nil "$B83(B") ("kj" nil "$B4V(B") ("yj" nil "$B>!(B")
	("uj" nil "$B;a(B") ("ij" nil "$B2h(B") (".j" nil "$B7?(B")
	("/j" nil "$B8N(B") ("lj" nil "$B@_(B") (";j" nil "$B9f(B")
	("oj" nil "$B?4(B") ("pj" nil "$BHN(B")
	("zk" nil "$B<c(B") ("xk" nil "$B5-(B") ("ck" nil "$B0Q(B")
	("vk" nil "$BF~(B") ("bk" nil "$B<B(B") ("nk" nil "$BO@(B")
	("mk" nil "$BCM(B") (",k" nil "$BO)(B") ("hk" nil "$B2=(B")
	("jk" nil "$B2<(B") ("kk" nil "$B2s(B") ("yk" nil "$B:P(B")
	("uk" nil "$BEY(B") ("ik" nil "$B9;(B") (".k" nil "$BAu(B")
	("/k" nil "$BF/(B") ("lk" nil "$BNr(B") (";k" nil "$B78(B")
	("ok" nil "$B6d(B") ("pk" nil "$BE>(B")
	("zq" nil "$B?-(B") ("xq" nil "$B1)(B") ("cq" nil "$B@E(B")
	("vq" nil "$B:b(B") ("bq" nil "$B;O(B") ("nq" nil "$B2O(B")
	("mq" nil "$B1[(B") (",q" nil "$BE}(B") ("aq" nil "$B0-(B")
	("sq" nil "$BIB(B") ("dq" nil "$BAa(B") ("fq" nil "$B;e(B")
	("gq" nil "$B;n(B") ("hq" nil "$B>>(B") ("jq" nil "$B0B(B")
	("kq" nil "$BET(B") ("qq" nil "$BJB(B") ("wq" nil "$BBV(B")
	("eq" nil "$BN>(B") ("rq" nil "$B>h(B") ("tq" nil "$B@l(B")
	("yq" nil "$B6=(B") ("uq" nil "$B8}(B") ("iq" nil "$BMN(B")
	(".q" nil "$B=((B") ("/q" nil "$BL}(B") ("lq" nil "$BM?(B")
	(";q" nil "$B@6(B") ("oq" nil "$BA%(B") ("pq" nil "$B5W(B")
	("zw" nil "$BN"(B") ("xw" nil "$BC;(B") ("cw" nil "$B2?(B")
	("vw" nil "$B@Q(B") ("bw" nil "$B7^(B") ("nw" nil "$B85(B")
	("mw" nil "$BB"(B") (",w" nil "$B8)(B") ("aw" nil "$B:,(B")
	("sw" nil "$B;E(B") ("dw" nil "$BL5(B") ("fw" nil "$B0F(B")
	("gw" nil "$B3[(B") ("hw" nil "$BF0(B") ("jw" nil "$B@n(B")
	("kw" nil "$B5k(B") ("qw" nil "$BEA(B") ("ww" nil "$B7r(B")
	("ew" nil "$BBT(B") ("rw" nil "$BGr(B") ("tw" nil "$B9A(B")
	("yw" nil "$B?e(B") ("uw" nil "$B;:(B") ("iw" nil "$BL3(B")
	(".w" nil "$BC[(B") ("/w" nil "$B3Q(B") ("lw" nil "$BLZ(B")
	(";w" nil "$B:4(B") ("ow" nil "$B1X(B") ("pw" nil "$BF,(B")
	("ze" nil "$BN`(B") ("xe" nil "$BHs(B") ("ce" nil "$BJd(B")
	("ve" nil "$B7Z(B") ("be" nil "$BN((B") ("ne" nil "$B:j(B")
	("me" nil "$B=I(B") (",e" nil "$B2D(B") ("ae" nil "$BE7(B")
	("se" nil "$B:#(B") ("de" nil "$B3F(B") ("fe" nil "$B4X(B")
	("ge" nil "$B1?(B") ("he" nil "$B9b(B") ("je" nil "$B9q(B")
	("ke" nil "$B;0(B") ("qe" nil "$B@D(B") ("we" nil "$B3h(B")
	("ee" nil "$B7k(B") ("re" nil "$BM%(B") ("te" nil "$B:G(B")
	("ye" nil "$B6b(B") ("ue" nil "$BCO(B") ("ie" nil "$BK|(B")
	(".e" nil "$B<<(B") ("/e" nil "$B=B(B") ("le" nil "$BH,(B")
	(";e" nil "$BKL(B") ("oe" nil "$B7z(B") ("pe" nil "$BE4(B")
	("zr" nil "$BI|(B") ("xr" nil "$BM7(B") ("cr" nil "$B;\(B")
	("vr" nil "$B5"(B") ("br" nil "$BJX(B") ("nr" nil "$BH>(B")
	("mr" nil "$B2,(B") (",r" nil "$B@P(B") ("ar" nil "$BN@(B")
	("sr" nil "$B9-(B") ("dr" nil "$BJ?(B") ("fr" nil "$B2;(B")
	("gr" nil "$B7W(B") ("hr" nil "$B;3(B") ("jr" nil "$BEE(B")
	("kr" nil "$B8^(B") ("qr" nil "$B@0(B") ("wr" nil "$B>/(B")
	("er" nil "$B?.(B") ("rr" nil "$BJs(B") ("tr" nil "$BB@(B")
	("yr" nil "$BD.(B") ("ur" nil "$B<7(B") ("ir" nil "$B5~(B")
	(".r" nil "$B5Y(B") ("/r" nil "$BK-(B") ("lr" nil "$B>.(B")
	(";r" nil "$B86(B") ("or" nil "$BM}(B") ("pr" nil "$B1D(B")
	("nt" nil "$BNS(B") ("mt" nil "$BLg(B") (",t" nil "$B3J(B")
	("ht" nil "$BL>(B") ("jt" nil "$BIt(B") ("kt" nil "$B6H(B")
	("yt" nil "$BBh(B") ("ut" nil "$BOB(B") ("it" nil "$B6h(B")
	(".t" nil "$B5H(B") ("/t" nil "$BNp(B") ("lt" nil "$BLd(B")
	(";t" nil "$B6a(B") ("ot" nil "$B@>(B") ("pt" nil "$BIY(B")
	("zy" nil "$BMn(B") ("xy" nil "$B>p(B") ("cy" nil "$B;d(B")
	("vy" nil "$B<h(B") ("by" nil "$BJL(B") ("ay" nil "$B=q(B")
	("sy" nil "$B>l(B") ("dy" nil "$B2q(B") ("fy" nil "$B>e(B")
	("gy" nil "$BDL(B") ("qy" nil "$B?)(B") ("wy" nil "$B;}(B")
	("ey" nil "$B;R(B") ("ry" nil "$B=P(B") ("ty" nil "$B9T(B")
	("zu" nil "$B9%(B") ("xu" nil "$B4[(B") ("cu" nil "$BD4(B")
	("vu" nil "$BCN(B") ("bu" nil "$B@Z(B") ("nu" nil "$BD#(B")
	("mu" nil "$BG7(B") (",u" nil "$BN9(B") ("au" nil "$BL\(B")
	("hu" nil "$B@=(B") ("ju" nil "$B<o(B") ("ku" nil "$BMQ(B")
	("yu" nil "$B3d(B") ("uu" nil "$B5Z(B") ("iu" nil "$B3Z(B")
	(".u" nil "$BCg(B") ("/u" nil "$B6K(B") ("lu" nil "$B3&(B")
	(";u" nil "$BMF(B") ("ou" nil "$B1`(B") ("pu" nil "$B=*(B")
	("zi" nil "$B4o(B") ("xi" nil "$B?J(B") ("ci" nil "$BBP(B")
	("vi" nil "$BMW(B") ("bi" nil "$B0U(B") ("ni" nil "$BA3(B")
	("mi" nil "$BCG(B") (",i" nil "$B81(B") ("hi" nil "$BO"(B")
	("ji" nil "$B<V(B") ("ki" nil "$B0J(B") ("qi" nil "$BAj(B")
	("yi" nil "$BL1(B") ("ui" nil "$BI=(B") ("ii" nil "$BIW(B")
	(".i" nil "$B9=(B") ("/i" nil "$BM9(B") ("li" nil "$B40(B")
	(";i" nil "$B5;(B") ("oi" nil "$B2C(B") ("pi" nil "$BG=(B")
	("z." nil "$BH4(B") ("x." nil "$BF3(B") ("c." nil "$B@J(B")
	("v." nil "$BO?(B") ("b." nil "$BD%(B") ("n." nil "$B2Z(B")
	("m." nil "$BNL(B") (",." nil "$B;k(B") ("a." nil "$B?=(B")
	("s." nil "$BIw(B") ("d." nil "$BBG(B") ("f." nil "$B2A(B")
	("g." nil "$B9~(B") ("h." nil "$BHf(B") ("j." nil "$B;_(B")
	("k." nil "$B?3(B") ("q." nil "$B:8(B") ("w." nil "$B;;(B")
	("e." nil "$B;X(B") ("r." nil "$B8~(B") ("t." nil "$BJ|(B")
	("y." nil "$B8:(B") ("u." nil "$BM[(B") ("i." nil "$BJ'(B")
	(".." nil "$BH`(B") ("/." nil "$B:M(B") ("l." nil "$B;&(B")
	(";." nil "$BNc(B") ("o." nil "$B4i(B") ("p." nil "$BIa(B")
	("z/" nil "$B0c(B") ("x/" nil "$B@<(B") ("c/" nil "$BDs(B")
	("v/" nil "$BEz(B") ("b/" nil "$B2a(B") ("n/" nil "$B8|(B")
	("m/" nil "$BFD(B") (",/" nil "$BN}(B") ("a/" nil "$B3N(B")
	("s/" nil "$BB-(B") ("d/" nil "$B9M(B") ("f/" nil "$BK>(B")
	("g/" nil "$B5,(B") ("h/" nil "$B=`(B") ("j/" nil "$BFq(B")
	("k/" nil "$B:[(B") ("q/" nil "$BE8(B") ("w/" nil "$BF@(B")
	("e/" nil "$B;`(B") ("r/" nil "$BM"(B") ("t/" nil "$BL#(B")
	("y/" nil "$BCz(B") ("u/" nil "$BA1(B") ("i/" nil "$B:`(B")
	("./" nil "$B67(B") ("//" nil "$B7J(B") ("l/" nil "$BE,(B")
	(";/" nil "$B?^(B") ("o/" nil "$B:9(B") ("p/" nil "$B@v(B")
	("zl" nil "$BG$(B") ("xl" nil "$B0z(B") ("cl" nil "$BE^(B")
	("vl" nil "$B<u(B") ("bl" nil "$B;W(B") ("nl" nil "$BHL(B")
	("ml" nil "$BJT(B") (",l" nil "$B0u(B") ("gl" nil "$B<R(B")
	("hl" nil "$BLk(B") ("jl" nil "$BJ*(B") ("kl" nil "$B=j(B")
	("wl" nil "$B8+(B") ("yl" nil "$B;f(B") ("ul" nil "$B1Q(B")
	("il" nil "$BBj(B") (".l" nil "$BGT(B") ("/l" nil "$B<x(B")
	("ll" nil "$B:](B") (";l" nil "$BB&(B") ("ol" nil "$B9p(B")
	("pl" nil "$B@*(B") ("z;" nil "$BCV(B") ("x;" nil "$BAh(B")
	("c;" nil "$B5A(B") ("v;" nil "$B::(B") ("b;" nil "$BGI(B")
	("n;" nil "$BKv(B") ("m;" nil "$BN](B") (",;" nil "$B>u(B")
	("a;" nil "$B2N(B") ("s;" nil "$BL@(B") ("d;" nil "$BD9(B")
	("f;" nil "$BJ}(B") ("g;" nil "$B@/(B") ("h;" nil "$B0L(B")
	("j;" nil "$B:_(B") ("k;" nil "$B<0(B") ("q;" nil "$B6u(B")
	("w;" nil "$B@~(B") ("e;" nil "$B9g(B") ("r;" nil "$B2H(B")
	("t;" nil "$B=8(B") ("y;" nil "$B2&(B") ("u;" nil "$B1R(B")
	("i;" nil "$B7`(B") (".;" nil "$BB((B") ("/;" nil "$BJU(B")
	("l;" nil "$B:Q(B") (";;" nil "$B5f(B") ("o;" nil "$B?F(B")
	("p;" nil "$BGz(B") ("zo" nil "$BFI(B") ("xo" nil "$B5a(B")
	("co" nil "$B1i(B") ("vo" nil "$B=Q(B") ("bo" nil "$B?H(B")
	("no" nil "$B;z(B") ("mo" nil "$BM\(B") (",o" nil "$B7b(B")
	("ao" nil "$B4|(B") ("so" nil "$BH/(B") ("do" nil "$B?M(B")
	("fo" nil "$B0w(B") ("go" nil "$B@8(B") ("ho" nil "$BM3(B")
	("jo" nil "$B6I(B") ("ko" nil "$BBN(B") ("qo" nil "$B2r(B")
	("wo" nil "$B5$(B") ("eo" nil "$B<T(B") ("ro" nil "$B<j(B")
	("to" nil "$BE*(B") ("yo" nil "$B5e(B") ("uo" nil "$B1!(B")
	("io" nil "$BHV(B") (".o" nil "$B;J(B") ("/o" nil "$B5o(B")
	("lo" nil "$BLt(B") (";o" nil "$BCJ(B") ("oo" nil "$B>o(B")
	("po" nil "$BNN(B") ("zp" nil "$BC#(B") ("xp" nil "$B8B(B")
	("cp" nil "$B1~(B") ("vp" nil "$BGc(B") ("bp" nil "$B46(B")
	("np" nil "$B3U(B") ("mp" nil "$BC4(B") (",p" nil "$B>-(B")
	("ap" nil "$BB3(B") ("sp" nil "$BAm(B") ("dp" nil "$BDj(B")
	("fp" nil "$B=w(B") ("gp" nil "$B@.(B") ("hp" nil "$B5i(B")
	("jp" nil "$B2](B") ("kp" nil "$B0i(B") ("qp" nil "$BG[(B")
	("wp" nil "$BM=(B") ("ep" nil "$B5D(B") ("rp" nil "$BFC(B")
	("tp" nil "$BK!(B") ("yp" nil "$B2L(B") ("up" nil "$BEy(B")
	("ip" nil "$B<s(B") (".p" nil "$B3#(B") ("/p" nil "$B8n(B")
	("lp" nil "$B?'(B") (";p" nil "$B5p(B") ("op" nil "$BLS(B")
	("pp" nil "$B7t(B")
	("nnz" nil "$BK2(B") ("mnz" nil "$B4<(B") (",nz" nil "$B;>(B")
	("hnz" nil "$B:7(B") ("jnz" nil "$BMZ(B") ("knz" nil "$B3/(B")
	("ynz" nil "$B5x(B") ("unz" nil "$B:@(B") ("inz" nil "$BKV(B")
	(".nz" nil "$BEF(B") ("/nz" nil "$B3p(B") ("lnz" nil "$B84(B")
	(";nz" nil "$BA'(B") ("onz" nil "$B;9(B") ("pnz" nil "$BBO(B")
	("nmz" nil "$BDY(B") ("mmz" nil "$B8'(B") (",mz" nil "$B<5(B")
	("hmz" nil "$BMV(B") ("jmz" nil "$B:s(B") ("kmz" nil "$B0+(B")
	("ymz" nil "$B9[(B") ("umz" nil "$B<6(B") ("imz" nil "$B1e(B")
	(".mz" nil "$BD5(B") ("/mz" nil "$B@H(B") ("lmz" nil "$BFf(B")
	(";mz" nil "$B:|(B") ("omz" nil "$BI*(B") ("pmz" nil "$BKs(B")
	("nnx" nil "$BC((B") ("mnx" nil "$BB|(B") (",nx" nil "$B0q(B")
	("hnx" nil "$B8{(B") ("jnx" nil "$BHZ(B") ("knx" nil "$BJ0(B")
	("ynx" nil "$B2e(B") ("unx" nil "$BNg(B") ("inx" nil "$B7T(B")
	(".nx" nil "$BCP(B") ("/nx" nil "$B3k(B") ("lnx" nil "$BME(B")
	(";nx" nil "$B7d(B") ("onx" nil "$B7X(B") ("pnx" nil "$B4;(B")
	("nmx" nil "$BC7(B") ("mmx" nil "$BCI(B") (",mx" nil "$B?A(B")
	("hmx" nil "$B9i(B") ("jmx" nil "$B:H(B") ("kmx" nil "$B26(B")
	("ymx" nil "$BNb(B") ("umx" nil "$BK1(B") ("imx" nil "$B0k(B")
	(".mx" nil "$B2W(B") ("/mx" nil "$BL'(B") ("lmx" nil "$B<t(B")
	(";mx" nil "$B0'(B") ("omx" nil "$BO<(B") ("pmx" nil "$BCA(B")
	("nnc" nil "$B0n(B") ("mnc" nil "$BH|(B") (",nc" nil "$BAt(B")
	("hnc" nil "$B<8(B") ("jnc" nil "$B;.(B") ("knc" nil "$BNe(B")
	("ync" nil "$B='(B") ("unc" nil "$B6s(B") ("inc" nil "$B;G(B")
	(".nc" nil "$B6{(B") ("/nc" nil "$BOP(B") ("lnc" nil "$BCo(B")
	(";nc" nil "$B3E(B") ("onc" nil "$BE#(B") ("pnc" nil "$BC.(B")
	("nmc" nil "$B1*(B") ("mmc" nil "$BL_(B") (",mc" nil "$BAt(B")
	("hmc" nil "$BO5(B") ("jmc" nil "$B5T(B") ("kmc" nil "$BN^(B")
	("ymc" nil "$BLl(B") ("umc" nil "$B?n(B") ("imc" nil "$B50(B")
	(".mc" nil "$BD!(B") ("/mc" nil "$BGm(B") ("lmc" nil "$B>Y(B")
	(";mc" nil "$BH%(B") ("omc" nil "$BJr(B") ("pmc" nil "$B5b(B")
	("nnv" nil "$BA#(B") ("mnv" nil "$B3?(B") (",nv" nil "$BO=(B")
	("hnv" nil "$B:+(B") ("jnv" nil "$BL7(B") ("knv" nil "$B;4(B")
	("ynv" nil "$B0`(B") ("unv" nil "$B6F(B") ("inv" nil "$B:((B")
	(".nv" nil "$BKx(B") ("/nv" nil "$B37(B") ("lnv" nil "$B6_(B")
	(";nv" nil "$BFR(B") ("onv" nil "$BLM(B") ("pnv" nil "$BNG(B")
	("nmv" nil "$B:z(B") ("mmv" nil "$BGh(B") (",mv" nil "$BLR(B")
	("hmv" nil "$B=%(B") ("jmv" nil "$B2%(B") ("kmv" nil "$B0.(B")
	("ymv" nil "$B6:(B") ("umv" nil "$BMu(B") ("imv" nil "$BKz(B")
	(".mv" nil "$B@L(B") ("/mv" nil "$B8o(B") ("lmv" nil "$BAE(B")
	(";mv" nil "$B06(B") ("omv" nil "$B:{(B") ("pmv" nil "$B2d(B")
	("nnb" nil "$BOI(B") ("mnb" nil "$BJ5(B") (",nb" nil "$B4/(B")
	("hnb" nil "$BIy(B") ("jnb" nil "$B>i(B") ("knb" nil "$B7((B")
	("ynb" nil "$B0`(B") ("unb" nil "$BDp(B") ("inb" nil "$B=9(B")
	(".nb" nil "$B09(B") ("/nb" nil "$B9e(B") ("lnb" nil "$BGF(B")
	(";nb" nil "$B:f(B") ("onb" nil "$BGs(B") ("pnb" nil "$BI((B")
	("nmb" nil "$B>s(B") ("mmb" nil "$B;S(B") (",mb" nil "$BJN(B")
	("hmb" nil "$B>|(B") ("jmb" nil "$BBF(B") ("kmb" nil "$BMv(B")
	("ymb" nil "$BDU(B") ("umb" nil "$BAI(B") ("imb" nil "$BF](B")
	(".mb" nil "$BLy(B") ("/mb" nil "$BN?(B") ("lmb" nil "$B=^(B")
	(";mb" nil "$B3G(B") ("omb" nil "$BJc(B") ("pmb" nil "$BKJ(B")
	("nna" nil "$B7S(B") ("mna" nil "$BFV(B") (",na" nil "$B3e(B")
	("hna" nil "$B2"(B") ("jna" nil "$BD3(B") ("kna" nil "$B>2(B")
	("yna" nil "$BCd(B") ("una" nil "$BEo(B") ("ina" nil "$BGZ(B")
	(".na" nil "$B8A(B") ("/na" nil "$B1((B") ("lna" nil "$BMG(B")
	(";na" nil "$B?!(B") ("ona" nil "$BAZ(B") ("pna" nil "$BM|(B")
	("nma" nil "$BFS(B") ("mma" nil "$B<D(B") (",ma" nil "$BK_(B")
	("hma" nil "$B1q(B") ("jma" nil "$BF9(B") ("kma" nil "$B?{(B")
	("yma" nil "$B0^(B") ("uma" nil "$B33(B") ("ima" nil "$B4v(B")
	(".ma" nil "$BK((B") ("/ma" nil "$B;F(B") ("lma" nil "$BG"(B")
	(";ma" nil "$B0/(B") ("oma" nil "$B=3(B") ("pma" nil "$B?U(B")
	("nns" nil "$BL((B") ("mns" nil "$BKl(B") (",ns" nil "$B:A(B")
	("hns" nil "$B3V(B") ("jns" nil "$BJt(B") ("kns" nil "$BIb(B")
	("yns" nil "$BL;(B") ("uns" nil "$B4@(B") ("ins" nil "$BD@(B")
	(".ns" nil "$BKu(B") ("/ns" nil "$BN6(B") ("lns" nil "$BM+(B")
	(";ns" nil "$BKD(B") ("ons" nil "$BBD(B") ("pns" nil "$B52(B")
	("nms" nil "$BM/(B") ("mms" nil "$B0>(B") (",ms" nil "$BH6(B")
	("hms" nil "$BMH(B") ("jms" nil "$BBn(B") ("kms" nil "$B:\(B")
	("yms" nil "$BB/(B") ("ums" nil "$BG%(B") ("ims" nil "$B02(B")
	(".ms" nil "$B0~(B") ("/ms" nil "$BOA(B") ("lms" nil "$B:)(B")
	(";ms" nil "$BF7(B") ("oms" nil "$B<>(B") ("pms" nil "$B0m(B")
	("nnd" nil "$B6^(B") ("mnd" nil "$BID(B") (",nd" nil "$BM!(B")
	("hnd" nil "$B42(B") ("jnd" nil "$BJk(B") ("knd" nil "$BJR(B")
	("ynd" nil "$BGC(B") ("und" nil "$B<q(B") ("ind" nil "$BD'(B")
	(".nd" nil "$BNT(B") ("/nd" nil "$B2n(B") ("lnd" nil "$BN'(B")
	(";nd" nil "$BJ6(B") ("ond" nil "$BM@(B") ("pnd" nil "$B4>(B")
	("nmd" nil "$B:>(B") ("mmd" nil "$BKQ(B") (",md" nil "$B?x(B")
	("hmd" nil "$B4T(B") ("jmd" nil "$BHa(B") ("kmd" nil "$B4m(B")
	("ymd" nil "$B>b(B") ("umd" nil "$BK;(B") ("imd" nil "$B7K(B")
	(".md" nil "$B=v(B") ("/md" nil "$B=Y(B") ("lmd" nil "$BLv(B")
	(";md" nil "$B=C(B") ("omd" nil "$BKa(B") ("pmd" nil "$B2^(B")
	("nnf" nil "$B0<(B") ("mnf" nil "$BC*(B") (",nf" nil "$B?#(B")
	("hnf" nil "$BL2(B") ("jnf" nil "$B55(B") ("knf" nil "$B<e(B")
	("ynf" nil "$BGY(B") ("unf" nil "$B5c(B") ("inf" nil "$BBa(B")
	(".nf" nil "$B1/(B") ("/nf" nil "$B<$(B") ("lnf" nil "$B=1(B")
	(";nf" nil "$B4((B") ("onf" nil "$BKF(B") ("pnf" nil "$B<Y(B")
	("nmf" nil "$BL.(B") ("mmf" nil "$BG{(B") (",mf" nil "$B7+(B")
	("hmf" nil "$B7x(B") ("jmf" nil "$B8%(B") ("kmf" nil "$B8p(B")
	("ymf" nil "$BBk(B") ("umf" nil "$BD{(B") ("imf" nil "$BDo(B")
	(".mf" nil "$BH^(B") ("/mf" nil "$BLh(B") ("lmf" nil "$B7g(B")
	(";mf" nil "$BN/(B") ("omf" nil "$B=@(B") ("pmf" nil "$BD[(B")
	("nng" nil "$B?p(B") ("mng" nil "$B1p(B") (",ng" nil "$BN3(B")
	("hng" nil "$B>)(B") ("jng" nil "$B3((B") ("kng" nil "$BM&(B")
	("yng" nil "$B4:(B") ("ung" nil "$BC{(B") ("ing" nil "$BG&(B")
	(".ng" nil "$B=T(B") ("/ng" nil "$BK+(B") ("lng" nil "$BD`(B")
	(";ng" nil "$B4$(B") ("ong" nil "$BBz(B") ("png" nil "$BK6(B")
	("nmg" nil "$BA@(B") ("mmg" nil "$BBW(B") (",mg" nil "$B8k(B")
	("hmg" nil "$BG:(B") ("jmg" nil "$BF8(B") ("kmg" nil "$BBX(B")
	("ymg" nil "$BJm(B") ("umg" nil "$B5=(B") ("img" nil "$B4~(B")
	(".mg" nil "$BL{(B") ("/mg" nil "$B8H(B") ("lmg" nil "$BFJ(B")
	(";mg" nil "$B?;(B") ("omg" nil "$BIe(B") ("pmg" nil "$BA8(B")
	("nnq" nil "$BL^(B") ("mnq" nil "$BIl(B") (",nq" nil "$BAo(B")
	("hnq" nil "$B6T(B") ("jnq" nil "$B21(B") ("knq" nil "$B2E(B")
	("ynq" nil "$BOD(B") ("unq" nil "$B1=(B") ("inq" nil "$B<4(B")
	(".nq" nil "$BK#(B") ("/nq" nil "$B<J(B") ("lnq" nil "$B58(B")
	(";nq" nil "$B3>(B") ("onq" nil "$B9"(B") ("pnq" nil "$B0;(B")
	("nmq" nil "$B>*(B") ("mmq" nil "$BDv(B") (",mq" nil "$B<`(B")
	("hmq" nil "$B<P(B") ("jmq" nil "$BKm(B") ("kmq" nil "$BCB(B")
	("ymq" nil "$B8T(B") ("umq" nil "$B?E(B") ("imq" nil "$B82(B")
	(".mq" nil "$B24(B") ("/mq" nil "$B;b(B") ("lmq" nil "$BND(B")
	(";mq" nil "$BGk(B") ("omq" nil "$BJo(B") ("pmq" nil "$B<&(B")
	("nnw" nil "$BF\(B") ("mnw" nil "$BL0(B") (",nw" nil "$B2T(B")
	("hnw" nil "$BNf(B") ("jnw" nil "$BMq(B") ("knw" nil "$B2>(B")
	("ynw" nil "$B1Z(B") ("unw" nil "$B=[(B") ("inw" nil "$B69(B")
	(".nw" nil "$BB](B") ("/nw" nil "$B>+(B") ("lnw" nil "$B6~(B")
	(";nw" nil "$BGe(B") ("onw" nil "$B4r(B") ("pnw" nil "$B7V(B")
	("nmw" nil "$BD_(B") ("mmw" nil "$BIQ(B") (",mw" nil "$B2c(B")
	("hmw" nil "$B1j(B") ("jmw" nil "$B=n(B") ("kmw" nil "$B=x(B")
	("ymw" nil "$BMg(B") ("umw" nil "$B9#(B") ("imw" nil "$BAx(B")
	(".mw" nil "$B0t(B") ("/mw" nil "$BE.(B") ("lmw" nil "$BK9(B")
	(";mw" nil "$B<_(B") ("omw" nil "$BER(B") ("pmw" nil "$BJ~(B")
	("nne" nil "$B5|(B") ("mne" nil "$BA)(B") (",ne" nil "$B2K(B")
	("hne" nil "$B=D(B") ("jne" nil "$BA{(B") ("kne" nil "$B<-(B")
	("yne" nil "$B6y(B") ("une" nil "$B1}(B") ("ine" nil "$B=F(B")
	(".ne" nil "$B3i(B") ("/ne" nil "$BBv(B") ("lne" nil "$BJI(B")
	(";ne" nil "$B?l(B") ("one" nil "$BK"(B") ("pne" nil "$B:x(B")
	("nme" nil "$BAg(B") ("mme" nil "$BJJ(B") (",me" nil "$BJ"(B")
	("hme" nil "$BC8(B") ("jme" nil "$B8X(B") ("kme" nil "$BHo(B")
	("yme" nil "$B4}(B") ("ume" nil "$B7w(B") ("ime" nil "$B>W(B")
	(".me" nil "$B1>(B") ("/me" nil "$B5&(B") ("lme" nil "$B4S(B")
	(";me" nil "$BNt(B") ("ome" nil "$B4t(B") ("pme" nil "$BAs(B")
	("nnr" nil "$BIK(B") ("mnr" nil "$B6i(B") (",nr" nil "$B63(B")
	("hnr" nil "$BNC(B") ("jnr" nil "$BH)(B") ("knr" nil "$BKR(B")
	("ynr" nil "$BHb(B") ("unr" nil "$BF-(B") ("inr" nil "$BK$(B")
	(".nr" nil "$BFW(B") ("/nr" nil "$BOH(B") ("lnr" nil "$B?f(B")
	(";nr" nil "$B:6(B") ("onr" nil "$B7"(B") ("pnr" nil "$BHA(B")
	("nmr" nil "$B;=(B") ("mmr" nil "$B3C(B") (",mr" nil "$B9U(B")
	("hmr" nil "$B2B(B") ("jmr" nil "$B>X(B") ("kmr" nil "$B=L(B")
	("ymr" nil "$B4A(B") ("umr" nil "$B88(B") ("imr" nil "$BKe(B")
	(".mr" nil "$B2U(B") ("/mr" nil "$B?P(B") ("lmr" nil "$BMr(B")
	(";mr" nil "$BJ.(B") ("omr" nil "$B1o(B") ("pmr" nil "$BF{(B")
	("nnt" nil "$B0Z(B") ("mnt" nil "$B<O(B") (",nt" nil "$BJx(B")
	("hnt" nil "$BJ3(B") ("jnt" nil "$BC_(B") ("knt" nil "$B4+(B")
	("ynt" nil "$BA7(B") ("unt" nil "$B:i(B") ("int" nil "$B5q(B")
	(".nt" nil "$BHF(B") ("/nt" nil "$BLF(B") ("lnt" nil "$BO!(B")
	(";nt" nil "$BJ((B") ("ont" nil "$B3T(B") ("pnt" nil "$B;5(B")
	("nmt" nil "$B=+(B") ("mmt" nil "$B8q(B") (",mt" nil "$B@[(B")
	("hmt" nil "$BD)(B") ("jmt" nil "$B=M(B") ("kmt" nil "$B?a(B")
	("ymt" nil "$B;g(B") ("umt" nil "$B2j(B") ("imt" nil "$BEk(B")
	(".mt" nil "$BKU(B") ("/mt" nil "$B1;(B") ("lmt" nil "$BDg(B")
	(";mt" nil "$BLU(B") ("omt" nil "$B<X(B") ("pmt" nil "$B;h(B")
	("zgn" nil "$B3)(B") ("xgn" nil "$BGD(B") ("cgn" nil "$BF%(B")
	("vgn" nil "$B<?(B") ("bgn" nil "$BIv(B") ("agn" nil "$B=J(B")
	("sgn" nil "$BG~(B") ("dgn" nil "$BH"(B") ("fgn" nil "$B3{(B")
	("ggn" nil "$BK}(B") ("qgn" nil "$B6t(B") ("wgn" nil "$BCb(B")
	("egn" nil "$B?/(B") ("rgn" nil "$BJh(B") ("tgn" nil "$BAF(B")
	("zgm" nil "$BM$(B") ("xgm" nil "$B6V(B") ("cgm" nil "$BF)(B")
	("vgm" nil "$B<|(B") ("bgm" nil "$B9I(B") ("agm" nil "$B@I(B")
	("sgm" nil "$BGP(B") ("dgm" nil "$BB8(B") ("fgm" nil "$B2[(B")
	("ggm" nil "$B89(B") ("qgm" nil "$BId(B") ("wgm" nil "$BO-(B")
	("egm" nil "$B2+(B") ("rgm" nil "$B5S(B") ("tgm" nil "$B0V(B")
	("zg," nil "$B>a(B") ("xg," nil "$BDf(B") ("cg," nil "$BNo(B")
	("vg," nil "$B7}(B") ("bg," nil "$B?c(B") ("ag," nil "$BC%(B")
	("sg," nil "$BO*(B") ("dg," nil "$BF}(B") ("fg," nil "$B4G(B")
	("gg," nil "$B9x(B") ("qg," nil "$BI](B") ("wg," nil "$BKd(B")
	("eg," nil "$B9K(B") ("rg," nil "$BB#(B") ("tg," nil "$B3M(B")
	("zgh" nil "$B?}(B") ("xgh" nil "$BDF(B") ("cgh" nil "$BA,(B")
	("vgh" nil "$BD"(B") ("bgh" nil "$B6M(B") ("agh" nil "$BE](B")
	("sgh" nil "$B>P(B") ("dgh" nil "$B:'(B") ("fgh" nil "$B@d(B")
	("ggh" nil "$B>c(B") ("qgh" nil "$B>0(B") ("wgh" nil "$B7{(B")
	("egh" nil "$BFy(B") ("rgh" nil "$B0a(B") ("tgh" nil "$BHK(B")
	("zgj" nil "$B4*(B") ("xgj" nil "$BMb(B") ("cgj" nil "$BN$(B")
	("vgj" nil "$BA](B") ("bgj" nil "$BM#(B") ("agj" nil "$B0](B")
	("sgj" nil "$BHW(B") ("dgj" nil "$B44(B") ("fgj" nil "$B<K(B")
	("ggj" nil "$B@%(B") ("qgj" nil "$B;m(B") ("wgj" nil "$B2-(B")
	("egj" nil "$B5V(B") ("rgj" nil "$B;6(B") ("tgj" nil "$B4j(B")
	("zgk" nil "$B5w(B") ("xgk" nil "$BK7(B") ("cgk" nil "$B>D(B")
	("vgk" nil "$B4J(B") ("bgk" nil "$BE~(B") ("agk" nil "$B3H(B")
	("sgk" nil "$B9_(B") ("dgk" nil "$B6!(B") ("fgk" nil "$B05(B")
	("ggk" nil "$BA!(B") ("qgk" nil "$B2w(B") ("wgk" nil "$BKc(B")
	("egk" nil "$B?y(B") ("rgk" nil "$BJa(B") ("tgk" nil "$BKG(B")
	("zgy" nil "$BG](B") ("xgy" nil "$B4.(B") ("cgy" nil "$B9@(B")
	("vgy" nil "$B1U(B") ("bgy" nil "$BE[(B") ("agy" nil "$BG<(B")
	("sgy" nil "$B6?(B") ("dgy" nil "$B1|(B") ("fgy" nil "$BKt(B")
	("ggy" nil "$BI.(B") ("qgy" nil "$BE/(B") ("wgy" nil "$BCF(B")
	("egy" nil "$BC:(B") ("rgy" nil "$B0p(B") ("tgy" nil "$B0Y(B")
	("zgu" nil "$B9W(B") ("xgu" nil "$B4N(B") ("cgu" nil "$B=S(B")
	("vgu" nil "$B7@(B") ("bgu" nil "$B28(B") ("agu" nil "$BDK(B")
	("sgu" nil "$B=g(B") ("dgu" nil "$B<~(B") ("fgu" nil "$B9S(B")
	("ggu" nil "$B>{(B") ("qgu" nil "$B6S(B") ("wgu" nil "$B:a(B")
	("egu" nil "$B@S(B") ("rgu" nil "$BCk(B") ("tgu" nil "$B7'(B")
	("zgi" nil "$B>z(B") ("xgi" nil "$BCr(B") ("cgi" nil "$B1@(B")
	("vgi" nil "$BLi(B") ("bgi" nil "$BDq(B") ("agi" nil "$B5m(B")
	("sgi" nil "$B?%(B") ("dgi" nil "$B2F(B") ("fgi" nil "$B1g(B")
	("ggi" nil "$BLA(B") ("qgi" nil "$B3w(B") ("wgi" nil "$B8u(B")
	("egi" nil "$B@9(B") ("rgi" nil "$B7c(B") ("tgi" nil "$BHc(B")
	("zg." nil "$B;"(B") ("xg." nil "$B6|(B") ("cg." nil "$BLW(B")
	("vg." nil "$BIn(B") ("bg." nil "$BKZ(B") ("ag." nil "$B<"(B")
	("sg." nil "$BCE(B") ("dg." nil "$BK4(B") ("fg." nil "$BE((B")
	("gg." nil "$BK^(B") ("qg." nil "$B1B(B") ("wg." nil "$B2:(B")
	("eg." nil "$B0_(B") ("rg." nil "$B@;(B") ("tg." nil "$BKM(B")
	("zg/" nil "$BHu(B") ("xg/" nil "$BAd(B") ("cg/" nil "$B1z(B")
	("vg/" nil "$BM4(B") ("bg/" nil "$BNU(B") ("ag/" nil "$B6r(B")
	("sg/" nil "$BNQ(B") ("dg/" nil "$B95(B") ("fg/" nil "$B1t(B")
	("gg/" nil "$BD((B") ("qg/" nil "$BH;(B") ("wg/" nil "$B;1(B")
	("eg/" nil "$B14(B") ("rg/" nil "$BH3(B") ("tg/" nil "$B2i(B")
	("zgl" nil "$B<'(B") ("xgl" nil "$B>$(B") ("cgl" nil "$BE0(B")
	("vgl" nil "$B1x(B") ("bgl" nil "$BAS(B") ("agl" nil "$B6X(B")
	("sgl" nil "$BDl(B") ("dgl" nil "$B@a(B") ("fgl" nil "$B>F(B")
	("ggl" nil "$B0\(B") ("qgl" nil "$B9|(B") ("wgl" nil "$BAq(B")
	("egl" nil "$BBS(B") ("rgl" nil "$BA\(B") ("tgl" nil "$B5U(B")
	("zg;" nil "$BGf(B") ("xg;" nil "$B>S(B") ("cg;" nil "$B4O(B")
	("vg;" nil "$B35(B") ("bg;" nil "$BAB(B") ("ag;" nil "$BCn(B")
	("sg;" nil "$B:Z(B") ("dg;" nil "$B0[(B") ("fg;" nil "$BEX(B")
	("gg;" nil "$B:$(B") ("qg;" nil "$B7$(B") ("wg;" nil "$B4q(B")
	("eg;" nil "$B9H(B") ("rg;" nil "$BAk(B") ("tg;" nil "$B3](B")
	("zgo" nil "$B>g(B") ("xgo" nil "$BIS(B") ("cgo" nil "$B7<(B")
	("vgo" nil "$B91(B") ("bgo" nil "$B?T(B") ("ago" nil "$BLo(B")
	("sgo" nil "$B>5(B") ("dgo" nil "$B0h(B") ("fgo" nil "$B7/(B")
	("ggo" nil "$BKk(B") ("qgo" nil "$BM6(B") ("wgo" nil "$B:^(B")
	("ego" nil "$BJ[(B") ("rgo" nil "$B;u(B") ("tgo" nil "$B>M(B")
	("zgp" nil "$B>[(B") ("xgp" nil "$BG+(B") ("cgp" nil "$BEM(B")
	("vgp" nil "$BG^(B") ("bgp" nil "$B1S(B") ("agp" nil "$BE:(B")
	("sgp" nil "$B5Q(B") ("dgp" nil "$BH((B") ("fgp" nil "$B?L(B")
	("ggp" nil "$BEt(B") ("qgp" nil "$B>"(B") ("wgp" nil "$BJ%(B")
	("egp" nil "$B=!(B") ("rgp" nil "$B54(B") ("tgp" nil "$B47(B")
	("nhz" nil "$B75(B") ("mhz" nil "$BMe(B") (",hz" nil "$B3L(B")
	("hhz" nil "$BB[(B") ("jhz" nil "$BB:(B") ("khz" nil "$BNm(B")
	("yhz" nil "$B?W(B") ("uhz" nil "$B@7(B") ("ihz" nil "$BM^(B")
	(".hz" nil "$BA((B") ("/hz" nil "$BBi(B") ("lhz" nil "$BIk(B")
	(";hz" nil "$BA2(B") ("ohz" nil "$BD$(B") ("phz" nil "$B2}(B")
	("nhx" nil "$B4a(B") ("mhx" nil "$BH2(B") (",hx" nil "$B7v(B")
	("hhx" nil "$B3a(B") ("jhx" nil "$B;j(B") ("khx" nil "$BCh(B")
	("yhx" nil "$B0N(B") ("uhx" nil "$BBs(B") ("ihx" nil "$BDb(B")
	(".hx" nil "$B?D(B") ("/hx" nil "$BD8(B") ("lhx" nil "$BNH(B")
	(";hx" nil "$B?](B") ("ohx" nil "$B36(B") ("phx" nil "$BJ>(B")
	("nhc" nil "$B9J(B") ("mhc" nil "$BN!(B") (",hc" nil "$B2u(B")
	("hhc" nil "$B;i(B") ("jhc" nil "$B57(B") ("khc" nil "$B5J(B")
	("yhc" nil "$B3@(B") ("uhc" nil "$BGS(B") ("ihc" nil "$BF((B")
	(".hc" nil "$B4h(B") ("/hc" nil "$B3n(B") ("lhc" nil "$B<U(B")
	(";hc" nil "$B9E(B") ("ohc" nil "$BB9(B") ("phc" nil "$B4W(B")
	("nhv" nil "$BJ=(B") ("mhv" nil "$BK](B") (",hv" nil "$BGo(B")
	("hhv" nil "$B6@(B") ("jhv" nil "$B0{(B") ("khv" nil "$B2$(B")
	("yhv" nil "$B?k(B") ("uhv" nil "$BD,(B") ("ihv" nil "$B:.(B")
	(".hv" nil "$B6k(B") ("/hv" nil "$BFX(B") ("lhv" nil "$B7j(B")
	(";hv" nil "$BFZ(B") ("ohv" nil "$B@,(B") ("phv" nil "$BK8(B")
	("nhb" nil "$BJ=(B") ("mhb" nil "$BNM(B") (",hb" nil "$BHJ(B")
	("hhb" nil "$BCj(B") ("jhb" nil "$BIj(B") ("khb" nil "$BCW(B")
	("yhb" nil "$BO'(B") ("uhb" nil "$B6C(B") ("ihb" nil "$B2m(B")
	(".hb" nil "$BH-(B") ("/hb" nil "$B0v(B") ("lhb" nil "$B;P(B")
	(";hb" nil "$B>f(B") ("ohb" nil "$BAN(B") ("phb" nil "$B4y(B")
	("nha" nil "$B6v(B") ("mha" nil "$B?O(B") (",ha" nil "$BI^(B")
	("hha" nil "$B7s(B") ("jha" nil "$B0x(B") ("kha" nil "$B6Z(B")
	("yha" nil "$B=_(B") ("uha" nil "$B0$(B") ("iha" nil "$B:~(B")
	(".ha" nil "$BMy(B") ("/ha" nil "$B0?(B") ("lha" nil "$BOQ(B")
	(";ha" nil "$BMB(B") ("oha" nil "$BK@(B") ("pha" nil "$B?((B")
	("nhs" nil "$BAK(B") ("mhs" nil "$B8b(B") (",hs" nil "$B0O(B")
	("hhs" nil "$BHS(B") ("jhs" nil "$B>](B") ("khs" nil "$B7O(B")
	("yhs" nil "$BN8(B") ("uhs" nil "$BMp(B") ("ihs" nil "$BK<(B")
	(".hs" nil "$B9r(B") ("/hs" nil "$BKE(B") ("lhs" nil "$B=}(B")
	(";hs" nil "$BLx(B") ("ohs" nil "$BEI(B") ("phs" nil "$BA<(B")
	("nhd" nil "$B1K(B") ("mhd" nil "$BJq(B") (",hd" nil "$BC<(B")
	("hhd" nil "$B@U(B") ("jhd" nil "$B9/(B") ("khd" nil "$B?K(B")
	("yhd" nil "$B5*(B") ("uhd" nil "$B2l(B") ("ihd" nil "$BFM(B")
	(".hd" nil "$BHn(B") ("/hd" nil "$B8J(B") ("lhd" nil "$BDy(B")
	(";hd" nil "$B:D(B") ("ohd" nil "$B8_(B") ("phd" nil "$BCx(B")
	("nhf" nil "$B@R(B") ("mhf" nil "$BB)(B") (",hf" nil "$B5((B")
	("hhf" nil "$B0M(B") ("jhf" nil "$BKB(B") ("khf" nil "$BEL(B")
	("yhf" nil "$BNX(B") ("uhf" nil "$B=c(B") ("ihf" nil "$BE|(B")
	(".hf" nil "$B:X(B") ("/hf" nil "$BL&(B") ("lhf" nil "$B49(B")
	(";hf" nil "$B5%(B") ("ohf" nil "$BN5(B") ("phf" nil "$B8((B")
	("nhg" nil "$BKP(B") ("mhg" nil "$BF'(B") (",hg" nil "$B2.(B")
	("hhg" nil "$BEp(B") ("jhg" nil "$B<1(B") ("khg" nil "$B4n(B")
	("yhg" nil "$BO7(B") ("uhg" nil "$BF`(B") ("ihg" nil "$B43(B")
	(".hg" nil "$BDD(B") ("/hg" nil "$B9*(B") ("lhg" nil "$BHH(B")
	(";hg" nil "$B1v(B") ("ohg" nil "$BL4(B") ("phg" nil "$BJ#(B")
	("nhq" nil "$B:5(B") ("mhq" nil "$B>8(B") (",hq" nil "$BO$(B")
	("hhq" nil "$B?2(B") ("jhq" nil "$B07(B") ("khq" nil "$B9k(B")
	("yhq" nil "$BH!(B") ("uhq" nil "$B9'(B") ("ihq" nil "$B?X(B")
	(".hq" nil "$BCZ(B") ("/hq" nil "$B3l(B") ("lhq" nil "$B4c(B")
	(";hq" nil "$BMR(B") ("ohq" nil "$B4K(B") ("phq" nil "$BBE(B")
	("nhw" nil "$BMJ(B") ("mhw" nil "$B<N(B") (",hw" nil "$BEB(B")
	("hhw" nil "$B="(B") ("jhw" nil "$BIc(B") ("khw" nil "$BMX(B")
	("yhw" nil "$B<l(B") ("uhw" nil "$B=~(B") ("ihw" nil "$BM>(B")
	(".hw" nil "$BN:(B") ("/hw" nil "$BDi(B") ("lhw" nil "$B:R(B")
	(";hw" nil "$BAr(B") ("ohw" nil "$BIu(B") ("phw" nil "$BB%(B")
	("nhe" nil "$B;#(B") ("mhe" nil "$B>;(B") (",he" nil "$BDa(B")
	("hhe" nil "$B?\(B") ("jhe" nil "$BI[(B") ("khe" nil "$BIq(B")
	("yhe" nil "$B90(B") ("uhe" nil "$B1d(B") ("ihe" nil "$BI'(B")
	(".he" nil "$BDA(B") ("/he" nil "$B@{(B") ("lhe" nil "$BGK(B")
	(";he" nil "$BCi(B") ("ohe" nil "$B<y(B") ("phe" nil "$BA/(B")
	("nhr" nil "$BJE(B") ("mhr" nil "$B71(B") (",hr" nil "$BG3(B")
	("hhr" nil "$BA`(B") ("jhr" nil "$B29(B") ("khr" nil "$BL)(B")
	("yhr" nil "$BAc(B") ("uhr" nil "$BI8(B") ("ihr" nil "$B2!(B")
	(".hr" nil "$BNq(B") ("/hr" nil "$BDe(B") ("lhr" nil "$BJ^(B")
	(";hr" nil "$B0d(B") ("ohr" nil "$BG_(B") ("phr" nil "$BE_(B")
	("nht" nil "$BB6(B") ("mht" nil "$BJf(B") (",ht" nil "$B?G(B")
	("hht" nil "$B>7(B") ("jht" nil "$B7l(B") ("kht" nil "$B1s(B")
	("yht" nil "$BK`(B") ("uht" nil "$B5l(B") ("iht" nil "$B3K(B")
	(".ht" nil "$B>x(B") ("/ht" nil "$BFF(B") ("lht" nil "$BF&(B")
	(";ht" nil "$BAC(B") ("oht" nil "$BN;(B") ("pht" nil "$BM5(B")
	("zvn" nil "$BAL(B") ("xvn" nil "$BJw(B") ("cvn" nil "$B:g(B")
	("vvn" nil "$BIo(B") ("bvn" nil "$BM](B") ("avn" nil "$BI?(B")
	("svn" nil "$BO3(B") ("dvn" nil "$B@](B") ("fvn" nil "$BHQ(B")
	("gvn" nil "$B23(B") ("qvn" nil "$BO>(B") ("wvn" nil "$BJK(B")
	("evn" nil "$BA-(B") ("rvn" nil "$B8Q(B") ("tvn" nil "$BD1(B")
	("zbn" nil "$B1a(B") ("xbn" nil "$B>V(B") ("cbn" nil "$B1^(B")
	("vbn" nil "$B:S(B") ("bbn" nil "$BG?(B") ("abn" nil "$B:t(B")
	("sbn" nil "$BFz(B") ("dbn" nil "$B0X(B") ("fbn" nil "$B<\(B")
	("gbn" nil "$BIg(B") ("qbn" nil "$B<^(B") ("wbn" nil "$BC!(B")
	("ebn" nil "$BKK(B") ("rbn" nil "$BD*(B") ("tbn" nil "$BL=(B")
	("zvm" nil "$BB{(B") ("xvm" nil "$B4g(B") ("cvm" nil "$BLQ(B")
	("vvm" nil "$BGN(B") ("bvm" nil "$B:k(B") ("avm" nil "$B2g(B")
	("svm" nil "$B4Y(B") ("dvm" nil "$B08(B") ("fvm" nil "$BE3(B")
	("gvm" nil "$BN_(B") ("qvm" nil "$B1m(B") ("wvm" nil "$B:q(B")
	("evm" nil "$BJn(B") ("rvm" nil "$BMt(B") ("tvm" nil "$B6,(B")
	("zbm" nil "$BEK(B") ("xbm" nil "$BK)(B") ("cbm" nil "$BNK(B")
	("vbm" nil "$BA?(B") ("bbm" nil "$B2@(B") ("abm" nil "$BLm(B")
	("sbm" nil "$B6U(B") ("dbm" nil "$B56(B") ("fbm" nil "$BNw(B")
	("gbm" nil "$B9B(B") ("qbm" nil "$BI5(B") ("wbm" nil "$BFx(B")
	("ebm" nil "$BJ:(B") ("rbm" nil "$B6)(B") ("tbm" nil "$B@y(B")
	("zv," nil "$BLe(B") ("xv," nil "$BA.(B") ("cv," nil "$B<[(B")
	("vv," nil "$B3!(B") ("bv," nil "$BL*(B") ("av," nil "$BFu(B")
	("sv," nil "$B2M(B") ("dv," nil "$B8[(B") ("fv," nil "$B5g(B")
	("gv," nil "$B>=(B") ("qv," nil "$B5d(B") ("wv," nil "$BG((B")
	("ev," nil "$B:2(B") ("rv," nil "$B>w(B") ("tv," nil "$B0y(B")
	("zb," nil "$B=6(B") ("xb," nil "$BA9(B") ("cb," nil "$BA:(B")
	("vb," nil "$BO4(B") ("bb," nil "$BL`(B") ("ab," nil "$B>?(B")
	("sb," nil "$BHR(B") ("db," nil "$B>#(B") ("fb," nil "$BEa(B")
	("gb," nil "$B@X(B") ("qb," nil "$B0P(B") ("wb," nil "$B0|(B")
	("eb," nil "$B2v(B") ("rb," nil "$B@e(B") ("tb," nil "$BGp(B")
	("zvh" nil "$B:-(B") ("xvh" nil "$B1\(B") ("cvh" nil "$B3x(B")
	("vvh" nil "$B6E(B") ("bvh" nil "$B3%(B") ("avh" nil "$B3j(B")
	("svh" nil "$B>\(B") ("dvh" nil "$BCs(B") ("fvh" nil "$BE&(B")
	("gvh" nil "$BG;(B") ("qvh" nil "$BA6(B") ("wvh" nil "$B;w(B")
	("evh" nil "$BBY(B") ("rvh" nil "$BHB(B") ("tvh" nil "$BLB(B")
	("zbh" nil "$B6z(B") ("xbh" nil "$B<S(B") ("cbh" nil "$B5u(B")
	("vbh" nil "$B3O(B") ("bbh" nil "$B?8(B") ("abh" nil "$B53(B")
	("sbh" nil "$B9F(B") ("dbh" nil "$B7:(B") ("fbh" nil "$B9((B")
	("gbh" nil "$B3^(B") ("qbh" nil "$B01(B") ("wbh" nil "$BK?(B")
	("ebh" nil "$B:}(B") ("rbh" nil "$BLf(B") ("tbh" nil "$BEG(B")
	("zvj" nil "$BL-(B") ("xvj" nil "$BIm(B") ("cvj" nil "$B8I(B")
	("vvj" nil "$BLq(B") ("bvj" nil "$B=7(B") ("avj" nil "$BC/(B")
	("svj" nil "$BLa(B") ("dvj" nil "$BNi(B") ("fvj" nil "$B8$(B")
	("gvj" nil "$BCH(B") ("qvj" nil "$BJ7(B") ("wvj" nil "$BDT(B")
	("evj" nil "$BD0(B") ("rvj" nil "$B;c(B") ("tvj" nil "$B6W(B")
	("zbj" nil "$BDw(B") ("xbj" nil "$B:;(B") ("cbj" nil "$BE1(B")
	("vbj" nil "$B=y(B") ("bbj" nil "$B04(B") ("abj" nil "$BLT(B")
	("sbj" nil "$B>4(B") ("dbj" nil "$B4x(B") ("fbj" nil "$B79(B")
	("gbj" nil "$BF<(B") ("qbj" nil "$B0r(B") ("wbj" nil "$B>1(B")
	("ebj" nil "$BHU(B") ("rbj" nil "$B@x(B") ("tbj" nil "$BK3(B")
	("zvk" nil "$B<.(B") ("xvk" nil "$B7B(B") ("cvk" nil "$B>N(B")
	("vvk" nil "$BA~(B") ("bvk" nil "$B<m(B") ("avk" nil "$BJz(B")
	("svk" nil "$B99(B") ("dvk" nil "$BG\(B") ("fvk" nil "$B3y(B")
	("gvk" nil "$B<n(B") ("qvk" nil "$BK&(B") ("wvk" nil "$BMw(B")
	("evk" nil "$BG5(B") ("rvk" nil "$B=V(B") ("tvk" nil "$BK%(B")
	("zbk" nil "$B12(B") ("xbk" nil "$B6O(B") ("cbk" nil "$BJG(B")
	("vbk" nil "$BM{(B") ("bbk" nil "$BGL(B") ("abk" nil "$BJ@(B")
	("sbk" nil "$B=O(B") ("dbk" nil "$B1F(B") ("fbk" nil "$BM_(B")
	("gbk" nil "$B6;(B") ("qbk" nil "$BFi(B") ("wbk" nil "$B;p(B")
	("ebk" nil "$B<M(B") ("rbk" nil "$BB!(B") ("tbk" nil "$B=Z(B")
	("zvy" nil "$B:V(B") ("xvy" nil "$B0G(B") ("cvy" nil "$B80(B")
	("vvy" nil "$B7L(B") ("bvy" nil "$B>6(B") ("avy" nil "$B0S(B")
	("svy" nil "$BFp(B") ("dvy" nil "$BC$(B") ("fvy" nil "$BAD(B")
	("gvy" nil "$BD&(B") ("qvy" nil "$B;7(B") ("wvy" nil "$B:"(B")
	("evy" nil "$BJS(B") ("rvy" nil "$B1n(B") ("tvy" nil "$B@O(B")
	("zby" nil "$B8?(B") ("xby" nil "$B3A(B") ("cby" nil "$BF_(B")
	("vby" nil "$B>_(B") ("bby" nil "$B<F(B") ("aby" nil "$B=b(B")
	("sby" nil "$BG-(B") ("dby" nil "$BL!(B") ("fby" nil "$B7I(B")
	("gby" nil "$BEb(B") ("qby" nil "$B<%(B") ("wby" nil "$BFt(B")
	("eby" nil "$BGR(B") ("rby" nil "$B5](B") ("tby" nil "$BFw(B")
	("zvu" nil "$BEN(B") ("xvu" nil "$BDV(B") ("cvu" nil "$B9X(B")
	("vvu" nil "$B?~(B") ("bvu" nil "$B2p(B") ("avu" nil "$B;r(B")
	("svu" nil "$B5>(B") ("dvu" nil "$BN4(B") ("fvu" nil "$B1h(B")
	("gvu" nil "$BKb(B") ("qvu" nil "$B?V(B") ("wvu" nil "$BI:(B")
	("evu" nil "$BC\(B") ("rvu" nil "$BKW(B") ("tvu" nil "$BNv(B")
	("zbu" nil "$BNF(B") ("xbu" nil "$BEc(B") ("cbu" nil "$BF=(B")
	("vbu" nil "$B9d(B") ("bbu" nil "$BHm(B") ("abu" nil "$BG!(B")
	("sbu" nil "$B9L(B") ("dbu" nil "$BNP(B") ("fbu" nil "$BOS(B")
	("gbu" nil "$BOF(B") ("qbu" nil "$B0*(B") ("wbu" nil "$B4w(B")
	("ebu" nil "$BBZ(B") ("rbu" nil "$BNu(B") ("tbu" nil "$BIP(B")
	("zvi" nil "$BKj(B") ("xvi" nil "$B8d(B") ("cvi" nil "$BGl(B")
	("vvi" nil "$BJW(B") ("bvi" nil "$B5}(B") ("avi" nil "$BB5(B")
	("svi" nil "$B>Q(B") ("dvi" nil "$BMj(B") ("fvi" nil "$BJv(B")
	("gvi" nil "$B=K(B") ("qvi" nil "$B7y(B") ("wvi" nil "$BHI(B")
	("evi" nil "$BKO(B") ("rvi" nil "$BHd(B") ("tvi" nil "$BGu(B")
	("zbi" nil "$BKj(B") ("xbi" nil "$B1M(B") ("cbi" nil "$BE=(B")
	("vbi" nil "$BGE(B") ("bbi" nil "$B5#(B") ("abi" nil "$BB5(B")
	("sbi" nil "$B9Z(B") ("dbi" nil "$BGw(B") ("fbi" nil "$BL<(B")
	("gbi" nil "$B3-(B") ("qbi" nil "$BEi(B") ("wbi" nil "$BE)(B")
	("ebi" nil "$B6](B") ("rbi" nil "$BIz(B") ("tbi" nil "$BH&(B")
	("zv." nil "$BIs(B") ("xv." nil "$BB\(B") ("cv." nil "$B>E(B")
	("vv." nil "$B6*(B") ("bv." nil "$BDJ(B") ("av." nil "$BMl(B")
	("sv." nil "$BFk(B") ("dv." nil "$B9!(B") ("fv." nil "$B9?(B")
	("gv." nil "$B:K(B") ("qv." nil "$B9m(B") ("wv." nil "$B:*(B")
	("ev." nil "$B0T(B") ("rv." nil "$B:/(B") ("tv." nil "$BNJ(B")
	("zb." nil "$B@C(B") ("xb." nil "$B4#(B") ("cb." nil "$BMd(B")
	("vb." nil "$BDP(B") ("bb." nil "$BC?(B") ("ab." nil "$B1C(B")
	("sb." nil "$BBC(B") ("db." nil "$B>L(B") ("fb." nil "$B;s(B")
	("gb." nil "$B?[(B") ("qb." nil "$BC>(B") ("wb." nil "$B10(B")
	("eb." nil "$B7=(B") ("rb." nil "$BN<(B") ("tb." nil "$BGW(B")
	("zv/" nil "$B8S(B") ("xv/" nil "$B?Q(B") ("cv/" nil "$B2k(B")
	("vv/" nil "$BA=(B") ("bv/" nil "$BDu(B") ("av/" nil "$B5@(B")
	("sv/" nil "$BOK(B") ("dv/" nil "$B6o(B") ("fv/" nil "$B22(B")
	("gv/" nil "$BL~(B") ("qv/" nil "$B7q(B") ("wv/" nil "$BFg(B")
	("ev/" nil "$B0H(B") ("rv/" nil "$BFd(B") ("tv/" nil "$B4\(B")
	("zb/" nil "$BJ\(B") ("xb/" nil "$B6}(B") ("cb/" nil "$BGb(B")
	("vb/" nil "$B4H(B") ("bb/" nil "$B6B(B") ("ab/" nil "$B3_(B")
	("sb/" nil "$B1b(B") ("db/" nil "$B1,(B") ("fb/" nil "$BLw(B")
	("gb/" nil "$B2`(B") ("qb/" nil "$BO.(B") ("wb/" nil "$BFh(B")
	("eb/" nil "$BAW(B") ("rb/" nil "$BD|(B") ("tb/" nil "$B4f(B")
	("zvl" nil "$B3.(B") ("xvl" nil "$B4-(B") ("cvl" nil "$BMO(B")
	("vvl" nil "$B00(B") ("bvl" nil "$BNl(B") ("avl" nil "$B=&(B")
	("svl" nil "$BA&(B") ("dvl" nil "$B7;(B") ("fvl" nil "$B1"(B")
	("gvl" nil "$BGU(B") ("qvl" nil "$B0I(B") ("wvl" nil "$B=A(B")
	("evl" nil "$B2|(B") ("rvl" nil "$B>,(B") ("tvl" nil "$BMk(B")
	("zbl" nil "$BGJ(B") ("xbl" nil "$BKr(B") ("cbl" nil "$B?g(B")
	("vbl" nil "$B?+(B") ("bbl" nil "$BK{(B") ("abl" nil "$B?j(B")
	("sbl" nil "$B>t(B") ("dbl" nil "$B9o(B") ("fbl" nil "$B8m(B")
	("gbl" nil "$B6<(B") ("qbl" nil "$B0}(B") ("wbl" nil "$B8U(B")
	("ebl" nil "$BH1(B") ("rbl" nil "$B6n(B") ("tbl" nil "$B@+(B")
	("zv;" nil "$B4C(B") ("xv;" nil "$BJp(B") ("cv;" nil "$B<p(B")
	("vv;" nil "$B0C(B") ("bv;" nil "$BFL(B") ("av;" nil "$B38(B")
	("sv;" nil "$BI6(B") ("dv;" nil "$BNR(B") ("fv;" nil "$BE{(B")
	("gv;" nil "$B6+(B") ("qv;" nil "$B<v(B") ("wv;" nil "$BM)(B")
	("ev;" nil "$BMS(B") ("rv;" nil "$B4=(B") ("tv;" nil "$B3m(B")
	("zb;" nil "$BCp(B") ("xb;" nil "$BBA(B") ("cb;" nil "$B7N(B")
	("vb;" nil "$BEw(B") ("bb;" nil "$BL6(B") ("ab;" nil "$BJ/(B")
	("sb;" nil "$B?I(B") ("db;" nil "$B:w(B") ("fb;" nil "$BDn(B")
	("gb;" nil "$BBy(B") ("qb;" nil "$B31(B") ("wb;" nil "$B?s(B")
	("eb;" nil "$BMI(B") ("rb;" nil "$B48(B") ("tb;" nil "$BB~(B")
	("zvo" nil "$BI&(B") ("xvo" nil "$B0j(B") ("cvo" nil "$B0)(B")
	("vvo" nil "$BHl(B") ("bvo" nil "$BLc(B") ("avo" nil "$B<d(B")
	("svo" nil "$BNn(B") ("dvo" nil "$B7,(B") ("fvo" nil "$B7.(B")
	("gvo" nil "$B7H(B") ("qvo" nil "$BJe(B") ("wvo" nil "$BF?(B")
	("evo" nil "$B7i(B") ("rvo" nil "$BKC(B") ("tvo" nil "$B3g(B")
	("zbo" nil "$B=](B") ("xbo" nil "$B0@(B") ("cbo" nil "$B4L(B")
	("vbo" nil "$B13(B") ("bbo" nil "$B1](B") ("abo" nil "$B6R(B")
	("sbo" nil "$B>j(B") ("dbo" nil "$BK'(B") ("fbo" nil "$BCC(B")
	("gbo" nil "$BBU(B") ("qbo" nil "$BKS(B") ("wbo" nil "$B3f(B")
	("ebo" nil "$BOE(B") ("rbo" nil "$B7_(B") ("tbo" nil "$B2I(B")
	("zvp" nil "$BLX(B") ("xvp" nil "$BH$(B") ("cvp" nil "$B<W(B")
	("vvp" nil "$BBI(B") ("bvp" nil "$BEh(B") ("avp" nil "$BFo(B")
	("svp" nil "$BBu(B") ("dvp" nil "$B8g(B") ("fvp" nil "$B6.(B")
	("gvp" nil "$BHe(B") ("qvp" nil "$BFQ(B") ("wvp" nil "$BKX(B")
	("evp" nil "$B;C(B") ("rvp" nil "$B>m(B") ("tvp" nil "$B1V(B")
	("zbp" nil "$BDG(B") ("xbp" nil "$BAM(B") ("cbp" nil "$B@r(B")
	("vbp" nil "$BIZ(B") ("bbp" nil "$B8C(B") ("abp" nil "$B=m(B")
	("sbp" nil "$B92(B") ("dbp" nil "$BA>(B") ("fbp" nil "$BF6(B")
	("gbp" nil "$B2'(B") ("qbp" nil "$B3r(B") ("wbp" nil "$B1y(B")
	("ebp" nil "$BDR(B") ("rbp" nil "$B@((B") ("tbp" nil "$B4b(B")
	("ztn" nil "$B3u(B") ("xtn" nil "$B5B(B") ("ctn" nil "$BI3(B")
	("vtn" nil "$BD?(B") ("btn" nil "$BI`(B") ("atn" nil "$B?0(B")
	("stn" nil "$B>n(B") ("dtn" nil "$BLV(B") ("ftn" nil "$B8W(B")
	("gtn" nil "$B@K(B") ("qtn" nil "$BK[(B") ("wtn" nil "$BCT(B")
	("etn" nil "$B0R(B") ("rtn" nil "$BBQ(B") ("ttn" nil "$B;x(B")
	("ztm" nil "$B6f(B") ("xtm" nil "$BA"(B") ("ctm" nil "$B;$(B")
	("vtm" nil "$B64(B") ("btm" nil "$BDX(B") ("atm" nil "$BGy(B")
	("stm" nil "$B:?(B") ("dtm" nil "$BH*(B") ("ftm" nil "$BO2(B")
	("gtm" nil "$BL[(B") ("qtm" nil "$B?1(B") ("wtm" nil "$BB7(B")
	("etm" nil "$B45(B") ("rtm" nil "$B6g(B") ("ttm" nil "$BE+(B")
	("zt," nil "$B@m(B") ("xt," nil "$BD^(B") ("ct," nil "$BMo(B")
	("vt," nil "$B97(B") ("bt," nil "$BGV(B") ("at," nil "$BA5(B")
	("st," nil "$B9Y(B") ("dt," nil "$BHi(B") ("ft," nil "$BLD(B")
	("gt," nil "$BHy(B") ("qt," nil "$BC@(B") ("wt," nil "$BIO(B")
	("et," nil "$BN,(B") ("rt," nil "$B9n(B") ("tt," nil "$B6`(B")
	("zth" nil "$BD<(B") ("xth" nil "$B9s(B") ("cth" nil "$BJD(B")
	("vth" nil "$B<Q(B") ("bth" nil "$B5j(B") ("ath" nil "$BMc(B")
	("sth" nil "$B@j(B") ("dth" nil "$B7C(B") ("fth" nil "$B6Q(B")
	("gth" nil "$BNs(B") ("qth" nil "$BHO(B") ("wth" nil "$B>R(B")
	("eth" nil "$BAv(B") ("rth" nil "$B9a(B") ("tth" nil "$BAX(B")
	("ztj" nil "$BAz(B") ("xtj" nil "$B1#(B") ("ctj" nil "$B4z(B")
	("vtj" nil "$BGq(B") ("btj" nil "$B;L(B") ("atj" nil "$B@^(B")
	("stj" nil "$B;o(B") ("dtj" nil "$B4_(B") ("ftj" nil "$B>y(B")
	("gtj" nil "$B5{(B") ("qtj" nil "$B5_(B") ("wtj" nil "$BNW(B")
	("etj" nil "$B:J(B") ("rtj" nil "$B=h(B") ("ttj" nil "$BN1(B")
	("ztk" nil "$BAe(B") ("xtk" nil "$B8-(B") ("ctk" nil "$BGQ(B")
	("vtk" nil "$B4E(B") ("btk" nil "$B<k(B") ("atk" nil "$BNx(B")
	("stk" nil "$BNE(B") ("dtk" nil "$B5R(B") ("ftk" nil "$B=|(B")
	("gtk" nil "$BE5(B") ("qtk" nil "$B7Q(B") ("wtk" nil "$B:=(B")
	("etk" nil "$B3W(B") ("rtk" nil "$B@A(B") ("ttk" nil "$B0!(B")
	("zty" nil "$B0g(B") ("xty" nil "$B5`(B") ("cty" nil "$B7|(B")
	("vty" nil "$B=-(B") ("bty" nil "$BH}(B") ("aty" nil "$BFl(B")
	("sty" nil "$BC5(B") ("dty" nil "$B4?(B") ("fty" nil "$B:E(B")
	("gty" nil "$B<{(B") ("qty" nil "$BCR(B") ("wty" nil "$B@?(B")
	("ety" nil "$BLu(B") ("rty" nil "$B8;(B") ("tty" nil "$B62(B")
	("ztu" nil "$B?q(B") ("xtu" nil "$B3<(B") ("ctu" nil "$B7!(B")
	("vtu" nil "$B:L(B") ("btu" nil "$BHg(B") ("atu" nil "$B3'(B")
	("stu" nil "$BLp(B") ("dtu" nil "$BI{(B") ("ftu" nil "$BI}(B")
	("gtu" nil "$BCY(B") ("qtu" nil "$BK:(B") ("wtu" nil "$B3P(B")
	("etu" nil "$BHk(B") ("rtu" nil "$B@c(B") ("ttu" nil "$B?B(B")
	("zti" nil "$B59(B") ("xti" nil "$B@@(B") ("cti" nil "$BN2(B")
	("vti" nil "$B8,(B") ("bti" nil "$B4"(B") ("ati" nil "$BBl(B")
	("sti" nil "$B</(B") ("dti" nil "$B8G(B") ("fti" nil "$BKY(B")
	("gti" nil "$BAO(B") ("qti" nil "$BL%(B") ("wti" nil "$B=R(B")
	("eti" nil "$BNa(B") ("rti" nil "$BB,(B") ("tti" nil "$BO/(B")
	("zt." nil "$B3}(B") ("xt." nil "$B@T(B") ("ct." nil "$B7E(B")
	("vt." nil "$BN\(B") ("bt." nil "$BFE(B") ("at." nil "$BH7(B")
	("st." nil "$B70(B") ("dt." nil "$B=.(B") ("ft." nil "$BL/(B")
	("gt." nil "$B5'(B") ("qt." nil "$BK0(B") ("wt." nil "$BO0(B")
	("et." nil "$B@'(B") ("rt." nil "$BBr(B") ("tt." nil "$B6'(B")
	("zt/" nil "$BAf(B") ("xt/" nil "$B5)(B") ("ct/" nil "$B8R(B")
	("vt/" nil "$BGt(B") ("bt/" nil "$B?`(B") ("at/" nil "$B=e(B")
	("st/" nil "$B:&(B") ("dt/" nil "$BCl(B") ("ft/" nil "$B?h(B")
	("gt/" nil "$BA+(B") ("qt/" nil "$BC^(B") ("wt/" nil "$B1$(B")
	("et/" nil "$B:o(B") ("rt/" nil "$B9&(B") ("tt/" nil "$B4`(B")
	("ztl" nil "$BG4(B") ("xtl" nil "$BCQ(B") ("ctl" nil "$B7u(B")
	("vtl" nil "$B@!(B") ("btl" nil "$B?r(B") ("atl" nil "$B>H(B")
	("stl" nil "$BLC(B") ("dtl" nil "$B5y(B") ("ftl" nil "$B:y(B")
	("gtl" nil "$B@k(B") ("qtl" nil "$B5M(B") ("wtl" nil "$BAP(B")
	("etl" nil "$BB0(B") ("rtl" nil "$B93(B") ("ttl" nil "$BH<(B")
	("zt;" nil "$B3s(B") ("xt;" nil "$B@B(B") ("ct;" nil "$BJ$(B")
	("vt;" nil "$B?S(B") ("bt;" nil "$BC3(B") ("at;" nil "$B;](B")
	("st;" nil "$BE`(B") ("dt;" nil "$BC&(B") ("ft;" nil "$B>'(B")
	("gt;" nil "$BFG(B") ("qt;" nil "$B@#(B") ("wt;" nil "$B8.(B")
	("et;" nil "$BG>(B") ("rt;" nil "$B@W(B") ("tt;" nil "$B68(B")
	("zto" nil "$B@&(B") ("xto" nil "$B7p(B") ("cto" nil "$B7f(B")
	("vto" nil "$BO#(B") ("bto" nil "$B@M(B") ("ato" nil "$B2x(B")
	("sto" nil "$B>G(B") ("dto" nil "$BLJ(B") ("fto" nil "$BB'(B")
	("gto" nil "$BMY(B") ("qto" nil "$B2G(B") ("wto" nil "$BB;(B")
	("eto" nil "$BNY(B") ("rto" nil "$B7D(B") ("tto" nil "$B4{(B")
	("ztp" nil "$BG|(B") ("xtp" nil "$B7&(B") ("ctp" nil "$B?b(B")
	("vtp" nil "$B=G(B") ("btp" nil "$BFr(B") ("atp" nil "$B7\(B")
	("stp" nil "$BIh(B") ("dtp" nil "$BJY(B") ("ftp" nil "$B=<(B")
	("gtp" nil "$B=o(B") ("qtp" nil "$BC2(B") ("wtp" nil "$B<a(B")
	("etp" nil "$B87(B") ("rtp" nil "$BOG(B") ("ttp" nil "$B7F(B")
	("nyz" nil "$B:I(B") ("myz" nil "$B:!(B") (",yz" nil "$BOM(B")
	("hyz" nil "$BEu(B") ("jyz" nil "$B6D(B") ("kyz" nil "$B3S(B")
	("yyz" nil "$B5L(B") ("uyz" nil "$BAn(B") ("iyz" nil "$B5:(B")
	(".yz" nil "$BGA(B") ("/yz" nil "$B=z(B") ("lyz" nil "$B5X(B")
	(";yz" nil "$B3:(B") ("oyz" nil "$B2b(B") ("pyz" nil "$BA^(B")
	("nyx" nil "$BF4(B") ("myx" nil "$BNh(B") (",yx" nil "$B8t(B")
	("hyx" nil "$B0%(B") ("jyx" nil "$BE\(B") ("kyx" nil "$B@w(B")
	("yyx" nil "$B5<(B") ("uyx" nil "$BI1(B") ("iyx" nil "$BD2(B")
	(".yx" nil "$BI0(B") ("/yx" nil "$BHC(B") ("lyx" nil "$B1w(B")
	(";yx" nil "$BHj(B") ("oyx" nil "$B;B(B") ("pyx" nil "$B34(B")
	("nyc" nil "$BDQ(B") ("myc" nil "$BC6(B") (",yc" nil "$B:U(B")
	("hyc" nil "$B>v(B") ("jyc" nil "$B9`(B") ("kyc" nil "$B>K(B")
	("yyc" nil "$BBL(B") ("uyc" nil "$B1l(B") ("iyc" nil "$B>I(B")
	(".yc" nil "$B4Z(B") ("/yc" nil "$B?*(B") ("lyc" nil "$B=k(B")
	(";yc" nil "$B@F(B") ("oyc" nil "$BI!(B") ("pyc" nil "$BC"(B")
	("nyv" nil "$B1H(B") ("myv" nil "$B6J(B") (",yv" nil "$B8`(B")
	("hyv" nil "$BEm(B") ("jyv" nil "$B8c(B") ("kyv" nil "$B?C(B")
	("yyv" nil "$BDC(B") ("uyv" nil "$B?5(B") ("iyv" nil "$B5r(B")
	(".yv" nil "$B7[(B") ("/yv" nil "$BH+(B") ("lyv" nil "$BE%(B")
	(";yv" nil "$B:O(B") ("oyv" nil "$BLG(B") ("pyv" nil "$B<@(B")
	("nyb" nil "$B3*(B") ("myb" nil "$BDr(B") (",yb" nil "$B9N(B")
	("hyb" nil "$B0=(B") ("jyb" nil "$B4l(B") ("kyb" nil "$BHh(B")
	("yyb" nil "$BIf(B") ("uyb" nil "$B@N(B") ("iyb" nil "$B7*(B")
	(".yb" nil "$B?$(B") ("/yb" nil "$BC,(B") ("lyb" nil "$B1Y(B")
	(";yb" nil "$BJP(B") ("oyb" nil "$B;l(B") ("pyb" nil "$B2{(B")
	("nya" nil "$BCv(B") ("mya" nil "$BO6(B") (",ya" nil "$B?R(B")
	("hya" nil "$B7G(B") ("jya" nil "$B3Y(B") ("kya" nil "$B<w(B")
	("yya" nil "$BCU(B") ("uya" nil "$B;?(B") ("iya" nil "$B2_(B")
	(".ya" nil "$BBd(B") ("/ya" nil "$BM~(B") ("lya" nil "$B9v(B")
	(";ya" nil "$BKA(B") ("oya" nil "$B1T(B") ("pya" nil "$B=a(B")
	("nys" nil "$B6c(B") ("mys" nil "$BAT(B") (",ys" nil "$B?o(B")
	("hys" nil "$BGv(B") ("jys" nil "$BIC(B") ("kys" nil "$B96(B")
	("yys" nil "$BF+(B") ("uys" nil "$BK=(B") ("iys" nil "$B74(B")
	(".ys" nil "$B2R(B") ("/ys" nil "$B2t(B") ("lys" nil "$BA|(B")
	(";ys" nil "$B51(B") ("oys" nil "$B5.(B") ("pys" nil "$BMD(B")
	("nyd" nil "$BDz(B") ("myd" nil "$B4%(B") (",yd" nil "$B6[(B")
	("hyd" nil "$BEr(B") ("jyd" nil "$BF.(B") ("kyd" nil "$BK.(B")
	("yyd" nil "$B72(B") ("uyd" nil "$B6l(B") ("iyd" nil "$BLO(B")
	(".yd" nil "$B1c(B") ("/yd" nil "$B0o(B") ("lyd" nil "$B;@(B")
	(";yd" nil "$BJA(B") ("oyd" nil "$BI<(B") ("pyd" nil "$BES(B")
	("nyf" nil "$B6G(B") ("myf" nil "$BCa(B") (",yf" nil "$B?N(B")
	("hyf" nil "$B8F(B") ("jyf" nil "$B5?(B") ("kyf" nil "$B=0(B")
	("yyf" nil "$BH](B") ("uyf" nil "$B;!(B") ("iyf" nil "$B4u(B")
	(".yf" nil "$BD/(B") ("/yf" nil "$B;|(B") ("lyf" nil "$B;%(B")
	(";yf" nil "$B9C(B") ("oyf" nil "$BGX(B") ("pyf" nil "$B>B(B")
	("nyg" nil "$BB1(B") ("myg" nil "$BD:(B") (",yg" nil "$B5[(B")
	("hyg" nil "$BMm(B") ("jyg" nil "$BJ)(B") ("kyg" nil "$B;Q(B")
	("yyg" nil "$B2Y(B") ("uyg" nil "$BB.(B") ("iyg" nil "$BE!(B")
	(".yg" nil "$BC`(B") ("/yg" nil "$B8O(B") ("lyg" nil "$BC0(B")
	(";yg" nil "$BHr(B") ("oyg" nil "$B;I(B") ("pyg" nil "$BB+(B")
	("nyq" nil "$B11(B") ("myq" nil "$BD7(B") (",yq" nil "$BJi(B")
	("hyq" nil "$BI$(B") ("jyq" nil "$B=\(B") ("kyq" nil "$B3c(B")
	("yyq" nil "$B8<(B") ("uyq" nil "$B4U(B") ("iyq" nil "$BN=(B")
	(".yq" nil "$BK*(B") ("/yq" nil "$B=l(B") ("lyq" nil "$B@p(B")
	(";yq" nil "$B?,(B") ("oyq" nil "$B<*(B") ("pyq" nil "$BK5(B")
	("nyw" nil "$B1L(B") ("myw" nil "$B94(B") (",yw" nil "$B25(B")
	("hyw" nil "$B9D(B") ("jyw" nil "$B>~(B") ("kyw" nil "$BGn(B")
	("yyw" nil "$BI9(B") ("uyw" nil "$BLP(B") ("iyw" nil "$BJ4(B")
	(".yw" nil "$B2y(B") ("/yw" nil "$B98(B") ("lyw" nil "$BFO(B")
	(";yw" nil "$BIR(B") ("oyw" nil "$BCy(B") ("pyw" nil "$B2f(B")
	("nye" nil "$BM1(B") ("mye" nil "$B8/(B") (",ye" nil "$BL8(B")
	("hye" nil "$B8P(B") ("jye" nil "$B:N(B") ("kye" nil "$B6-(B")
	("yye" nil "$B?"(B") ("uye" nil "$B5n(B") ("iye" nil "$B0W(B")
	(".ye" nil "$B:0(B") ("/ye" nil "$BD~(B") ("lye" nil "$BJ;(B")
	(";ye" nil "$B27(B") ("oye" nil "$B>O(B") ("pye" nil "$BD6(B")
	("nyr" nil "$B8](B") ("myr" nil "$BMs(B") (",yr" nil "$B8*(B")
	("hyr" nil "$B@g(B") ("jyr" nil "$BN%(B") ("kyr" nil "$B<Z(B")
	("yyr" nil "$B0E(B") ("uyr" nil "$BAJ(B") ("iyr" nil "$BD;(B")
	(".yr" nil "$BM*(B") ("/yr" nil "$B8L(B") ("lyr" nil "$B<9(B")
	(";yr" nil "$B6p(B") ("oyr" nil "$BDh(B") ("pyr" nil "$BAb(B")
	("nyt" nil "$B?u(B") ("myt" nil "$B;'(B") (",yt" nil "$B8\(B")
	("hyt" nil "$BIA(B") ("jyt" nil "$B8y(B") ("kyt" nil "$BM<(B")
	("yyt" nil "$B0E(B") ("uyt" nil "$BAJ(B") ("iyt" nil "$BKg(B")
	(".yt" nil "$B@`(B") ("/yt" nil "$BH\(B") ("lyt" nil "$B5F(B")
	(";yt" nil "$BFa(B") ("oyt" nil "$B=d(B") ("pyt" nil "$B;t(B")
	))

(if skk-tutcode-use-touch16+
    (setq skk-rom-kana-rule-list
	  (nconc '(("tld" nil "$B$Q(B") ("tle" nil "$B$T(B") ("tlr" nil "$B$W(B")
		   ("tlg" nil "$B$Z(B") ("tlf" nil "$B$](B") ("dlr" nil "$B$E(B")
		   ("alu" nil "$B%t(B") ("eld" nil "$B%u(B") ("elg" nil "$B%v(B"))
		 skk-rom-kana-rule-list)))

(provide 'skk-tutcdef)

;;; skk-tutcdef.el ends here
