# Local B table

This table lists all the entries of the local B table.  You can use them to
provide context information for a measured value.

Every entry is listed together with its measure unit, length in characters or
digits and description.

| Code   | Description                                                        | Unit               | Format         |
| ------ | ------------------------------------------------------------------ | ------------------ | -------------- |
| 001001 | WMO BLOCK NUMBER                                                   | Numeric                  | 2 digits       |
| 001002 | WMO STATION NUMBER                                                 | Numeric                  | 3 digits       |
| 001006 | AIRCRAFT FLIGHT NUMBER                                             | Character                | 8 chars        |
| 001007 | SATELLITE IDENTIFIER                                               | CODE TABLE 1007          | 3 chars        |
| 001008 | AIRCRAFT REGISTRATION NUMBER OR OTHER IDENTIFICATION               | Character                | 8 chars        |
| 001011 | SHIP OR MOBILE LAND STATION IDENTIFIER                             | Character                | 9 chars        |
| 001012 | DIRECTION OF MOTION OF MOVING OBSERVING PLATFORM**                 | DEGREE TRUE              | 3 digits       |
| 001013 | SPEED OF MOTION OF MOVING OBSERVING PLATFORM*                      | M/S                      | 3 digits       |
| 001019 | LONG STATION OR SITE NAME                                          | Character                | 32 chars       |
| 001023 | OBSERVATION SEQUENCE NUMBER                                        | Numeric                  | 3 digits       |
| 001033 | IDENTIFICATION OF ORIGINATING/GENERATING CENTRE                    | CODE TABLE 001033        | 3 chars        |
| 001034 | IDENTIFICATION OF ORIGINATING/GENERATING SUB-CENTRE                | CODE TABLE 001034        | 3 chars        |
| 001063 | ICAO LOCATION INDICATOR                                            | Character                | 8 chars        |
| 001192 | [SIM] MeteoDB station ID                                           | Numeric                  | 8 digits       |
| 001193 | [SIM] Report code                                                  | Numeric                  | 5 digits       |
| 001194 | [SIM] Report mnemonic                                              | Character                | 16 chars       |
| 001212 | AIR QUALITY OBSERVING STATION LOCAL CODE                           | Character                | 7 chars        |
| 001213 | AIRBASE AIR QUALITY OBSERVING STATION CODE                         | Character                | 7 chars        |
| 001214 | GEMS AIR QUALITY OBSERVING STATION CODE                            | Character                | 6 chars        |
| 001215 | AIR QUALITY OBSERVING STATION DOMINANT EMISSION SOURCE             | CODE TABLE 001215        | 1 chars        |
| 001216 | AIR QUALITY OBSERVING STATION AREA TYPE                            | CODE TABLE 001216        | 1 chars        |
| 001217 | AIR QUALITY OBSERVING STATION TERRAIN TYPE                         | CODE TABLE 001217        | 2 chars        |
| 002001 | TYPE OF STATION                                                    | CODE TABLE 2001          | 1 chars        |
| 002002 | TYPE OF INSTRUMENTATION FOR WIND MEASUREMENT                       | FLAG TABLE 2002          | 2 digits       |
| 002003 | TYPE OF MEASURING EQUIPMENT USED                                   | CODE TABLE 2003          | 2 chars        |
| 002004 | TYPE OF INSTRUMENTATION FOR EVAPORATION MEASUREMENT OR TYPE OF C   | CODE TABLE 2004          | 2 chars        |
| 002005 | PRECISION OF TEMPERATURE OBSERVATION                               | K                        | #.##           |
| 002011 | RADIOSONDE TYPE                                                    | CODE TABLE 2011          | 3 chars        |
| 002012 | RADIOSONDE COMPUTATIONAL METHOD                                    | CODE TABLE 2012          | 2 chars        |
| 002013 | SOLAR AND INFRARED RADIATION CORRECTION                            | CODE TABLE 2013          | 2 chars        |
| 002014 | TRACKING TECHNIQUE/STATUS OF SYSTEM USED                           | CODE TABLE 2014          | 3 chars        |
| 002038 | METHOD OF WATER TEMPERATURE AND/OR SALINITY MEASUREMENT            | CODE TABLE 2038          | 2 chars        |
| 002039 | METHOD OF WET-BULB TEMPERATURE MEASUREMENT                         | CODE TABLE 2039          | 1 chars        |
| 002048 | SATELLITE SENSOR INDICATOR                                         | CODE TABLE 2048          | 2 chars        |
| 002061 | AIRCRAFT NAVIGATIONAL SYSTEM                                       | CODE TABLE 2061          | 1 chars        |
| 002062 | TYPE OF AIRCRAFT DATA RELAY SYSTEM                                 | CODE TABLE 2062          | 2 chars        |
| 002063 | AIRCRAFT ROLL ANGLE                                                | DEGREE                   | ###.##         |
| 002064 | AIRCRAFT ROLL ANGLE QUALITY                                        | CODE TABLE 2064          | 1 chars        |
| 002070 | ORIGINAL SPECIFICATION OF LATITUDE/LONGITUDE                       | CODE TABLE 2070          | 2 chars        |
| 002121 | MEAN FREQUENCY                                                     | Hz                       | ###00000000    |
| 002125 | PULSE REPETITION FREQUENCY                                         | Hz                       | ###0           |
| 004001 | YEAR                                                               | YEAR                     | 4 digits       |
| 004002 | MONTH                                                              | MONTH                    | 2 digits       |
| 004003 | DAY                                                                | DAY                      | 2 digits       |
| 004004 | HOUR                                                               | HOUR                     | 2 digits       |
| 004005 | MINUTE                                                             | MINUTE                   | 2 digits       |
| 004006 | SECOND                                                             | SECOND                   | 2 digits       |
| 004086 | LONG TIME PERIOD OR DISPLACEMENT                                   | SECOND                   | 5 digits       |
| 004192 | [SIM] Time range type                                              | Numeric                  | 4 digits       |
| 004193 | [SIM] Time range P1                                                | Numeric                  | 10 digits      |
| 004194 | [SIM] Time range P2                                                | Numeric                  | 10 digits      |
| 004195 | [SIM] Temperature event - time of occurrence                       | MINUTE                   | 4 digits       |
| 004196 | [SIM] Relative humidity event - time of occurrence                 | MINUTE                   | 4 digits       |
| 004197 | [SIM] Wind velocity event - time of occurrence                     | MINUTE                   | 4 digits       |
| 004198 | [SIM] Pressure event - time of occurrence                          | MINUTE                   | 4 digits       |
| 005001 | LATITUDE (HIGH ACCURACY)                                           | DEGREE                   | ##.#####       |
| 005015 | LATITUDE DISPLACEMENT (HIGH ACCURACY)                              | DEGREE                   | ##.#####       |
| 005021 | BEARING OR AZIMUTH                                                 | DEGREE TRUE              | ###.##         |
| 005022 | SOLAR AZIMUTH                                                      | DEGREE TRUE              | ###.##         |
| 005040 | ORBIT NUMBER                                                       | Numeric                  | 8 digits       |
| 005041 | SCAN LINE NUMBER                                                   | Numeric                  | 3 digits       |
| 005043 | FIELD OF VIEW NUMBER                                               | Numeric                  | 3 digits       |
| 006001 | LONGITUDE (HIGH ACCURACY)                                          | DEGREE                   | ###.#####      |
| 006015 | LONGITUDE DISPLACEMENT (HIGH ACCURACY)                             | DEGREE                   | ###.#####      |
| 007002 | HEIGHT OR ALTITUDE                                                 | M                        | #####0         |
| 007004 | PRESSURE                                                           | PA                       | #####0         |
| 007007 | HEIGHT                                                             | M                        | 6 digits       |
| 007010 | FLIGHT LEVEL                                                       | FT                       | #####0         |
| 007024 | SATELLITE ZENITH ANGLE                                             | DEGREE                   | ###.##         |
| 007025 | SOLAR ZENITH ANGLE                                                 | DEGREE                   | ###.##         |
| 007030 | HEIGHT OF STATION GROUND ABOVE MEAN SEA LEVEL (SEE NOTE 3)         | M                        | ####.#         |
| 007031 | HEIGHT OF BAROMETER ABOVE MEAN SEA LEVEL (SEE NOTE 4)              | M                        | ####.#         |
| 007032 | HEIGHT OF SENSOR ABOVE LOCAL GROUND (OR DECK OF MARINE PLATFORM)   | M                        | ###.##         |
| 007192 | [SIM] First level type                                             | Numeric                  | 4 digits       |
| 007193 | [SIM] Level L1                                                     | Numeric                  | 10 digits      |
| 007194 | [SIM] Level L2                                                     | Numeric                  | 10 digits      |
| 007195 | [SIM] Second level type                                            | Numeric                  | 4 digits       |
| 008002 | VERTICAL SIGNIFICANCE (SURFACE OBSERVATIONS)                       | CODE TABLE 8002          | 2 chars        |
| 008004 | PHASE OF AIRCRAFT FLIGHT                                           | CODE TABLE 8004          | 1 chars        |
| 008009 | DETAILED PHASE OF FLIGHT                                           | CODE TABLE 8009          | 2 chars        |
| 008021 | TIME SIGNIFICANCE                                                  | CODE TABLE 8021          | 2 chars        |
| 008042 | EXTENDED VERTICAL SOUNDING SIGNIFICANCE                            | FLAG TABLE 8042          | 6 digits       |
| 008044 | (VAL) CAS REGISTRY NUMBER                                          | Character                | 11 chars       |
| 008192 | [SIM] Number of wind velocity mean values present                  | Numeric                  | 2 digits       |
| 008193 | [SIM] Number of wind velocity minimum values present               | Numeric                  | 2 digits       |
| 008194 | [SIM] Number of wind velocity maximum values present               | Numeric                  | 2 digits       |
| 008195 | [SIM] Number of wind prevalent direction values present            | Numeric                  | 2 digits       |
| 008196 | [SIM] Number of mean temperature values present                    | Numeric                  | 2 digits       |
| 008197 | [SIM] Number of minimum temperature values present                 | Numeric                  | 2 digits       |
| 008198 | [SIM] Number of maximum temperature values present                 | Numeric                  | 2 digits       |
| 008199 | [SIM] Number of mean relative humidity values present              | Numeric                  | 2 digits       |
| 008200 | [SIM] Number of minimum relative humidity values present           | Numeric                  | 2 digits       |
| 008201 | [SIM] Number of maximum relative humidity values present           | Numeric                  | 2 digits       |
| 008202 | [SIM] Number of mean pressure values present                       | Numeric                  | 2 digits       |
| 008203 | [SIM] Number of minimum pressure values present                    | Numeric                  | 2 digits       |
| 008204 | [SIM] Number of maximum pressure values present                    | Numeric                  | 2 digits       |
| 008205 | [SIM] Number of precipitation values present                       | Numeric                  | 2 digits       |
| 008206 | [SIM] Number of leaf wetness values present                        | Numeric                  | 2 digits       |
| 008207 | [SIM] Number of scalar wind velocity mean values present           | Numeric                  | 2 digits       |
| 008208 | [SIM] Number of cloud cover mean values present                    | Numeric                  | 2 digits       |
| 008209 | [SIM] Number of cloud cover maximum values present                 | Numeric                  | 2 digits       |
| 008210 | [SIM] Number of cloud cover minimum values present                 | Numeric                  | 2 digits       |
| 010004 | PRESSURE                                                           | PA                       | #####0         |
| 010007 | HEIGHT                                                             | M                        | 6 digits       |
| 010008 | GEOPOTENTIAL                                                       | M**2/S**2                | 7 digits       |
| 010009 | GEOPOTENTIAL HEIGHT                                                | GPM                      | 5 digits       |
| 010051 | PRESSURE REDUCED TO MEAN SEA LEVEL                                 | PA                       | #####0         |
| 010052 | ALTIMETER SETTING (QNH)                                            | PA                       | #####0         |
| 010060 | PRESSURE CHANGE                                                    | PA                       | ####0          |
| 010063 | CHARACTERISTIC OF PRESSURE TENDENCY                                | CODE TABLE 10063         | 2 chars        |
| 010197 | ANEMOMETER HEIGHT                                                  | M                        | 3 digits       |
| 011001 | WIND DIRECTION                                                     | DEGREE TRUE              | 3 digits       |
| 011002 | WIND SPEED                                                         | M/S                      | ###.#          |
| 011003 | U-COMPONENT                                                        | M/S                      | ###.#          |
| 011004 | V-COMPONENT                                                        | M/S                      | ###.#          |
| 011005 | W-COMPONENT                                                        | PA/S                     | ###.#          |
| 011006 | W-COMPONENT                                                        | M/S                      | ##.##          |
| 011016 | EXTREME COUNTERCLOCKWISE WIND DIRECTION OF A VARIABLE WIND         | DEGREE TRUE              | 3 digits       |
| 011017 | EXTREME CLOCKWISE WIND DIRECTION OF A VARIABLE WIND                | DEGREE TRUE              | 3 digits       |
| 011031 | DEGREE OF TURBULENCE                                               | CODE TABLE 11031         | 2 chars        |
| 011036 | MAXIMUM DERIVED EQUIVALENT VERTICAL GUST SPEED                     | M/S                      | ###.#          |
| 011037 | TURBULENCE INDEX                                                   | CODE TABLE 11037         | 2 chars        |
| 011039 | EXTENDED TIME OF OCCURRENCE OF PEAK  EDDY DISSIPATION RATE         | CODE TABLE 11039         | 2 chars        |
| 011041 | MAXIMUM WIND GUST SPEED                                            | M/S                      | ###.#          |
| 011043 | MAXIMUM WIND GUST DIRECTION                                        | DEGREE TRUE              | 3 digits       |
| 011050 | STANDARD DEVIATION OF HORIZONTAL WIND SPEED                        | M/S                      | ###.#          |
| 011061 | ABSOLUTE WIND SHEAR IN 1 KM LAYER BELOW                            | M/S                      | ###.#          |
| 011062 | ABSOLUTE WIND SHEAR IN 1 KM LAYER ABOVE                            | M/S                      | ###.#          |
| 011075 | MEAN TURBULENCE INTENSITY (EDDY DISSIPATION RATE)                  | M**(2/3)/S               | #.##           |
| 011076 | PEAK TURBULENCE INTENSITY (EDDY DISSIPATION RATE)                  | M**(2/3)/S               | #.##           |
| 011077 | REPORTING INTERVAL OR AVERAGING TIME FOR EDDY DISSIPATION RATE     | S                        | 4 digits       |
| 011192 | [SIM] W-component terrain following                                | M/S                      | ##.##          |
| 011193 | [SIM] Stability class                                              | Numeric                  | 2 digits       |
| 011194 | [SIM] Friction velocity (calmet)                                   | M/S                      | #.###          |
| 011195 | [SIM] Mixing height (calmet)                                       | M                        | 4 digits       |
| 011196 | [SIM] Obukov lenght (calmet)                                       | M                        | ####.#         |
| 011197 | [SIM] Convective velocitiy scale (calmet)                          | M/S                      | #.###          |
| 011198 | [SIM] SQRT(2*TKE)                                                  | M/S                      | ##.####        |
| 011199 | [SIM] Surface Roughness                                            | M                        | ###.#          |
| 011200 | [SIM] U-component of momentum flux                                 | N/M**2                   | ##.####        |
| 011201 | [SIM] V-component of momentum flux                                 | N/M**2                   | ##.####        |
| 011202 | [SIM] Friction velocity (diagmet)                                  | M/S                      | #.###          |
| 011203 | [SIM] Mixing height (diagmet)                                      | M                        | 4 digits       |
| 011204 | [SIM] Obukov lenght (diagmet)                                      | M                        | ####.#         |
| 011205 | [SIM] Convective velocitiy scale (diagmet)                         | M/S                      | #.###          |
| 011206 | [SIM] Friction velocity (COSMO)                                    | M/S                      | #.###          |
| 011207 | [SIM] Obukov lenght (COSMO)                                        | M                        | ####.#         |
| 011208 | [SIM] Distance covered by the hourly mean wind                     | M                        | 7 digits       |
| 012001 | TEMPERATURE/AIR TEMPERATURE                                        | C                        | ##.#           |
| 012003 | DEW-POINT TEMPERATURE                                              | C                        | ##.#           |
| 012030 | SOIL TEMPERATURE                                                   | C                        | ##.#           |
| 012049 | Temperature change over specified period                           | C                        | 2 digits       |
| 012061 | SKIN TEMPERATURE                                                   | K                        | ###.#          |
| 012063 | BRIGHTNESS TEMPERATURE                                             | K                        | ###.#          |
| 012101 | TEMPERATURE/DRY-BULB TEMPERATURE                                   | K                        | ###.##         |
| 012102 | WET-BULB TEMPERATURE                                               | C                        | ##.##          |
| 012103 | DEW-POINT TEMPERATURE                                              | K                        | ###.##         |
| 012121 | GROUND MINIMUM TEMPERATURE                                         | C                        | ##.##          |
| 012131 | SNOW TEMPERATURE                                                   | C                        | ##.##          |
| 012192 | POTENTIAL TEMPERATURE                                              | K                        | ###.##         |
| 012193 | PSEUDO-EQUIVALENT POTENTIAL TEMPERATURE                            | K                        | ###.##         |
| 012194 | [SIM] Air density                                                  | KG/M**3                  | .######        |
| 013001 | SPECIFIC HUMIDITY                                                  | KG/KG                    | .#####         |
| 013002 | MIXING RATIO                                                       | KG/KG                    | .#####         |
| 013003 | RELATIVE HUMIDITY                                                  | %                        | 3 digits       |
| 013011 | TOTAL PRECIPITATION / TOTAL WATER EQUIVALENT                       | KG/M**2                  | ####.#         |
| 013012 | DEPTH OF FRESH SNOW                                                | M                        | ##.##          |
| 013013 | TOTAL SNOW DEPTH                                                   | M                        | ###.###        |
| 013031 | EVAPOTRANSPIRATION                                                 | KG/M**2                  | 3 digits       |
| 013033 | EVAPORATION/EVAPOTRANSPIRATION                                     | KG/M**2                  | ###.#          |
| 013080 | WATER PH                                                           | pH                       | ##.#           |
| 013081 | WATER CONDUCTIVITY                                                 | S/M                      | #.###          |
| 013082 | WATER TEMPERATURE                                                  | K                        | ###.#          |
| 013083 | DISSOLVED OXYGEN                                                   | KG/M**3                  | .######        |
| 013192 | [SIM] Cloud liquid water content                                   | KG/KG                    | .########      |
| 013193 | [SIM] Cloud ice content                                            | KG/KG                    | .########      |
| 013194 | [SIM] Water table depth                                            | M                        | ###.###        |
| 013195 | [SIM] Precipitating liquid water                                   | KG/KG                    | .########      |
| 013196 | [SIM] Precipitating ice                                            | KG/KG                    | .########      |
| 013197 | [SIM] Total precipitating water+ice                                | KG/KG                    | .########      |
| 013198 | [SIM] Total liquid water (cloud+precipitating)                     | KG/KG                    | .########      |
| 013199 | [SIM] Total ice (cloud+precipitating)                              | KG/KG                    | .########      |
| 013200 | [SIM] Grid-scale liquid precipitation                              | KG/M**2                  | ####.#         |
| 013201 | [SIM] Grid-scale snowfall                                          | KG/M**2                  | ####.#         |
| 013202 | [SIM] Convective liquid precipitation                              | KG/M**2                  | ####.#         |
| 013203 | [SIM] Convective snowfall                                          | KG/M**2                  | ####.#         |
| 013204 | [SIM] Total convective precipitation (liquid + snow)               | KG/M**2                  | ####.#         |
| 013205 | [SIM] Snowfall (grid-scale + convective)                           | KG/M**2                  | ####.#         |
| 013206 | [SIM] Soil water content                                           | KG/M**2                  | ####.#         |
| 013210 | [SIM] Penetration of the probe in the snow                         | M                        | #.##           |
| 013212 | [SIM] Leaf wetness duration                                        | S                        | #######0       |
| 013215 | [SIM] River level                                                  | M                        | ####.##        |
| 013216 | [SIM] Hourly precipitation                                         | KG/M**2                  | ####.#         |
| 013217 | [SIM] 5 minutes precipitation                                      | KG/M**2                  | ####.#         |
| 013218 | [SIM] 10 minutes precipitation                                     | KG/M**2                  | ####.#         |
| 013219 | [SIM] 15 minutes precipitation                                     | KG/M**2                  | ####.#         |
| 013220 | [SIM] 20 minutes precipitation                                     | KG/M**2                  | ####.#         |
| 013221 | [SIM] 30 minutes precipitation                                     | KG/M**2                  | ####.#         |
| 013222 | [SIM] 180 minutes precipitation                                    | KG/M**2                  | ####.#         |
| 013223 | [SIM] 360 minutes precipitation                                    | KG/M**2                  | ####.#         |
| 013224 | [SIM] 720 minutes precipitation                                    | KG/M**2                  | ####.#         |
| 013225 | [SIM] 1440 minutes precipitation                                   | KG/M**2                  | ####.#         |
| 013226 | [SIM] River discharge                                              | M**3/S                   | #####.##       |
| 013227 | [SIM] Soil volumetric water content                                | %                        | ###.#          |
| 013228 | [SIM] Piezometric level                                            | M                        | ###.###        |
| 013229 | [SIM] Density of snow                                              | KG/M**3                  | ####.#         |
| 013230 | [SIM] Convective Available Potential Energy (CAPE)                 | J/KG                     | ####.#         |
| 013231 | [SIM] Ossigeno disciolto sat                                       | %                        | ###.#          |
| 014002 | Long-wave radiation, integrated over period specified              | J M-2                    | #####000       |
| 014004 | Short-wave radiation, integrated over period specified             | J M-2                    | #####000       |
| 014016 | NET RADIATION                                                      | J/M**2                   | #####0000      |
| 014017 | INSTANTANEOUS LONG-WAVE RADIATION (incoming)                       | W/M**2                   | 4 digits       |
| 014018 | INSTANTANEOUS SHORT-WAVE RADIATION (incoming)                      | W/M**2                   | ####000        |
| 014019 | SURFACE ALBEDO                                                     | %                        | 3 digits       |
| 014021 | GLOBAL SOLAR RADIATION, INTEGRATED OVER PERIOD SPECIFIED           | J/M**2                   | #####0000      |
| 014028 | Global solar radiation (high accuracy), integrated over period s   | J M-2                    | ######00       |
| 014029 | Diffuse solar radiation (high accuracy), integrated over period    | J M-2                    | ######00       |
| 014030 | Direct solar radiation (high accuracy), integrated over period s   | J M-2                    | ######00       |
| 014031 | TOTAL SUNSHINE                                                     | MINUTE                   | 4 digits       |
| 014192 | [SIM] Instantenous sensible heat flux                              | W/M**2                   | 4 digits       |
| 014193 | [SIM] Instantenous latent heat flux                                | W/M**2                   | 4 digits       |
| 014194 | [SIM] Instantenous direct solar radiation                          | W/M**2                   | ####000        |
| 014195 | [SIM] Instantenous diffuse solar radiation                         | W/M**2                   | ####000        |
| 014196 | [SIM] INSTANTANEOUS NET LONG-WAVE RADIATION                        | W/M**2                   | 4 digits       |
| 014197 | [SIM] INSTANTANEOUS NET SHORT-WAVE RADIATION                       | W/M**2                   | ####000        |
| 014198 | [SIM] Visible radiation (downward)                                 | W/M**2                   | ####.###       |
| 014199 | [SIM] Visible radiation (upward)                                   | W/M**2                   | ####.###       |
| 014200 | [SIM] Infrared radiation (downward)                                | W/M**2                   | ####.###       |
| 014201 | [SIM] Infrared radiation (upward)                                  | W/M**2                   | ####.###       |
| 015192 | [SIM] NO Concentration                                             | KG/M**3                  | .##########    |
| 015193 | [SIM] NO2 Concentration                                            | KG/M**3                  | .##########    |
| 015194 | [SIM] O3 Concentration                                             | KG/M**3                  | .##########    |
| 015195 | [SIM] PM10 Concentration                                           | KG/M**3                  | .##########    |
| 015196 | [SIM] CO Concentration                                             | KG/M**3                  | .##########    |
| 015197 | [SIM] SO2 Concentration                                            | KG/M**3                  | .##########    |
| 015198 | [SIM] PM2.5 Concentration                                          | KG/M**3                  | .##########    |
| 015199 | [SIM] NOY Concentration                                            | KG/M**3                  | .##########    |
| 015200 | [SIM] HCNM Concentration                                           | KG/M**3                  | .##########    |
| 015201 | [SIM] ALDE Concentration                                           | KG/M**3                  | .##########    |
| 015202 | [SIM] PM5 Concentration (tot. aerosol < 5 ug)                      | KG/M**3                  | .##########    |
| 015203 | [SIM] PM1 Concentration (tot. aerosol < 1.25 ug)                   | KG/M**3                  | .##########    |
| 015204 | [SIM] PM06 Concentration (tot. aerosol < 0.6 ug)                   | KG/M**3                  | .##########    |
| 015205 | [SIM] PM03 Concentration (tot. aerosol < 0.3 ug)                   | KG/M**3                  | .##########    |
| 015206 | [SIM] PM015 Concentration (tot. aerosol < 0.15 ug)                 | KG/M**3                  | .##########    |
| 015207 | [SIM] PM008 Concentration (tot. aerosol < 0.08 ug)                 | KG/M**3                  | .##########    |
| 015208 | [SIM] Concentration of primary particulate matter in PM10          | KG/M**3                  | .##########    |
| 015209 | [SIM] Concentration of sulfate in PM10                             | KG/M**3                  | .##########    |
| 015210 | [SIM] Concentration of nitrate in PM10                             | KG/M**3                  | .##########    |
| 015211 | [SIM] Concentration of ammonium in PM10                            | KG/M**3                  | .##########    |
| 015212 | [SIM] Concentration of black carbon in PM10                        | KG/M**3                  | .##########    |
| 015213 | [SIM] Concentration of organic carbon in PM10                      | KG/M**3                  | .##########    |
| 015214 | [SIM] Concentration of dust in PM10                                | KG/M**3                  | .##########    |
| 015215 | [SIM] Concentration of anthrop. A1D in PM10                        | KG/M**3                  | .##########    |
| 015216 | [SIM] Concentration of anthrop. BmP in PM10                        | KG/M**3                  | .##########    |
| 015217 | [SIM] Concentration of biogenic A1D in PM10                        | KG/M**3                  | .##########    |
| 015218 | [SIM] Concentration of biogenic BmP in PM10                        | KG/M**3                  | .##########    |
| 015219 | [SIM] Concentration of water in PM10                               | KG/M**3                  | .##########    |
| 015220 | [SIM] Concentration of sea salt in PM10                            | KG/M**3                  | .##########    |
| 015221 | [SIM] Concentration of secondary organic aerosol in PM10           | KG/M**3                  | .##########    |
| 015222 | [SIM] Total concentration of primary aerosol in PM10               | KG/M**3                  | .##########    |
| 015223 | [SIM] Total concentration of secondary aerosol in PM10             | KG/M**3                  | .##########    |
| 015224 | [SIM] Uncertainity in O3 estimate (Pesco)                          | KG/M**3                  | .##########    |
| 015225 | [SIM] Uncertainity in PM10 estimate (Pesco)                        | KG/M**3                  | .##########    |
| 015226 | [SIM] Uncertainity in NO2 estimate (Pesco)                         | KG/M**3                  | .##########    |
| 015227 | [SIM] Uncertainity in PM2.5 estimate (Pesco)                       | KG/M**3                  | .##########    |
| 015228 | [SIM] NH3 Concentration                                            | KG/M**3                  | .##########    |
| 015229 | [SIM] Concentration of primary part. matter in aerosol             | KG/M**3                  | .##########    |
| 015230 | [SIM] Concentration of sulfate in aerosol                          | KG/M**3                  | .##########    |
| 015231 | [SIM] Concentration of nitrate in aerosol                          | KG/M**3                  | .##########    |
| 015232 | [SIM] Concentration of ammonium in aerosol                         | KG/M**3                  | .##########    |
| 015233 | [SIM] Concentration of anthrop. sec. org. in aerosol               | KG/M**3                  | .##########    |
| 015234 | [SIM] Concentration of biogenic sec. org. in aerosol               | KG/M**3                  | .##########    |
| 015235 | [SIM] Concentration of ISOPA1 in PM10                              | KG/M**3                  | .##########    |
| 015236 | [SIM] C6H6 Concentration                                           | KG/M**3                  | .##########    |
| 015237 | [SIM] Concentration of anthropogenic aerosol in PM10               | KG/M**3                  | .##########    |
| 015238 | [SIM] Concentration of biogenic aerosol in PM10                    | KG/M**3                  | .##########    |
| 015239 | [SIM] Concentration of anthropogenic aerosol in PM2.5              | KG/M**3                  | .##########    |
| 015240 | [SIM] Concentration of biogenic aerosol in PM2.5                   | KG/M**3                  | .##########    |
| 015241 | [SIM] Aerosol Optical Thickness                                    | Numeric                  | #.####         |
| 020001 | HORIZONTAL VISIBILITY                                              | M                        | ####0          |
| 020003 | PRESENT WEATHER (SEE NOTE 1)                                       | CODE TABLE 20003         | 3 chars        |
| 020004 | PAST WEATHER (1) (SEE NOTE 2)                                      | CODE TABLE 20004         | 2 chars        |
| 020005 | PAST WEATHER (2) (SEE NOTE 2)                                      | CODE TABLE 20005         | 2 chars        |
| 020009 | GENERAL WEATHER INDICATOR (TAF/METAR)                              | CODE TABLE 20009         | 2 chars        |
| 020010 | CLOUD COVER (TOTAL)                                                | %                        | 3 digits       |
| 020011 | CLOUD AMOUNT                                                       | CODE TABLE 20011         | 2 chars        |
| 020012 | CLOUD TYPE                                                         | CODE TABLE 20012         | 2 chars        |
| 020013 | HEIGHT OF BASE OF CLOUD                                            | M                        | 5 digits       |
| 020017 | CLOUD TOP DESCRIPTION                                              | CODE TABLE 20017         | 2 chars        |
| 020019 | SIGNIFICANT PRESENT OR FORECAST WEATHER                            | Character                | 9 chars        |
| 020021 | TYPE OF PRECIPITATION                                              | FLAG TABLE 20021         | 10 digits      |
| 020031 | ICE DEPOSIT (THICKNESS)                                            | M                        | #.##           |
| 020032 | RATE OF ICE ACCRETION                                              | CODE TABLE 20032         | 1 chars        |
| 020033 | CAUSE OF ICE ACCRETION                                             | FLAG TABLE 20033         | 2 digits       |
| 020034 | SEA ICE CONCENTRATION                                              | CODE TABLE 20034         | 2 chars        |
| 020035 | AMOUNT AND TYPE OF ICE                                             | CODE TABLE 20035         | 2 chars        |
| 020036 | ICE SITUATION                                                      | CODE TABLE 20036         | 2 chars        |
| 020037 | ICE DEVELOPMENT                                                    | CODE TABLE 20037         | 2 chars        |
| 020038 | BEARING OF ICE EDGE (SEE NOTE 3)                                   | DEGREE TRUE              | 3 digits       |
| 020042 | AIRFRAME ICING PRESENT                                             | CODE TABLE 20042         | 1 chars        |
| 020043 | PEAK LIQUID WATER CONTENT                                          | KG/M**3                  | .####          |
| 020044 | AVERAGE LIQUID WATER CONTENT                                       | KG/M**3                  | .####          |
| 020045 | SUPERCOOLED LARGE DROPLET (SLD) CONDITIONS                         | CODE TABLE 20045         | 2 chars        |
| 020062 | STATE OF THE GROUND (WITH OR WITHOUT SNOW)                         | CODE TABLE 20062         | 2 chars        |
| 020192 | [SIM] Presence of rain > 1mm                                       | BOOLEAN                  | 1 digits       |
| 020193 | [SIM] Cloud type (METAR)                                           | Character                | 2 chars        |
| 020194 | [SIM] Presence of shower                                           | BOOLEAN                  | 1 digits       |
| 020195 | [SIM] Presence of hail                                             | BOOLEAN                  | 1 digits       |
| 020196 | [SIM] Presence of thunderstorm                                     | BOOLEAN                  | 1 digits       |
| 020197 | [SIM] Presence of snow                                             | BOOLEAN                  | 1 digits       |
| 020198 | [SIM] Presence of frost                                            | BOOLEAN                  | 1 digits       |
| 020199 | [SIM] Presence of dew                                              | BOOLEAN                  | 1 digits       |
| 020200 | [SIM] Presence of fog                                              | BOOLEAN                  | 1 digits       |
| 020201 | [SIM] Presence of water-spout                                      | BOOLEAN                  | 1 digits       |
| 020202 | [SIM] State of the ground with snow                                | CODE TABLE               | 2 chars        |
| 022001 | DIRECTION OF WAVES                                                 | DEGREE TRUE              | 3 digits       |
| 022002 | DIRECTION OF WIND WAVES                                            | DEGREE TRUE              | 3 digits       |
| 022003 | DIRECTION OF SWELL WAVES                                           | DEGREE TRUE              | 3 digits       |
| 022004 | DIRECTION OF CURRENT                                               | DEGREE TRUE              | 3 digits       |
| 022011 | PERIOD OF WAVES                                                    | S                        | 2 digits       |
| 022012 | PERIOD OF WIND WAVES                                               | S                        | 2 digits       |
| 022013 | PERIOD OF SWELL WAVES                                              | S                        | 2 digits       |
| 022021 | HEIGHT OF WAVES                                                    | M                        | ###.#          |
| 022022 | HEIGHT OF WIND WAVES                                               | M                        | ###.#          |
| 022023 | HEIGHT OF SWELL WAVES                                              | M                        | ###.#          |
| 022031 | SPEED OF CURRENT                                                   | M/S                      | ##.##          |
| 022032 | SPEED OF SEA SURFACE CURRENT                                       | M/S                      | ##.##          |
| 022037 | Tidal elevation with respect to national land datum                | M                        | ##.###         |
| 022038 | Tidal elevation with respect to local chart datum                  | M                        | ##.###         |
| 022043 | SEA/WATER TEMPERATURE                                              | K                        | ###.##         |
| 022049 | SEA-SURFACE TEMPERATURE                                            | K                        | ###.##         |
| 022062 | SALINITY                                                           | PART PER THOUSAND        | ###.##         |
| 022063 | TOTAL WATER DEPTH                                                  | M                        | 5 digits       |
| 022066 | WATER CONDUCTIVITY                                                 | S M-1                    | ##.######      |
| 022070 | SIGNIFICANT WAVE HEIGHT                                            | M                        | ##.##          |
| 022071 | SPECTRAL PEAK WAVE PERIOD                                          | S                        | ##.#           |
| 022073 | MAXIMUM WAVE HEIGHT                                                | M                        | ##.##          |
| 022074 | AVERAGE WAVE PERIOD                                                | S                        | ##.#           |
| 022192 | [SIM] Current X component                                          | M/S                      | ##.##          |
| 022193 | [SIM] Current Y component                                          | M/S                      | ##.##          |
| 022194 | [SIM] Concentrazione clorofilla a                                  | microg/l                 | ####.##        |
| 023192 | [SIM] Dry deposition of H2SO4                                      | MOL/M**3                 | #.#####        |
| 023193 | [SIM] Wet deposition of H2SO4                                      | MOL/M**3                 | #.#####        |
| 023194 | [SIM] Dry deposition of NH4                                        | MOL/M**3                 | #.#####        |
| 023195 | [SIM] Wet deposition of NH4                                        | MOL/M**3                 | #.#####        |
| 023196 | [SIM] Dry deposition of HNO3                                       | MOL/M**3                 | #.#####        |
| 023197 | [SIM] Wet deposition of HNO3                                       | MOL/M**3                 | #.#####        |
| 023198 | [SIM] Solid transport by river                                     | KG/S                     | ######.##      |
| 025076 | LOG-10 OF (TEMP-RAD CENTRAL WAVENUMBER) FOR ATOVS                  | LOGM-1                   | ##.########    |
| 029192 | [SIM] Land fraction                                                | %                        | ###.#          |
| 031000 | SHORT DELAYED DESCRIPTOR REPLICATION FACTOR                        | Numeric                  | 1 digits       |
| 031001 | DELAYED DESCRIPTOR REPLICATION FACTOR                              | Numeric                  | 3 digits       |
| 031002 | EXTENDED DELAYED DESCRIPTOR REPLICATION FACTOR                     | Numeric                  | 5 digits       |
| 031011 | DELAYED DESCRIPTOR AND DATA REPETITION FACTOR                      | Numeric                  | 3 digits       |
| 031012 | EXTENDED DELAYED DESCRIPTOR AND DATA REPETITION FACTOR             | Numeric                  | 5 digits       |
| 031021 | ASSOCIATED FIELD SIGNIFICANCE                                      | CODE TABLE 31021         | 2 chars        |
| 031031 | DATA PRESENT INDICATOR                                             | FLAG TABLE 31031         | 1 digits       |
| 033002 | QUALITY INFORMATION                                                | CODE TABLE 33002         | 1 chars        |
| 033003 | QUALITY INFORMATION                                                | CODE TABLE 33003         | 1 chars        |
| 033005 | QUALITY INFORMATION (AWS DATA)                                     | FLAG TABLE 33005         | 10 digits      |
| 033006 | INTERNAL MEASUREMENT STATUS INFORMATION (AWS)                      | CODE TABLE 33006         | 1 chars        |
| 033007 | PER CENT CONFIDENCE                                                | %                        | 3 digits       |
| 033015 | DATA QUALITY CHECK INDICATOR                                       | CODE TABLE 33015         | 2 chars        |
| 033020 | QUALITY CONTROL INDICATION OF FOLLOWING VALUE                      | CODE TABLE 33020         | 1 chars        |
| 033021 | QUALITY OF FOLLOWING VALUE                                         | CODE TABLE 33021         | 1 chars        |
| 033022 | QUALITY OF BUOY SATELLITE TRANSMISSION                             | CODE TABLE 33022         | 1 chars        |
| 033023 | QUALITY OF BUOY LOCATION                                           | CODE TABLE 33023         | 1 chars        |
| 033024 | STATION ELEVATION QUALITY MARK (FOR MOBILE STATIONS)               | CODE TABLE 33024         | 2 chars        |
| 033025 | ACARS INTERPOLATED VALUES                                          | CODE TABLE 33025         | 1 chars        |
| 033026 | MOISTURE QUALITY                                                   | CODE TABLE 33026         | 2 chars        |
| 033027 | LOCATION QUALITY CLASS (RANGE OF RADIUS OF 66 % CONFIDENCE)        | CODE TABLE 33027         | 1 chars        |
| 033030 | SCAN LINE STATUS FLAGS FOR ATOVS                                   | FLAG TABLE 33030         | 8 digits       |
| 033031 | SCAN LINE QUALITY FLAGS FOR ATOVS                                  | FLAG TABLE 33031         | 8 digits       |
| 033032 | CHANNEL QUALITY FLAGS FOR ATOVS                                    | FLAG TABLE 33032         | 8 digits       |
| 033033 | FIELD OF VIEW QUALITY FLAGS FOR ATOVS                              | FLAG TABLE 33033         | 8 digits       |
| 033035 | MANUAL/AUTOMATIC QUALITY CONTROL                                   | CODE TABLE 33035         | 2 chars        |
| 033036 | NOMINAL CONFIDENCE THRESHOLD                                       | %                        | 3 digits       |
| 033037 | WIND CORRELATION ERROR                                             | FLAG TABLE 33037         | 7 digits       |
| 033038 | QUALITY FLAGS FOR GROUND-BASED GNSS DATA                           | FLAG TABLE 33038         | 4 digits       |
| 033040 | CONFIDENCE INTERVAL                                                | PERCENT                  | 3 digits       |
| 033041 | ATTRIBUTE OF FOLLOWING VALUE                                       | CODE TABLE 33041         | 1 chars        |
| 033050 | GLOBAL GTSPP QUALITY FLAG                                          | CODE TABLE 33050         | 2 chars        |
| 033192 | [SIM] Climatological and consistency check                         | PERCENT                  | 3 digits       |
| 033193 | [SIM] Time consistency                                             | PERCENT                  | 3 digits       |
| 033194 | [SIM] Space consistency                                            | PERCENT                  | 3 digits       |
| 033195 | [SIM] MeteoDB variable ID                                          | Numeric                  | 8 digits       |
| 033196 | [SIM] Data has been invalidated                                    | CODE TABLE 33196         | 1 chars        |
| 033197 | [SIM] Manual replacement in substitution                           | CODE TABLE 33197         | 1 chars        |
| 033198 | [SIM] Observation increment                                        | Numeric                  | ######.####    |
| 033201 | [SIM] Kalman coefficient, state vector (s.v.) x1                   | Numeric                  | ######.####    |
| 033202 | [SIM] Kalman coefficient, state vector (s.v.) x2                   | Numeric                  | ######.####    |
| 033203 | [SIM] Kalman coefficient, s.v. error covariance matrix(1,1)        | Numeric                  | ######.####    |
| 033204 | [SIM] Kalman coefficient, s.v. error covariance matrix(1,2)        | Numeric                  | ######.####    |
| 033205 | [SIM] Kalman coefficient, s.v. error covariance matrix(2,1)        | Numeric                  | ######.####    |
| 033206 | [SIM] Kalman coefficient, s.v. error covariance matrix(2,2)        | Numeric                  | ######.####    |
| 033207 | [SIM] Kalman observation sequential counter                        | Numeric                  | 3 digits       |
| 033208 | [SIM] Kalman osservation missing counter                           | Numeric                  | 3 digits       |
| 033209 | [SIM] Normalized Density Index                                     | PERCENT                  | 3 digits       |
| 048001 | [SIM] Graminacee_Graminacee indistinte                             | POLLEN/M**3              | #######.#      |
| 048002 | [SIM] Betulacee_Ontano nero                                        | POLLEN/M**3              | #######.#      |
| 048003 | [SIM] Betulacee_Betulla                                            | POLLEN/M**3              | #######.#      |
| 048004 | [SIM] Betulacee_Betulacee indistinte                               | POLLEN/M**3              | #######.#      |
| 048005 | [SIM] Composite_Ambrosia                                           | POLLEN/M**3              | #######.#      |
| 048006 | [SIM] Composite_Artemisia                                          | POLLEN/M**3              | #######.#      |
| 048007 | [SIM] Composite_Composite indistinte                               | POLLEN/M**3              | #######.#      |
| 048008 | [SIM] Corilacee_Nocciolo                                           | POLLEN/M**3              | #######.#      |
| 048009 | [SIM] Corilacee_Carpino bianco -Carpino nero                       | POLLEN/M**3              | #######.#      |
| 048010 | [SIM] Corilacee_Corilacee indistinte                               | POLLEN/M**3              | #######.#      |
| 048011 | [SIM] Fagacee_Castagno                                             | POLLEN/M**3              | #######.#      |
| 048012 | [SIM] Fagacee_Faggio                                               | POLLEN/M**3              | #######.#      |
| 048013 | [SIM] Fagacee_Quercia                                              | POLLEN/M**3              | #######.#      |
| 048014 | [SIM] Fagacee_Fagacee indistinte                                   | POLLEN/M**3              | #######.#      |
| 048015 | [SIM] Oleacee_Olivo                                                | POLLEN/M**3              | #######.#      |
| 048016 | [SIM] Oleacee_Frassino                                             | POLLEN/M**3              | #######.#      |
| 048017 | [SIM] Oleacee_Oleacee indistinte                                   | POLLEN/M**3              | #######.#      |
| 048018 | [SIM] Plantaginacee_Plantaginacee indistinte                       | POLLEN/M**3              | #######.#      |
| 048019 | [SIM] Urticacee_Urticacee indistinte                               | POLLEN/M**3              | #######.#      |
| 048020 | [SIM] Cupressacee - Taxacee indistinte_Cipresso comune             | POLLEN/M**3              | #######.#      |
| 048021 | [SIM] Cupressacee - Taxacee indistinte_Cupressacee - Taxacee ind   | POLLEN/M**3              | #######.#      |
| 048022 | [SIM] Chenopodiacee - Amarantacee Indistinte_Amaranto              | POLLEN/M**3              | #######.#      |
| 048023 | [SIM] Chenopodiacee - Amarantacee Indistinte_Chenopodiacee - Ama   | POLLEN/M**3              | #######.#      |
| 048024 | [SIM] Poligonacee_Poligonacee indistinte                           | POLLEN/M**3              | #######.#      |
| 048025 | [SIM] Euphorbiacee_Euforbiacee indistinte                          | POLLEN/M**3              | #######.#      |
| 048026 | [SIM] Mirtacee_Mirtacee indistinte                                 | POLLEN/M**3              | #######.#      |
| 048027 | [SIM] Ulmacee_Bagolaro comune                                      | POLLEN/M**3              | #######.#      |
| 048028 | [SIM] Ulmacee_Olmo campestre                                       | POLLEN/M**3              | #######.#      |
| 048029 | [SIM] Ulmacee_Ulmacee indistinte                                   | POLLEN/M**3              | #######.#      |
| 048030 | [SIM] Platanacee_Platanacee indistinte                             | POLLEN/M**3              | #######.#      |
| 048031 | [SIM] Aceraceae_Aceracee indistinte                                | POLLEN/M**3              | #######.#      |
| 048032 | [SIM] Pinacee_Pinacee indistinte                                   | POLLEN/M**3              | #######.#      |
| 048033 | [SIM] Salicacee_Salice comune                                      | POLLEN/M**3              | #######.#      |
| 048034 | [SIM] Salicacee_Pioppo                                             | POLLEN/M**3              | #######.#      |
| 048035 | [SIM] Salicacee_Salicacee indistinte                               | POLLEN/M**3              | #######.#      |
| 048036 | [SIM] Ciperacee_Ciperacee indistinte                               | POLLEN/M**3              | #######.#      |
| 048037 | [SIM] Juglandacee_Juglandacee indistinte                           | POLLEN/M**3              | #######.#      |
| 048038 | [SIM] Ippocastanacee_Ippocastanacee indistinte                     | POLLEN/M**3              | #######.#      |
| 048039 | [SIM] Spore fungine_Alternaria                                     | POLLEN/M**3              | #######.#      |
| 048040 | [SIM] Spore fungine_Botrytis                                       | POLLEN/M**3              | #######.#      |
| 048041 | [SIM] Spore fungine_Stemphylium                                    | POLLEN/M**3              | #######.#      |
| 048042 | [SIM] Spore fungine_Cladosporium                                   | POLLEN/M**3              | #######.#      |
| 048043 | [SIM] Spore fungine_Epicoccum                                      | POLLEN/M**3              | #######.#      |
| 048044 | [SIM] Altri Pollini / Non Identificati_Altri pollini identificat   | POLLEN/M**3              | #######.#      |
| 048045 | [SIM] Altri Pollini / Non Identificati_Pollini non identificati    | POLLEN/M**3              | #######.#      |
| 048046 | [SIM] Altre Spore / Non identificati_Altre spore fungine           | POLLEN/M**3              | #######.#      |
| 048047 | [SIM] Altre Spore / Non identificati_Spore fungine non identific   | POLLEN/M**3              | #######.#      |
| 048048 | [SIM] Graminacee_Graminacee indistinte 1                           | POLLEN/M**3              | #######.#      |
| 048049 | [SIM] Plantaginacee_Plantaginacee indistinte 1                     | POLLEN/M**3              | #######.#      |
| 048050 | [SIM] Urticacee_Urticacee indistinte 1                             | POLLEN/M**3              | #######.#      |
| 048051 | [SIM] Poligonacee_Poligonacee indistinte 1                         | POLLEN/M**3              | #######.#      |
| 048052 | [SIM] Euphorbiacee_Euforbiacee indistinte 1                        | POLLEN/M**3              | #######.#      |
| 048053 | [SIM] Mirtacee_Mirtacee indistinte 1                               | POLLEN/M**3              | #######.#      |
| 048054 | [SIM] Platanacee_Platanacee indistinte 1                           | POLLEN/M**3              | #######.#      |
| 048055 | [SIM] Aceraceae_Aceracee indistinte 1                              | POLLEN/M**3              | #######.#      |
| 048056 | [SIM] Pinacee_Pinacee indistinte 1                                 | POLLEN/M**3              | #######.#      |
| 048057 | [SIM] Ciperacee_Ciperacee indistinte 1                             | POLLEN/M**3              | #######.#      |
| 048058 | [SIM] Juglandacee_Juglandacee indistinte 1                         | POLLEN/M**3              | #######.#      |
| 048059 | [SIM] Ippocastanacee_Ippocastanacee indistinte 1                   | POLLEN/M**3              | #######.#      |
| 048060 | [SIM] Oleacee_Ligustro                                             | POLLEN/M**3              | #######.#      |
| 048128 | [SIM] Conta Graminacee_Graminacee indistinte                       | Numeric                  | 7 digits       |
| 048129 | [SIM] Conta Betulacee_Ontano nero                                  | Numeric                  | 7 digits       |
| 048130 | [SIM] Conta Betulacee_Betulla                                      | Numeric                  | 7 digits       |
| 048131 | [SIM] Conta Betulacee_Betulacee indistinte                         | Numeric                  | 7 digits       |
| 048132 | [SIM] Conta Composite_Ambrosia                                     | Numeric                  | 7 digits       |
| 048133 | [SIM] Conta Composite_Artemisia                                    | Numeric                  | 7 digits       |
| 048134 | [SIM] Conta Composite_Composite indistinte                         | Numeric                  | 7 digits       |
| 048135 | [SIM] Conta Corilacee_Nocciolo                                     | Numeric                  | 7 digits       |
| 048136 | [SIM] Conta Corilacee_Carpino bianco -Carpino nero                 | Numeric                  | 7 digits       |
| 048137 | [SIM] Conta Corilacee_Corilacee indistinte                         | Numeric                  | 7 digits       |
| 048138 | [SIM] Conta Fagacee_Castagno                                       | Numeric                  | 7 digits       |
| 048139 | [SIM] Conta Fagacee_Faggio                                         | Numeric                  | 7 digits       |
| 048140 | [SIM] Conta Fagacee_Quercia                                        | Numeric                  | 7 digits       |
| 048141 | [SIM] Conta Fagacee_Fagacee indistinte                             | Numeric                  | 7 digits       |
| 048142 | [SIM] Conta Oleacee_Olivo                                          | Numeric                  | 7 digits       |
| 048143 | [SIM] Conta Oleacee_Frassino                                       | Numeric                  | 7 digits       |
| 048144 | [SIM] Conta Oleacee_Oleacee indistinte                             | Numeric                  | 7 digits       |
| 048145 | [SIM] Conta Plantaginacee_Plantaginacee indistinte                 | Numeric                  | 7 digits       |
| 048146 | [SIM] Conta Urticacee_Urticacee indistinte                         | Numeric                  | 7 digits       |
| 048147 | [SIM] Conta Cupressacee - Taxacee indistinte_Cipresso comune       | Numeric                  | 7 digits       |
| 048148 | [SIM] Conta Cupressacee - Taxacee indistinte_Cupressacee - Taxac   | Numeric                  | 7 digits       |
| 048149 | [SIM] Conta Chenopodiacee - Amarantacee Indistinte_Amaranto        | Numeric                  | 7 digits       |
| 048150 | [SIM] Conta Chenopodiacee - Amarantacee Indistinte_Chenopodiacee   | Numeric                  | 7 digits       |
| 048151 | [SIM] Conta Poligonacee_Poligonacee indistinte                     | Numeric                  | 7 digits       |
| 048152 | [SIM] Conta Euphorbiacee_Euforbiacee indistinte                    | Numeric                  | 7 digits       |
| 048153 | [SIM] Conta Mirtacee_Mirtacee indistinte                           | Numeric                  | 7 digits       |
| 048154 | [SIM] Conta Ulmacee_Bagolaro comune                                | Numeric                  | 7 digits       |
| 048155 | [SIM] Conta Ulmacee_Olmo campestre                                 | Numeric                  | 7 digits       |
| 048156 | [SIM] Conta Ulmacee_Ulmacee indistinte                             | Numeric                  | 7 digits       |
| 048157 | [SIM] Conta Platanacee_Platanacee indistinte                       | Numeric                  | 7 digits       |
| 048158 | [SIM] Conta Aceraceae_Aceracee indistinte                          | Numeric                  | 7 digits       |
| 048159 | [SIM] Conta Pinacee_Pinacee indistinte                             | Numeric                  | 7 digits       |
| 048160 | [SIM] Conta Salicacee_Salice comune                                | Numeric                  | 7 digits       |
| 048161 | [SIM] Conta Salicacee_Pioppo                                       | Numeric                  | 7 digits       |
| 048162 | [SIM] Conta Salicacee_Salicacee indistinte                         | Numeric                  | 7 digits       |
| 048163 | [SIM] Conta Ciperacee_Ciperacee indistinte                         | Numeric                  | 7 digits       |
| 048164 | [SIM] Conta Juglandacee_Juglandacee indistinte                     | Numeric                  | 7 digits       |
| 048165 | [SIM] Conta Ippocastanacee_Ippocastanacee indistinte               | Numeric                  | 7 digits       |
| 048166 | [SIM] Conta Spore fungine_Alternaria                               | Numeric                  | 7 digits       |
| 048167 | [SIM] Conta Spore fungine_Botrytis                                 | Numeric                  | 7 digits       |
| 048168 | [SIM] Conta Spore fungine_Stemphylium                              | Numeric                  | 7 digits       |
| 048169 | [SIM] Conta Spore fungine_Cladosporium                             | Numeric                  | 7 digits       |
| 048170 | [SIM] Conta Spore fungine_Epicoccum                                | Numeric                  | 7 digits       |
| 048171 | [SIM] Conta Altri Pollini / Non Identificati_Altri pollini ident   | Numeric                  | 7 digits       |
| 048172 | [SIM] Conta Altri Pollini / Non Identificati_Pollini non identif   | Numeric                  | 7 digits       |
| 048173 | [SIM] Conta Altre Spore / Non identificati_Altre spore fungine     | Numeric                  | 7 digits       |
| 048174 | [SIM] Conta Altre Spore / Non identificati_Spore fungine non ide   | Numeric                  | 7 digits       |
| 048175 | [SIM] Conta Graminacee_Graminacee indistinte 1                     | Numeric                  | 7 digits       |
| 048176 | [SIM] Conta Plantaginacee_Plantaginacee indistinte 1               | Numeric                  | 7 digits       |
| 048177 | [SIM] Conta Urticacee_Urticacee indistinte 1                       | Numeric                  | 7 digits       |
| 048178 | [SIM] Conta Poligonacee_Poligonacee indistinte 1                   | Numeric                  | 7 digits       |
| 048179 | [SIM] Conta Euphorbiacee_Euforbiacee indistinte 1                  | Numeric                  | 7 digits       |
| 048180 | [SIM] Conta Mirtacee_Mirtacee indistinte 1                         | Numeric                  | 7 digits       |
| 048181 | [SIM] Conta Platanacee_Platanacee indistinte 1                     | Numeric                  | 7 digits       |
| 048182 | [SIM] Conta Aceraceae_Aceracee indistinte 1                        | Numeric                  | 7 digits       |
| 048183 | [SIM] Conta Pinacee_Pinacee indistinte 1                           | Numeric                  | 7 digits       |
| 048184 | [SIM] Conta Ciperacee_Ciperacee indistinte 1                       | Numeric                  | 7 digits       |
| 048185 | [SIM] Conta Juglandacee_Juglandacee indistinte 1                   | Numeric                  | 7 digits       |
| 048186 | [SIM] Conta Ippocastanacee_Ippocastanacee indistinte 1             | Numeric                  | 7 digits       |
| 048187 | [SIM] Conta Oleacee_Ligustro                                       | Numeric                  | 7 digits       |
