if(DEFINED RAWSPEED_CACHELINESIZE)
  return()
endif()

message(STATUS "Trying to query CPU L1d cache line size")

if(BINARY_PACKAGE_BUILD)
  message(STATUS "Performing binary package build, using hardcoded value.")
else()
  try_run(RAWSPEED_CACHELINESIZE_EXITCODE RAWSPEED_CACHELINESIZE_COMPILED
    "${CMAKE_BINARY_DIR}"
    "${CMAKE_CURRENT_LIST_DIR}/cpu-cache-line-size.cpp"
    COMPILE_OUTPUT_VARIABLE  RAWSPEED_CACHELINESIZE_COMPILE_OUTPUT
    RUN_OUTPUT_VARIABLE RAWSPEED_CACHELINESIZE_RUN_OUTPUT)

  if(NOT RAWSPEED_CACHELINESIZE_COMPILED OR NOT RAWSPEED_CACHELINESIZE_EXITCODE EQUAL 0)
    message(SEND_ERROR "Failed to query CPU L1d cache line size:\n${RAWSPEED_CACHELINESIZE_COMPILE_OUTPUT}\n${RAWSPEED_CACHELINESIZE_RUN_OUTPUT}")
    return()
  endif()

  string(STRIP "${RAWSPEED_CACHELINESIZE_RUN_OUTPUT}" RAWSPEED_CACHELINESIZE)

  if(RAWSPEED_CACHELINESIZE EQUAL 0)
    message(WARNING "Detected CPU L1d cache line size is zero! Falling back to hardcoded value.")
    unset(RAWSPEED_CACHELINESIZE)
  endif()
endif()

if(NOT DEFINED RAWSPEED_CACHELINESIZE)
  set(RAWSPEED_CACHELINESIZE 64)
endif()

set(RAWSPEED_CACHELINESIZE ${RAWSPEED_CACHELINESIZE} CACHE INTERNAL "")
message(STATUS "Deciding that the CPU L1d cache line size is ${RAWSPEED_CACHELINESIZE} bytes")
