#include "sys"
#include "../config/config"

void socketclose (int fd) {
    PROFILE("socketclose");

    if (fd > 2) {
	debugmsg ((Mstr("Closing socket ") + fd) + "\n");

	if (config.fastclose()) {
	    struct linger l;
	    l.l_onoff = 1;
	    l.l_linger = 2;
	    setsockopt (fd, SOL_SOCKET, SO_LINGER, &l, sizeof(l));
	}
	shutdown(fd, SHUT_RDWR);
	close(fd);
    }
}
