<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2017                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2017
 *
 * Generated from xml/schema/CRM/Contact/GroupContact.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:2545d3926c711a25b5075a6ac980ed99)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
/**
 * CRM_Contact_DAO_GroupContact constructor.
 */
class CRM_Contact_DAO_GroupContact extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_group_contact';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * primary key
   *
   * @var int unsigned
   */
  public $id;
  /**
   * FK to civicrm_group
   *
   * @var int unsigned
   */
  public $group_id;
  /**
   * FK to civicrm_contact
   *
   * @var int unsigned
   */
  public $contact_id;
  /**
   * status of contact relative to membership in group
   *
   * @var string
   */
  public $status;
  /**
   * Optional location to associate with this membership
   *
   * @var int unsigned
   */
  public $location_id;
  /**
   * Optional email to associate with this membership
   *
   * @var int unsigned
   */
  public $email_id;
  /**
   * Class constructor.
   */
  function __construct() {
    $this->__table = 'civicrm_group_contact';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'group_id', 'civicrm_group', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'contact_id', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'location_id', 'civicrm_loc_block', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'email_id', 'civicrm_email', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Group Contact ID') ,
          'description' => 'primary key',
          'required' => true,
          'table_name' => 'civicrm_group_contact',
          'entity' => 'GroupContact',
          'bao' => 'CRM_Contact_BAO_GroupContact',
          'localizable' => 0,
        ) ,
        'group_id' => array(
          'name' => 'group_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Group ID') ,
          'description' => 'FK to civicrm_group',
          'required' => true,
          'table_name' => 'civicrm_group_contact',
          'entity' => 'GroupContact',
          'bao' => 'CRM_Contact_BAO_GroupContact',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Group',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_group',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
          )
        ) ,
        'contact_id' => array(
          'name' => 'contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contact ID') ,
          'description' => 'FK to civicrm_contact',
          'required' => true,
          'table_name' => 'civicrm_group_contact',
          'entity' => 'GroupContact',
          'bao' => 'CRM_Contact_BAO_GroupContact',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
        ) ,
        'status' => array(
          'name' => 'status',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Group Contact Status') ,
          'description' => 'status of contact relative to membership in group',
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'table_name' => 'civicrm_group_contact',
          'entity' => 'GroupContact',
          'bao' => 'CRM_Contact_BAO_GroupContact',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'callback' => 'CRM_Core_SelectValues::groupContactStatus',
          )
        ) ,
        'location_id' => array(
          'name' => 'location_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Group Contact Location') ,
          'description' => 'Optional location to associate with this membership',
          'table_name' => 'civicrm_group_contact',
          'entity' => 'GroupContact',
          'bao' => 'CRM_Contact_BAO_GroupContact',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_LocBlock',
        ) ,
        'email_id' => array(
          'name' => 'email_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Group Contact Email') ,
          'description' => 'Optional email to associate with this membership',
          'table_name' => 'civicrm_group_contact',
          'entity' => 'GroupContact',
          'bao' => 'CRM_Contact_BAO_GroupContact',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_Email',
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'group_contact', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'group_contact', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = array(
      'UI_contact_group' => array(
        'name' => 'UI_contact_group',
        'field' => array(
          0 => 'contact_id',
          1 => 'group_id',
        ) ,
        'localizable' => false,
        'unique' => true,
        'sig' => 'civicrm_group_contact::1::contact_id::group_id',
      ) ,
    );
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }
}
