{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetCreateParticles: Boolean;
    procedure SetCreateParticles(const Value: Boolean);
    function GetEnabled: Boolean;
    procedure SetEnabled(const Value: Boolean);
    function GetLifetimeVariation: Single;
    procedure SetLifetimeVariation(const Value: Single);
    function GetMaxParticles: Integer;
    procedure SetMaxParticles(const Value: Integer);
    function GetParticleLifetime: Single;
    procedure SetParticleLifetime(const Value: Single);
    function GetParticleSize: TVector2;
    procedure SetParticleSize(const Value: TVector2);
    function GetColorRamp: TAbstractColorNode;
    procedure SetColorRamp(const Value: TAbstractColorNode);
    function GetEmitter: TAbstractParticleEmitterNode;
    procedure SetEmitter(const Value: TAbstractParticleEmitterNode);
    function GetGeometryType: TParticlesGeometry;
    procedure SetGeometryType(const Value: TParticlesGeometry);
    function GetTexCoordRamp: TTextureCoordinateNode;
    procedure SetTexCoordRamp(const Value: TTextureCoordinateNode);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdCreateParticles: TSFBool;
    { Internal wrapper for property @link(CreateParticles). This wrapper API may change, we advise to access simpler @link(CreateParticles) instead. }
    public property FdCreateParticles: TSFBool read FFdCreateParticles;
    {  }
    property CreateParticles: Boolean read GetCreateParticles write SetCreateParticles;

    strict private FFdEnabled: TSFBool;
    { Internal wrapper for property @link(Enabled). This wrapper API may change, we advise to access simpler @link(Enabled) instead. }
    public property FdEnabled: TSFBool read FFdEnabled;
    {  }
    property Enabled: Boolean read GetEnabled write SetEnabled;

    strict private FFdLifetimeVariation: TSFFloat;
    { Internal wrapper for property @link(LifetimeVariation). This wrapper API may change, we advise to access simpler @link(LifetimeVariation) instead. }
    public property FdLifetimeVariation: TSFFloat read FFdLifetimeVariation;
    {  }
    property LifetimeVariation: Single read GetLifetimeVariation write SetLifetimeVariation;

    strict private FFdMaxParticles: TSFInt32;
    { Internal wrapper for property @link(MaxParticles). This wrapper API may change, we advise to access simpler @link(MaxParticles) instead. }
    public property FdMaxParticles: TSFInt32 read FFdMaxParticles;
    {  }
    property MaxParticles: Integer read GetMaxParticles write SetMaxParticles;

    strict private FFdParticleLifetime: TSFFloat;
    { Internal wrapper for property @link(ParticleLifetime). This wrapper API may change, we advise to access simpler @link(ParticleLifetime) instead. }
    public property FdParticleLifetime: TSFFloat read FFdParticleLifetime;
    {  }
    property ParticleLifetime: Single read GetParticleLifetime write SetParticleLifetime;

    strict private FFdParticleSize: TSFVec2f;
    { Internal wrapper for property @link(ParticleSize). This wrapper API may change, we advise to access simpler @link(ParticleSize) instead. }
    public property FdParticleSize: TSFVec2f read FFdParticleSize;
    {  }
    property ParticleSize: TVector2 read GetParticleSize write SetParticleSize;

    strict private FEventIsActive: TSFBoolEvent;
    {  }
    public property EventIsActive: TSFBoolEvent read FEventIsActive;

    strict private FFdColorRamp: TSFNode;
    { Internal wrapper for property @link(ColorRamp). This wrapper API may change, we advise to access simpler @link(ColorRamp) instead. }
    public property FdColorRamp: TSFNode read FFdColorRamp;
    {  }
    property ColorRamp: TAbstractColorNode read GetColorRamp write SetColorRamp;

    strict private FFdColorKey: TMFFloat;
    { Internal wrapper for property @link(ColorKey). This wrapper API may change, we advise to access simpler @link(ColorKey) instead. }
    public property FdColorKey: TMFFloat read FFdColorKey;
    {  }
    procedure SetColorKey(const Value: array of Single); overload;
    {  }
    procedure SetColorKey(const Value: TSingleList); overload;

    strict private FFdEmitter: TSFNode;
    { Internal wrapper for property @link(Emitter). This wrapper API may change, we advise to access simpler @link(Emitter) instead. }
    public property FdEmitter: TSFNode read FFdEmitter;
    {  }
    property Emitter: TAbstractParticleEmitterNode read GetEmitter write SetEmitter;

    strict private FFdGeometryType: TSFStringEnum;
    { Internal wrapper for property @link(GeometryType). This wrapper API may change, we advise to access simpler @link(GeometryType) instead. }
    public property FdGeometryType: TSFStringEnum read FFdGeometryType;
    {  }
    property GeometryType: TParticlesGeometry read GetGeometryType write SetGeometryType;

    strict private FFdPhysics: TMFNode;
    { Internal wrapper for property @link(Physics). This wrapper API may change, we advise to access simpler @link(Physics) instead. }
    public property FdPhysics: TMFNode read FFdPhysics;
    {  }
    procedure SetPhysics(const Value: array of TAbstractParticlePhysicsModelNode);

    strict private FFdTexCoordRamp: TSFNode;
    { Internal wrapper for property @link(TexCoordRamp). This wrapper API may change, we advise to access simpler @link(TexCoordRamp) instead. }
    public property FdTexCoordRamp: TSFNode read FFdTexCoordRamp;
    {  }
    property TexCoordRamp: TTextureCoordinateNode read GetTexCoordRamp write SetTexCoordRamp;

    strict private FFdTexCoordKey: TMFFloat;
    { Internal wrapper for property @link(TexCoordKey). This wrapper API may change, we advise to access simpler @link(TexCoordKey) instead. }
    public property FdTexCoordKey: TMFFloat read FFdTexCoordKey;
    {  }
    procedure SetTexCoordKey(const Value: array of Single); overload;
    {  }
    procedure SetTexCoordKey(const Value: TSingleList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TParticleSystemNode ----------------------------------------------- }

function TParticleSystemNode.GetCreateParticles: Boolean;
begin
  Result := FdCreateParticles.Value;
end;

procedure TParticleSystemNode.SetCreateParticles(const Value: Boolean);
begin
  FdCreateParticles.Send(Value);
end;

function TParticleSystemNode.GetEnabled: Boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TParticleSystemNode.SetEnabled(const Value: Boolean);
begin
  FdEnabled.Send(Value);
end;

function TParticleSystemNode.GetLifetimeVariation: Single;
begin
  Result := FdLifetimeVariation.Value;
end;

procedure TParticleSystemNode.SetLifetimeVariation(const Value: Single);
begin
  FdLifetimeVariation.Send(Value);
end;

function TParticleSystemNode.GetMaxParticles: Integer;
begin
  Result := FdMaxParticles.Value;
end;

procedure TParticleSystemNode.SetMaxParticles(const Value: Integer);
begin
  FdMaxParticles.Send(Value);
end;

function TParticleSystemNode.GetParticleLifetime: Single;
begin
  Result := FdParticleLifetime.Value;
end;

procedure TParticleSystemNode.SetParticleLifetime(const Value: Single);
begin
  FdParticleLifetime.Send(Value);
end;

function TParticleSystemNode.GetParticleSize: TVector2;
begin
  Result := FdParticleSize.Value;
end;

procedure TParticleSystemNode.SetParticleSize(const Value: TVector2);
begin
  FdParticleSize.Send(Value);
end;

function TParticleSystemNode.GetColorRamp: TAbstractColorNode;
begin
  if FdColorRamp.Value is TAbstractColorNode then
    Result := TAbstractColorNode(FdColorRamp.Value)
  else
    Result := nil;
end;

procedure TParticleSystemNode.SetColorRamp(const Value: TAbstractColorNode);
begin
  FdColorRamp.Send(Value);
end;

procedure TParticleSystemNode.SetColorKey(const Value: array of Single);
begin
  FdColorKey.Send(Value);
end;

procedure TParticleSystemNode.SetColorKey(const Value: TSingleList);
begin
  FdColorKey.Send(Value);
end;

function TParticleSystemNode.GetEmitter: TAbstractParticleEmitterNode;
begin
  if FdEmitter.Value is TAbstractParticleEmitterNode then
    Result := TAbstractParticleEmitterNode(FdEmitter.Value)
  else
    Result := nil;
end;

procedure TParticleSystemNode.SetEmitter(const Value: TAbstractParticleEmitterNode);
begin
  FdEmitter.Send(Value);
end;

function TParticleSystemNode.GetGeometryType: TParticlesGeometry;
begin
  Result := TParticlesGeometry(FdGeometryType.EnumValue);
end;

procedure TParticleSystemNode.SetGeometryType(const Value: TParticlesGeometry);
begin
  FdGeometryType.SendEnumValue(Ord(Value));
end;

procedure TParticleSystemNode.SetPhysics(const Value: array of TAbstractParticlePhysicsModelNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractParticlePhysicsModelNode));
  FdPhysics.Send(A);
end;

function TParticleSystemNode.GetTexCoordRamp: TTextureCoordinateNode;
begin
  if FdTexCoordRamp.Value is TTextureCoordinateNode then
    Result := TTextureCoordinateNode(FdTexCoordRamp.Value)
  else
    Result := nil;
end;

procedure TParticleSystemNode.SetTexCoordRamp(const Value: TTextureCoordinateNode);
begin
  FdTexCoordRamp.Send(Value);
end;

procedure TParticleSystemNode.SetTexCoordKey(const Value: array of Single);
begin
  FdTexCoordKey.Send(Value);
end;

procedure TParticleSystemNode.SetTexCoordKey(const Value: TSingleList);
begin
  FdTexCoordKey.Send(Value);
end;

class function TParticleSystemNode.ClassX3DType: String;
begin
  Result := 'ParticleSystem';
end;

procedure TParticleSystemNode.CreateNode;
begin
  inherited;

  FFdCreateParticles := TSFBool.Create(Self, True, 'createParticles', true);
   FdCreateParticles.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCreateParticles);

  FFdEnabled := TSFBool.Create(Self, True, 'enabled', true);
   FdEnabled.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEnabled);

  FFdLifetimeVariation := TSFFloat.Create(Self, True, 'lifetimeVariation', 0.25);
   FdLifetimeVariation.ChangeAlways := chVisibleNonGeometry;
   FdLifetimeVariation.MustBeNonnegative := true;
  AddField(FFdLifetimeVariation);

  FFdMaxParticles := TSFInt32.Create(Self, True, 'maxParticles', 200);
   FdMaxParticles.ChangeAlways := chVisibleNonGeometry;
   FdMaxParticles.MustBeNonnegative := true;
  AddField(FFdMaxParticles);

  FFdParticleLifetime := TSFFloat.Create(Self, True, 'particleLifetime', 5);
   FdParticleLifetime.ChangeAlways := chVisibleNonGeometry;
   FdParticleLifetime.MustBeNonnegative := true;
  AddField(FFdParticleLifetime);

  FFdParticleSize := TSFVec2f.Create(Self, True, 'particleSize', Vector2(0.02, 0.02));
   FdParticleSize.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdParticleSize);

  FEventIsActive := TSFBoolEvent.Create(Self, 'isActive', false);
  AddEvent(FEventIsActive);

  FFdColorRamp := TSFNode.Create(Self, False, 'colorRamp', [TAbstractColorNode]);
   FdColorRamp.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdColorRamp);

  FFdColorKey := TMFFloat.Create(Self, False, 'colorKey', []);
   FdColorKey.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdColorKey);

  FFdEmitter := TSFNode.Create(Self, False, 'emitter', [TAbstractParticleEmitterNode]);
   FdEmitter.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEmitter);

  FFdGeometryType := TSFStringEnum.Create(Self, False, 'geometryType', @ParticlesGeometryNames, Ord(High(ParticlesGeometryNames)) + 1, Ord(pgQuad));
   FdGeometryType.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeometryType);

  FFdPhysics := TMFNode.Create(Self, False, 'physics', [TAbstractParticlePhysicsModelNode]);
   FdPhysics.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdPhysics);

  FFdTexCoordRamp := TSFNode.Create(Self, False, 'texCoordRamp', [TTextureCoordinateNode]);
   FdTexCoordRamp.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTexCoordRamp);

  FFdTexCoordKey := TMFFloat.Create(Self, False, 'texCoordKey', []);
   FdTexCoordKey.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTexCoordKey);
end;

{$endif read_implementation}
