{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetLayout: TAbstractLayoutNode;
    procedure SetLayout(const Value: TAbstractLayoutNode);
    function GetViewport: TAbstractViewportNode;
    procedure SetViewport(const Value: TAbstractViewportNode);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdLayout: TSFNode;
    { Internal wrapper for property @link(Layout). This wrapper API may change, we advise to access simpler @link(Layout) instead. }
    public property FdLayout: TSFNode read FFdLayout;
    {  }
    property Layout: TAbstractLayoutNode read GetLayout write SetLayout;

    strict private FFdViewport: TSFNode;
    { Internal wrapper for property @link(Viewport). This wrapper API may change, we advise to access simpler @link(Viewport) instead. }
    public property FdViewport: TSFNode read FFdViewport;
    {  }
    property Viewport: TAbstractViewportNode read GetViewport write SetViewport;

{$endif read_interface}

{$ifdef read_implementation}

{ TLayoutGroupNode ----------------------------------------------- }

function TLayoutGroupNode.GetLayout: TAbstractLayoutNode;
begin
  if FdLayout.Value is TAbstractLayoutNode then
    Result := TAbstractLayoutNode(FdLayout.Value)
  else
    Result := nil;
end;

procedure TLayoutGroupNode.SetLayout(const Value: TAbstractLayoutNode);
begin
  FdLayout.Send(Value);
end;

function TLayoutGroupNode.GetViewport: TAbstractViewportNode;
begin
  if FdViewport.Value is TAbstractViewportNode then
    Result := TAbstractViewportNode(FdViewport.Value)
  else
    Result := nil;
end;

procedure TLayoutGroupNode.SetViewport(const Value: TAbstractViewportNode);
begin
  FdViewport.Send(Value);
end;

class function TLayoutGroupNode.ClassX3DType: String;
begin
  Result := 'LayoutGroup';
end;

procedure TLayoutGroupNode.CreateNode;
begin
  inherited;

  FFdLayout := TSFNode.Create(Self, True, 'layout', [TAbstractLayoutNode]);
   FdLayout.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLayout);

  FFdViewport := TSFNode.Create(Self, True, 'viewport', [TAbstractViewportNode]);
   FdViewport.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdViewport);
end;

{$endif read_implementation}
