/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2021 Univ. Grenoble Alpes, CNRS, Grenoble INP, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#ifndef PROPERTYEXPLOREREXTENSION_H
#define PROPERTYEXPLOREREXTENSION_H

#include "PropertyExplorerAPI.h"

//-- Core
#include <ViewerExtension.h>

/**
 * @ingroup group_sdk_libraries_core_propertyexplorer
 *
 * @brief Manage the PropertyExplorer viewer, instanciates and register the default "Property Explorer" instance.
 *
 */
class PROPERTYEXPLORER_API PropertyExplorerExtension : public camitk::ViewerExtension {
    Q_OBJECT
    Q_INTERFACES(camitk::ViewerExtension);
    Q_PLUGIN_METADATA(IID "fr.imag.camitk.sdk.viewer.propertyexplorerextension")

public:
    /// Constructor
    PropertyExplorerExtension() = default;

    /// Destructor
    virtual ~PropertyExplorerExtension() = default;

    /// Method returning the viewer extension name
    virtual QString getName() override {
        return "Property Explorer Extension";
    };

    /// Method returning the viewer extension description
    virtual QString getDescription() override {
        return "The property explorer shows the properties of the currently selected component";
    };

    /// initialize all the viewers
    virtual void init() override;

};

#endif // PROPERTYEXPLOREREXTENSION_H


