//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sample/StandardSamples/MagneticLayersBuilder.h
//! @brief    Defines class to build samples with magnetic layers
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_SAMPLE_STANDARDSAMPLES_MAGNETICLAYERSBUILDER_H
#define BORNAGAIN_SAMPLE_STANDARDSAMPLES_MAGNETICLAYERSBUILDER_H

class MultiLayer;

#include "Sample/Multilayer/RoughnessModels.h"

//! Builds sample: spheres in substrate layer with a zero magnetic field.

namespace ExemplarySamples {

MultiLayer* createMagneticSubstrateZeroField();

} // namespace ExemplarySamples

//! Builds sample: ambient and one magnetized layer on a non-magnetized substrate.

namespace ExemplarySamples {

MultiLayer* createSimpleMagneticLayer();

} // namespace ExemplarySamples

//! Builds sample: magnetic spheres in a magnetized layer on a non-magnetized substrate.

namespace ExemplarySamples {

MultiLayer* createMagneticLayer();

} // namespace ExemplarySamples

//! Builds sample: magnetic layer on a magnetic substrate with the fields rotated by 90°

namespace ExemplarySamples {

MultiLayer* createSimpleMagneticRotationWithRoughness(const std::string& roughnessKey);

} // namespace ExemplarySamples

//! Builds sample: rotated magnetic spheres in substrate layer with a unit magnetic field.

namespace ExemplarySamples {

MultiLayer* createMagneticRotation();

} // namespace ExemplarySamples

#endif // BORNAGAIN_SAMPLE_STANDARDSAMPLES_MAGNETICLAYERSBUILDER_H
