/* piw-variables.c -
 *
 ****************************************************************
 * Copyright (C) 1999 Tom Lord
 * 
 * See the file "COPYING.PIW" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/piw/variables.h"
#include "hackerlab/piw-malloc/piw-variables.h"


/************************************************************************
 *(h0 "Control Flags and Variables Summary")
 * 
 * PIW instrumentation is controlled at run-time by a collection of
 * boolean flags and integer variables.  These parameters modulate what
 * checking is performed, and when, and what information is written to
 * log files.
 * 
 * There are two basic ways to manipulate these parameters.  First, they
 * may be set in an environment variable, `PIWFLAGS' that is defined when
 * your program starts (or more precisely, when the PIW run-time system
 * is initialized -- usually the first time `malloc' is called.)  Second,
 * they may be set by assigning directly to certain global variables,
 * either from your program, or from a debugger.
 * 
 * The environment variable `PIWFLAGS' should be a list of variable
 * names, with optional values, separated by whitespace characters, as in
 * this example:
 * 
 * 
 *   % PIWFLAGS="piw_malloc_log piw_malloc_block_pad=64"
 *   % export PIWFLAGS
 * 
 * If no value is specified for a variable (such as "piw_malloc_log" in
 * the example) it is given the value `1'.  All variables have a default
 * value, which is usually `0'.
 * 
 * The global variables used by the PIW run-time system and the variables
 * that may be specified in `PIWFLAGS' have the same names:
 * 
 *   (gdb) set piw_malloc_log = 1
 * 
 * or
 * 
 *    {
 *       extern int piw_malloc_log;
 *       piw_malloc_log = 1;
 *    }
 * 
 * 
 * Not all variables can be modified at run-time.  Some may only be set
 * before the PIW run-time system is initialized, usually by specifying a
 * value in `PIWFLAGS'.  The documentation for each variable says whether
 * or not it can be modified on-the-fly.
 * 
 * For reference, a complete list of PIW control variables is provided
 * here.  Each variable is also introduced in the chapter that
 * documents the kind of instrumentation it controls.
 *
 insert*/
int piw_malloc_log;		/* + Log calls and errors in
				 *   allocation functions. */
int piw_malloc_block_pad;	/* Add padding to allocated regions. */
int piw_malloc_block_fill;	/* + Fill newly allocated and freed 
				 *   memory. */
int piw_malloc_padding_fill;	/* + Fill padding areas around 
				 *   allocated memory. */
int piw_malloc_check_filled;	/* Check filled memory for signs of 
				 * overwrites. */
int piw_malloc_internals_check;	/* + Periodicly perform internal 
				 *   checks. */
int piw_log_writes;		/* + Log every write barrier 
				 *   encountered. */
int piw_keep_tag_bits;		/* Keep a bitmap of allocated 
				 * regions. */
int piw_tag_map_range;		/* The size of the tagged heap, 
				 * (in megabytes). */
int piw_log_buffer_size;	/* Size of the log record buffer. */
/*end-insert
 */


/*(c piw_init_flags_and_variables)
 * void piw_init_flags_and_variables ();
 * 
 * Initialize the PIW control flags and variables from the environment
 * variable `PIWFLAGS'.  This function is called automatically when
 * the first allocation-related call occurs.
 * 
 * 
 */
void
piw_init_flags_and_variables ()
{
  piw_malloc_log = piw_get_flag ("piw_malloc_log");
  piw_malloc_block_pad = piw_get_flag ("piw_malloc_block_pad");
  piw_malloc_block_fill = piw_get_flag ("piw_malloc_block_fill");
  piw_malloc_padding_fill = piw_get_flag ("piw_malloc_padding_fill");
  piw_malloc_check_filled = piw_get_flag ("piw_malloc_check_filled");
  piw_malloc_internals_check = piw_get_flag ("piw_malloc_internals_check");
  piw_log_writes = piw_get_flag ("piw_log_writes");
  piw_keep_tag_bits = piw_get_flag ("piw_keep_tag_bits");
  piw_tag_map_range = piw_get_flag ("piw_tag_map_range");
  piw_log_buffer_size = piw_get_flag ("piw_log_buffer_size");
}

