/* Copyright (c) 2009  Dmitry Xmelkov
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
 */

/* Test of cbrt() function: args with all '1' in mantissa.
   $Id$	*/

#define	ULPMAX	1	/* max possible error in units at last position	*/

#include <math.h>
#include <stdlib.h>
#include "progmem.h"

#ifndef	__AVR__
# include <stdio.h>
# define PRINTFLN(fmt, ...)	\
    printf ("\nLine %d: " fmt "\n", __LINE__, ##__VA_ARGS__)
# define EXIT(code)	exit ((code) < 255 ? (code) : 100 + (code) % 100)
#else
# define PRINTFLN(args...)
# define EXIT	exit
#endif

union float_u {
    unsigned long u32;
    float flt;
};

/* Result is placed into SRAM variable, allocated at the start of
   memory. This is convinient to debug: read a core dump.	*/
volatile union float_u v = {.u32 = 1};

PROGMEM const struct {
    unsigned long x;
    unsigned long z;
} t[] = {

    /* x, cbrt(x)	*/
    { 0x00000001,0x26a14518 },  /*   1:  1.4012985e-45  1.1190347e-15 */
    { 0x00000003,0x26e89768 },  /*   2:  4.2038954e-45  1.6139273e-15 */
    { 0x00000007,0x271a3fc5 },  /*   3:  9.8090893e-45  2.1406363e-15 */
    { 0x0000000f,0x2746dce6 },  /*   4:  2.1019477e-44  2.7597769e-15 */
    { 0x0000001f,0x277d4e19 },  /*   5:  4.3440252e-44  3.5153139e-15 */
    { 0x0000003f,0x27a06cf0 },  /*   6:  8.8281803e-44  4.4527030e-15 */
    { 0x0000007f,0x27caa825 },  /*   7:  1.7796490e-43  5.6248566e-15 */
    { 0x000000ff,0x27ffaa8e },  /*   8:  3.5733111e-43  7.0961634e-15 */
    { 0x000001ff,0x28212a32 },  /*   9:  7.1606352e-43  8.9464454e-15 */
    { 0x000003ff,0x284b1f05 },  /*  10:  1.4335283e-42  1.1275490e-14 */
    { 0x000007ff,0x287ff555 },  /*  11:  2.8684580e-42  1.4208541e-14 */
    { 0x00000fff,0x28a141bc },  /*  12:  5.7383172e-42  1.7903098e-14 */
    { 0x00001fff,0x28cb2dd7 },  /*  13:  1.1478036e-41  2.2557408e-14 */
    { 0x00003fff,0x28fffeab },  /*  14:  2.2957473e-41  2.8421131e-14 */
    { 0x00007fff,0x292144ac },  /*  15:  4.5916347e-41  3.5808746e-14 */
    { 0x0000ffff,0x294b2fb1 },  /*  16:  9.1834095e-41  4.5116422e-14 */
    { 0x0001ffff,0x297fffd5 },  /*  17:  1.8366959e-40  5.6843274e-14 */
    { 0x0003ffff,0x29a1450a },  /*  18:  3.6734058e-40  7.1618129e-14 */
    { 0x0007ffff,0x29cb2fed },  /*  19:  7.3468257e-40  9.0233245e-14 */
    { 0x000fffff,0x29fffffb },  /*  20:  1.4693665e-39  1.1368680e-13 */
    { 0x001fffff,0x2a214516 },  /*  21:  2.9387345e-39  1.4323642e-13 */
    { 0x003fffff,0x2a4b2ff4 },  /*  22:  5.8774704e-39  1.8046659e-13 */
    { 0x007fffff,0x2a7fffff },  /*  23:  1.1754942e-38  2.2737367e-13 */
    { 0x00ffffff,0x2aa14518 },  /*  24:  2.3509886e-38  2.8647287e-13 */
    { 0x017fffff,0x2acb2ff5 },  /*  25:  4.7019771e-38  3.6093320e-13 */
    { 0x01ffffff,0x2b000000 },  /*  26:  9.4039542e-38  4.5474734e-13 */
    { 0x027fffff,0x2b214518 },  /*  27:  1.8807908e-37  5.7294575e-13 */
    { 0x02ffffff,0x2b4b2ff5 },  /*  28:  3.7615817e-37  7.2186641e-13 */
    { 0x037fffff,0x2b800000 },  /*  29:  7.5231634e-37  9.0949468e-13 */
    { 0x03ffffff,0x2ba14518 },  /*  30:  1.5046327e-36  1.1458915e-12 */
    { 0x047fffff,0x2bcb2ff5 },  /*  31:  3.0092654e-36  1.4437328e-12 */
    { 0x04ffffff,0x2c000000 },  /*  32:  6.0185307e-36  1.8189894e-12 */
    { 0x057fffff,0x2c214518 },  /*  33:  1.2037061e-35  2.2917830e-12 */
    { 0x05ffffff,0x2c4b2ff5 },  /*  34:  2.4074123e-35  2.8874656e-12 */
    { 0x067fffff,0x2c800000 },  /*  35:  4.8148246e-35  3.6379787e-12 */
    { 0x06ffffff,0x2ca14518 },  /*  36:  9.6296491e-35  4.5835660e-12 */
    { 0x077fffff,0x2ccb2ff5 },  /*  37:  1.9259298e-34  5.7749313e-12 */
    { 0x07ffffff,0x2d000000 },  /*  38:  3.8518597e-34  7.2759575e-12 */
    { 0x087fffff,0x2d214518 },  /*  39:  7.7037193e-34  9.1671320e-12 */
    { 0x08ffffff,0x2d4b2ff5 },  /*  40:  1.5407439e-33  1.1549863e-11 */
    { 0x097fffff,0x2d800000 },  /*  41:  3.0814877e-33  1.4551915e-11 */
    { 0x09ffffff,0x2da14518 },  /*  42:  6.1629755e-33  1.8334264e-11 */
    { 0x0a7fffff,0x2dcb2ff5 },  /*  43:  1.2325951e-32  2.3099725e-11 */
    { 0x0affffff,0x2e000000 },  /*  44:  2.4651902e-32  2.9103830e-11 */
    { 0x0b7fffff,0x2e214518 },  /*  45:  4.9303804e-32  3.6668528e-11 */
    { 0x0bffffff,0x2e4b2ff5 },  /*  46:  9.8607607e-32  4.6199450e-11 */
    { 0x0c7fffff,0x2e800000 },  /*  47:  1.9721521e-31  5.8207660e-11 */
    { 0x0cffffff,0x2ea14518 },  /*  48:  3.9443043e-31  7.3337056e-11 */
    { 0x0d7fffff,0x2ecb2ff5 },  /*  49:  7.8886086e-31  9.2398900e-11 */
    { 0x0dffffff,0x2f000000 },  /*  50:  1.5777217e-30  1.1641532e-10 */
    { 0x0e7fffff,0x2f214518 },  /*  51:  3.1554434e-30  1.4667411e-10 */
    { 0x0effffff,0x2f4b2ff5 },  /*  52:  6.3108869e-30  1.8479780e-10 */
    { 0x0f7fffff,0x2f800000 },  /*  53:  1.2621774e-29  2.3283064e-10 */
    { 0x0fffffff,0x2fa14518 },  /*  54:  2.5243547e-29  2.9334822e-10 */
    { 0x107fffff,0x2fcb2ff5 },  /*  55:  5.0487095e-29  3.6959560e-10 */
    { 0x10ffffff,0x30000000 },  /*  56:  1.0097419e-28  4.6566128e-10 */
    { 0x117fffff,0x30214518 },  /*  57:  2.0194838e-28  5.8669645e-10 */
    { 0x11ffffff,0x304b2ff5 },  /*  58:  4.0389676e-28  7.3919120e-10 */
    { 0x127fffff,0x30800000 },  /*  59:  8.0779352e-28  9.3132255e-10 */
    { 0x12ffffff,0x30a14518 },  /*  60:  1.6155870e-27  1.1733929e-09 */
    { 0x137fffff,0x30cb2ff5 },  /*  61:  3.2311741e-27  1.4783824e-09 */
    { 0x13ffffff,0x31000000 },  /*  62:  6.4623482e-27  1.8626451e-09 */
    { 0x147fffff,0x31214518 },  /*  63:  1.2924696e-26  2.3467858e-09 */
    { 0x14ffffff,0x314b2ff5 },  /*  64:  2.5849393e-26  2.9567648e-09 */
    { 0x157fffff,0x31800000 },  /*  65:  5.1698785e-26  3.7252902e-09 */
    { 0x15ffffff,0x31a14518 },  /*  66:  1.0339757e-25  4.6935716e-09 */
    { 0x167fffff,0x31cb2ff5 },  /*  67:  2.0679514e-25  5.9135296e-09 */
    { 0x16ffffff,0x32000000 },  /*  68:  4.1359028e-25  7.4505804e-09 */
    { 0x177fffff,0x32214518 },  /*  69:  8.2718056e-25  9.3871431e-09 */
    { 0x17ffffff,0x324b2ff5 },  /*  70:  1.6543611e-24  1.1827059e-08 */
    { 0x187fffff,0x32800000 },  /*  71:  3.3087223e-24  1.4901161e-08 */
    { 0x18ffffff,0x32a14518 },  /*  72:  6.6174445e-24  1.8774286e-08 */
    { 0x197fffff,0x32cb2ff5 },  /*  73:  1.3234889e-23  2.3654118e-08 */
    { 0x19ffffff,0x33000000 },  /*  74:  2.6469778e-23  2.9802322e-08 */
    { 0x1a7fffff,0x33214518 },  /*  75:  5.2939556e-23  3.7548573e-08 */
    { 0x1affffff,0x334b2ff5 },  /*  76:  1.0587911e-22  4.7308237e-08 */
    { 0x1b7fffff,0x33800000 },  /*  77:  2.1175822e-22  5.9604644e-08 */
    { 0x1bffffff,0x33a14518 },  /*  78:  4.2351645e-22  7.5097145e-08 */
    { 0x1c7fffff,0x33cb2ff5 },  /*  79:  8.4703290e-22  9.4616474e-08 */
    { 0x1cffffff,0x34000000 },  /*  80:  1.6940658e-21  1.1920929e-07 */
    { 0x1d7fffff,0x34214518 },  /*  81:  3.3881316e-21  1.5019429e-07 */
    { 0x1dffffff,0x344b2ff5 },  /*  82:  6.7762632e-21  1.8923295e-07 */
    { 0x1e7fffff,0x34800000 },  /*  83:  1.3552526e-20  2.3841857e-07 */
    { 0x1effffff,0x34a14518 },  /*  84:  2.7105053e-20  3.0038858e-07 */
    { 0x1f7fffff,0x34cb2ff5 },  /*  85:  5.4210105e-20  3.7846590e-07 */
    { 0x1fffffff,0x35000000 },  /*  86:  1.0842021e-19  4.7683715e-07 */
    { 0x207fffff,0x35214518 },  /*  87:  2.1684042e-19  6.0077716e-07 */
    { 0x20ffffff,0x354b2ff5 },  /*  88:  4.3368084e-19  7.5693179e-07 */
    { 0x217fffff,0x35800000 },  /*  89:  8.6736169e-19  9.5367430e-07 */
    { 0x21ffffff,0x35a14518 },  /*  90:  1.7347234e-18  1.2015543e-06 */
    { 0x227fffff,0x35cb2ff5 },  /*  91:  3.4694467e-18  1.5138636e-06 */
    { 0x22ffffff,0x36000000 },  /*  92:  6.9388935e-18  1.9073486e-06 */
    { 0x237fffff,0x36214518 },  /*  93:  1.3877787e-17  2.4031086e-06 */
    { 0x23ffffff,0x364b2ff5 },  /*  94:  2.7755574e-17  3.0277272e-06 */
    { 0x247fffff,0x36800000 },  /*  95:  5.5511148e-17  3.8146972e-06 */
    { 0x24ffffff,0x36a14518 },  /*  96:  1.1102230e-16  4.8062173e-06 */
    { 0x257fffff,0x36cb2ff5 },  /*  97:  2.2204459e-16  6.0554543e-06 */
    { 0x25ffffff,0x37000000 },  /*  98:  4.4408918e-16  7.6293944e-06 */
    { 0x267fffff,0x37214518 },  /*  99:  8.8817837e-16  9.6124346e-06 */
    { 0x26ffffff,0x374b2ff5 },  /* 100:  1.7763567e-15  1.2110909e-05 */
    { 0x277fffff,0x37800000 },  /* 101:  3.5527135e-15  1.5258789e-05 */
    { 0x27ffffff,0x37a14518 },  /* 102:  7.1054269e-15  1.9224869e-05 */
    { 0x287fffff,0x37cb2ff5 },  /* 103:  1.4210854e-14  2.4221817e-05 */
    { 0x28ffffff,0x38000000 },  /* 104:  2.8421708e-14  3.0517577e-05 */
    { 0x297fffff,0x38214518 },  /* 105:  5.6843415e-14  3.8449738e-05 */
    { 0x29ffffff,0x384b2ff5 },  /* 106:  1.1368683e-13  4.8443635e-05 */
    { 0x2a7fffff,0x38800000 },  /* 107:  2.2737366e-13  6.1035155e-05 */
    { 0x2affffff,0x38a14518 },  /* 108:  4.5474732e-13  7.6899477e-05 */
    { 0x2b7fffff,0x38cb2ff5 },  /* 109:  9.0949465e-13  9.6887269e-05 */
    { 0x2bffffff,0x39000000 },  /* 110:  1.8189893e-12  1.2207031e-04 */
    { 0x2c7fffff,0x39214518 },  /* 111:  3.6379786e-12  1.5379895e-04 */
    { 0x2cffffff,0x394b2ff5 },  /* 112:  7.2759572e-12  1.9377454e-04 */
    { 0x2d7fffff,0x39800000 },  /* 113:  1.4551914e-11  2.4414062e-04 */
    { 0x2dffffff,0x39a14518 },  /* 114:  2.9103829e-11  3.0759791e-04 */
    { 0x2e7fffff,0x39cb2ff5 },  /* 115:  5.8207657e-11  3.8754908e-04 */
    { 0x2effffff,0x3a000000 },  /* 116:  1.1641531e-10  4.8828124e-04 */
    { 0x2f7fffff,0x3a214518 },  /* 117:  2.3283063e-10  6.1519581e-04 */
    { 0x2fffffff,0x3a4b2ff5 },  /* 118:  4.6566126e-10  7.7509815e-04 */
    { 0x307fffff,0x3a800000 },  /* 119:  9.3132252e-10  9.7656248e-04 */
    { 0x30ffffff,0x3aa14518 },  /* 120:  1.8626450e-09  1.2303916e-03 */
    { 0x317fffff,0x3acb2ff5 },  /* 121:  3.7252901e-09  1.5501963e-03 */
    { 0x31ffffff,0x3b000000 },  /* 122:  7.4505802e-09  1.9531250e-03 */
    { 0x327fffff,0x3b214518 },  /* 123:  1.4901160e-08  2.4607832e-03 */
    { 0x32ffffff,0x3b4b2ff5 },  /* 124:  2.9802321e-08  3.1003926e-03 */
    { 0x337fffff,0x3b800000 },  /* 125:  5.9604641e-08  3.9062499e-03 */
    { 0x33ffffff,0x3ba14518 },  /* 126:  1.1920928e-07  4.9215665e-03 */
    { 0x347fffff,0x3bcb2ff5 },  /* 127:  2.3841856e-07  6.2007852e-03 */
    { 0x34ffffff,0x3c000000 },  /* 128:  4.7683713e-07  7.8124998e-03 */
    { 0x357fffff,0x3c214518 },  /* 129:  9.5367426e-07  9.8431330e-03 */
    { 0x35ffffff,0x3c4b2ff5 },  /* 130:  1.9073485e-06  1.2401570e-02 */
    { 0x367fffff,0x3c800000 },  /* 131:  3.8146970e-06  1.5625000e-02 */
    { 0x36ffffff,0x3ca14518 },  /* 132:  7.6293941e-06  1.9686266e-02 */
    { 0x377fffff,0x3ccb2ff5 },  /* 133:  1.5258788e-05  2.4803141e-02 */
    { 0x37ffffff,0x3d000000 },  /* 134:  3.0517576e-05  3.1249999e-02 */
    { 0x387fffff,0x3d214518 },  /* 135:  6.1035153e-05  3.9372532e-02 */
    { 0x38ffffff,0x3d4b2ff5 },  /* 136:  1.2207031e-04  4.9606282e-02 */
    { 0x397fffff,0x3d800000 },  /* 137:  2.4414061e-04  6.2499999e-02 */
    { 0x39ffffff,0x3da14518 },  /* 138:  4.8828122e-04  7.8745064e-02 */
    { 0x3a7fffff,0x3dcb2ff5 },  /* 139:  9.7656244e-04  9.9212564e-02 */
    { 0x3affffff,0x3e000000 },  /* 140:  1.9531249e-03  1.2500000e-01 */
    { 0x3b7fffff,0x3e214518 },  /* 141:  3.9062498e-03  1.5749013e-01 */
    { 0x3bffffff,0x3e4b2ff5 },  /* 142:  7.8124995e-03  1.9842513e-01 */
    { 0x3c7fffff,0x3e800000 },  /* 143:  1.5624999e-02  2.4999999e-01 */
    { 0x3cffffff,0x3ea14518 },  /* 144:  3.1249998e-02  3.1498026e-01 */
    { 0x3d7fffff,0x3ecb2ff5 },  /* 145:  6.2499996e-02  3.9685025e-01 */
    { 0x3dffffff,0x3f000000 },  /* 146:  1.2499999e-01  4.9999999e-01 */
    { 0x3e7fffff,0x3f214518 },  /* 147:  2.4999999e-01  6.2996051e-01 */
    { 0x3effffff,0x3f4b2ff5 },  /* 148:  4.9999997e-01  7.9370051e-01 */
    { 0x3f7fffff,0x3f800000 },  /* 149:  9.9999994e-01  9.9999998e-01 */
    { 0x3fffffff,0x3fa14518 },  /* 150:  1.9999999e+00  1.2599210e+00 */
    { 0x407fffff,0x3fcb2ff5 },  /* 151:  3.9999998e+00  1.5874010e+00 */
    { 0x40ffffff,0x40000000 },  /* 152:  7.9999995e+00  2.0000000e+00 */
    { 0x417fffff,0x40214518 },  /* 153:  1.5999999e+01  2.5198420e+00 */
    { 0x41ffffff,0x404b2ff5 },  /* 154:  3.1999998e+01  3.1748020e+00 */
    { 0x427fffff,0x40800000 },  /* 155:  6.3999996e+01  3.9999999e+00 */
    { 0x42ffffff,0x40a14518 },  /* 156:  1.2799999e+02  5.0396841e+00 */
    { 0x437fffff,0x40cb2ff5 },  /* 157:  2.5599998e+02  6.3496041e+00 */
    { 0x43ffffff,0x41000000 },  /* 158:  5.1199997e+02  7.9999998e+00 */
    { 0x447fffff,0x41214518 },  /* 159:  1.0239999e+03  1.0079368e+01 */
    { 0x44ffffff,0x414b2ff5 },  /* 160:  2.0479999e+03  1.2699208e+01 */
    { 0x457fffff,0x41800000 },  /* 161:  4.0959998e+03  1.6000000e+01 */
    { 0x45ffffff,0x41a14518 },  /* 162:  8.1919995e+03  2.0158736e+01 */
    { 0x467fffff,0x41cb2ff5 },  /* 163:  1.6383999e+04  2.5398416e+01 */
    { 0x46ffffff,0x42000000 },  /* 164:  3.2767998e+04  3.1999999e+01 */
    { 0x477fffff,0x42214518 },  /* 165:  6.5535996e+04  4.0317473e+01 */
    { 0x47ffffff,0x424b2ff5 },  /* 166:  1.3107199e+05  5.0796833e+01 */
    { 0x487fffff,0x42800000 },  /* 167:  2.6214398e+05  6.3999999e+01 */
    { 0x48ffffff,0x42a14518 },  /* 168:  5.2428797e+05  8.0634945e+01 */
    { 0x497fffff,0x42cb2ff5 },  /* 169:  1.0485759e+06  1.0159367e+02 */
    { 0x49ffffff,0x43000000 },  /* 170:  2.0971519e+06  1.2800000e+02 */
    { 0x4a7fffff,0x43214518 },  /* 171:  4.1943038e+06  1.6126989e+02 */
    { 0x4affffff,0x434b2ff5 },  /* 172:  8.3886075e+06  2.0318733e+02 */
    { 0x4b7fffff,0x43800000 },  /* 173:  1.6777215e+07  2.5599999e+02 */
    { 0x4bffffff,0x43a14518 },  /* 174:  3.3554430e+07  3.2253978e+02 */
    { 0x4c7fffff,0x43cb2ff5 },  /* 175:  6.7108860e+07  4.0637466e+02 */
    { 0x4cffffff,0x44000000 },  /* 176:  1.3421772e+08  5.1199999e+02 */
    { 0x4d7fffff,0x44214518 },  /* 177:  2.6843544e+08  6.4507956e+02 */
    { 0x4dffffff,0x444b2ff5 },  /* 178:  5.3687088e+08  8.1274932e+02 */
    { 0x4e7fffff,0x44800000 },  /* 179:  1.0737418e+09  1.0240000e+03 */
    { 0x4effffff,0x44a14518 },  /* 180:  2.1474835e+09  1.2901591e+03 */
    { 0x4f7fffff,0x44cb2ff5 },  /* 181:  4.2949670e+09  1.6254986e+03 */
    { 0x4fffffff,0x45000000 },  /* 182:  8.5899341e+09  2.0480000e+03 */
    { 0x507fffff,0x45214518 },  /* 183:  1.7179868e+10  2.5803183e+03 */
    { 0x50ffffff,0x454b2ff5 },  /* 184:  3.4359736e+10  3.2509973e+03 */
    { 0x517fffff,0x45800000 },  /* 185:  6.8719473e+10  4.0959999e+03 */
    { 0x51ffffff,0x45a14518 },  /* 186:  1.3743895e+11  5.1606365e+03 */
    { 0x527fffff,0x45cb2ff5 },  /* 187:  2.7487789e+11  6.5019946e+03 */
    { 0x52ffffff,0x46000000 },  /* 188:  5.4975578e+11  8.1919998e+03 */
    { 0x537fffff,0x46214518 },  /* 189:  1.0995116e+12  1.0321273e+04 */
    { 0x53ffffff,0x464b2ff5 },  /* 190:  2.1990231e+12  1.3003989e+04 */
    { 0x547fffff,0x46800000 },  /* 191:  4.3980462e+12  1.6384000e+04 */
    { 0x54ffffff,0x46a14518 },  /* 192:  8.7960925e+12  2.0642546e+04 */
    { 0x557fffff,0x46cb2ff5 },  /* 193:  1.7592185e+13  2.6007978e+04 */
    { 0x55ffffff,0x47000000 },  /* 194:  3.5184370e+13  3.2767999e+04 */
    { 0x567fffff,0x47214518 },  /* 195:  7.0368740e+13  4.1285092e+04 */
    { 0x56ffffff,0x474b2ff5 },  /* 196:  1.4073748e+14  5.2015957e+04 */
    { 0x577fffff,0x47800000 },  /* 197:  2.8147496e+14  6.5535999e+04 */
    { 0x57ffffff,0x47a14518 },  /* 198:  5.6294992e+14  8.2570184e+04 */
    { 0x587fffff,0x47cb2ff5 },  /* 199:  1.1258998e+15  1.0403191e+05 */
    { 0x58ffffff,0x48000000 },  /* 200:  2.2517997e+15  1.3107200e+05 */
    { 0x597fffff,0x48214518 },  /* 201:  4.5035994e+15  1.6514037e+05 */
    { 0x59ffffff,0x484b2ff5 },  /* 202:  9.0071987e+15  2.0806383e+05 */
    { 0x5a7fffff,0x48800000 },  /* 203:  1.8014397e+16  2.6214399e+05 */
    { 0x5affffff,0x48a14518 },  /* 204:  3.6028795e+16  3.3028074e+05 */
    { 0x5b7fffff,0x48cb2ff5 },  /* 205:  7.2057590e+16  4.1612765e+05 */
    { 0x5bffffff,0x49000000 },  /* 206:  1.4411518e+17  5.2428799e+05 */
    { 0x5c7fffff,0x49214518 },  /* 207:  2.8823036e+17  6.6056147e+05 */
    { 0x5cffffff,0x494b2ff5 },  /* 208:  5.7646072e+17  8.3225531e+05 */
    { 0x5d7fffff,0x49800000 },  /* 209:  1.1529214e+18  1.0485760e+06 */
    { 0x5dffffff,0x49a14518 },  /* 210:  2.3058429e+18  1.3211229e+06 */
    { 0x5e7fffff,0x49cb2ff5 },  /* 211:  4.6116857e+18  1.6645106e+06 */
    { 0x5effffff,0x4a000000 },  /* 212:  9.2233715e+18  2.0971520e+06 */
    { 0x5f7fffff,0x4a214518 },  /* 213:  1.8446743e+19  2.6422459e+06 */
    { 0x5fffffff,0x4a4b2ff5 },  /* 214:  3.6893486e+19  3.3290212e+06 */
    { 0x607fffff,0x4a800000 },  /* 215:  7.3786972e+19  4.1943039e+06 */
    { 0x60ffffff,0x4aa14518 },  /* 216:  1.4757394e+20  5.2844918e+06 */
    { 0x617fffff,0x4acb2ff5 },  /* 217:  2.9514789e+20  6.6580424e+06 */
    { 0x61ffffff,0x4b000000 },  /* 218:  5.9029578e+20  8.3886078e+06 */
    { 0x627fffff,0x4b214518 },  /* 219:  1.1805916e+21  1.0568984e+07 */
    { 0x62ffffff,0x4b4b2ff5 },  /* 220:  2.3611831e+21  1.3316085e+07 */
    { 0x637fffff,0x4b800000 },  /* 221:  4.7223662e+21  1.6777216e+07 */
    { 0x63ffffff,0x4ba14518 },  /* 222:  9.4447324e+21  2.1137967e+07 */
    { 0x647fffff,0x4bcb2ff5 },  /* 223:  1.8889465e+22  2.6632170e+07 */
    { 0x64ffffff,0x4c000000 },  /* 224:  3.7778930e+22  3.3554431e+07 */
    { 0x657fffff,0x4c214518 },  /* 225:  7.5557859e+22  4.2275934e+07 */
    { 0x65ffffff,0x4c4b2ff5 },  /* 226:  1.5111572e+23  5.3264340e+07 */
    { 0x667fffff,0x4c800000 },  /* 227:  3.0223144e+23  6.7108863e+07 */
    { 0x66ffffff,0x4ca14518 },  /* 228:  6.0446287e+23  8.4551869e+07 */
    { 0x677fffff,0x4ccb2ff5 },  /* 229:  1.2089257e+24  1.0652868e+08 */
    { 0x67ffffff,0x4d000000 },  /* 230:  2.4178515e+24  1.3421773e+08 */
    { 0x687fffff,0x4d214518 },  /* 231:  4.8357030e+24  1.6910374e+08 */
    { 0x68ffffff,0x4d4b2ff5 },  /* 232:  9.6714060e+24  2.1305736e+08 */
    { 0x697fffff,0x4d800000 },  /* 233:  1.9342812e+25  2.6843545e+08 */
    { 0x69ffffff,0x4da14518 },  /* 234:  3.8685624e+25  3.3820747e+08 */
    { 0x6a7fffff,0x4dcb2ff5 },  /* 235:  7.7371248e+25  4.2611472e+08 */
    { 0x6affffff,0x4e000000 },  /* 236:  1.5474250e+26  5.3687090e+08 */
    { 0x6b7fffff,0x4e214518 },  /* 237:  3.0948499e+26  6.7641495e+08 */
    { 0x6bffffff,0x4e4b2ff5 },  /* 238:  6.1896998e+26  8.5222943e+08 */
    { 0x6c7fffff,0x4e800000 },  /* 239:  1.2379400e+27  1.0737418e+09 */
    { 0x6cffffff,0x4ea14518 },  /* 240:  2.4758799e+27  1.3528299e+09 */
    { 0x6d7fffff,0x4ecb2ff5 },  /* 241:  4.9517599e+27  1.7044589e+09 */
    { 0x6dffffff,0x4f000000 },  /* 242:  9.9035197e+27  2.1474836e+09 */
    { 0x6e7fffff,0x4f214518 },  /* 243:  1.9807039e+28  2.7056598e+09 */
    { 0x6effffff,0x4f4b2ff5 },  /* 244:  3.9614079e+28  3.4089177e+09 */
    { 0x6f7fffff,0x4f800000 },  /* 245:  7.9228158e+28  4.2949672e+09 */
    { 0x6fffffff,0x4fa14518 },  /* 246:  1.5845632e+29  5.4113196e+09 */
    { 0x707fffff,0x4fcb2ff5 },  /* 247:  3.1691263e+29  6.8178355e+09 */
    { 0x70ffffff,0x50000000 },  /* 248:  6.3382526e+29  8.5899344e+09 */
    { 0x717fffff,0x50214518 },  /* 249:  1.2676505e+30  1.0822639e+10 */
    { 0x71ffffff,0x504b2ff5 },  /* 250:  2.5353010e+30  1.3635671e+10 */
    { 0x727fffff,0x50800000 },  /* 251:  5.0706021e+30  1.7179869e+10 */
    { 0x72ffffff,0x50a14518 },  /* 252:  1.0141204e+31  2.1645278e+10 */
    { 0x737fffff,0x50cb2ff5 },  /* 253:  2.0282408e+31  2.7271342e+10 */
    { 0x73ffffff,0x51000000 },  /* 254:  4.0564817e+31  3.4359738e+10 */
    { 0x747fffff,0x51214518 },  /* 255:  8.1129634e+31  4.3290557e+10 */
    { 0x74ffffff,0x514b2ff5 },  /* 256:  1.6225927e+32  5.4542684e+10 */
    { 0x757fffff,0x51800000 },  /* 257:  3.2451853e+32  6.8719475e+10 */
    { 0x75ffffff,0x51a14518 },  /* 258:  6.4903707e+32  8.6581113e+10 */
    { 0x767fffff,0x51cb2ff5 },  /* 259:  1.2980741e+33  1.0908537e+11 */
    { 0x76ffffff,0x52000000 },  /* 260:  2.5961483e+33  1.3743895e+11 */
    { 0x777fffff,0x52214518 },  /* 261:  5.1922965e+33  1.7316223e+11 */
    { 0x77ffffff,0x524b2ff5 },  /* 262:  1.0384593e+34  2.1817073e+11 */
    { 0x787fffff,0x52800000 },  /* 263:  2.0769186e+34  2.7487790e+11 */
    { 0x78ffffff,0x52a14518 },  /* 264:  4.1538372e+34  3.4632445e+11 */
    { 0x797fffff,0x52cb2ff5 },  /* 265:  8.3076745e+34  4.3634147e+11 */
    { 0x79ffffff,0x53000000 },  /* 266:  1.6615349e+35  5.4975580e+11 */
    { 0x7a7fffff,0x53214518 },  /* 267:  3.3230698e+35  6.9264891e+11 */
    { 0x7affffff,0x534b2ff5 },  /* 268:  6.6461396e+35  8.7268294e+11 */
    { 0x7b7fffff,0x53800000 },  /* 269:  1.3292279e+36  1.0995116e+12 */
    { 0x7bffffff,0x53a14518 },  /* 270:  2.6584558e+36  1.3852978e+12 */
    { 0x7c7fffff,0x53cb2ff5 },  /* 271:  5.3169117e+36  1.7453659e+12 */
    { 0x7cffffff,0x54000000 },  /* 272:  1.0633823e+37  2.1990232e+12 */
    { 0x7d7fffff,0x54214518 },  /* 273:  2.1267647e+37  2.7705956e+12 */
    { 0x7dffffff,0x544b2ff5 },  /* 274:  4.2535293e+37  3.4907318e+12 */
    { 0x7e7fffff,0x54800000 },  /* 275:  8.5070587e+37  4.3980464e+12 */
    { 0x7effffff,0x54a14518 },  /* 276:  1.7014117e+38  5.5411913e+12 */
    { 0x7f7fffff,0x54cb2ff5 },  /* 277:  3.4028235e+38  6.9814635e+12 */
};

int main ()
{
    int i;
    union float_u tx, tz;
    
    for (i = 0;  (size_t)i < sizeof(t) / sizeof(t[0]); i++) {
	tx.u32 = pgm_read_dword (& t[i].x);
	tz.u32 = pgm_read_dword (& t[i].z);
	v.flt = cbrt (tx.flt);
	if ((v.u32 - tz.u32) > ULPMAX && (tz.u32 - v.u32) > ULPMAX) {
	    PRINTFLN ("t1[%d]={0x%08lx,0x%08lx} --> 0x%08lx\n",
		      i, tx.u32, tz.u32, v.u32);
	    EXIT (i + 1);
	}
    }
    
    return 0;
}
