/*
 * Decompiled with CFR 0.152.
 */
package jbet;

import jbet.ClassFileException;
import jbet.DagClassInfo;
import jbet.DagSnippit;
import jbet.DataFlowException;
import jbet.ElementNotFoundException;
import jbet.MethodInfo;
import jbet.MethodSignature;

public class DagMethodInfo
extends MethodSignature {
    private MethodInfo origmi;
    public DagClassInfo cr;

    public DagMethodInfo() {
    }

    public DagMethodInfo(DagClassInfo crin, MethodInfo mi, boolean runGraphify) throws ClassFileException, DataFlowException, ElementNotFoundException {
        this.cr = crin;
        this.name = mi.name;
        this.descriptor = mi.descriptor;
        this.accessFlags = mi.accessFlags;
        this.exceptions = mi.exceptions;
        this.origmi = mi;
        if (runGraphify) {
            this.dags = DagSnippit.graphify(mi);
            ((DagSnippit)this.dags).method = this;
        }
    }

    public DagMethodInfo(DagClassInfo crin, MethodInfo mi) {
        this.cr = crin;
        this.name = mi.name;
        this.descriptor = mi.descriptor;
        this.accessFlags = mi.accessFlags;
        this.exceptions = mi.exceptions;
        this.origmi = mi;
    }

    public Object classrep() {
        DagMethodInfo dagMethodInfo = this;
        return dagMethodInfo.cr;
    }

    public boolean isStatic() {
        DagMethodInfo dagMethodInfo = this;
        boolean bl = (dagMethodInfo.accessFlags & 8) != 0;
        return bl;
    }

    public boolean isVirtual() {
        DagMethodInfo dagMethodInfo = this;
        boolean bl = (dagMethodInfo.accessFlags & 8) == 0;
        return bl;
    }

    public boolean isNative() {
        DagMethodInfo dagMethodInfo = this;
        boolean bl = (dagMethodInfo.accessFlags & 0x100) != 0;
        return bl;
    }

    public DagSnippit dags() {
        DagMethodInfo dagMethodInfo = this;
        return (DagSnippit)dagMethodInfo.dags;
    }

    public MethodInfo resolve() {
        DagMethodInfo dagMethodInfo = this;
        return dagMethodInfo.origmi;
    }
}

