/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.cojen.classfile.ConstantInfo;
import org.cojen.classfile.Descriptor;
import org.cojen.classfile.MethodDesc;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.constant.ConstantClassInfo;
import org.cojen.classfile.constant.ConstantDoubleInfo;
import org.cojen.classfile.constant.ConstantFieldInfo;
import org.cojen.classfile.constant.ConstantFloatInfo;
import org.cojen.classfile.constant.ConstantIntegerInfo;
import org.cojen.classfile.constant.ConstantInterfaceMethodInfo;
import org.cojen.classfile.constant.ConstantLongInfo;
import org.cojen.classfile.constant.ConstantMethodInfo;
import org.cojen.classfile.constant.ConstantNameAndTypeInfo;
import org.cojen.classfile.constant.ConstantStringInfo;
import org.cojen.classfile.constant.ConstantUTFInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantPool {
    private Map<ConstantInfo, ConstantInfo> mConstants = new HashMap<ConstantInfo, ConstantInfo>();
    private Vector<ConstantInfo> mIndexedConstants;
    private int mEntries;
    private boolean mPreserveOrder;

    ConstantPool() {
    }

    private ConstantPool(Vector<ConstantInfo> indexedConstants) {
        this.mIndexedConstants = indexedConstants;
        int size = indexedConstants.size();
        for (int i = 1; i < size; ++i) {
            ConstantInfo ci = indexedConstants.get(i);
            if (ci == null) continue;
            this.mConstants.put(ci, ci);
            this.mEntries += ci.getEntryCount();
        }
        this.mPreserveOrder = true;
    }

    public ConstantInfo getConstant(int index) {
        if (this.mIndexedConstants == null) {
            throw new IllegalStateException("Constant pool indexes have not been assigned");
        }
        return this.mIndexedConstants.get(index);
    }

    public Set<ConstantInfo> getAllConstants() {
        return Collections.unmodifiableSet(this.mConstants.keySet());
    }

    public int getSize() {
        return this.mEntries;
    }

    public ConstantClassInfo addConstantClass(String className) {
        return (ConstantClassInfo)this.addConstant(new ConstantClassInfo(this, className));
    }

    public ConstantClassInfo addConstantClass(String className, int dim) {
        return (ConstantClassInfo)this.addConstant(new ConstantClassInfo(this, className, dim));
    }

    public ConstantClassInfo addConstantClass(TypeDesc type) {
        return (ConstantClassInfo)this.addConstant(new ConstantClassInfo(this, type));
    }

    public ConstantFieldInfo addConstantField(String className, String fieldName, TypeDesc type) {
        ConstantFieldInfo ci = new ConstantFieldInfo(this.addConstantClass(className), this.addConstantNameAndType(fieldName, type));
        return (ConstantFieldInfo)this.addConstant(ci);
    }

    public ConstantMethodInfo addConstantMethod(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        MethodDesc md = MethodDesc.forArguments(ret, params);
        ConstantMethodInfo ci = new ConstantMethodInfo(this.addConstantClass(className), this.addConstantNameAndType(methodName, md));
        return (ConstantMethodInfo)this.addConstant(ci);
    }

    public ConstantInterfaceMethodInfo addConstantInterfaceMethod(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        MethodDesc md = MethodDesc.forArguments(ret, params);
        ConstantInterfaceMethodInfo ci = new ConstantInterfaceMethodInfo(this.addConstantClass(className), this.addConstantNameAndType(methodName, md));
        return (ConstantInterfaceMethodInfo)this.addConstant(ci);
    }

    public ConstantMethodInfo addConstantConstructor(String className, TypeDesc[] params) {
        return this.addConstantMethod(className, "<init>", null, params);
    }

    public ConstantIntegerInfo addConstantInteger(int value) {
        return (ConstantIntegerInfo)this.addConstant(new ConstantIntegerInfo(value));
    }

    public ConstantLongInfo addConstantLong(long value) {
        return (ConstantLongInfo)this.addConstant(new ConstantLongInfo(value));
    }

    public ConstantFloatInfo addConstantFloat(float value) {
        return (ConstantFloatInfo)this.addConstant(new ConstantFloatInfo(value));
    }

    public ConstantDoubleInfo addConstantDouble(double value) {
        return (ConstantDoubleInfo)this.addConstant(new ConstantDoubleInfo(value));
    }

    public ConstantStringInfo addConstantString(String str) {
        return (ConstantStringInfo)this.addConstant(new ConstantStringInfo(this, str));
    }

    public ConstantUTFInfo addConstantUTF(String str) {
        return (ConstantUTFInfo)this.addConstant(new ConstantUTFInfo(str));
    }

    public ConstantNameAndTypeInfo addConstantNameAndType(String name, Descriptor type) {
        return (ConstantNameAndTypeInfo)this.addConstant(new ConstantNameAndTypeInfo(this, name, type));
    }

    public ConstantNameAndTypeInfo addConstantNameAndType(ConstantUTFInfo nameConstant, ConstantUTFInfo descConstant) {
        return (ConstantNameAndTypeInfo)this.addConstant(new ConstantNameAndTypeInfo(nameConstant, descConstant));
    }

    public ConstantInfo addConstant(ConstantInfo constant) {
        ConstantInfo info = this.mConstants.get(constant);
        if (info != null) {
            return info;
        }
        int entryCount = constant.getEntryCount();
        if (this.mIndexedConstants != null && this.mPreserveOrder) {
            int size = this.mIndexedConstants.size();
            this.mIndexedConstants.setSize(size + entryCount);
            this.mIndexedConstants.set(size, constant);
            constant.mIndex = size;
        }
        this.mConstants.put(constant, constant);
        this.mEntries += entryCount;
        return constant;
    }

    public void writeTo(DataOutput dout) throws IOException {
        int size = this.getSize() + 1;
        if (size >= 65535) {
            throw new IllegalStateException("Constant pool entry count cannot exceed 65535: " + size);
        }
        dout.writeShort(size);
        if (this.mIndexedConstants == null || !this.mPreserveOrder) {
            this.mIndexedConstants = new Vector(size);
            this.mIndexedConstants.setSize(size);
            int index = 1;
            for (ConstantInfo constant : this.mConstants.keySet()) {
                if (!constant.hasPriority()) continue;
                constant.mIndex = index;
                this.mIndexedConstants.set(index, constant);
                index += constant.getEntryCount();
            }
            for (ConstantInfo constant : this.mConstants.keySet()) {
                if (constant.hasPriority()) continue;
                constant.mIndex = index;
                this.mIndexedConstants.set(index, constant);
                index += constant.getEntryCount();
            }
        }
        for (int i = 1; i < size; ++i) {
            ConstantInfo obj = this.mIndexedConstants.get(i);
            if (obj == null) continue;
            obj.writeTo(dout);
        }
    }

    public static ConstantPool readFrom(DataInput din) throws IOException {
        int index;
        int entryCount;
        int size = din.readUnsignedShort();
        Vector<ConstantInfo> constants = new Vector<ConstantInfo>(size);
        constants.setSize(size);
        for (index = 1; index < size; index += entryCount) {
            ConstantInfo constant;
            byte tag = din.readByte();
            entryCount = 1;
            switch (tag) {
                case 1: {
                    constant = new ConstantUTFInfo(din.readUTF());
                    break;
                }
                case 3: {
                    constant = new ConstantIntegerInfo(din.readInt());
                    break;
                }
                case 4: {
                    constant = new ConstantFloatInfo(din.readFloat());
                    break;
                }
                case 5: {
                    constant = new ConstantLongInfo(din.readLong());
                    ++entryCount;
                    break;
                }
                case 6: {
                    constant = new ConstantDoubleInfo(din.readDouble());
                    ++entryCount;
                    break;
                }
                case 7: 
                case 8: {
                    constant = new TempEntry(tag, din.readUnsignedShort());
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    constant = new TempEntry(tag, din.readShort() << 16 | din.readUnsignedShort());
                    break;
                }
                default: {
                    throw new IOException("Invalid constant pool tag: " + tag);
                }
            }
            constant.mIndex = index;
            constants.set(index, constant);
        }
        for (index = 1; index < size; ++index) {
            ConstantPool.resolve(constants, index);
        }
        return new ConstantPool(constants);
    }

    private static ConstantInfo resolve(List<ConstantInfo> constants, int index) {
        ConstantInfo constant = constants.get(index);
        if (constant == null) {
            return null;
        }
        if (!(constant instanceof TempEntry)) {
            return constant;
        }
        TempEntry entry = (TempEntry)constant;
        int data = entry.mData;
        int index1 = data & 0xFFFF;
        ConstantInfo ci1 = constants.get(index1);
        if (ci1 instanceof TempEntry) {
            ci1 = ConstantPool.resolve(constants, index1);
        }
        ConstantInfo ci = null;
        block0 : switch (entry.mTag) {
            case 7: {
                ci = new ConstantClassInfo((ConstantUTFInfo)ci1);
                break;
            }
            case 8: {
                ci = new ConstantStringInfo((ConstantUTFInfo)ci1);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                int index2 = data >>> 16;
                ConstantInfo ci2 = constants.get(index2);
                if (ci2 instanceof TempEntry) {
                    ci2 = ConstantPool.resolve(constants, index2);
                }
                switch (entry.mTag) {
                    case 9: {
                        ci = new ConstantFieldInfo((ConstantClassInfo)ci2, (ConstantNameAndTypeInfo)ci1);
                        break block0;
                    }
                    case 10: {
                        ci = new ConstantMethodInfo((ConstantClassInfo)ci2, (ConstantNameAndTypeInfo)ci1);
                        break block0;
                    }
                    case 11: {
                        ci = new ConstantInterfaceMethodInfo((ConstantClassInfo)ci2, (ConstantNameAndTypeInfo)ci1);
                        break block0;
                    }
                    case 12: {
                        ci = new ConstantNameAndTypeInfo((ConstantUTFInfo)ci2, (ConstantUTFInfo)ci1);
                    }
                }
            }
        }
        ci.mIndex = index;
        constants.set(index, ci);
        return ci;
    }

    private static class TempEntry
    extends ConstantInfo {
        public int mTag;
        public int mData;

        public TempEntry(int tag, int data) {
            super(-1);
            this.mTag = tag;
            this.mData = data;
        }
    }
}

