/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.template;

import jd.xml.xpath.VariableName;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.model.NodeNamePool;
import jd.xml.xpath.object.XObject;
import jd.xml.xpath.object.XString;
import jd.xml.xslt.XsltContext;
import jd.xml.xslt.expr.XResultTreeFragment;
import jd.xml.xslt.result.ResultTreeRecorder;
import jd.xml.xslt.template.Template;

public class Variable {
    public static final int VARIABLE = 0;
    public static final int PARAMETER = 1;
    public static final int WITHPARAM = 2;
    public static final Variable[] EMPTY_LIST = new Variable[0];
    private static final XString EMPTY_STRING = new XString("");
    private VariableName name_;
    private Expression select_;
    private Template template_;
    private XObject value_;
    private int type_;

    public Variable(VariableName variableName, Expression expression, Template template, int n) {
        this.name_ = variableName;
        this.select_ = expression;
        this.template_ = template;
        this.type_ = n;
        if (this.select_ != null && this.select_.getContextDependencies() == 0) {
            this.value_ = expression.toXObject(null);
        } else if (this.select_ == null && this.template_ == null) {
            this.value_ = EMPTY_STRING;
        }
    }

    public boolean isParameter() {
        return this.type_ == 1;
    }

    public VariableName getVariableName() {
        return this.name_;
    }

    public void setVariableName(Variable variable) {
        if (this.type_ != 2) {
            throw new IllegalStateException("not a with-param variable");
        }
        this.name_ = variable.name_;
    }

    public boolean hasSameName(Variable variable) {
        return this.name_.getName() == variable.getVariableName().getName();
    }

    public Template getTemplate() {
        return this.template_;
    }

    public Expression getExpression() {
        return this.select_;
    }

    public XObject getConstantValue() {
        return this.value_;
    }

    public XObject getValue(XsltContext xsltContext) {
        if (this.value_ != null) {
            return this.value_;
        }
        if (this.select_ != null) {
            return this.select_.toXObject(xsltContext);
        }
        ResultTreeRecorder resultTreeRecorder = new ResultTreeRecorder();
        Template.instantiate(xsltContext, resultTreeRecorder, this.template_);
        NodeNamePool nodeNamePool = xsltContext.getModelCache().getNodeNamePool();
        return new XResultTreeFragment(nodeNamePool, resultTreeRecorder);
    }

    public String toString() {
        return "Variable " + this.name_.getName();
    }

    public static XObject[] getValues(XsltContext xsltContext, Variable[] variableArray) {
        XObject[] xObjectArray = null;
        if (variableArray != null) {
            int n = variableArray.length;
            xObjectArray = new XObject[n];
            for (int i = 0; i < n; ++i) {
                xObjectArray[i] = variableArray[i].getValue(xsltContext);
            }
        }
        return xObjectArray;
    }
}

