/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.parser;

import java.util.StringTokenizer;
import java.util.Vector;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xslt.parser.PatternParser;
import jd.xml.xslt.parser.XsltParseContext;
import jd.xml.xslt.parser.XsltParseException;
import jd.xml.xslt.pattern.Pattern;

class AttributeIterator {
    private XPathNode attribute_;
    private String localName_;
    private XsltParseContext context_;
    private PatternParser patternParser_;
    private int count_;
    private int next_;
    private XPathNode[] attributes_;
    private boolean isStylesheetElem_;

    public AttributeIterator(PatternParser patternParser, XsltParseContext xsltParseContext, XPathNode[] xPathNodeArray, boolean bl) {
        this.patternParser_ = patternParser;
        this.context_ = xsltParseContext;
        this.attributes_ = xPathNodeArray;
        this.count_ = xPathNodeArray == null ? 0 : xPathNodeArray.length;
        this.isStylesheetElem_ = bl;
        this.start();
    }

    public void start() {
        this.next_ = -1;
    }

    public boolean next() {
        XPathNode xPathNode;
        while (++this.next_ < this.count_ && (xPathNode = this.attributes_[this.next_]).getPrefix() != null && this.isStylesheetElem_ && !this.context_.isStylesheetNode(xPathNode)) {
        }
        if (this.next_ < this.count_) {
            this.attribute_ = this.attributes_[this.next_];
            this.localName_ = this.attribute_.getLocalName();
            return true;
        }
        this.attribute_ = null;
        this.localName_ = null;
        return false;
    }

    public XPathNode getAttribute() {
        return this.attribute_;
    }

    public String getName() {
        return this.attribute_.getName();
    }

    public boolean match(String string) {
        return this.localName_.equals(string);
    }

    public String getValue() {
        String string = this.attribute_.getValue();
        return string.length() == 0 ? null : string;
    }

    public boolean getBoolean(String string, String string2, boolean bl) throws XsltParseException {
        String string3 = this.getValue();
        if (string.equals(string3)) {
            return true;
        }
        if (string2.equals(string3)) {
            return false;
        }
        if (this.context_.processForwardsCompatible()) {
            return bl;
        }
        throw this.createException("illegal attribute value '" + string3 + "'");
    }

    public char getChar() throws XsltParseException {
        String string = this.getValue();
        if (string.length() != 1) {
            throw this.createException("attribute value must be a single character");
        }
        return string.charAt(0);
    }

    public String getExpandedName() throws XsltParseException {
        return this.context_.getExpandedName(this.getValue());
    }

    public String[] getExpandedNames() throws XsltParseException {
        Object[] objectArray = null;
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getValue());
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(this.context_.getExpandedName(stringTokenizer.nextToken()));
        }
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public Expression getExpression() throws XsltParseException {
        try {
            String string = this.getValue();
            if (string == null) {
                throw new IllegalArgumentException("expression is empty");
            }
            return this.patternParser_.parseExpression(string);
        }
        catch (Exception exception) {
            this.context_.setCurrentAttribute(this.attribute_);
            throw this.context_.createException("cannot parse expression", exception);
        }
    }

    public Pattern getPattern() throws XsltParseException {
        try {
            return this.patternParser_.parsePattern(this.getValue());
        }
        catch (Exception exception) {
            this.context_.setCurrentAttribute(this.attribute_);
            throw this.context_.createException("invalid match attribute", exception);
        }
    }

    public void reportInvalidAttribute() throws XsltParseException {
        if (!this.context_.processForwardsCompatible()) {
            throw this.createException("unknown attribute");
        }
    }

    public void reportInvalidAttributeValue() throws XsltParseException {
        if (!this.context_.processForwardsCompatible()) {
            throw this.createException("invalid attribute value: '" + this.getValue() + "'");
        }
    }

    private XsltParseException createException(String string) {
        return this.context_.createException(string, this.attribute_);
    }
}

