/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.object;

public abstract class Equality {
    public static final Equality EQUAL = new Equal();
    public static final Equality NOT_EQUAL = new NotEqual();
    private final String symbol_;

    private Equality(String string) {
        this.symbol_ = string;
    }

    public String getSymbol() {
        return this.symbol_;
    }

    public abstract boolean compare(boolean var1, boolean var2);

    public abstract boolean compare(double var1, double var3);

    public abstract boolean compare(String var1, String var2);

    private static final class NotEqual
    extends Equality {
        public NotEqual() {
            super("!=");
        }

        public boolean compare(double d, double d2) {
            return d != d2;
        }

        public boolean compare(boolean bl, boolean bl2) {
            return bl != bl2;
        }

        public boolean compare(String string, String string2) {
            return !string.equals(string2);
        }
    }

    private static final class Equal
    extends Equality {
        public Equal() {
            super("=");
        }

        public boolean compare(double d, double d2) {
            return d == d2;
        }

        public boolean compare(boolean bl, boolean bl2) {
            return bl == bl2;
        }

        public boolean compare(String string, String string2) {
            return string.equals(string2);
        }
    }
}

