/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.builder;

import com.claritysys.jvm.classfile.JVM;

public final class ByteArray
implements JVM {
    private byte[] bytes;
    private int size;
    private boolean unreachable_here;
    private int stackPointer;
    private int maxStack;
    private boolean shared;
    public static final boolean[] UNREACHABLES = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

    public ByteArray() {
        this(256);
    }

    public ByteArray(int capacity) {
        this.bytes = new byte[capacity];
    }

    public void reset() {
        if (this.shared) {
            this.bytes = new byte[256];
            this.shared = false;
        }
        this.size = 0;
        this.unreachable_here = false;
        this.stackPointer = 0;
        this.maxStack = 0;
    }

    public void reserve(int increment) {
        if (this.size + increment > this.bytes.length) {
            byte[] new_bytes = new byte[2 * this.bytes.length + increment];
            System.arraycopy(this.bytes, 0, new_bytes, 0, this.size);
            this.bytes = new_bytes;
        }
    }

    public void putOpcode(int opcode) {
        int produce;
        this.put1(opcode);
        this.unreachable_here = UNREACHABLES[opcode];
        int stack = this.stackPointer;
        int consume = CONSUME_STACK[opcode];
        if (consume > 0) {
            stack -= consume;
        }
        if ((produce = PRODUCE_STACK[opcode]) > 0) {
            stack += produce;
        }
        this.stackPointer = stack;
        if (stack > this.maxStack) {
            this.maxStack = stack;
        }
    }

    public void put1(int i) {
        this.reserve(1);
        this.bytes[this.size++] = (byte)i;
    }

    public void put2(int i) {
        this.reserve(2);
        this.bytes[this.size++] = (byte)(i >> 8);
        this.bytes[this.size++] = (byte)i;
    }

    public void put2(int pc, int i) {
        this.reserve(2);
        this.bytes[pc + 0] = (byte)(i >> 8);
        this.bytes[pc + 1] = (byte)i;
    }

    public void put4(int i) {
        this.reserve(4);
        this.bytes[this.size++] = (byte)(i >> 24);
        this.bytes[this.size++] = (byte)(i >> 16);
        this.bytes[this.size++] = (byte)(i >> 8);
        this.bytes[this.size++] = (byte)i;
    }

    public int getI2(int pc) {
        int i2 = this.bytes[pc + 0] << 8 | this.bytes[pc + 1] & 0xFF;
        return i2;
    }

    public byte[] getCode() {
        if (this.size == this.bytes.length) {
            this.shared = true;
            return this.bytes;
        }
        this.shared = false;
        byte[] code = new byte[this.size];
        System.arraycopy(this.bytes, 0, code, 0, this.size);
        return code;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getSize() {
        return this.size;
    }

    public int getPC() {
        return this.getSize();
    }

    public void adjustStack(int delta) {
        this.stackPointer += delta;
        if (this.stackPointer > this.maxStack) {
            this.maxStack = this.stackPointer;
        }
        if (this.stackPointer < 0) {
            throw new IllegalStateException("Stack pointer < 0: " + this.stackPointer + ", last=" + delta);
        }
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public void setUnreachable(boolean isUnreachable) {
        this.unreachable_here = isUnreachable;
    }

    public boolean isUnreachable() {
        return this.unreachable_here;
    }
}

