/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.tool.re;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.jiapi.reflect.BranchInstruction;
import net.sf.jiapi.reflect.Instruction;
import net.sf.jiapi.tool.re.Node;
import net.sf.jiapi.tool.re.SimpleStatement;
import net.sf.jiapi.tool.re.SimpleStatementBuilder;
import net.sf.jiapi.tool.re.Statement;

public class IfStatement
extends Statement {
    private final Node header;
    private final Node ifNode;
    private final Node elseNode;
    private final Node exitNode;
    private final List<Statement> ifBody = new LinkedList<Statement>();
    private List<Statement> elseBody = new LinkedList<Statement>();

    public IfStatement(Node header) {
        super(header);
        this.header = header;
        Set<Node> successors = header.getSuccessors();
        Iterator<Node> iter = successors.iterator();
        Node n1 = iter.next();
        Node n2 = iter.next();
        System.out.println("n1(" + n1.getId() + ") post dominators" + Node.getNodeIds(n1.getPostDominators()));
        System.out.println("n2(" + n2.getId() + ") post dominators" + Node.getNodeIds(n2.getPostDominators()));
        this.exitNode = n1.getCommonPostDominators(n2).get(0);
        System.out.println("exitNode: " + this.exitNode.getId());
        if (this.exitNode.equals(n1)) {
            this.ifNode = n2;
            this.elseNode = null;
        } else if (this.exitNode.equals(n2)) {
            this.ifNode = n1;
            this.elseNode = null;
        } else {
            BranchInstruction bIns = (BranchInstruction)header.getBasicBlock().getLastInstruction();
            Instruction n1Ins = n1.getBasicBlock().getFirstInstruction();
            if (bIns.getTarget().equals(n1Ins)) {
                this.ifNode = n2;
                this.elseNode = n1;
            } else {
                this.ifNode = n1;
                this.elseNode = n2;
            }
        }
    }

    @Override
    Node getNextNode() {
        return this.exitNode;
    }

    public Node getIfBody() {
        return this.ifNode;
    }

    public Node getElseBody() {
        return this.elseNode;
    }

    public String toString() {
        SimpleStatementBuilder ssb = new SimpleStatementBuilder();
        List<SimpleStatement> ssList = ssb.createSimpleStatements(this.header.getBasicBlock().getInstructionList());
        StringBuffer sb = new StringBuffer("IfStatement(" + this.header.getId() + ")" + ssList);
        this.indentMore();
        for (Statement s : this.ifBody) {
            sb.append("\n" + indentationString);
            sb.append(s);
        }
        if (this.elseBody.size() > 0) {
            this.indentLess();
            sb.append("\n" + indentationString);
            sb.append("else");
            this.indentMore();
            for (Statement s : this.elseBody) {
                sb.append("\n" + indentationString);
                sb.append(s);
            }
        }
        this.indentLess();
        return sb.toString();
    }

    void addStatementForIfBlock(Statement stmt) {
        this.ifBody.add(stmt);
    }

    public void addStatementForElseBlock(Statement stmt) {
        this.elseBody.add(stmt);
    }
}

