/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.FunctionProxy;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class Variable
implements VariableDeclaration,
Binding {
    private String name;
    private Value value;

    private Variable() {
    }

    protected static Variable make(String string) {
        Variable variable = new Variable();
        variable.name = string;
        return variable;
    }

    public SequenceType getRequiredType() {
        return SequenceType.ANY_SEQUENCE;
    }

    public String getVariableName() {
        return this.name;
    }

    public int getVariableFingerprint() {
        return -1;
    }

    public void setValue(Object object) throws XPathException {
        this.value = FunctionProxy.convertJavaObjectToXPath(object, null);
        if (this.value == null) {
            this.value = EmptySequence.getInstance();
        }
    }

    public void setXPathValue(Value value) throws XPathException {
        this.value = value;
        if (this.value == null) {
            this.value = EmptySequence.getInstance();
        }
    }

    public void registerReference(BindingReference bindingReference) {
        bindingReference.setStaticType(SequenceType.ANY_SEQUENCE, null, 0);
        bindingReference.fixup(this);
    }

    public Value evaluateVariable(XPathContext xPathContext) {
        return this.value;
    }
}

