/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class Element
extends ElementCreator {
    private Expression elementName;
    private Expression namespace = null;
    private NamespaceResolver nsContext;

    public Element(Expression expression, Expression expression2, NamespaceResolver namespaceResolver, AttributeSet[] attributeSetArray, SchemaType schemaType, int n) throws XPathException {
        this.elementName = expression;
        this.namespace = expression2;
        this.nsContext = namespaceResolver;
        this.useAttributeSets = attributeSetArray;
        this.schemaType = schemaType;
        this.validation = n;
    }

    public Expression simplify() throws XPathException {
        this.elementName = this.elementName.simplify();
        if (this.namespace != null) {
            this.namespace = this.namespace.simplify();
        }
        return super.simplify();
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.elementName = this.elementName.analyze(staticContext);
        RoleLocator roleLocator = new RoleLocator(4, "element/name", 0);
        this.elementName = this.elementName.getItemType().getPrimitiveType() == 530 ? TypeChecker.staticTypeCheck(this.elementName, SequenceType.SINGLE_ITEM, false, roleLocator) : TypeChecker.staticTypeCheck(this.elementName, SequenceType.SINGLE_STRING, false, roleLocator);
        if (this.namespace != null) {
            this.namespace = this.namespace.analyze(staticContext);
            roleLocator = new RoleLocator(4, "element/namespace", 0);
            this.namespace = TypeChecker.staticTypeCheck(this.namespace, SequenceType.SINGLE_STRING, false, roleLocator);
        }
        int n = 0;
        while (n < this.children.length) {
            if (!(this.children[n] instanceof ExprInstruction)) {
                throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
            }
            this.children[n] = (ExprInstruction)((ExprInstruction)this.children[n]).analyze(staticContext);
            ++n;
        }
        return this;
    }

    public void getXPathExpressions(List list) {
        list.add(this.elementName);
        if (this.namespace != null) {
            list.add(this.namespace);
        }
    }

    public void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.elementName = this.elementName.promote(promotionOffer);
        if (this.namespace != null) {
            this.namespace = this.namespace.promote(promotionOffer);
        }
        super.promoteInst(promotionOffer);
    }

    protected int getNameCode(XPathContext xPathContext) throws XPathException, TransformerException {
        String string;
        Controller controller = xPathContext.getController();
        NamePool namePool = controller.getNamePool();
        String string2 = null;
        String string3 = null;
        Item item = this.elementName.evaluateItem(xPathContext);
        if (item instanceof StringValue) {
            String string4 = item.getStringValue();
            try {
                String[] stringArray = Name.getQNameParts(string4);
                string2 = stringArray[0];
                string3 = stringArray[1];
            }
            catch (QNameException qNameException) {
                this.recoverableError("Invalid element name. " + qNameException.getMessage(), controller);
                return -1;
            }
        } else if (item instanceof QNameValue) {
            string3 = ((QNameValue)item).getLocalName();
            string = ((QNameValue)item).getNamespaceURI();
            this.namespace = new StringValue(string);
            string2 = namePool.suggestPrefixForURI(string);
            if (string2 == null) {
                string2 = "nsq0";
            }
        }
        if (this.namespace == null) {
            string = this.nsContext.getURIForPrefix(string2, true, namePool);
            if (string == null) {
                this.recoverableError("Undeclared prefix in element name: " + string2, controller);
                return -1;
            }
        } else {
            string = this.namespace.evaluateAsString(xPathContext);
            if (string.equals("")) {
                string2 = "";
            }
            if (string2.equals("xmlns")) {
                string2 = "x-xmlns";
            }
        }
        return namePool.allocate(string2, string, string3);
    }

    protected void outputNamespaceNodes(XPathContext xPathContext, Receiver receiver) throws TransformerException {
    }

    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        instructionDetails.setInstructionName("element");
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "element ");
        System.err.println(ExpressionTool.indent(n + 1) + "name");
        this.elementName.display(n + 2, namePool);
        if (this.children.length == 0) {
            System.err.println(ExpressionTool.indent(n + 1) + "empty content");
        } else {
            int n2 = 0;
            while (n2 < this.children.length) {
                if (this.children[n2] instanceof Expression) {
                    ((Expression)((Object)this.children[n2])).display(n + 1, namePool);
                } else {
                    System.err.println(ExpressionTool.indent(n + 1) + this.children[n2].getInstructionName());
                }
                ++n2;
            }
        }
    }
}

