/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public final class IdentityComparison
extends BinaryExpression {
    private boolean generateIdEmulation = false;

    public IdentityComparison(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public void setGenerateIdEmulation(boolean bl) {
        this.generateIdEmulation = bl;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.operands[0] = this.operands[0].analyze(staticContext);
        this.operands[1] = this.operands[1].analyze(staticContext);
        RoleLocator roleLocator = new RoleLocator(1, Tokenizer.tokens[this.operator], 0);
        this.operands[0] = TypeChecker.staticTypeCheck(this.operands[0], SequenceType.OPTIONAL_NODE, false, roleLocator);
        RoleLocator roleLocator2 = new RoleLocator(1, Tokenizer.tokens[this.operator], 1);
        this.operands[1] = TypeChecker.staticTypeCheck(this.operands[1], SequenceType.OPTIONAL_NODE, false, roleLocator2);
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo = this.getNode(this.operands[0], xPathContext);
        if (nodeInfo == null) {
            if (this.generateIdEmulation) {
                return BooleanValue.get(this.getNode(this.operands[1], xPathContext) == null);
            }
            return null;
        }
        NodeInfo nodeInfo2 = this.getNode(this.operands[1], xPathContext);
        if (nodeInfo2 == null) {
            if (this.generateIdEmulation) {
                return BooleanValue.FALSE;
            }
            return null;
        }
        return BooleanValue.get(this.compareIdentity(nodeInfo, nodeInfo2));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo = this.getNode(this.operands[0], xPathContext);
        if (nodeInfo == null) {
            if (this.generateIdEmulation) {
                return this.getNode(this.operands[1], xPathContext) == null;
            }
            return false;
        }
        NodeInfo nodeInfo2 = this.getNode(this.operands[1], xPathContext);
        if (nodeInfo2 == null) {
            return false;
        }
        return this.compareIdentity(nodeInfo, nodeInfo2);
    }

    private boolean compareIdentity(NodeInfo nodeInfo, NodeInfo nodeInfo2) {
        switch (this.operator) {
            case 20: {
                return nodeInfo.isSameNode(nodeInfo2);
            }
            case 37: {
                return GlobalOrderComparer.getInstance().compare(nodeInfo, nodeInfo2) < 0;
            }
            case 38: {
                return GlobalOrderComparer.getInstance().compare(nodeInfo, nodeInfo2) > 0;
            }
        }
        throw new UnsupportedOperationException("Unknown node identity test");
    }

    private NodeInfo getNode(Expression expression, XPathContext xPathContext) throws XPathException {
        return (NodeInfo)expression.evaluateItem(xPathContext);
    }

    public ItemType getItemType() {
        return Type.BOOLEAN_TYPE;
    }
}

